//-----------------------------------------------------------
// team options page
// chaage team speech colours
// quick team change combo
//-----------------------------------------------------------
class XConsole_TeamOptionsTab extends UWindowPageWindow config(XConsole);

// colour combo stuff
var UWindowComboControl NameCombo, LocationCombo, MessageCombo, ComCombo, TeamCombo;
var UWindowComboControl SayNameCombo, SayMessageCombo, KillCombo;
var UWindowSmallButton SpecButton, BehindButton;
var UMenuLabelControl SpecText, BehindText;
var string NameText, LocationText, MessageText, NameHelpText, LocationHelpText, MessageHelpText;
var string TeamText, Teams[4],NoTeam, TeamHelp;
var int CCXOffset, CCYOffset, ComboWidth;

// misc
var bool bCreated;
var Console                 Con;
var AConsole                XCon;

struct Colours{
	var string Name;
	var color Value;
};

var config colours Colour[12];
var config byte TeamNameColour, TeamLocationColour, TeamMessageColour;
var config byte SayNameColour, SayMessageColour, KillMessageColour;

//vars
final function DoVars(){

    Con = Root.Console;
    XCon=AConsole(Con);
    CCYOffset=5;
    CCXOffset=0;
    ComboWidth = 124;

    NameText="  TS     Name:";
    LocationText="  TS Location:";
    MessageText="  TS Message:";
    TeamText="  Your Team:";

    NameHelpText="Colour of Teammates name in HUD TeamSay messages";
    LocationHelpText="Colour of Teammates location HUD TeamSay messages";
    MessageHelpText="Colour of Teammates messages in HUD TeamSay messages";
    TeamHelp="Change Teams";

    Teams[0]="Red";
    Teams[1]="Blue";
    Teams[2]="Green";
    Teams[3]="Gold";
    NoTeam="None";

}

final function Load(){

    local PlayerReplicationInfo PRI;
	PRI=GetPlayerOwner().PlayerReplicationInfo;

	// Combos
    NameCombo.SetSelectedIndex(TeamNameColour);
    LocationCombo.SetSelectedIndex(TeamLocationColour);
    MessageCombo.SetSelectedIndex(TeamMessageColour);
	SayNameCombo.SetSelectedIndex(SayNameColour);
	SayMessageCombo.SetSelectedIndex(SayMessageColour);
	KillCombo.SetSelectedIndex(KillMessageColour);
    
	if(PRI!=none) TeamCombo.SetSelectedIndex(Max(TeamCombo.FindItemIndex2(string(PRI.Team)), 0));

   	class'TeamSayMessagePlus'.default.GreenColor=Colour[TeamNameColour].Value;
    class'TeamSayMessagePlus'.default.CyanColor=Colour[TeamLocationColour].Value;
    class'TeamSayMessagePlus'.default.LightGreenColor=Colour[TeamMessageColour].Value;
    class'SayMessagePlus'.default.GreenColor=Colour[SayNameColour].Value;
    class'SayMessagePlus'.default.LightGreenColor=Colour[SayMessageColour].Value;
    class'DeathMessagePlus'.default.DrawColor=Colour[KillMessageColour].Value;
}

// struct to string convertor
final function string StringIt(color c){
return "(r="$string(c.R)$",g="$string(c.G)$",b="$string(c.B)$",a="$string(c.A)$")";
}

// combos
final function NameChanged()
{
    TeamNameColour = NameCombo.GetSelectedIndex();
   	class'TeamSayMessagePlus'.default.GreenColor=Colour[TeamNameColour].Value;
    saveconfig();
}

final function LocationChanged()
{
    TeamLocationColour = LocationCombo.GetSelectedIndex();
    class'TeamSayMessagePlus'.default.CyanColor=Colour[TeamLocationColour].Value;
    saveconfig();
}

final function MsgChanged()
{
    TeamMessageColour = MessageCombo.GetSelectedIndex();
    class'TeamSayMessagePlus'.default.LightGreenColor=Colour[TeamMessageColour].Value;
    saveconfig();
}

final function SayNameChanged()
{
    SayNameColour = SayNameCombo.GetSelectedIndex();
    class'SayMessagePlus'.default.GreenColor=Colour[SayNameColour].Value;
    saveconfig();
}

final function SayMessageChanged()
{
    SayMessageColour = SayMessageCombo.GetSelectedIndex();
    class'SayMessagePlus'.default.LightGreenColor=Colour[SayMessageColour].Value;
    saveconfig();
}

final function KillChanged()
{
    KillMessageColour = KillCombo.GetSelectedIndex();
    class'DeathMessagePlus'.default.DrawColor=Colour[KillMessageColour].Value;
    saveconfig();
}

final function TeamChanged(){

	local int NewTeam;
	GetPlayerOwner().UpdateURL("Team", TeamCombo.GetValue2(), True);
    NewTeam = Int(TeamCombo.GetValue2());
	if(GetPlayerOwner().PlayerReplicationInfo != None)
		if(GetPlayerOwner().PlayerReplicationInfo.Team != NewTeam && bCreated == true)
		{
			GetPlayerOwner().ChangeTeam(NewTeam);
			Root.Console.ConsoleWindow.Close();
		}
}

final function Spectate(){

         if( GetPlayerOwner().GetDefaultUrl("OverrideClass") =="")
         {
         GetPlayerOwner().UpdateUrl("overrideClass","Botpack.CHSpectator",true);
         GetPlayerOwner().ConsoleCommand("Reconnect");
         SpecButton.SetText("Enter Game");
         }
         else
         {
         GetPlayerOwner().UpdateUrl("overrideClass","",true);
         GetPlayerOwner().ConsoleCommand("Reconnect");
         SpecButton.SetText("Spectate");
         }
         Root.Console.ConsoleWindow.Close();
}

final function BView(){

	if( GetPlayerOwner().bBehindView )
	{
		GetPlayerOwner().ConsoleCommand("behindview 0");
		XCon.FollowPers="behindview 0";
	}
	else 
	{
		GetPlayerOwner().ConsoleCommand("behindview 1");
		XCon.FollowPers="behindview 1";
	}
    Root.Console.ConsoleWindow.Close();
}
	
function Created(){
    DoVars();
    MakeCombos();
    super.Created();
    Load();
    bCreated=true;
	SaveConfig();
}

// combos
final function MakeCombos(){
    local int i;

    NameCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    NameCombo.SetText(NameText);
	NameCombo.SetFont(F_Normal);
	NameCombo.SetEditable(False);
	NameCombo.Align = TA_Left;
	NameCombo.SetHelpText(NameHelpText);
	for(i=0;i<20 && Colour[i].Name!="";i++)
    NameCombo.AddItem(Colour[i].Name);
    NameCombo.bAlwaysBehind=true;

	CCYOffset += 17;
	LocationCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    LocationCombo.SetText(LocationText);
	LocationCombo.SetFont(F_Normal);
	LocationCombo.SetEditable(False);
	LocationCombo.Align = TA_Left;
	LocationCombo.SetHelpText(LocationHelpText);
	for(i=0;i<20 && Colour[i].Name!="";i++)
    LocationCombo.AddItem(Colour[i].Name);
    LocationCombo.bAlwaysBehind=true;

	CCYOffset += 17;
	MessageCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    MessageCombo.SetText(MessageText);
	MessageCombo.SetFont(F_Normal);
	MessageCombo.SetEditable(False);
	MessageCombo.Align = TA_Left;
	MessageCombo.SetHelpText(MessageHelpText);
	for(i=0;i<20 && Colour[i].Name!="";i++)
    MessageCombo.AddItem(Colour[i].Name);
    MessageCombo.bAlwaysBehind=true;

    CCYOffset =5; CCXOffset += ComboWidth;
	SayNameCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    SayNameCombo.SetText("   Chat Name: ");
	SayNameCombo.SetFont(F_Normal);
	SayNameCombo.SetEditable(False);
	SayNameCombo.Align = TA_Left;
	SayNameCombo.SetHelpText("Change message name colour");
	for(i=0;i<20 && Colour[i].Name!="";i++)
    SayNameCombo.AddItem(Colour[i].Name);
    SayNameCombo.bAlwaysBehind=true;

	CCYOffset += 17;
	SayMessageCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    SayMessageCombo.SetText("   Chat   Msg: ");
	SayMessageCombo.SetFont(F_Normal);
	SayMessageCombo.SetEditable(False);
	SayMessageCombo.Align = TA_Left;
	SayMessageCombo.SetHelpText("Change message colours");
	for(i=0;i<20 && Colour[i].Name!="";i++)
    SayMessageCombo.AddItem(Colour[i].Name);
    SayMessageCombo.bAlwaysBehind=true;

	CCYOffset += 17;
	KillCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
    KillCombo.SetText("              Kills: ");
	KillCombo.SetFont(F_Normal);
	KillCombo.SetEditable(False);
	KillCombo.Align = TA_Left;
	KIllCombo.SetHelpText("Change kill message colours");
	for(i=0;i<20 && Colour[i].Name!="";i++)
    KillCombo.AddItem(Colour[i].Name);
    KillCombo.bAlwaysBehind=true;

	
	
    CCYOffset=5; CCXOffset += ComboWidth;
	TeamCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CCXOffset, CCYOffset, ComboWidth, 1));
	TeamCombo.SetText(TeamText);
	TeamCombo.SetHelpText(TeamHelp);
	TeamCombo.SetFont(F_Normal);
	TeamCombo.SetEditable(False);
	TeamCombo.AddItem(NoTeam, String(255));
	for (i=0; i<4; i++)
	{
	TeamCombo.AddItem(Teams[i], String(i));
	}
    
	CCYOffset += 18;
	SpecButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CCXOffset+63, CCYOffset, 60, 1));
    SpecButton.ToolTipString="Toggle Spectate/Play";
    if( GetPlayerOwner().GetDefaultUrl("OverrideClass") =="") SpecButton.SetText("Spectate");
    if( GetPlayerOwner().GetDefaultUrl("OverrideClass") =="Botpack.CHSpectator") SpecButton.SetText("Enter Game");

    SpecText = UMenuLabelControl(CreateControl(class'UMenuLabelControl', CCXOffset+10, CCYOffset+1, 55, 1));
    SpecText.SetText("Spec/Play:");
	
	CCYOffset += 18;
	BehindButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CCXOffset+63, CCYOffset, 60, 1));
    BehindButton.ToolTipString="Toggle 1st/3rd Person";
	if( GetPlayerOwner().bBehindView ) BehindButton.SetText("1st Person");
	else BehindButton.SetText("3rd Person");

    BehindText = UMenuLabelControl(CreateControl(class'UMenuLabelControl', CCXOffset+10, CCYOffset+1, 55, 1));
    BehindText.SetText("        View:");
}

// notify
function Notify(UWindowDialogControl C, byte E)
{
if(!bCreated)return;

    switch(E)
      {
          case DE_Change:
          switch(C)
                    {
                        case NameCombo:NameChanged();break;
                        case LocationCombo:LocationChanged();break;
                        case MessageCombo:MsgChanged();break;
       			        case TeamCombo:TeamChanged();break;
						case SayNameCombo:SayNameChanged();break;
						case SayMessageCombo:SayMessageChanged();break;
						case KillCombo:KillChanged();break;
       			        break;
                    }
         case DE_Click:
         switch(C)
                  {
                       case SpecButton:Spectate();break;
                       case BehindButton:BView();break;
                  }
       }

     Super.Notify(C, E);
}

function WindowShown()
{
	if(GetPlayerOwner().PlayerReplicationInfo != None)
		TeamCombo.SetSelectedIndex(Max(TeamCombo.FindItemIndex2(string(GetPlayerOwner().PlayerReplicationInfo.Team)), 0));
    if( GetPlayerOwner().GetDefaultUrl("OverrideClass") =="") SpecButton.SetText("Spectate");
    else SpecButton.SetText("Enter Game");
	if( GetPlayerOwner().bBehindView ) BehindButton.SetText("1st Person");
	else BehindButton.SetText("3rd Person");
	super.WindowShown();
}

defaultproperties
{
    Colour(0)=(Name="Gold",Value=(R=255,G=255,B=0,A=0),),
    Colour(1)=(Name="Purple",Value=(R=255,G=0,B=255,A=0),),
    Colour(2)=(Name="Light Blue",Value=(R=0,G=128,B=255,A=0),),
    Colour(3)=(Name="Turquoise",Value=(R=0,G=255,B=255,A=0),),
    Colour(4)=(Name="Red",Value=(R=0,G=0,B=0,A=0),),
    Colour(5)=(Name="Orange",Value=(R=255,G=128,B=0,A=0),),
    Colour(6)=(Name="Green",Value=(R=0,G=255,B=0,A=0),),
    Colour(7)=(Name="Pink",Value=(R=255,G=50,B=50,A=0),),
    Colour(8)=(Name="White",Value=(R=255,G=255,B=255,A=0),),
    Colour(9)=(Name="Deep Blue",Value=(R=0,G=0,B=255,A=0),),
    Colour(10)=(Name="Light Green",Value=(R=50,G=255,B=50,A=0),),
    TeamLocationColour=2
    SayNameColour=6
    SayMessageColour=10
    KillMessageColour=7
}
