//-----------------------------------------------------------
// Admin stuff - level changing etc
//-----------------------------------------------------------
class XConsole_ServerTab extends UWindowPageWindow config(XConsole);

// controls
var UWindowSmallButton LevelButton, ComButton, PWClearButton;
var UWindowComboControl MapCombo, TypeCombo, MaxCombo, MinCombo, TeamsCombo;
var UWindowEditControl ComControl, PassControl, TimeControl, CapControl, FragControl, FFControl;
var UWindowCheckBox InstaCB, SniperCB, RelicsCB, LowGravCB, MapVoteCB, TModeCB, TransCB;

// Classes
var Console      Con;
var AConsole     XCon;

// Misc
var bool RunInProg, bCreated;
var name LogTag;
var config bool UseLocalMapList, UseCustomMapList1, UseCustomMapList2, UseCustomMapList3;
var config bool UseCustomMapList4, Sniper, Insta, Lowg, Relics, Trans, Tournament, Vote;
var byte MaxCols, MaxRows;
var int Time, CBXOffset, CBYoffset, CBoxOffset, CBWidth, CBSpread;
var string LevelText, HelpLevelText;
var string Command, MutateString, Pre, GClass, Game, Mut[4], AdminPre;
var config string MapVote, TimeLimit;
var config string CustomMapList1[64], CustomMapList2[64], CustomMapList3[64], CustomMapList4[64];
var config string FragLimit, CapLimit, FFScale;
var config string MaxPlayers, MaxTeams, MinPlayers;
var config int MapList1Pos, MapList2Pos, MapList3Pos, MapList4Pos;

struct GameTypes{
	var string Name;
	var string GameClass;
	var string Mutator;
	var string Prefix;
};

var config GameTypes GameType[20];

final function DoVars(){

    Con=root.Console;
    XCon=AConsole(Con);
    XCon.ServerTab=self;
    AdminPre="admin ";
    CBXOffset=-60;
    CBYOffset=5;
    CBSpread=55;
    CBWidth=54;
    MaxCols=5;
    MaxRows=2;
    LevelText="Run!";
    HelpLevelText="Start new game";
    Mut[0]="Botpack.SniperArena";
    Mut[1]="Botpack.InstaGibDM";
    Mut[2]="Relics.RelicRegen,Relics.RelicDeath,Relics.RelicDefense,Relics.RelicRedemption,Relics.RelicSpeed,Relics.RelicStrength";
    Mut[3]="Botpack.LowGrav";
}

function Created(){

    DoVars();
    DoButtons();
    super.Created();
	bCreated=true;
	SaveConfig();
}

// Buttons etc
final function DoButtons(){
    local int i,index;

    TimeControl = UWindowEditControl(CreateControl(class'UWindowEditControl', CBXOffset+330, CBYOffset, 60 ,20));
    TimeControl.SetFont(F_Normal);
    TimeControl.SetNumericOnly(True);
    TimeControl.SetMaxLength(3);
    TimeControl.SetHistory(True);
    TimeControl.SetValue(TimeLimit);
    TimeControl.SetText("Time:");

    FragControl = UWindowEditControl(CreateControl(class'UWindowEditControl', CBXOffset+330, CBYOffset+17, 60 ,20));
    FragControl.SetFont(F_Normal);
    FragControl.SetNumericOnly(True);
    FragControl.SetMaxLength(3);
    FragControl.SetHistory(True);
    FragControl.SetValue(FragLimit);
    FragControl.SetText("Frags:");

    CapControl = UWindowEditControl(CreateControl(class'UWindowEditControl', CBXOffset+330, CBYOffset+34, 60 ,20));
    CapControl.SetFont(F_Normal);
    CapControl.SetNumericOnly(True);
    CapControl.SetMaxLength(3);
    CapControl.SetHistory(True);
    CapControl.SetValue(CapLimit);
    CapControl.SetText("Caps:");

    FFControl = UWindowEditControl(CreateControl(class'UWindowEditControl', CBXOffset+548, CBYOffset+17,60 ,1 ));
	FFControl.SetFont(F_Normal);
	FFControl.SetNumericOnly(True);
	FFControl.SetMaxLength(3);
	FFControl.SetHistory(True);
	FFControl.SetValue(FFScale);
	FFControl.SetText("F Fire");

    SniperCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+389, CBYOffset,66 ,1 ));
    InstaCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+389, CBYOffset+17,66 ,1 ));
    RelicsCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+389, CBYOffset+34,66 ,1 ));
    LowGravCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+469, CBYOffset,66 ,1 ));
    MapVoteCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+469, CBYOffset+17,66 ,1 ));
    TModeCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+463, CBYOffset+34,72 ,1 ));
    TransCB = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+539, CBYOffset,72 ,1 ));
    SniperCB.SetText("       Sniper");
    InstaCB.SetText("         Insta");
    RelicsCB.SetText("        Relics");
    LowGravCB.SetText("      Low G");
    MapVoteCB.SetText("  Map Vote");
    TModeCB.SetText("Tournament");
    TransCB.SetText("Translocator");
    SniperCB.bChecked=Sniper;
    InstaCB.bChecked=Insta;
    RelicsCB.bChecked=Relics;
    LowGravCB.bChecked=LowG;
    MapVoteCB.bChecked=Vote;
    TModeCB.bChecked=Tournament;
    TransCB.bChecked=Trans;

    TypeCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CBXOffset+4, CBYOffset,200,1 ));
    TypeCombo.SetEditable(false);
    TypeCombo.SetFont(F_Normal);
    TypeCombo.bAlwaysBehind=true;
    TypeCombo.SetText("                      Game:");
    for(i=0;i<20;i++)
    {
                     if(GameType[i].Name!="")TypeCombo.AddItem(GameType[i].Name);
    }
    TypeCombo.SetSelectedIndex(0);

    MapCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CBXOffset+4, CBYOffset+17,200,1 ));
    MapCombo.SetEditable(false);
    MapCombo.SetFont(F_Normal);
    MapCombo.bAlwaysBehind=true;
    MapCombo.SetText("                        Map:");
    MapCombo.SetSelectedIndex(0);

    MaxCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CBXOffset+210, CBYOffset,110,1 ));
    MaxCombo.SetEditable(false);
    MaxCombo.SetFont(F_Normal);
    MaxCombo.bAlwaysBehind=true;
    MaxCombo.SetText("MaxPlayers:");
    for(i=1;i<33;i++)
    {
                     MaxCombo.AddItem(string(i));
    }
    MaxCombo.SetSelectedIndex(int(MaxPlayers)-1);

    MinCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CBXOffset+210, CBYOffset+17,110,1 ));
    MinCombo.SetEditable(false);
    MinCombo.SetFont(F_Normal);
    MinCombo.bAlwaysBehind=true;
    MinCombo.SetText("MinPlayers:");
    for(i=0;i<17;i++)
    {
                     MinCombo.AddItem(string(i));
    }
    MinCombo.SetSelectedIndex(int(MinPlayers));

    TeamsCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CBXOffset+210, CBYOffset+34,110,1 ));
    TeamsCombo.SetEditable(false);
    TeamsCombo.SetFont(F_Normal);
    TeamsCombo.bAlwaysBehind=true;
    TeamsCombo.SetText("Teams:");
    for(i=1;i<5;i++)
    {
                    TeamsCombo.AddItem(string(i));
    }
    TeamsCombo.SetSelectedIndex(int(MaxTeams)-1);

    PassControl = UWindowEditControl(CreateControl(class'UWindowEditControl', CBXOffset+43, CBYOffset+34, 120 ,20));
    PassControl.SetFont(F_Normal);
    PassControl.SetNumericOnly(False);
    PassControl.SetMaxLength(16);
    PassControl.SetHistory(True);
    PassControl.bAlwaysBehind=true;
    PassControl.SetText("           Pass:");


    PWClearButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CBXOffset+174, CBYOffset+35,30 ,1 ));
    PWClearButton.SetText("Clear");
    PWClearButton.ToolTipString="Clear Game Password";

    LevelButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CBXOffset+568, CBYOffset+33,40 ,1 ));
    LevelButton.SetText(LevelText);
    LevelButton.ToolTipString=HelpLevelText;
    IterateMaps();
}


final function IterateMaps(){
	local string FirstMap, NextMap, TestMap, Map[256];
    local int i;
    local TDMMaplist TDM;
    local ASMapList AS;
    local CTFMapList CTF;
    local DOMMaplist DOM;

    GClass=GameType[TypeCombo.GetSelectedIndex()].GameClass;
	MapCombo.Clear();

    if(UseCustomMapList1 && MapList1Pos==TypeCombo.GetSelectedIndex())
    {
        for(i=0 ; i<64; i++)
        {
        if(CustomMapList1[i]!="")
        MapCombo.AddItem(CustomMapList1[i]);
        }
        MapCombo.SetSelectedIndex(0);
        return;
    }

    if(UseCustomMapList2 && MapList2Pos==TypeCombo.GetSelectedIndex())
    {
        for(i=0 ; i<64; i++)
        {
        if(CustomMapList2[i]!="")
        MapCombo.AddItem(CustomMapList2[i]);
        }
        MapCombo.SetSelectedIndex(0);
        return;
    }

    if(UseCustomMapList3 && MapList3Pos==TypeCombo.GetSelectedIndex())
    {
        for(i=0 ; i<64; i++)
        {
        if(CustomMapList3[i]!="")
        MapCombo.AddItem(CustomMapList3[i]);
        }
        MapCombo.SetSelectedIndex(0);
        return;
    }

    if(UseCustomMapList4 && MapList4Pos==TypeCombo.GetSelectedIndex())
    {
        for(i=0 ; i<64; i++)
        {
        if(CustomMapList4[i]!="")
        MapCombo.AddItem(CustomMapList4[i]);
        }
        MapCombo.SetSelectedIndex(0);
        return;
    }

    if(UseLocalMapList)
    {
        if(GClass~="BotPack.DeathMatchPlus")
        {
        TDM=getplayerowner().spawn(class'botpack.TDMmaplist',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=TDM.Maps[i];
            }
        }
        if(GClass~="BotPack.CTFGame")
        {
        CTF=getplayerowner().spawn(class'botpack.CTFMapList',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=CTF.Maps[i];
            }
        }
        if(GClass~="BotPack.TeamGamePlus")
        {
        TDM=getplayerowner().spawn(class'botpack.TDMmaplist',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=TDM.Maps[i];
            }
        }
        if(instr(caps(GClass),"ASSAULT")>0)
        {
        AS=getplayerowner().spawn(class'botpack.ASMapList',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=AS.Maps[i];
            }
        }

        if(GClass~="BotPack.Domination")
        {
        DOM=getplayerowner().spawn(class'botpack.DOMMaplist',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=DOM.Maps[i];
            }
        }

        if(GClass~="BotPack.LastManStanding")
        {
        TDM=getplayerowner().spawn(class'botpack.TDMmaplist',,,);
            for(i=0 ; i<32 ; i++)
            {
				Map[i]=TDM.Maps[i];
            }
        }

        for(i=0 ; i<32 ; i++)
        {
    		if(Map[i]!="")
            {
				MapCombo.AddItem(Left(Map[i], Len(Map[i]) - 4),Map[i]);
    		}
        }
	    MapCombo.SetSelectedIndex(0);
        return;

    }

    Pre = GameType[TypeCombo.GetSelectedIndex()].Prefix;
    FirstMap = GetPlayerOwner().GetMapName(Pre, "", 0);
	NextMap = FirstMap;

	while (!(FirstMap ~= TestMap))
	{
		if(!(Left(NextMap, Len(NextMap) - 4) ~= (Pre$"-tutorial")))
		MapCombo.AddItem(Left(NextMap, Len(NextMap) - 4), NextMap);
		NextMap = GetPlayerOwner().GetMapName(Pre, NextMap, 1);
		TestMap = NextMap;
	}

	MapCombo.Sort();
	MapCombo.SetSelectedIndex(0);
}

final function NewLevel(){
    local string Goal;
    local TournamentGameReplicationInfo TGRI;
	local int FFS, i;

	RunInProg=true;
	time=0;
    GClass=GameType[TypeCombo.GetSelectedIndex()].GameClass;
    if( (instr(caps(GClass),"LEAGUEASSAULT")<0) && (AdminPre=="moderator ") )
    {
		Echo("You are not allowed to change the gametype!");
		return;
    }

	TGRI=TournamentGameReplicationInfo(root.console.viewport.actor.gamereplicationinfo);
    TimeLimit=TimeControl.GetValue();
    FragLimit=FragControl.GetValue();
    CapLimit=CapControl.GetValue();
    saveconfig();

    if(GClass~="botpack.ctfgame") Goal=CapLimit;
    else Goal=FragLimit;
    if(GClass~="BotPack.DeathMatchPlus" || GClass~="BotPack.LastManStanding") goto 1000;
    // hackety hackety hack
    if(left(caps(GClass),7)!="BOTPACK" && !(TGRI.GameClass~=GClass)) 
		XCon.ConsoleCommand("admin summon " $ GClass);

    XCon.ConsoleCommand("admin set " $ GClass $ " GoalTeamScore " $ Goal);
    XCon.ConsoleCommand("admin set " $ GClass $ " MaxTeams " $ MaxTeams);
1000:
    XCon.ConsoleCommand("admin set " $ GClass $ " TimeLimit " $ TimeLimit);
    XCon.ConsoleCommand("admin set " $ GClass $ " FragLimit " $ FragLimit);
    XCon.ConsoleCommand("admin set engine.gameinfo MaxPlayers " $ MaxPlayers);
    XCon.ConsoleCommand("admin set botpack.deathmatchplus MinPlayers " $ MinPlayers);
    XCon.ConsoleCommand("admin set " $ GClass $ " bTournament " $ Tournament);
    XCon.ConsoleCommand("admin set " $ GClass $ " bUseTranslocator " $ Trans);

    echo("######################");
    echo("#  New Level");
    echo("#  Game: " $ TypeCombo.GetValue());
    echo("#  Level: " $ MapCombo.GetValue());
    echo("#  Max Players: " $ MaxPlayers);
    echo("#  Min Players: " $ MinPlayers);
    if(!(GClass~="BotPack.DeathMatchPlus") && !(GClass~="BotPack.LastManStanding"))
    echo("#  Teams: " $ MaxTeams);
    if(instr(caps(GClass),"ASSAULT")>0) goto 2000;
    echo("#  Time Limit: " $ TimeLimit);
    if(GClass~="botpack.ctfgame") echo("#  Cap Limit: " $ Goal);
    else echo("#  Frag Limit: " $ Goal);
2000:
	if(AdminPre!="moderator " && !(GClass~="BotPack.DeathMatchPlus")) echo("#  Friendly Fire: " $ FFScale $ "%");
    echo("######################");
    if( (instr(caps(GClass),"LEAGUEASSAULT")>0) && (AdminPre=="moderator ") )
    Command=AdminPre $ "servertravel " $ MapCombo.GetValue() $ MutatorList();
    else
    Command=AdminPre $ "servertravel " $ MapCombo.GetValue() $ "?game=" $ GClass $ MutatorList();
    Command=Command $ "?TimeLimit=" $ TimeLimit $ "?FragLimit=" $ FragLimit;
    XCon.ConsoleCommand(Command);
//    echo(command);
//    echo(mutatorlist());
}

function Tick(float deltatime)
{
	time++;
	if(time>900 && RunInProg && AdminPre!="moderator ") SetFF();
}

function SetFF()
{
	local GameReplicationInfo GRI;

	GRI=root.console.viewport.actor.gamereplicationinfo;
	GClass=GRI.GameClass;
	time=0;
	RunInProg=false;
	
	if(GClass~="Botpack.UTIntro" || GClass~="Botpack.DeathMatchPlus") return;
	if(AdminPre=="moderator ") return;
	
	XCon.AdminTab.Login("");
	echo("Setting Friendly Fire Scale");

	XCon.ConsoleCommand("admin set " $ GClass $ " FriendlyFireScale " $ float(FFScale)/100);
	
	XCon.ConsoleCommand("adminlogout");
}

function ChangeFF()
{
	local GameReplicationInfo GRI;

	FFScale=FFControl.GetValue();
	GRI=root.console.viewport.actor.gamereplicationinfo;
	GClass=GRI.GameClass;
	
	if(float(FFScale)<0)FFScale="0";
	if(float(FFScale)>100)FFScale="100";
	if(GClass~="Botpack.DeathMatchPlus") return;
	if(AdminPre=="moderator ") return;
	
	XCon.ConsoleCommand("admin set " $ GClass $ " FriendlyFireScale " $ float(FFScale)/100);

	saveconfig();

}

final function string MutatorList(){

    MutateString = "?Mutator=";
    if(GameType[TypeCombo.GetSelectedIndex()].Mutator!="") 
		MutateString=MutateString $ GameType[TypeCombo.GetSelectedIndex()].Mutator$ ",";
    if(Sniper) MutateString=MutateString $ Mut[0] $ ",";
    if(Insta)
        {
        if(instr(caps(GameType[TypeCombo.GetSelectedIndex()].GameClass), "LEAGUEASSAULT")>0) 
			MutateString=MutateString $ "LeagueAS-SP.iAS,";
			else MutateString=MutateString $ Mut[1] $ ",";
        }
    if(Relics) MutateString=MutateString $ Mut[2] $ ",";
    if(LowG) MutateString=MutateString $ Mut[3] $ ",";
    if(Vote) MutateString=MutateString $ MapVote $ ",";
    return MutateString;
}

function Notify(UWindowDialogControl C, byte E){
    local string PW;
	local PlayerReplicationInfo PRI;

	if (!bCreated) return;

    PRI = GetPlayerOwner().PlayerReplicationInfo;

    if(PRI!=none)
    {
        if(PRI.bAdmin)
        {
            AdminPre="admin ";
        }
        if(XCon.AdminTab!=none)
        XCon.AdminTab.AdminPre=AdminPre;
        
    }

        switch(E)
		{
              case DE_Click:
              switch(C)
              {
                  case PassControl:return;
				  case InstaCB:Insta=InstaCB.bChecked;saveconfig();break;
				  case SniperCB:Sniper=SniperCB.bChecked;saveconfig();break;
				  case RelicsCB:Relics=RelicsCB.bChecked;saveconfig();break;
				  case LowGravCB:LowG=LowGravCB.bChecked;saveconfig();break;
				  case MapVoteCB:Vote=MapVoteCB.bChecked;saveconfig();break;
				  case TModeCB:Tournament=TModeCB.bChecked;saveconfig();break;
				  case TransCB:Trans=TransCB.bChecked;saveconfig();break;
              }
				case DE_Change:
				switch(C)
				{
					case TypeCombo:IterateMaps();break;
				}
		}

	if(TournamentGameReplicationInfo(GetPlayerOwner().GameReplicationInfo)==none) return;
	Game=TournamentGameReplicationInfo(GetPlayerOwner().GameReplicationInfo).GameClass;

        switch(E)
          {
              case DE_Click:
              switch(C)
              {
                  case LevelButton:NewLevel();break;
                  case PWClearButton:
                       XCon.ConsoleCommand("admin set engine.gameinfo gamepassword");
                       PassControl.Clear();
                       Echo("Game password cleared");
                       break;
              }

              case DE_EnterPressed:
              switch(C)
              {
                  case PassControl:
                       PW=PassControl.GetValue();
                       XCon.ConsoleCommand( "admin set engine.gameinfo gamepassword " $ PW );
                       Echo("Game password set to " $ PW);
                       PassControl.Clear();
                       PassControl.SetValue(PW);
					   break;
                  case TimeControl:
                       TimeLimit=TimeControl.GetValue();
                       saveconfig();
                       if(Game=="") return;
                       XCon.ConsoleCommand("admin set " $ Game $ " RemainingTime " $ (int(TimeLimit)*60));
                       XCon.ConsoleCommand("admin set " $ Game $ " TimeLimit " $ TimeLimit);
                       TimeControl.Clear();
                       TimeControl.SetValue(TimeLimit);
					   break;

                  case FragControl:
                       FragLimit=FragControl.GetValue();
                       saveconfig();
                       if(Game=="") return;
                       if(Game!="Botpack.DeathMatchPlus" && Game!="Botpack.LastManStanding")
                       XCon.ConsoleCommand("admin set " $ Game $ " GoalTeamScore " $ FragLimit);
                       else XCon.ConsoleCommand("admin set " $ Game $ " FragLimit " $ FragLimit);
                       FragControl.Clear();
                       FragControl.SetValue(FragLimit);
					   break;

                  case CapControl:
                       CapLimit=CapControl.GetValue();
                       saveconfig();
                       XCon.ConsoleCommand("admin set botpack.ctfgame goalteamscore " $ CapLimit);
                       CapControl.Clear();
                       CapControl.SetValue(CapLimit);
					   break;
				case FFControl:
					ChangeFF();
					FFControl.Clear();
					FFControl.SetValue(FFScale);
					break;
                 }
                 case DE_change:
                 switch(C)
                 {
                        case MaxCombo:
                        MaxPlayers=MaxCombo.GetValue();
                        XCon.ConsoleCommand("admin set engine.gameinfo MaxPlayers " $ MaxCombo.GetValue());
                        saveconfig();
                        break;

                        case MinCombo:
                        MinPlayers=MinCombo.GetValue();
                        XCon.ConsoleCommand("admin set deathmatchplus MinPlayers " $ MinCombo.GetValue());
                        saveconfig();
                        break;

                        case TeamsCombo:
                        if(Game=="") return;
                        MaxTeams=TeamsCombo.GetValue();
                        if(Game!="BotPack.DeathMatchPlus" && Game!="BotPack.LastManStanding")
                        XCon.ConsoleCommand("admin set "$ Game $ " MaxTeams " $ MaxTeams);
                        saveconfig();
                        break;

						case FFControl:
						return;
                 }
           }
     Super.Notify(C, E);
}

final function Echo(coerce string s){XCon.Echo(s);}

defaultproperties
{
    UseLocalMapList=True
    UseCustomMapList1=True
    MapVote="MapVoteLA13"
    TimeLimit="30"
    CustomMapList1(0)="JB-Warehouse-III"
    CustomMapList1(1)="JB-Freya"
    CustomMapList1(2)="JB-DarkTowers-III"
    CustomMapList1(3)="JB-Coret-III"
    CustomMapList1(4)="JB-OfMiceAndMen-III"
    CustomMapList1(5)="JB-Argos"
    FragLimit="10"
    CapLimit="5"
    MaxPlayers="8"
    MaxTeams="2"
    MinPlayers="0"
    MapList1Pos=5
    GameType(0)=(Name="Deathmatch",GameClass="BotPack.DeathMatchPlus",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="DM"),
    GameType(1)=(Name="Team Deathmatch",GameClass="BotPack.TeamGamePlus",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="DM"),
    GameType(2)=(Name="League Assault",GameClass="LeagueAS140.LeagueAssault",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="AS"),
    GameType(3)=(Name="Capture The Flag",GameClass="BotPack.CTFGame",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="CTF"),
    GameType(4)=(Name="Domination",GameClass="BotPack.Domination",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="DOM"),
    GameType(5)=(Name="Jailbreak",GameClass="Jailbreak.Jailbreak",Mutator="Mutator=MapVoteLA13.BDBMapVote",Prefix="JB"),
}
