class XConsole_SLRightClickMenu extends UWindowRightClickMenu config(XConsole);

var UWindowPulldownMenuItem SMessage[30], ASSubmenu, AdminSubMenu, CustomSubMenu1, CustomSubMenu2;

var string InfoName, SpecName, KickName, BanName, AdminPre;
var Console Con;
var AConsole XCon;
var XConsole_CW	XClient;

struct ServerMenus{
	var string Name;
	var string Command;
};

var config ServerMenus ServerMenu[30];
var config string CustomSub1Name, CustomSub2Name;
var config bool bShowAssaultSubmenu, bShowAdminSubMenu, bShowCustomSubMenu1, bShowCustomSubMenu2;

function created()
{
	local int i;
	super.created();
    Con = Root.Console;
	XCon=AConsole(Con);
	XClient=XCon.XClient;
	
	if(bShowAdminSubmenu)
	{
		AdminSubmenu=AddMenuItem("Admin",none);
		AdminSubMenu.createsubmenu(class'XConsole_AdminSubMenu', self);
		AdminSubMenu.SubMenu.bAlwaysOnTop=true;
		AdminSubMenu.SubMenu.bLeaveOnScreen=true;
		AdminSubMenu.SubMenu.HideWindow();
		AddMenuItem("-",none);
	}

	if(bShowAssaultSubmenu)
	{
		ASSubmenu=AddMenuItem("League Assault",none);
		ASSubMenu.createsubmenu(class'XConsole_ASSubMenu', self);
		ASSubMenu.SubMenu.bAlwaysOnTop=true;
		ASSubMenu.SubMenu.bLeaveOnScreen=true;
		ASSubMenu.SubMenu.HideWindow();
		AddMenuItem("-",none);
	}

	if(bShowCustomSubmenu1)
	{
		CustomSubmenu1=AddMenuItem(CustomSub1Name,none);
		CustomSubmenu1.createsubmenu(class'XConsole_CustomSubMenu1', self);
		CustomSubmenu1.SubMenu.bAlwaysOnTop=true;
		CustomSubmenu1.SubMenu.bLeaveOnScreen=true;
		CustomSubmenu1.SubMenu.HideWindow();
		AddMenuItem("-",none);
	}

	if(bShowCustomSubmenu2)
	{
		CustomSubmenu2=AddMenuItem(CustomSub2Name,none);
		CustomSubmenu2.createsubmenu(class'XConsole_CustomSubMenu2', self);
		CustomSubmenu2.SubMenu.bAlwaysOnTop=true;
		CustomSubmenu2.SubMenu.bLeaveOnScreen=true;
		CustomSubmenu2.SubMenu.HideWindow();
		AddMenuItem("-",none);
	}

	for(i=0;i<30;i++)
	{
		if(ServerMenu[i].Name!="")
		SMessage[i]=AddMenuItem(ServerMenu[i].Name,none);
	}
	saveconfig();
}

function ExecuteItem(UWindowPulldownMenuItem I)
{
	local int j;

	
	if(AdminPre=="")
	AdminPre=XCon.AdminTab.AdminPre;
	
	for(j=0;j<30;j++)
	{
		switch(I)
		{
		case SMessage[j]:ServerCom(j);break;
		}
	}
	xclient.playerlist.smenu.hidewindow();
	xclient.Overlay.smenu.hidewindow();

}

function ServerCom(int i)
{
	local string c, com;
	local int p, j;

	c=ServerMenu[i].Command $ ";";
	
	for(j=0;j<100;j++)
	{
		p=instr(c,";");
		if(p>-1)
		{
			com=left(c,p);
			c=right(c,len(c)-p-1);
			if(com!="") XCon.ExecMenuCommand(com);
		}
	}
}

function Echo(coerce string s)
{
	xclient.echo(S);
}

defaultproperties
{
    ServerMenu(0)=(Name="Server Message 1",Command="admin say # The server will restart after this map. Please reconnect."),
    ServerMenu(1)=(Name="Server Message 2",Command="admin say # Team are uneven! Please fix teams!"),
    ServerMenu(2)=(Name="Server Message 3",Command="admin say # Server shutting down for housekeeping after this map."),
    ServerMenu(3)=(Name="-",Command=""),
    ServerMenu(4)=(Name="Save Console Text",Command="dump"),
    ServerMenu(5)=(Name="Transparent Console",Command="trans"),
    ServerMenu(6)=(Name="-",Command=""),
    ServerMenu(27)=(Name="&Disconnect",Command="disconnect"),
    ServerMenu(28)=(Name="&Reconnect",Command="reconnect"),
    ServerMenu(29)=(Name="&Quit UT",Command="exit"),
    bShowAssaultSubmenu=True
    bShowAdminSubMenu=True
}
