//-----------------------------------------------------------
// Pure stuff
//-----------------------------------------------------------
class XConsole_PureTab extends UWindowPageWindow;

// controls
var UWindowSmallButton PButton[20], KickButton, BanButton, IDButton;
//var UWindowSmallButton LoginButton, LogoutButton;
//var UWindowEditControl LoginControl;
var UWindowComboControl KickCombo, BanCombo;

var string ButtonText[20], Com[20], IDText, HelpIDText, KickText, BanText;
var string HelpText[20], HelpKickText, HelpBanText;
//var string LoginText, LogoutText, HelpLoginText, HelpLogoutText;
var byte MaxCols, MaxRows;
var int CBXOffset, CBYoffset, CBoxOffset, CBWidth, CBSpread;

// Misc
var bool bCreated;
var name LogTag;

// Classes
var Console                 Con;
var AConsole                XCon;

final function DoVars(){

    Con=root.Console;
    XCon=AConsole(Con);
    CBXOffset=5;
    CBYOffset=5;
    CBSpread=55;
    CBWidth=54;
    MaxCols=5;
    MaxRows=2;

    ButtonText[0]="Pure ON";
    ButtonText[1]="Pure OFF";
    ButtonText[2]="Show IPs";
    ButtonText[3]="Netspeeds";
    ButtonText[4]="TickRate";
    ButtonText[5]="Info";
    ButtonText[6]="Fix Teams";
    ButtonText[7]="Next Team";
    ButtonText[8]="1st Person";
    ButtonText[9]="3rd Person";

    IDText="Show IDs";
    KickText="Kick ID:";
    BanText="Ban ID:";
    HelpIDText="Show player IDs";
    HelpKickText="Kick by ID";
    HelpBanText="Ban by ID";

    HelpText[0]="Turn on Pure";
    HelpText[1]="Turn off Pure";
    HelpText[2]="Show player IPs";
    HelpText[3]="Show player netspeeds";
    HelpText[4]="Show server tickrate";
    HelpText[5]="Show server cheat info";
    HelpText[6]="Fix team sizes";
    HelpText[7]="Switch to next team";
    HelpText[8]="1st Person view";
    HelpText[9]="3rd Person view";

    Com[0]="Mutate EnablePure";
    Com[1]="Mutate DisablePure";
    Com[2]="Mutate PureShowIPs";
    Com[3]="Mutate PureShowNetspeeds";
    Com[4]="Mutate PureShowTickrate";
    Com[5]="Mutate CheatInfo";
    Com[6]="Mutate FixTeams";
    Com[7]="Mutate NextTeam";
    Com[8]="BehindView 0";
    Com[9]="BehindView 1";
}

function Created(){

    DoVars();
    DoButtons();
    super.Created();
	bCreated=true;
}

// Buttons etc
final function DoButtons(){
 local byte i, Col, Row;

	for (i=0; i<20; i++)
	{
        if (ButtonText[i]=="")
        break;
        else if ( Row==MaxRows) { Row=0; Col+=1; }
        PButton[i] = UWindowSmallButton(CreateControl(class'UWindowSmallButton', (Col*CBSpread)+CBXOffset, (Row*18)+CBYOffset,CBWidth ,1 ));
        PButton[i].SetText(ButtonText[i]);
        PButton[i].ToolTipString=HelpText[i];
        PButton[i].bAlwaysBehind=true;
        PButton[i].Register(self);
        Row+=1;
    }

        KickCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 55+CBXOffset, 36+CBYOffset,108,1 ));
        KickCombo.SetEditable(false);
	    KickCombo.SetFont(F_Normal);
        KickCombo.bAlwaysBehind=true;
        KickCombo.AddItem("ID:");
        for(i=0;i<32;i++)
        {
        KickCombo.AddItem(string(i));
        }
        KickCombo.setselectedindex(0);

        BanCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 166+CBXOffset, 36+CBYOffset,108,1 ));
        BanCombo.SetEditable(false);
	    BanCombo.SetFont(F_Normal);
        BanCombo.bAlwaysBehind=true;
        BanCombo.AddItem("ID:");
        for(i=0;i<32;i++)
        {
        BanCombo.AddItem(string(i));
        }
        BanCombo.setselectedindex(0);

        KickButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 55+CBXOffset, 36+CBYOffset,CBWidth ,1 ));
        KickButton.SetText(KickText);
        KickButton.ToolTipString=HelpKickText;

        BanButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 166+CBXOffset, 36+CBYOffset,CBWidth ,1 ));
        BanButton.SetText(BanText);
        BanButton.ToolTipString=HelpBanText;

        IDButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CBXOffset, 36+CBYOffset,CBWidth ,1 ));
        IDButton.SetText(IDText);
        IDButton.ToolTipString=HelpIDText;
}

// notify
function Notify(UWindowDialogControl C, byte E)
{
local string S;
if(!bCreated)return;

    switch(E)
      {
          case DE_Click:
          switch(C)
          {
              case PButton[0]:XCon.ConsoleCommand(Com[0]); break;
              case PButton[1]:XCon.ConsoleCommand(Com[1]); break;
              case PButton[2]:XCon.ConsoleCommand(Com[2]); break;
              case PButton[3]:XCon.ConsoleCommand(Com[3]); break;
              case PButton[4]:XCon.ConsoleCommand(Com[4]); break;
              case PButton[5]:XCon.ConsoleCommand(Com[5]); break;
              case PButton[6]:XCon.ConsoleCommand(Com[6]); break;
              case PButton[7]:XCon.ConsoleCommand(Com[7]); break;
              case PButton[8]:XCon.ConsoleCommand(Com[8]); break;
              case PButton[9]:XCon.ConsoleCommand(Com[9]); break;
              case IDButton:XCon.ConsoleCommand("Mutate ShowID"); break;
              case KickButton:Kick();break;
              case BanButton:KickBan();break;
              break;
              }
              }

     Super.Notify(C, E);
}

final function Kick(){

    if(KickCombo.getselectedindex()!=0)
    {
    xcon.consolecommand("Mutate KickID " $ KickCombo.getselectedindex()-1);
    Echo("ID number " $ KickCombo.getselectedindex()-1 $ " has been kicked");
    }
}

final function KickBan(){

    if(BanCombo.getselectedindex()!=0)
    {
    xcon.consolecommand("Mutate BanID " $ BanCombo.getselectedindex()-1);
    Echo("ID number " $ BanCombo.getselectedindex()-1 $ " has been Banned");
    }
}

final function Echo(coerce string s){XCon.Echo(S);}

defaultproperties
{
    LogTag=PureTab
}
