class XConsole_PlayerListBox extends UWindowDialogClientWindow config(XConsole);

var string PlayerList[64];
var Console Con;
var AConsole XCon;
var float MouseX, MouseY;
var XConsole_CW XClient;
var string SelectedPlayer;
var class<UWindowPulldownMenu>   PRightClickMenuClass, SRightClickMenuClass;
var XConsole_SLRightClickMenu SMenu;
var XConsole_PLRightClickMenu PMenu;
var int Selected, SelectedID;
var bool bSelected;
var config bool bShowIDs;
var color selectcolour, red, blue, green, gold, lgrey, dgrey, white;

function created()
{
    Con = Root.Console;
    XCon=AConsole(Con);
	XCon.Plist=self;
	Setup();
	Super.Created();
}

function Setup()
{
    if(PRightClickMenuClass != None)
    {
        PMenu = XConsole_PLRightClickMenu(Root.CreateWindow(PRightClickMenuClass, 0, 0, 40, 50, Self));
        PMenu.HideWindow();
    }

    if(SRightClickMenuClass != None)
    {
        SMenu = XConsole_SLRightClickMenu(Root.CreateWindow(SRightClickMenuClass, 0, 0, 40, 50, Self));
        SMenu.HideWindow();
    }

}

final function Echo(coerce string s){
       XCon.Echo(s);
}

function BeforePaint(Canvas C, float MouseX, float MouseY)
{

}

function Resized()
{
//	super.Resized();
}
function string FixedNick(string s)
{
    local int i, ascnr;
    local string decnick;

    for(i=0;i<len(s);i++)
    {
        ascnr=asc(Left(Mid(S,i),1));
        if (ascnr < 0)
             ascnr+=256;

             decnick=decnick $ chr(ascnr);
    }
    return decnick;
}

function Paint(Canvas C, float X, float Y)
{
	local int i, j;
    local gamereplicationinfo Gri;
	local string PID, Pre, HasFlag;
    GRI = GetPlayerOwner().GameReplicationInfo;
	if(GRI==none) return;
//	if(VertSB!=none) VertSB.SetSize(0,0);
//    C.Font = Root.Fonts[F_Normal];
	C.DrawColor = SelectColour;
	DrawStretchedTexture(C, 0, wintop + selected*11, winwidth, 11, Texture'WhiteTexture');
	ClipText(C, 0, Selected*11, SelectedPlayer);

    for ( i=0 ; i<32 ; i++)
	{
		PID="";
		Pre="";
		HasFlag="";
        if (Gri.PRIArray[i]!=none && !(Gri.PRIArray[i].PlayerName=="Player" && Gri.PRIArray[i].PlayerID==0) 
			&& !Gri.PRIArray[i].bIsABot)
        {
			PlayerList[i]=Gri.PRIArray[i].PlayerName;
			if(PlayerList[i]!="")
			{
				if(Gri.PriArray[i].bAdmin && Gri.PriArray[i].bIsSpectator && !Gri.PriArray[i].bWaitingPlayer) C.DrawColor = white;
				else if(Gri.PRIArray[i].Team==0) C.DrawColor = red;
				else if(Gri.PRIArray[i].Team==1) C.DrawColor = blue;
				else if(Gri.PRIArray[i].Team==2) C.DrawColor = green;
				else if(Gri.PRIArray[i].Team==3) C.DrawColor = gold;
				else if(Gri.PRIArray[i].Team==255) C.DrawColor = lgrey;
				if(Gri.PriArray[i].bIsSpectator && !Gri.PriArray[i].bAdmin && !Gri.PriArray[i].bWaitingPlayer) 
					C.DrawColor = dgrey;
				
				if( ( instr( string(Gri.PriArray[i].HasFlag), "Flag" ) > -1 ) )	HasFlag="! ";
				if(bShowIDs) PID=string(GRI.PriArray[i].PlayerID) $ ": ";
				if(Gri.PriArray[i].bAdmin) pre="@";
				
				ClipText(C, 0, j*11,  PID $ HasFlag $ Pre $ PlayerList[i]);
				j++;
			}
        }
	}
}

function LMouseDown(float X, float Y)
{
	PaintSelected();
	SMenu.HideWindow();
	PMenu.HideWindow();
	Super.LMouseDown(X,Y);
}

function DoubleClick(float X, float Y)
{
	PaintSelected();
	root.console.viewport.actor.ViewPlayer(selectedplayer);
	root.EscClose();
	Super.DoubleClick(X,Y);
}

function RMouseUp(float X, float Y)
{
	PaintSelected();
	
	if(selectedplayer!="")
		PlayerMenu(X,Y);
	else
		ServerMenu(X,Y);
	Super.RMouseUp(X,Y);
}

function PlayerMenu(float X, float Y)
{

    local float MenuX, MenuY;
    local WindowConsole C;
	
	PaintSelected();

    if(PMenu != None)
    {
        WindowToGlobal(X, Y, MenuX, MenuY);
        PMenu.WinLeft = MenuX;
        PMenu.WinTop = MenuY;
		PMenu.WinWidth = 20;
        PMenu.ShowWindow();
		PMenu.bAlwaysOnTop=true;
		PMenu.bLeaveOnScreen=true;
		C = WindowConsole(GetPlayerOwner().Player.Console);
		C.bQuickKeyEnable=true;
    }
}

function ServerMenu(float X, float Y)
{

    local float MenuX, MenuY;
    local WindowConsole C;
	
	PaintSelected();

    if(SMenu != None)
    {
        WindowToGlobal(X, Y, MenuX, MenuY);
        SMenu.WinLeft = MenuX;
        SMenu.WinTop = MenuY;
		SMenu.WinWidth = 20;
        SMenu.ShowWindow();
		SMenu.bAlwaysOnTop=true;
		SMenu.bLeaveOnScreen=true;
		C = WindowConsole(GetPlayerOwner().Player.Console);
		C.bQuickKeyEnable=true;
    }
}

function PaintSelected()
{
	local int i, j;
	local float SplitterLeft, SplitterTop, SplitterHeight, SplitterWidth;
    local gamereplicationinfo Gri;
    GRI = GetPlayerOwner().GameReplicationInfo;
	if(GRI==none) return;

	SplitterLeft=xcon.xclient.splitter.winleft;
	SplitterTop=xcon.xclient.splitter.wintop;
	SplitterHeight=xcon.xclient.splitter.winheight-SplitterTop-16;
	SplitterWidth=xcon.xclient.splitter.winwidth;
    
	for ( i=0 ; i<40 ; i++)
	{
        if (Gri.PRIArray[i]!=none && !(Gri.PRIArray[i].PlayerName=="Player" && Gri.PRIArray[i].PlayerID==0) 
			&& !Gri.PRIArray[i].bIsABot)
        {
			PlayerList[i]=Gri.PRIArray[i].PlayerName;
			if(PlayerList[i]!="")
			{
				if(MouseY >= j*11 && MouseY <= (j*11)+10 && MouseX > Winleft && MouseX < Winleft + WinWidth)
				{
					SelectedPlayer=PlayerList[i];
					Selected=j;
					break;
				}
				j++;
			}
        }
			else 
			{
				SelectedPlayer="";
				Selected=-1;
			}		
	}
	if( MouseY > (j+1)*11 )
	{
		SelectedPlayer="";
		Selected=-1;
	}
		SMenu.AdminSubmenu.SubMenu.hidewindow();
		SMenu.ASSubmenu.SubMenu.hidewindow();
		if(SMenu.CustomSubMenu1!=none) SMenu.CustomSubMenu1.SubMenu.hidewindow();
		if(SMenu.CustomSubMenu2!=none) SMenu.CustomSubMenu2.SubMenu.hidewindow();
}

defaultproperties
{
    PRightClickMenuClass=Class'XConsole_PLRightClickMenu'
    SRightClickMenuClass=Class'XConsole_SLRightClickMenu'
    selectcolour=(R=0,G=0,B=50,A=0),
    Red=(R=255,G=15,B=15,A=0),
    Blue=(R=0,G=100,B=255,A=0),
    Green=(R=0,G=180,B=0,A=0),
    gold=(R=180,G=180,B=0,A=0),
    lgrey=(R=80,G=80,B=80,A=0),
    dgrey=(R=35,G=35,B=35,A=0),
    White=(R=255,G=255,B=100,A=0),
}
