class XConsole_PLRightClickMenu extends UWindowRightClickMenu config(XConsole);

var UWindowPulldownMenuItem info, spec, Follow, StopFollow, PMessage[30], kick, ban;
var XConsole_PlayerListBox List;

var string InfoName, SpecName, KickName, BanName, SelectedPlayer, AdminPre;
var string FollowName, StopFollowName;
var Console Con;
var AConsole XCon;
var XConsole_CW	XClient;

struct PlayerMenus{
	var string Name;
	var string Command;
};

var config PlayerMenus PlayerMenu[30];

function created()
{
	local int i;
	local bool pname;

	super.created();
    Con = Root.Console;
	XCon=AConsole(Con);
	XClient=XCon.XClient;

	Info = AddMenuItem(InfoName, none);
	AddMenuItem("-",none);
	Spec = AddMenuItem(SpecName, none);
	Follow = AddMenuItem(FollowName, none);
	StopFollow = AddMenuItem(StopFollowName, none);
	AddMenuItem("-",none);

	for(i=0;i<30;i++)
	{
		if(PlayerMenu[i].Name!="")
		{
			PMessage[i]=AddMenuItem(PlayerMenu[i].Name,none);
			pname=true;
		}
	}

	if(pname) AddMenuItem("-",none);
	
	Kick = AddMenuItem(KickName, none);
	Ban = AddMenuItem(BanName, none);

	SaveConfig();
}


function ExecuteItem(UWindowPulldownMenuItem I)
{
	local int j;

	
	if(AdminPre=="")
	AdminPre=XCon.AdminTab.AdminPre;
	
	for(j=0;j<30;j++)
	{
		switch(I)
		{
			case PMessage[j]:PlayerMsg(j);break;
		}
	}
	
	switch(I)
    {
		case Info:PlayerInfo();break;
		case Kick:PlayerKick();break;
		case Ban:PlayerBan();break;
		case Spec:SpecPlayer();break;
		case Follow:FollowPlayer();break;
		case StopFollow:StopFollowPlayer();break;
	}
	xclient.playerlist.pmenu.hidewindow();
}

function PlayerInfo()
{
	local GameReplicationInfo GRI;
	local PlayerReplicationInfo PRI;
	local int i;

	xclient.playerlist.pmenu.hidewindow();
	GRI = GetPlayerOwner().GameReplicationInfo;
	if(GRI==none) return;

	for(i=0; i<32; i++)
	{
		if(GRI.PriArray[i].PlayerName == xclient.playerlist.selectedplayer)
		break;
	}
	
	PRI=GRI.PriArray[i];
	if(PRI==none) return;
	echo("*********************************");
	echo("Info for player " $ PRI.PlayerName);
	if(PRI.bIsSpectator && !PRI.bWaitingPlayer) echo("Spectator");
	echo("ID: " $ PRI.PlayerID);
	echo("Team ID: " $ PRI.TeamID);
	echo("Ping: " $ PRI.Ping);
	echo("Packet Loss: " $ PRI.PacketLoss);
	echo("Score: " $ int(PRI.Score));
	echo("Deaths: " $ int(PRI.Deaths));
//	echo("Start Time: " $ PRI.StartTime);
//	echo("Time Acc: " $ PRI.TimeAcc);
	echo("*********************************");

}

function string FixedNick(string s)
{
	local int i, ascnr;
	local string decnick;

	for(i=0;i<len(s);i++)
	{
		ascnr=asc(Left(Mid(S,i),1));
		if (ascnr < 0)
			 ascnr+=256;

			 decnick=decnick $ chr(ascnr);
	}
	return decnick;
}


function PlayerMsg(int mi)
{
	local string Slap, Player;
	local int i, l, p, pos[10];

	Slap=PlayerMenu[mi].Command;
	Player=FixedNick(xclient.playerlist.selectedplayer);
	
	for(i=0;i<10;i++)
	{
		pos[i]=-1;
		p=instr(slap,"%p%");
		if(p>-1)
		{
			pos[i]=p;
			slap = left(slap,pos[i]) $ "xxx" $ right(slap,len(slap)-p-3);
		}
	}

	Slap=PlayerMenu[mi].Command;
	for(i=10;i>-1;i--)
	{
		l=len(slap);
		if(pos[i]>-1)
		{
			slap = left(slap,pos[i]) $ Player $ right(slap,l-pos[i]-3);
		}
	}

	PlayerCom(Slap);
}

function PlayerCom(string S)
 {
     local string com;
     local int p, j;

     S = S $ ";";

     for(j=0;j<100;j++)
     {
         p=instr(S,";");
         if(p>-1)
         {
             com=left(S,p);
             S=right(S,len(S)-p-1);
             if(com!="") XCon.Concommand(com);
         }
     }
 }

function Echo(coerce string s)
{
	xclient.echo(S);
}

function SpecPlayer()
{
	xclient.playerlist.pmenu.hidewindow();
	GetPlayerOwner().ViewPlayer(xclient.playerlist.selectedplayer);
	root.EscClose();
}

function FollowPlayer()
{
	xclient.playerlist.pmenu.hidewindow();
	GetPlayerOwner().ViewPlayer(xclient.playerlist.selectedplayer);
	XCon.bFollow=true;
	XCon.Followee=xclient.playerlist.selectedplayer;
	XCon.exo("Following " $ XCon.Followee $ ". Type 'stopfollow' to end.");
	XCon.enable('tick');
	root.EscClose();
}

function StopFollowPlayer()
{
	XCon.bFollow=false;
	xclient.playerlist.pmenu.hidewindow();
	root.EscClose();
}

function PlayerKick()
{
	xcon.concommand(adminpre $"kick " $ xcon.xclient.playerlist.selectedplayer);
}

function PlayerBan()
{
    xcon.concommand("admin kickban " $ xcon.xclient.playerlist.selectedplayer);
}

defaultproperties
{
    InfoName="&Player Info"
    SpecName="&Spectate Player"
    KickName="&Kick Player"
    BanName="&Ban Player"
    FollowName="&Follow Player"
    StopFollowName="S&top Following Player"
    PlayerMenu(0)=(Name="Player Message 1",Command="admin say # %p%: Your behaviour will not be tolerated on this server. First warning."),
    PlayerMenu(1)=(Name="Player Message 2",Command="admin say # %p%: Your behaviour will not be tolerated on this server. Second warning."),
    PlayerMenu(2)=(Name="Player Message 3",Command="admin say # %p%: Your behaviour will not be tolerated on this server. Final warning."),
}
