//-----------------------------------------------------------
// Logging box
//-----------------------------------------------------------
class XConsole_Logger extends StatLogFile;

// classes stuff
var AConsole                  XCon;
var XConsole_LogActor         Ticker;
var XConsole_CW               XClient;
var XConsole_LogTab           LogTab;
var viewport VP;

// state bools
var bool bLogging, bTimeStamp,bLogLock,bLogOpen,TickTest,Snafu,bMarkSet,bRounds,ChangeMode;
var bool bUseColours;

var GameReplicationInfo GINFO;

// console + log strings
var string OldMap, OldServer, LogState, LogStr[5000], AsLogStr[5000], EndStr, OldAsMap;
var string WeekDay[7], LogStartStr, ErrorsStr,MapChgStr,LogEndStr,StartStr, OverStr, UnderStr;
var string ConOverStr, ConUnderStr, Spacer;
var string D, Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM,FinalName;
var string TeamColour[5], LogStrA[5000], LogStrB[5000];

var int Checkline,TopLine,ClipA,SafeCount,LogOffSet, MaxLines, ASCount, ASMarkA, NumLines;
var int LogFormat, OldFormat, MarkBSet;
var name LogTag;

// Initiator
final function Init(){

    log("Logger spawning away happily",logtag);
    ErrorsStr="#\\/?*<:>\"| ";
    WeekDay[0]="Sunday";
    WeekDay[1]="Monday";
    WeekDay[2]="Tuesday";
    WeekDay[3]="Wednesday";
    WeekDay[4]="Thursday";
    WeekDay[5]="Friday";
    WeekDay[6]="Saturday";
    StatLogFile="../XLogs/XLogDummy.tmp.Log";
    StatLogFinal="../XLogs/XLogDummy.log";
    LogEndStr = "}----------------------------------{ Log End }----------------------------------{";
    LogStartStr="}----------------------------------{ Log Start }---------------------------------{";
    UnderStr="";
    OverStr= "__________________________________________________________________________________________";
    ConUnderStr=Left(UnderStr,60);
    ConOverStr=Left(OverStr,60);
    Spacer="                    ";
    LogFormat=LogTab.LogFormat;
    OldFormat=LogFormat;
    if(Snafu) LogState="snafu";else LogState="waiting";
	TeamColour[0]="<font color=#CC0000>";
	TeamColour[1]="<font color=#0000CC>";
	TeamColour[2]="<font color=#00CC00>";
	TeamColour[3]="<font color=#AAAA00>";
	TeamColour[4]="<font color=#CCCCCC>";
    Loop();
    SetTimer(60, True);
}

function SafeLevelChange(){
    if(!bMarkSet){ MarkA(); return; }
    else MarkB();
    return;
}

function LevelChange(){
if(!IsMap()) return;
    if(Snafu){SafeLevelChange();return;}
    CheckLine=(Con().TopLine + 1) % Con().MaxLines;
    gotostate('waiting');
}

// no-state loop
function Loop(){
    if(LogState~="logging")gotostate('Logging');return;
    if(LogState~="waiting")gotostate('Waiting');return;
    if(LogState~="snafu")gotostate('SafeLog');return;
}

// log state
state Logging{
    function Loop(){
        LogState="Logging";
        if(!bLogging) return;
        if(!bLogOpen) StartLogging();
        if(Checkline!=(Con().TopLine + 1) % Con().MaxLines) LogLine();
        if(change()) gotostate('waiting');
        return;
    }
}

// waiting state
state Waiting{
    function Loop()
    {
        LogState="Waiting";
        if(!bLogging) return;
        if(bLogOpen) StopLogging();
        if(IsMap()) gotostate('Logging');
    }

}

// Snafu state
state SafeLog{
    function Loop(){
        LogState="Snafu";
        if(Ticker!=none) LogTab.KillTimer();
    }
}



// one-liners for ya
final function Echo(coerce string s){XClient.Echo(s);} // text
final function CR() {Echo(" ");} // cr
final function PlayerPawn Player(){if(VP!=none)return VP.Actor;}// playerowner
final function WindowConsole Con(){if(VP!=none)return WindowConsole(VP.Console);} // console
final function string Logger(){if(VP!=none)return VP.Actor.GetDefaultUrl("name");}// name
final function PlayerReplicationInfo PRI(){return Player().PlayerReplicationInfo;}// pri
final function GameReplicationInfo GRI(){if(VP!=none) return VP.Actor.GameReplicationInfo;}// gri
final function TournamentGameReplicationInfo TGRI(){return TournamentGameReplicationInfo(GRI());}//tgri
final function string Server(){if(GRI()!=none) return GRI().ServerName;}//server
final function bool Change(){return(Map()!=OldMap||Server()!=OldServer);}//changes
final function string Map(){return left(Level(),instr(Level(),".LevelInfo"));}// map
final function bool IsMap(){return (Map()!="UT-Exo-Map" && Map()!="UT-Logo-Map" && Map()!="Entry" && Map()!="CityIntro" && Server()!="");}// map?
final function bool IsText(string T){return (t!=""&&t!=" ");}// is worth logging?
final function string MSGText(PlayerReplicationInfo P, name N,string T){if(n=='Say'||n=='TeamSay') return T;}//pri
final function LevelInfo Level(){if(VP!=none) return VP.Actor.Level;}// levelinfo
final function bool IsAssault(){ if(GRI()!=none && instr(GRI().GameClass,"Assault")>=0)return true;else return false;}//gametype tester
final function string OldAsStr(){If(AsStr()=="(Defending)") return "(Attacking)"; else return "(Defending)";}
final function NewFile(){OpenFile(FileName()); DoHeader();}
final function EndFile(){DoFooter(); CloseFile();}
final function Snafued(){Snafu=true;if(bLogOpen && bLogging) StopLogging();MarkA();gotostate('SafeLog');}//going Snafu
final function UnSnafued(){Snafu=false;if(bMarkSet && bLogging) MarkB();gotostate('Waiting');}//back to norm
function Timer()
{
	local int i, Time;

	local string s;
	

	s = "<tr><td width=10>" $ GameTime() $ "<td width=10><td>";
	
	//Log("Timer/LOGGER");
	
	GINFO = GRI();
	
	
	Time = VP.Actor.Level.TimeSeconds + VP.Actor.PlayerReplicationInfo.StartTime;

	//Log(GINFO.ElapsedTime $ "-");


	SortPRIArray();	
	
	if(GINFO.bTeamGame)
	{
		for(i = 0;i<2;i++)
		{
			s = s $ TeamColour[i] $ " TEAM " $ i $ " = " $ int(TournamentGameReplicationInfo(GINFO).Teams[i].Score) $ "</font><br>";
	
		}
		s = s $ "<hr>";
	}
	
	s = s $ "<table><tr><th>Name</th><th>F</th><th>D</th><th>FPH</th></tr>";
	for(i = 0;i<ArrayCount(GINFO.PRIArray);i++)
	{
		if(GINFO.PRIArray[i] != None && !GINFO.PRIArray[i].bIsSpectator)
		{
			s = s $ "<tr><td>";
		
			if(GINFO.PRIArray[i].Team != 255) s = s $ TeamColour[GINFO.PRIArray[i].Team];
			else s = s $ TeamColour[4];

			s = s $ GINFO.PRIArray[i].PlayerName $ "</font></td><td>" $ int(GINFO.PRIArray[i].Score) $ "</td><td>" 
				$ int(GINFO.PRIArray[i].Deaths) $ "</td><td>" $ int(GINFO.PRIArray[i].Score * 3600 /Max(60, Time - GINFO.PRIArray[i].StartTime)) $ "</td></tr>";
				
		}
	}
	
	s = s $  "</table></tr>";
	LogEvent(s);
	
}

final function SortPRIArray()
{

local int I, J, Max, N;
local PlayerReplicationInfo TempPRI;

for(I = 0;I<32;I++)
	if(GINFO.PRIArray[i] != None)
		N++;

	for ( I=0; I<N-1; I++ )
    {
        Max = I;
        for ( J=I+1; J<N; J++ )
        {
        	  if(GINFO.bTeamGame)
        	  {
        	  
        	  	 if(GINFO.PRIArray[J].Team < GINFO.PRIArray[Max].Team)
       	    	  	 Max = J;  	  	 
  	 		  else if(GINFO.PRIArray[J].Team == GINFO.PRIArray[Max].Team && GINFO.PRIArray[J].Score > GINFO.PRIArray[Max].Score)
	                Max = J;
	            else if (GINFO.PRIArray[J].Team == GINFO.PRIArray[Max].Team && (GINFO.PRIArray[J].Score == GINFO.PRIArray[Max].Score) && (GINFO.PRIArray[J].Deaths < GINFO.PRIArray[Max].Deaths))
	                Max = J;
	            else if (GINFO.PRIArray[J].Team == GINFO.PRIArray[Max].Team && (GINFO.PRIArray[J].Score == GINFO.PRIArray[Max].Score) && (GINFO.PRIArray[J].Deaths == GINFO.PRIArray[Max].Deaths) &&
	                     (GINFO.PRIArray[J].PlayerName < GINFO.PRIArray[Max].PlayerName))
	                Max = J;
        	  }
        	  else
        	  {
		  if(GINFO.PRIArray[J].Score > GINFO.PRIArray[Max].Score)
                Max = J;
            else if ((GINFO.PRIArray[J].Score == GINFO.PRIArray[Max].Score) && (GINFO.PRIArray[J].Deaths < GINFO.PRIArray[Max].Deaths))
                Max = J;
            else if ((GINFO.PRIArray[J].Score == GINFO.PRIArray[Max].Score) && (GINFO.PRIArray[J].Deaths == GINFO.PRIArray[Max].Deaths) &&
                     (GINFO.PRIArray[J].PlayerName < GINFO.PRIArray[Max].PlayerName))
                Max = J;
             }
        }
			
	if(Max != I)
		{
		
        TempPRI = GINFO.PRIArray[Max];
        GINFO.PRIArray[Max] = GINFO.PRIArray[I];
        GINFO.PRIArray[I] = TempPRI;
        
        }
        
    }	
}


final function string ServerURL(){
	local string u;

	u=Level().GetAddressURL();
	if (instr(u,":")==0)u="127.0.0.1";
	return u;
}


final function LogEvent(string S)
{
	if(!bLogOpen) return;
	FileLog(S);FileFlush();
}


// log switch
final function LogSwitch()
{
//    if(bLogging && (!bLogOpen || !bMarkSet))
    if(bLogging)
        {
            if(Snafu) MarkA(); else StartLogging();
            return;
        }
//    if(!bLogging && (bLogOpen || bMarkSet))
    if(!bLogging)
        {
            if(Snafu) MarkB(); else StopLogging();
            return;
        }
}

// Game elapsed time
final function string GameTime(){
    local string m,s;
    local float gt;
    local int gm,gs;

    if(!bTimeStamp||GRI()==none||TGRI()==none)return "";
    gt=GRI().RemainingTime;
    if(TGRI().TimeLimit==0) gt=GRI().ElapsedTime;
    gs=gt % 60;
    if(gs>9) {s=string(gs);} else {s="0"$gs;}
    if (gt>59){gm=int(gt/60);}
    if(gm>9){m=string(gm);}else {m="0"$gm;}
    return "["$m$":"$s$"] ";
}

// time and date
final function string FileTime(){
     if(Level()==none)return "";
     Date(Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM);
     return Year$"."$Month$"."$Day$"-"$Hour$"."$Min$"."$Sec;
}

// more user friendly form
final function string LogTime(){
     if(Level()==none)return "";
     Date(Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM);
     if(AMPM=="PM")Hour=string(int(Hour)-12);
     if(XClient.DateStyle==0)return DayOfWeek$" "$Day$"/"$Month$"/"$Year$" "$Hour$"."$Min$" "$AMPM;
     else return DayOfWeek$" "$Month$"/"$Day$"/"$Year$" "$Hour$"."$Min$" "$AMPM;
}

// date time from levelinfo
final function Date(out string Y,out string M,out string D,out string DOW,out string H,out string Min,out string S,out string AP){
    local LevelInfo L;
    L=Level();
    Y = string(L.Year);
    if (L.Month < 10) M = "0"$L.Month;	else M = ""$L.Month;
    if (L.Day < 10)	D = "0"$L.Day;	else D = ""$L.Day;
    if (L.Hour < 10) H = "0"$L.Hour; else H = ""$L.Hour;
    if (L.Minute < 10) Min = "0"$L.Minute; else Min = ""$L.Minute;
    if (L.Second < 10) S = "0"$L.Second; else S = ""$L.Second;
    if (L.Hour > 12) AP="PM";else AP="AM";
    DOW=WeekDay[L.DayOfWeek];
}

// Make Filename
final function string FileName(){
    local int i, j;
    local string S,M,F;
    FinalName="";
    S=Server();M=Map();F=FileTime();
    while (i < Len(S)) 
	{
        if ( InStr(ErrorsStr,Mid(S,i,1)) != -1 ) FinalName=FinalName $ "_";
    	else FinalName=FinalName $ Mid(S,i,1);
    	i++;
    }

	while(InStr(FinalName,"__") !=-1)
	{
		j=InStr(FinalName,"__");
		if(j !=-1) 
		FinalName=left(FinalName,j) $ right(FinalName,len(FinalName)-j-1);
	}

    FinalName = F $ "-" $ M $ "-" $ FinalName;
    return FinalName;
}

// start
final function StartLogging(){
    NewFile();
    Echo("____________________________________________________________");
    Echo("     " $ LogPad("Log Start"));
    Echo("");
	OldMap=Map();OldServer=Server();
    gotostate ('Logging');
}

// ender
final function StopLogging(){
	if(!bLogOpen) return;
    EndFile();
    Echo("____________________________________________________________");
    Echo("    " $ LogPad(OldMap $ " End"));
    Echo("");
    OldMap="";OldServer="";
    gotostate ('Waiting');
}

// one line
final function LogLine(){
    local name Type;
    local string Text, PName, Colour, MsgColour;
    local PlayerReplicationInfo MSGPRI;
	local int l;

    MSGPRI = Con().GetMsgPlayer(CheckLine);
	Type = Con().GetMsgType(CheckLine);
	Text = Con().GetMsgText(CheckLine);
	
	
	if(MSGPRI!=none && bUseColours)
	{
		if(MSGPRI.Team!=255) Colour=TeamColour[MSGPRI.Team];
			else Colour=TeamColour[4];
	}
	else Colour="";
	
	if(MSGPRI!=none)
	{
		l=len(MSGPRI.PlayerName);

		if(Type=='event' && mid(Text,l,1)==":" && MSGPRI.bIsSpectator && 
			instr(Text,MSGPRI.PlayerName)==0) 
		{
			Text=mid(Text,l+1);
			PName=MSGPRI.PlayerName;
		}
		else if(Type=='say' || Type=='teamsay') PName=MSGPRI.PlayerName;
	}

	if(bUseColours && Type=='teamsay') MsgColour=Colour;

	if(IsText(Text)) 
		LogEvent("<tr><td width=10>" $ GameTime() $ "<td width=10><b>" $ Colour $ PName $ "</b></font><td>" $ MsgColour $ Text $ "</font></tr>");

	CheckLine=(CheckLine + 1) % Con().MaxLines;
}

final function DoText(string S){
     FileLog(S);FileFlush();
}

// header
final function DoHeader(){
    local int l, m,i;local string a, b;

    if(LogFormat==1)
    {
    DoText("<html><head>");
    DoText("<meta http-equiv='Content-Type' content='text/html' charset='utf-16'>");
    DoText("<link rel='stylesheet' href='style.css'>");
    DoText("<link rel='shortcut icon' href='favicon.ico'>");
    DoText("<title>UT Log " $ FinalName $ "</title>");
    DoText("</head>");
    DoText(" ");
    DoText("<body bgcolor=#000000 link=#dddddd alink=#ffffff vlink=#dddddd text=ffffff>");
    DoText("<center>");
    DoText("<table border=2><tr><td>");
    DoText("<table border=1 width=100% bgcolor=#444444><tr><th>");
    LogEvent("<br>");
    LogEvent("UNREAL TOURNAMENT LOG<br>");
    LogEvent(" Server:        "$Server() $ "<br>");
	LogEvent(" IP:            "$ServerURL() $ "<br>");
    LogEvent(" Map:           "$Map() $ "<br>");
    LogEvent(" Logger:        "$Logger() $ "<br>");
    LogEvent(" Log Time:      "$LogTime() $ "<br>");
    LogEvent("<br>");
    DoText("</td></tr></table>");
    DoText("<table border=1 width=100%>");
    DoText("<tr><td>");
    }
    else
    {
    DoText("}--------------------------------{ Unreal Tournament Log }-------------------------------{");
    DoText(" ");
    DoText(" Server:        "$Server());
    DoText(" IP:            "$ServerURL());
    DoText(" Map:           "$Map());
    DoText(" Logger:        "$Logger());
    DoText(" Log Time:      "$LogTime());
    DoText(" ");
    DoText("}----------------------------------------------------------------------------------------{");
    DoText(" ");
    }
}

final function DoMapStart(string S){

    if(LogFormat==0)
    {
		logevent(OverStr);
		logevent(LogPad(map() $ " Start " $ S ));
		logevent(UnderStr);
    }
    else
    {
		LogEvent("<center>" $ OverStr $ "<br>");
		logevent(LogPad(map() $ " Start " $ S $ "<br>"));
		logevent(UnderStr $ "</center><br>");
    }
}

// footer
final function DoFooter(){
    LogEvent(" ");
    if(LogFormat==1)
    {
		DoText("</table>");
		DoText("<table border=1 width=100% bgcolor=#444444><tr><th>");
		LogEvent("<br>");
		LogEvent("AConsole "$xcon.version $ "<br>");
		LogEvent("<a href=mailto:xconsole@unrealize.co.uk>xconsole@unrealize.co.uk</a><br>");
		LogEvent("<a href=http://www.unrealize.co.uk>http://www.unrealize.co.uk</a><br>");
		LogEvent("<br>");
		DoText("</td></tr></td></tr></table></table></html></body>");
    }
    else
    {
		LogEvent("}----------------------------------------------------------------------------------------{");
		LogEvent(" ");
		LogEvent("AConsole "$xcon.version);
		LogEvent("xconsole@unrealize.co.uk");
		LogEvent("http://www.unrealize.co.uk");
		LogEvent(" ");
		LogEvent("}----------------------------------------------------------------------------------------{");
    }

    if(ChangeMode) LogFormat=LogTab.LogFormat;
    ChangeMode=false;
}

// file creator
final function OpenFile(coerce string F){
    if(bLogOpen) return;
    if(LogFormat==1)
    {
    StatLogFile="../XLogs/" $ F$ ".unfinished.html";
    StatLogFinal="../XLogs/" $ F $ ".html";
    }
    else
    {
    StatLogFile="../XLogs/" $ F$ ".unfinished.log";
    StatLogFinal="../XLogs/" $ F $ ".log";
    }
    Log("Attempting open file --> "$StatLogFinal,logtag);
    OpenLog();
    bLogOpen=true;
}

// file closer
final function CloseFile(){
    if(!bLogOpen) return;
    FileFlush();
    CloseLog();
    bLogOpen=false;
    log("File Closed",logtag);
}

//---------------- safe mode
// Snafumode 1
final function MarkA(){
	if(bMarkSet) { MarkB(); return; }
	if(IsMap()) return;
    SafeCount++;
    Echo("____________________________________________________________");
	Echo(StartCount());
    Echo("");
	bMarkSet=true;
}

//Snafumode 2
final function MarkB(){
	if(IsAssault() && bRounds) { AssaultMarkB(); return; }
    if(!IsMap() || !bMarkSet)return;
	Echo("____________________________________________________________");
    Echo(EndCount());
    Echo("");
    GetText(NumLines);
    NewFile();
    LogText(NumLines);
    EndFile();
    OldMap="";OldServer="";bMarkSet=false;
    if(bLogging) MarkA();
}

function AssaultMarkB(){
	MarkBSet++; 
	if(MarkBSet==1) { EndFirstRound(); return; }
	MarkBSet=0;
	Echo("____________________________________________________________");
    Echo(EndCount());
    Echo("");
    LogAssaultRound();
    bMarkSet=false;
	MarkA();
}

function EndFirstRound(){

	Echo("____________________________________________________________");
	Echo(LogPad("Round Over"));
	Echo("");
	OldAsMap=(Server() $ Map());
	GetASTextA(NumLines);
}

final function LogAssaultRound(){
    NewFile();
    DoMapStart(OldAsStr());
	GetASTextB(NumLines);
    LogTextA();
    AsMarker();
	LogTextB();
    EndFile();
    OldMap="";OldServer="";OldAsMap="";
    bMarkSet=false;
    MarkA();
}

final function LogTextA(){
    local int i;
    for(i=0; i < MaxLines; i++)
        {
			if(LogStrA[i]!="")
			{
				if(LogFormat==0) LogEvent(LogStrA[i]);
				else LogEvent(LogStrA[i] $ "<br>");
			}
				 
        }
}

final function LogTextB(){
    local int i;
    for(i=0; i < MaxLines; i++)
        {
			if(LogStrB[i]!="")
			{
				if(LogFormat==0) LogEvent(LogStrB[i]);
				else LogEvent(LogStrB[i] $ "<br>");
			}
				 
        }
}

final function LogText(int j){
    local int i;
    for(i=0; i <= j; i++)
        {
			if(LogStr[i]!="")
			{
				if(LogFormat==0) LogEvent(LogStr[i]);
				else LogEvent(LogStr[i] $ "<br>");
			}
				 
        }
}

final function NoAsRound(){
    CR();
    Echo(EndCount());
    GetText(NumLines);
    NewFile();
    LogText(NumLines);
    EndFile();
    OldMap="";OldServer="";bMarkSet=false;
    MarkA();
}

final function string StartCount(){
    local string S;
    S=SafeCount $ LogPad(" Log Start");
    if(SafeCount<10) S="0" $ S;
    if(SafeCount<100) S="0" $ S;
    StartStr=S;
    return S;
}


final function string EndCount(){
    local string S;
    S=SafeCount $ LogPad(Map() $ " End    ");
    if(SafeCount<10) S="0" $ S;
    if(SafeCount<100) S="0" $ S;
    EndStr=S;
    return S;
}

final function GetASTextA(out int N){
    local int i,ClipA,ClipB;
    local UWindowDynamicTextRow L;
    local UWindowList List;
    StartStr=StartCount();
    MaxLines=XCon.MaxLines();
    List=XClient.TextArea.List;
    for(ClipA=0; ClipA < MaxLines; ClipA++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            if(L.Text == StartStr) break;
        }
    ClipA = (ClipA + 2) % MaxLines;

    for(ClipB=0; ClipB < MaxLines; ClipB++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipB));
            if(L.Text == LogPad("Round Over")) break;
        }
    ClipB = (ClipB - 2) % MaxLines;

    for(i=0; i<MaxLines; i++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            LogStrA[i]= L.Text;
            if(ClipA == ClipB) break;
            ClipA = (ClipA + 1) % MaxLines;
        }
    N=i;
}

final function GetASTextB(out int N){
    local int i,ClipA,ClipB;
    local UWindowDynamicTextRow L;
    local UWindowList List;
    StartStr=StartCount();
    MaxLines=XCon.MaxLines();
    List=XClient.TextArea.List;
    for(ClipA=0; ClipA < MaxLines; ClipA++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            if(L.Text == LogPad("Round Over")) break;
        }
    ClipA = (ClipA + 2) % MaxLines;

    for(ClipB=0; ClipB < MaxLines; ClipB++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipB));
            if(L.Text == EndStr) break;
        }
    ClipB = (ClipB - 2) % MaxLines;

    for(i=0; i<MaxLines; i++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            LogStrB[i]= L.Text;
            if(ClipA == ClipB) break;
            ClipA = (ClipA + 1) % MaxLines;
        }
    N=i;
}


final function GetText(out int N){
    local int i,ClipA,ClipB;
    local UWindowDynamicTextRow L;
    local UWindowList List;
    StartStr=StartCount();
    MaxLines=XCon.MaxLines();
    List=XClient.TextArea.List;
    for(ClipA=0; ClipA < MaxLines; ClipA++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            if(L.Text == StartStr) break;
        }
    ClipA = (ClipA + 2) % MaxLines;

    for(ClipB=0; ClipB < MaxLines; ClipB++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipB));
            if(L.Text == EndStr) break;
        }
    ClipB = (ClipB - 2) % MaxLines;

    for(i=0; i<MaxLines; i++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(ClipA));
            LogStr[i]= L.Text;
            if(ClipA == ClipB) break;
            ClipA = (ClipA + 1) % MaxLines;
        }
    N=i;
}

// attack/defence divider
final function AsMarker(){
    if(LogFormat==0)
    {
		LogEvent(OverStr);
		LogEvent(LogPad("Round 2 " $ AsStr()));
		LogEvent(UnderStr);
    }
    else
    {
		LogEvent("<center>" $ OverStr $ "<br>");
		LogEvent(LogPad("Round 2 " $ AsStr() $ "<br>"));
		LogEvent(UnderStr $ "</center><br>");
    }
}

final function string LogPad(coerce string S){
    local int i,l;
    l = 45-(len(S)/2);
    while(i<l)
        {
        S = " " $ S;
        i++;
        }
    return S;
}

// el dumpo
final function Dump(){
    local int i;
    local UWindowDynamicTextRow L;
    local UWindowList List;
	local string File;

    MaxLines=XCon.MaxLines();
    List=XClient.TextArea.List;
    if(bLogOpen)StopLogging();
    File="Dump-" $ FileName();
	OpenFile(File);
    DoHeader();
    LogEvent(" ");
    for(i=0; i<MaxLines; i++)
        {
            L = UWindowDynamicTextRow(List.FindEntry(i));
            if((L!=none) && (L.Text!=""))
			{
			
			if(LogFormat==1)
				{
					FileLog(L.Text $ "<BR>");FileFlush();
				}
			else
				{
					FileLog(L.Text);FileFlush();
				}
			}
        }
    EndFile();
    if(LogFormat==1) echo("Console Text Dump -> " $ File $ ".html");
    else echo("Console Text Dump -> " $ File $ ".txt");
}

final function string AsStr(){
if (!IsAssault())return "";
if ( PRI().Team == Assault(Level().game).CurrentDefender )return "(Defending)";
else return "(Attacking)";
}

defaultproperties
{
    LogTag=XConsole_Logger
}
