//-----------------------------------------------------------
// the logger
// 3 types logging - normal mode uses rogue actor
// safe mode logs between mapo changes
// dump button saves all console text
//-----------------------------------------------------------
class XConsole_LogTab extends UWindowPageWindow config(XConsole);

var bool bVerbose, bCreated, bLogging;
var name LogTag;
var config bool bLogLock,bTimeStamp,bSafeMode,bRounds,bUseColours;
var config int LogFormat;
var UWindowComboControl LogFormatCombo, DateStyleCombo;
var UWindowSmallButton DumpButton;
var UWindowCheckbox LogBox[10];

var Console                 Con;
var AConsole                XCon;
var XConsole_LogActor       Ticker;
var XConsole_Logger         Logger;
var XConsole_CW             XClient;

var string LogBoxText[10], Help[10];
var byte MaxCols, MaxRows;
var int CBXOffset, CBYoffset, CBWidth, CBSpread;


final function MakeControls(){
    local byte Combowidth;
	local byte i, Col, Row;
    ComboWidth = 110;

    for (i=0; i<6; i++)
	{
        if ( Row==MaxRows) { Row=0; Col+=1; }
        LogBox[i] = UWindowCheckbox(CreateControl(class'UWindowCheckbox', (Col*CBSpread)+CBXOffset, (Row*15)+CBYOffset,CBWidth ,1 ));
        LogBox[i].SetText(LogBoxText[i]);
        LogBox[i].bAlwaysBehind=true;
        LogBox[i].ToolTipString=Help[i];
        LogBox[i].Register(self);
        Row+=1;
    }
    LogFormatCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 290, 10, ComboWidth, 1));
	LogFormatCombo.SetFont(F_Normal);
	LogFormatCombo.SetEditable(False);
    LogFormatCombo.AddItem("Text");
    LogFormatCombo.AddItem("HTML");
    LogFormatCombo.Text="    Format:";
    LogFormatCombo.bAlwaysBehind=true;
    LogFormatCombo.SetSelectedIndex(LogFormat);

    DateStyleCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 290, 30, ComboWidth, 1));
	DateStyleCombo.SetFont(F_Normal);
	DateStyleCombo.SetEditable(False);
    DateStyleCombo.AddItem("UK/Euro");
    DateStyleCombo.AddItem("US");
    DateStyleCombo.Text="Date Style:";
    DateStyleCombo.bAlwaysBehind=true;

    DumpButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',218,30,50,20));
    DumpButton.SetText("Dump!");
    DumpButton.ToolTipString="Dump console to log file now";
}

function Created(){
    DoVars();
    MakeControls();
    LogBox[0].bChecked=bLogLock;
    LogBox[1].bChecked=bTimeStamp;
    LogBox[2].bChecked=bLogLock;
    LogBox[3].bChecked=bRounds;
    LogBox[4].bChecked=bSafeMode;
    LogBox[5].bChecked=bUseColours;
    LogBox[1].bDisabled=bSafeMode;
    LogBox[3].bDisabled=!bSafeMode;
	LogBox[5].bDisabled=bSafeMode==true || LogFormat==0;
	bCreated=true;
//  if(bLogging && Logger==none) SpawnLogger();
//	if(bLogging && Logger!=none) SpawnSwitch();
//	if(bLogging) StartUp();
    super.Created();
	SaveConfig();
}

final function DoVars(){
    Con=root.Console;
    XCon=AConsole(Con);
    XCon.LogTab=self;;
	XClient=XCon.XClient;
    bLogging=bLogLock;
    CBSpread=90;
    CBWidth=70;
    CBXOffset=20;
    CBYOffset=5;
    MaxCols=5;
    MaxRows=3;

    LogBoxText[0]="Log";
    LogBoxText[1]="Timestamp";
    LogBoxText[2]="Log Lock";
    LogBoxText[3]="AS Rounds";
    LogBoxText[4]="Safe Mode";
    LogBoxText[5]="Use Colour";

    Help[0]="Logging on/off";
    Help[1]="Timestamp on/off";
    Help[2]="Auto start logging at UT startup";
    Help[3]="Sort Assault rounds into one file";
    Help[4]="Use safe mode logging without rogue timing actor";
    Help[5]="Use team colours";

}

final function SpawnTimer(){
    if(Ticker!=none || Logger==none)return;
    foreach GetEntryLevel().AllActors(class'XConsole_LogActor',Ticker)
    break;
    Ticker=root.GetEntryLevel().Spawn(class'XConsole_LogActor');
    LogBox[1].bDisabled=false;
	LogBox[5].bDisabled=false;
	LogBox[3].bDisabled=true;

    if(Logger!=none){Logger.Ticker=Ticker; Ticker.Logger=Logger; }
}

final function KillTimer(){
    if(Ticker==none)return;
    Ticker.destroy();
    Ticker=none;
    LogBox[1].bDisabled=true;
	LogBox[3].bDisabled=false;
    LogBox[5].bDisabled=true;

    if(Logger!=none){Logger.Ticker=none;}
}

final function SetVars(){

    bLogging=LogBox[0].bChecked;
    bTimeStamp=LogBox[1].bChecked;
    bLogLock=LogBox[2].bChecked;
    bRounds=LogBox[3].bChecked;
    bSafeMode=LogBox[4].bChecked;
    bUseColours=LogBox[5].bChecked;
    if(bLogging && bCreated && Logger==none) SpawnLogger();
	if(bLogging && bCreated && Logger!=none) SpawnSwitch();
    SaveConfig();
}

final function SafeToggle(){
	LogBox[4].bChecked=!LogBox[4].bChecked;
	SetVars();
}

final function SpawnLogger(){

	foreach GetEntryLevel().AllActors(class'XConsole_Logger',Logger)
	break;
	Logger=root.GetEntryLevel().Spawn(class'XConsole_Logger');

	if(Logger==none) { Log("Couldn't spawn Logger!"); return; }
	XCon.Logger=Logger;
	Logger.XCon=XCon;
	Logger.XClient=XClient;
	Logger.LogTab=self;
	Logger.Init();
    Logger.bLogging=bLogging;
    Logger.bTimeStamp=bTimeStamp;
    Logger.bRounds=bRounds;
    Logger.Snafu=bSafeMode;
    Logger.VP=root.Console.Viewport;
    Logger.LogFormat=LogFormat;
    Logger.bUseColours=bUseColours;
	if(bLogging && !bSafeMode) SpawnTimer(); 
	else if(bLogging) Logger.LevelChange();
}

final function SpawnSwitch(){
	if(bSafeMode) KillTimer();
	else SpawnTimer();
}

function StartUp(){
	if(bLogging && Logger==none) SpawnLogger();
	if(bLogging && Logger!=none) SpawnSwitch();
	if(Logger!=none) Logger.LogSwitch();
}

function LogToggle(){
	bLogging=!bLogging;
	LogBox[0].bChecked=bLogging;
    if(bLogging && bCreated && Logger==none) SpawnLogger();
	if(bLogging && bCreated && Logger!=none) SpawnSwitch();
	if(Logger!=none) Logger.LogSwitch();
}

function LockToggle()
{
	LogBox[2].bChecked=!LogBox[2].bChecked;
	echo ("Log lock " $ LogBox[2].bChecked);
	SaveConfig();
}
function Notify(UWindowDialogControl C, byte E)
{
if(!bCreated)return;
    switch(E)
      {
        case DE_Click:
             switch(C)
            {
                case LogBox[0]:SetVars(); Logger.LogSwitch(); break;
                case LogBox[1]:SetVars(); break;
                case LogBox[2]:SetVars(); break;
                case LogBox[3]:SetVars(); break;
                case LogBox[4]:SetVars(); break;
                case LogBox[5]:SetVars(); break;
                case DumpButton:XCon.Dump(); break;
                break;
            }
        case DE_Change:
             switch(C)
             {
             case LogFormatCombo:LogFormat=LogFormatCombo.GetSelectedIndex();
				  LogBox[5].bDisabled=bSafeMode || LogFormat==0;
                  saveconfig();
                  if(Logger!=none) Logger.LogFormat=LogFormat;
                  break;
             case DateStyleCombo:SetDate();break;
             break;
             }
        }

     Super.Notify(C, E);
}

final function SetDate(){

    if(XClient!=none)
    {
		XClient.DateStyle=DateStyleCombo.GetSelectedIndex();
		XClient.SaveConfig();
    }
}

final function Echo(coerce string s){XCon.Echo(S);}

defaultproperties
{
    LogTag=LOG-->
    bTimeStamp=True
    bSafeMode=True
    bRounds=True
    bUseColours=True
    LogFormat=1
}
