//-----------------------------------------------------------
// AConsole Frame Window
//-----------------------------------------------------------

class XConsole_FW expands UMenuConsoleWindow;

var float OldParentWidth, OldParentHeight;
var byte Margin;
var name logtag;
var string StatusBarText;
var console con;
var AConsole XCon;

function Created()
{
    Super.Created();
    InitPos();
	Con=root.console;
	XCon=AConsole(Con);
    WindowTitle="AConsole - Extended System Console " $ XCon.GetVersion() $" - xconsole@unrealize.co.uk";
    Margin=15;
}

function ResolutionChanged(float W, float H){InitPos();}
function Resized(){super.Resized();SetDimensions();}

final function InitPos(){
    SetSize((ParentWindow.WinWidth/4)*3,(ParentWindow.Winheight/4)*3);
	WinLeft = ParentWindow.WinWidth/2 - WinWidth/2;
	WinTop = ParentWindow.WinHeight/2 - WinHeight/2;
	MinWinWidth = 480;
    MinWinHeight = 145;
    OldParentWidth = ParentWindow.WinWidth;
    OldParentHeight = ParentWindow.WinHeight;
    class'xconsole_cw'.default.WW=WinWidth;
}

function ShowWindow(){
	Super.ShowWindow();
	SetDimensions();
	if(ParentWindow.WinWidth != OldParentWidth || ParentWindow.WinHeight != OldParentHeight)
	{
        InitPos();
	}
}

// Margin keeps console from getting lost under menu bar
function SetDimensions(){
    if (WinTop < Margin) { Wintop = Margin; }
    if (WinLeft < (Margin-Winwidth)) { WinLeft = Margin-winwidth; }
    if (WinTop > ParentWindow.WinHeight-Margin) { WinTop = ParentWindow.WinHeight-Margin; }
    if (WinLeft > ParentWindow.WinWidth-Margin) { WinLeft = ParentWindow.WinWidth-Margin; }
    SetSize(WinWidth, WinHeight);
    class'xconsole_cw'.default.WW=WinWidth;
}

defaultproperties
{
    LogTag=XConsole
    ClientClass=Class'XConsole_CW'
}
