//-----------------------------------------------------------
// Custom Buttons
//-----------------------------------------------------------
class XConsole_CustomTab expands UWindowPageWindow config(XConsole);

// controls
var UWindowSmallButton PButton[18];

// Misc
var byte MaxCols, MaxRows;
var int CBXOffset, CBYoffset, CBoxOffset, CBWidth, CBSpread;
var bool bCreated;

// Classes
var Console   Con;
var AConsole  XCon;

struct CustomButton
{
	var string Name;
	var string Command;
};

var config CustomButton CustomButtons[18];

final function DoVars(){

    Con=root.Console;
    XCon=AConsole(Con);
    CBXOffset=5;
    CBYOffset=5;
    CBSpread=85;
    CBWidth=85;
    MaxCols=6;
    MaxRows=3;

}

function Created(){

    DoVars();
    DoButtons();
    super.Created();
	bCreated=true;
	SaveConfig();
}

final function DoButtons(){
	local byte i, Col, Row;

	for (i=0; i<18; i++)
	{
        if ( Row==MaxRows) { Col+=1; Row=0; }
        PButton[i] = UWindowSmallButton(CreateControl(class'UWindowSmallButton', (Col*CBSpread)+CBXOffset, (Row*18)+CBYOffset,CBWidth ,1 ));
        PButton[i].SetText(CustomButtons[i].Name);
        PButton[i].Register(self);
        Row+=1;
    }

}

function Notify(UWindowDialogControl C, byte E)
{	
	local int i;

	if(!bCreated) return;

    switch(E)
      {
          case DE_Click:
            for (i=0;i<18;i++)
			{
				switch(C)
				{
					case PButton[i]:
					XCon.ConsoleCommand(CustomButtons[i].Command);
					return;
				}
			}
      }
     Super.Notify(C, E);
}

final function Echo(coerce string s){XCon.Echo(S);}

defaultproperties
{
    CustomButtons(0)=(Name="Mass Kick",Command="admin killall playerpawn"),
    CustomButtons(1)=(Name="End Assault",Command="admin killall fortstandard"),
    CustomButtons(2)=(Name="Summon RL",Command="admin summon UT_Eightball"),
    CustomButtons(3)=(Name="Summon Rox",Command="admin summon rocketpack"),
    CustomButtons(4)=(Name="All Ammo",Command="admin allammo"),
    CustomButtons(5)=(Name="IpToCountry",Command="mutate IpToCountry"),
    CustomButtons(6)=(Name="FF On",Command="admin set leagueassault friendlyfirescale 100"),
    CustomButtons(7)=(Name="FF Off",Command="admin set leagueassault friendlyfirescale 0"),
    CustomButtons(9)=(Name="Mod Summon RL",Command="moderator summon ut_eightball"),
    CustomButtons(10)=(Name="Mod Summon Rox",Command="moderator summon rocketpack"),
    CustomButtons(11)=(Name="Restart",Command="admin servertravel?"),
}
