//-----------------------------------------------------------
// console messages
//-----------------------------------------------------------
class XConsole_ConsoleTab extends UWindowPageWindow config(XConsole);

// check boxes stuff
var UWindowCheckbox Cbox[20], LasD, LasO;
var string CBoxText[20],CBHelpText[20];
var byte nCboxClass[20], MaxCols, MaxRows;
var config string CboxValue[20];
var config bool LasDeath, LasOther;
var int CBXOffset, CBYoffset, CBoxOffset, CBWidth, CBSpread;
var class<localmessage> CBoxClass[60];
var UWindowSmallButton InfoButton, TransButton;

// Misc
var bool bCreated;
var name LogTag;

// Classes
var Console                 Con;
var AConsole                XCon;

final function DoVars(){

    Con=root.Console;
    XCon=AConsole(Con);
    CBXOffset=10;
    CBYOffset=4;
    CBSpread=80;
    CBWidth=70;
    MaxCols=5;
    MaxRows=3;
    CBoxText[0]="      Pickups";
    CBoxText[1]="            Kills";
    CBoxText[2]="    1st Blood";
    CBoxText[3]="       Sprees";
    CBoxText[4]="      Multikill";
    CBoxText[5]="Own Death";
    CBoxText[6]="         Times";
    CBoxText[7]="           CTF";
    CBoxText[8]="           LMS";
    CBoxText[9]="          DOM";
    CBHelpText[0]="Pickup messages";
    CBHelpText[1]="Kill messages";
    CBHelpText[2]="First blood messages";
    CBHelpText[3]="Killing spree messages";
    CBHelpText[4]="Multikill messages";
    CBHelpText[5]="Your death messages";
    CBHelpText[6]="Countdown times etc";
    CBHelpText[7]="Flag messages";
    CBHelpText[8]="Last Man Standing messages";
    CBHelpText[9]="Domination control point messages";
    nCboxClass[0]=2;
    nCboxClass[1]=2;
    nCboxClass[6]=2;

    CBoxClass[0]=Class'Botpack.PickupMessagePlus';
    CBoxClass[1]=Class'Botpack.DeathMessagePlus';
    CBoxClass[2]=Class'Botpack.FirstBloodMessage';
    CBoxClass[3]=Class'Botpack.KillingSpreeMessage';
    CBoxClass[4]=Class'Botpack.MultiKillMessage';
    CBoxClass[5]=Class'Botpack.VictimMessage';
    CBoxClass[6]=Class'Botpack.DeathMatchMessage';
    CBoxClass[7]=Class'Botpack.CTFMessage';
    CBoxClass[8]=Class'Botpack.LMSOutMessage';
    CBoxClass[9]=Class'Botpack.ControlPointMessage';
    CBoxClass[20]=Class'Botpack.ItemMessagePlus';
    CBoxClass[21]=Class'Botpack.DecapitationMessage';
    CBoxClass[26]=Class'Botpack.TimeMessage';
    CBoxClass[40]=Class'Botpack.PickupMessageHealthPlus';
    CBoxClass[41]=Class'Botpack.EradicatedDeathMessage';

}

// Checkbox
final function CBTicked(byte XDim)
{
    local byte YDim, index;
    local string s,t;
    XCon.ConsoleCommand("summon leagueas140.NewMsgDeathMessagePlus");

    for (YDim=0; YDim<=nCboxClass[XDim]; YDim++)
        {
        index=YDim*20+XDim;
        CboxValue[XDim]=string(Cbox[XDim].bChecked);
        if(CBoxClass[index]!=none)
            {
                CBoxClass[index].default.bisconsolemessage = cbox[xdim].bchecked;
            }
        }

    LasDeath=LasD.bChecked;
	LasOther=LasO.bChecked;
    saveconfig();

}
function Created(){

    DoVars();
    DoBoxes();
    super.Created();
    Load();
	bCreated=true;
	SaveConfig();
}

// configuration
final function Load()
{
    local byte XDim, YDim, index;
    XCon.ConsoleCommand("summon leagueas140.NewMsgDeathMessagePlus");
    // Checkboxes
    while ((XDim<20) && (Cbox[XDim]!=none))
    {
        Cbox[XDim].bChecked = (CboxValue[XDim]~="true");
        index=YDim*20+XDim;
        if(CBoxClass[index]!=none)
            {
                CBoxClass[index].default.bisconsolemessage = cbox[xdim].bchecked;
            }
        YDim+=1;
        if(YDim > nCboxClass[XDim])
            {
                YDim=0;
                XDim+=1;
            }
    }
    LasD.bChecked=LasDeath;
    XCon.ConsoleCommand("set leagueas140.NewMsgDeathMessagePlus bIsConsoleMessage " $ LasDeath);
    LasO.bChecked=LasOther;
    XCon.ConsoleCommand("set leagueas140.NewStringMessagePlus bIsConsoleMessage " $ LasOther);
}

final function LasDeathMessage(){

    LasDeath=LasD.bChecked;
    XCon.ConsoleCommand("summon leagueas140.NewMsgDeathMessagePlus");
    XCon.ConsoleCommand("set leagueas140.NewMsgDeathMessagePlus bIsConsoleMessage " $ LasDeath);
    saveconfig();
}

final function LasOtherMessage(){

    LasOther=LasO.bChecked;
    XCon.ConsoleCommand("summon leagueas140.NewStringMessagePlus");
    XCon.ConsoleCommand("set leagueas140.NewStringMessagePlus bIsConsoleMessage " $ LasOther);
    saveconfig();
}
// checkboxes
final function DoBoxes(){
 local byte i, Col, Row;

	for (i=0; i<20; i++)
	{
        if (CboxText[i]=="")
        break;
        else if ( Row==MaxRows) { Row=0; Col+=1; }
        Cbox[i] = UWindowCheckbox(CreateControl(class'UWindowCheckbox', (Col*CBSpread)+CBXOffset, (Row*18)+CBYOffset,CBWidth ,1 ));
        Cbox[i].SetText(CboxText[i]);
        Cbox[i].ToolTipString=CBHelpText[i];
        Cbox[i].bAlwaysBehind=true;
        Cbox[i].Register(self);
        Row+=1;
    }
    LasD=UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+240, CBYOffset+18,CBWidth ,1 ));
    LasD.SetText("LAS Deaths");
    LasD.ToolTipString="LeagueAS Death Messages";
    LasD.bAlwaysBehind=true;
    LasD.Register(self);

    LasO=UWindowCheckbox(CreateControl(class'UWindowCheckbox', CBXOffset+240, CBYOffset+36,CBWidth ,1 ));
    LasO.SetText("  LAS Other");
    LasO.ToolTipString="LeagueAS Other Messages";
    LasO.bAlwaysBehind=true;
    LasO.Register(self);

    InfoButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CBXOffset+338, CBYOffset+17, 50, 1));
    InfoButton.SetText("Info");

    TransButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', CBXOffset+338, CBYOffset+36, 50, 1));
    TransButton.SetText("Trans");
}

// notify?
function Notify(UWindowDialogControl C, byte E)
{
local string S;

    switch(E)
      {
          case DE_Change:
                if(instr(C,"Checkbox")>0)
                {
                    switch(C)
                    {
                        case Cbox[FindCboxNum(C)]:CBTicked(FindCboxNum(C));break;
                        case LasD:LasDeathMessage();break;
                        case LasO:LasOtherMessage();break;
                        break;
                    }
                }
         case DE_Click:
         switch(C)
                  {
                       case InfoButton:XCon.Info();break;
                       case TransButton:XCon.Trans();break;
                  }
       }
     Super.Notify(C, E);
}

final function Echo(coerce string s){XCon.Echo(S);}
final function int FindCboxNum(coerce string b){return Int(right(b,(len(b)-25)))-Int(right(CBox[0],(len(CBox[0])-25)));}// cbox offset

defaultproperties
{
    CboxValue(0)="False"
    CboxValue(1)="False"
    CboxValue(2)="False"
    CboxValue(3)="False"
    CboxValue(4)="False"
    CboxValue(5)="False"
    CboxValue(6)="False"
    CboxValue(7)="False"
    CboxValue(8)="False"
    CboxValue(9)="False"
    LogTag=ConsoleTab
}
