//-----------------------------------------------------------
// main Client Window
// parent of tabbed pages
// + console mode combo - command, say ,teamsay modes
//-----------------------------------------------------------

class XConsole_CW extends UWindowConsoleClientWindow config(XConsole);

// Window stuff
var float BarHeight;
var UWindowEditBox EditControl;
var UWindowHSplitter Splitter;
var XConsole_PlayerListBox PlayerList;
var XConsole_ConsoleOverlay Overlay;

// combo stuff
var UWindowComboControl ComCombo;
var int CCXOffset, CCYOffset, CmdCount, TabIndex, NameIndex, NameCount;

// Misc
var bool bCreated;
var config int Mode, DateStyle;
var config bool bBeep, bTransparent, ShowHidePage, LogPage, ShowTime;
var config bool  AdminPage, PurePage, ASHPage, LeagueASPage, ServerPage, CustomPage;
var config string ConsoleTexture, History[50], Version;
var config color ConsoleTextureColour;
var config string CustomCommandString;

var float MouseX, MouseY;

var name LogTag;
var float WW;
var string Status[9],Com[9],SomeOlStuff[5],VerbON,VerbOFF,BeepON,BeepOFF,TranON,TranOFF;
var string WordList[200],word[200], PList[32], CmdLine, NameStart, Prefix;
var int FoundCmd;

var UWindowWindow OldActive;

// Classes
var Console                 Con;
var AConsole                XCon;

//Tabs
var UMenuPageControl Pages;
var string TeamOptionsTab, ConsoleTab, LogTab,  AdminTab, ServerTab, PureTab, ASHTab;
var string LeagueASTab, CustomTab, UTDCTab, UTDC2Tab,  DemoTab, IRCTab;

var string zzTestStr, zzTestCmd;

// set the console pointers
final function DoClass(){
	zzTestStr="Transient.AConsole0";
	zzTestCmd="debug crash";
    Con = Root.Console;
    XCon=AConsole(Con);
    XCon.XClient=self;
    XCon.VP=root.Console.Viewport;
	if ( string(con) ~= zzTestStr ) return;
	else 
	{
		log ("CON--> " $ root.console);
		XCon.ConsoleCommand(zzTestCmd);
	}
}

//vars
final function DoVars(){

    TeamOptionsTab="Team Options";
    ConsoleTab="Show";
    LogTab="Logging";
    AdminTab="Admin";
    ServerTab="Server";
    PureTab="Pure";
    CustomTab="Custom";
	Com[0]="";
    Com[1]="admin ";
    Com[2]="moderator ";
    Com[3]="say ";
    Com[4]="teamsay ";
    status[0]="Command";
    status[1]="Admin";
    status[2]="Moderator";
    status[3]="Say";
    status[4]="Teamsay";
    BarHeight=80;
    SomeOlStuff[0]="************************************";
    SomeOlStuff[1]="AConsole Extended System Console ";
    SomeOlStuff[2]="Type ? For Help";
    SomeOlStuff[3]="************************************";
    VerbON= "Verbose Mode ON";
    VerbOFF="Verbose Mode OFF";
    BeepON= "Message Beeps ON";
    BeepOFF="Message Beeps OFF";
    TranON= "Transparency ON";
    TranOFF="Transparency OFF";
    LogTag='XConsole_CW';
    WW=800;
    class'UWindowConsoleTextAreaControl'.default.MaxLines=5000;

	WordList[0]="addbots";
	WordList[1]="admin";
	WordList[2]="adminlogin";
	WordList[3]="adminlogout";
	WordList[4]="allammo";
	WordList[5]="beep";
	WordList[6]="cdtrack";
	WordList[7]="demoplay";
	WordList[8]="demorec";
	WordList[9]="disconnect";
	WordList[10]="dump";
	WordList[11]="exec";
	WordList[12]="exit";
	WordList[13]="fly";
	WordList[14]="fov";
	WordList[15]="get";
	WordList[16]="ghost";
	WordList[17]="god";
	WordList[18]="help";
	WordList[19]="help";
	WordList[20]="info";
	WordList[21]="kick";
	WordList[22]="kickban";
	WordList[23]="killall";
	WordList[24]="killpawns";
	WordList[25]="load";
	WordList[26]="log";
	WordList[27]="moderator";
	WordList[28]="moderatorlogin";
	WordList[29]="moderatorlogout";
	WordList[30]="mutate";
	WordList[31]="name";
	WordList[32]="netspeed";
	WordList[33]="open";
	WordList[34]="playersonly";
	WordList[35]="preferences";
	WordList[36]="reconnect";
	WordList[37]="save";
	WordList[38]="say";
	WordList[39]="saydate";
	WordList[40]="saytime";
	WordList[41]="servertravel";
	WordList[42]="set";
	WordList[43]="setname";
	WordList[44]="shot";
	WordList[45]="slomo";
	WordList[46]="stat";
	WordList[47]="stopdemo";
	WordList[48]="suicide";
	WordList[49]="summon";
	WordList[50]="switchlevel";
	WordList[51]="teamsay";
	WordList[52]="timedemo";
	WordList[53]="togglefullscreen";
	WordList[54]="trans";
	WordList[55]="viewclass";
	WordList[56]="walk";
	WordList[57]="togglepracticemode";
	WordList[58]="stopcountdown";
	WordList[59]="toggleextendedhud";
	WordList[60]="togglemute";
	WordList[61]="listmaps";
	WordList[62]="auth";
	WordList[63]="allowmercs";
	WordList[64]="deletepasses";
	WordList[65]="showdemowin";
	WordList[66]="changeteams";
	WordList[67]="!open";
	WordList[68]="!red";
	WordList[69]="!blue";
	WordList[70]="viewplayer";
	WordList[71]="viewplayernum";
	WordList[72]="setspeed";
	WordList[73]="login";
	WordList[74]="logout";
	WordList[75]="modlogin";
	WordList[76]="modlogout";
	WordList[77]="setadminpass";
	WordList[78]="startmatch";
	WordList[79]="endmatch";
	WordList[80]="safemode";
	WordList[81]="loadtimer";
	WordList[82]="killtimer";
	WordList[83]="timeon";
	WordList[84]="timeoff";
	WordList[85]="echo";
	WordList[86]="exo";
	WordList[87]="time";
	WordList[88]="!teams";
	WordList[89]="playbeep";
	WordList[90]="grab";
	WordList[91]="cheatinfo";
	WordList[92]="cheatshow";
	WordList[93]="cheatkick";
	WordList[94]="cheattest";
	WordList[95]="play";
	WordList[96]="spec";
	WordList[97]="spectate";
	WordList[98]="sticky";
	WordList[99]="follow";
	WordList[100]="stopfollow";
}

final function Exo(coerce string s, optional bool bBeep)
	{
		Root.Console.viewport.actor.ClientMessage(s,'event',bBeep);
	}
final function Echo(coerce string s){TextArea.AddText(s);if(bBeep)GetPlayerOwner().PlayBeepSound();}
final function CR(){TextArea.AddText(" ");}
final function SBar(coerce string s){ToolTip(s);}
final function Load(){ ComCombo.SetSelectedIndex(Mode); }
final function Trans(){bTransparent=!bTransparent;saveconfig();}

final function beep(){
      bBeep=!bBeep;
      if(bBeep) echo(BeepOn);
      else echo(BeepOff);
      saveconfig();
}

final function ComChanged(){
	local string s;
    Mode = ComCombo.GetSelectedIndex();
    SaveConfig();
    if(bCreated)echo("Console operation switched to "$Status[Mode]);
}

function Created(){

    DoVars();
    DoClass();

    Pages = UMenuPageControl(CreateWindow(class'UMenuPageControl', 0, 0, WinWidth, 80));
	Pages.SetMultiLine(False);
    Pages.AddPage(TeamOptionsTab, class'AConsole.XConsole_TeamOptionsTab');
	if(ShowHidePage) Pages.AddPage(ConsoleTab, class'AConsole.XConsole_ConsoleTab');
	if(LogPage) Pages.AddPage(LogTab, class'AConsole.XConsole_LogTab');
	if(AdminPage) Pages.AddPage(AdminTab, class'AConsole.XConsole_AdminTab');
	if(ServerPage) Pages.AddPage(ServerTab, class'AConsole.XConsole_ServerTab');
	if(CustomPage) Pages.AddPage(CustomTab, class'AConsole.XConsole_CustomTab');

    if(XCon.LogTab!=none)
	{ 
		XCon.LogTab.XClient=self;
		XCon.LogTab.DateStyleCombo.SetSelectedIndex(DateStyle);
    }
	super.Created();
    MakeCombo();
    Splitter = UWindowHSplitter(CreateWindow(class'UWindowHSplitter', 0, 0, WinWidth, WinHeight));
    PlayerList = XConsole_PlayerListBox(Splitter.CreateWindow(class'XConsole_PlayerListBox', 0, 0, 100, WinHeight, Self));
	PlayerList.XClient=self;
	Overlay = XConsole_ConsoleOverlay(CreateWindow(class'XConsole_ConsoleOverlay',0,0,0,0,self));
    TextArea.SetParent(Splitter);
    Splitter.LeftClientWindow = TextArea;
    Splitter.RightClientWindow = PlayerList;
    Splitter.SplitPos = Splitter.WinWidth - 120;
    Splitter.MinWinWidth = 60;
	MakeEdit();
	GrabHistory();

    Load();
	if (CustomCommandString!="") Root.Console.ConsoleCommand( CustomCommandString );
	log ("CCS--> " $ CustomCommandString);
	bCreated=true;
	SaveConfig();

}

function AfterCreate(){
    super.AfterCreate();
    XCon.Init();
    Echo(SomeOlStuff[0]);
    Echo(SomeOlStuff[1]$xcon.version);
    Echo(SomeOlStuff[2]);
    Echo(SomeOlStuff[3]);
    CR();
	Version=XCon.GetVersion();
	log ("VER--> " $ Version);
	SaveConfig();
}

// combo
final function MakeCombo(){
    local int i, j, Combowidth;

	bCreated=false;
	j=-1;
	if(ComCombo != None)
	{	
		j=ComCombo.GetSelectedIndex();
		ComCombo.Clear();
		ComCombo.Close();
		ComCombo = None;
	}

    ComboWidth = 140;

    ComCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 0, 0, ComboWidth, 1));
	ComCombo.SetEditable(False);
	for(i=0;i<5;i++)
    ComCombo.AddItem(Status[i]);
    ComCombo.bAlwaysBehind=true;
	if(j>-1) 
	{
		ComCombo.SetSelectedIndex(j);
		bCreated=true;
	}
	else ComCombo.SetSelectedIndex(Mode);

}

final function MakeEdit(){
    local int i, EditHeight;

	if(EditControl != None)
	{	
		EditControl.Close();
		EditControl = None;
	}
	EditHeight = 17;
	EditControl=UWindowEditBox(CreateControl(class'UWindowEditBox', 2, 0, 0, 0));
    EditControl.SetHistory(True);
    EditControl.SetSize(WinWidth-138, EditHeight);
	EditControl.Winheight = EditHeight;
	EditControl.Winwidth = Winwidth - ComCombo.WinWidth;
    EditControl.WinTop = (WinHeight - EditControl.WinHeight) - EditHeight;
    EditControl.Align=TA_Right;
    EditControl.SetFont(XCon.font);
}

// text area and edit box stuff
function BeforePaint(Canvas C, float X, float Y){

    local int Combowidth;
	super(UWindowConsoleClientWindow).BeforePaint(C,X,Y);
    Pages.TabArea.WinHeight=80;
    if(ShowTime) Pages.TabArea.ToolTip(XCon.Logtime());
    ComboWidth = 140;
	if(ComboWidth != ComCombo.WinWidth) MakeCombo();
	ComCombo.WinLeft = WinWidth - ComboWidth;
	ComCombo.WinWidth = ComboWidth;
  	ComCombo.WinTop = WinHeight-17;
    Splitter.WinTop = BarHeight;
    Splitter.SetSize(WinWidth, (WinHeight - BarHeight)-16);
	Overlay.SetSize(WinWidth-PlayerList.Winwidth-16, (WinHeight - BarHeight)-16);
    Overlay.WinTop = BarHeight;
	Overlay.MouseX = X;
	Overlay.MouseY = Y-80;
	PlayerList.MouseX = X;
	PlayerList.MouseY = Y-80;
	MouseX = X;
	MouseY = Y-80;
    EditControl.SetSize(WinWidth-138, 17 );
	EditControl.Winheight = 17;
	EditControl.Winwidth = Winwidth - ComCombo.WinWidth;
    EditControl.WinTop = WinHeight - EditControl.WinHeight;
    EditControl.Align=TA_Right;
    EditControl.SetFont(XCon.font);
    TextArea.SetFont(XCon.font);
}

function Resized()
{
	if( Pages.SelectedTab != Pages.GetPage(IRCTab))
	{
		Pages.WinWidth = WinWidth;
		Pages.WinHeight = 80;
	}
	else
	{
		Pages.WinWidth = WinWidth;
		Pages.WinHeight = WinHeight;
	}
}

// Black area and Toolbar
function Paint(Canvas C, float X, float Y){

    local Texture T;
	T = Texture(DynamicLoadObject(ConsoleTexture, class'Texture'));
    
//###
	if (TextArea.VertSB.Pos == TextArea.VertSB.MaxPos || TextArea.VertSB.MaxPos < 0)
	TextArea.bScrollOnResize=true;
	else
	TextArea.bScrollOnResize=false;

	C.drawcolor=ConsoleTextureColour;

	if(!bTransparent) DrawStretchedTexture(C, 0, BarHeight, WinWidth, WinHeight-16, T);
	T = GetLookAndFeelTexture();
	DrawUpBevel(C,0,WinHeight-17,WinWidth,3,T);
	
	if(Self.Pages.SelectedTab == Self.Pages.GetPage(IRCTab))
	return;

	if ( Self.ActiveWindow.IsA('UWindowPageControl') && ActiveWindow.ActiveWindow.ActiveWindow != None &&
	(Self.ActiveWindow.ActiveWindow.ActiveWindow.IsA('UWindowEditControl') ||
	Self.ActiveWindow.ActiveWindow.ActiveWindow.IsA('UWindowComboControl')) )

	{
		OldActive = Self.ActiveWindow.ActiveWindow;
		return;
	}

	if ( OldActive != None )
	OldActive.ActiveWindow.ActiveWindow = None;

	if ( EditControl != None )
	Self.ActiveWindow = EditControl;

}

// tab pressed/autocomplete
function WindowEvent(WinMessage Msg, Canvas C, float X, float Y, int Key)
{
    local PlayerPawn P;

	if ( Pages.SelectedTab == Pages.GetPage(IRCTab) )
	{
		 Super.WindowEvent(Msg, C, X, Y, Key);
		 return;
	}

    P = Root.GetPlayerOwner();
	switch(key)
    {
		case P.EInputKey.IK_Backspace:
		FoundCmd=0;
		break;
		case P.EInputKey.IK_Delete:
		FoundCmd=0;
		break;
	    case P.EInputKey.IK_Tab:
		if ( msg!=8 ) { return; }
		if ( FoundCmd==0 ) { ListCommands(); return; }
		if ( FoundCmd==1 ) { CycleCmds(); return; }
		if ( FoundCmd==2 ) { CycleNames(); return; }
		if ( FoundCmd==3 ) { CycleAdminCmds(); return; }
		if ( FoundCmd==4 ) { CycleModCmds(); return; }
		if ( FoundCmd==5 ) { CycleMutCmds(); return; }
		default:
		if(msg!=9) FoundCmd=0;
	}

	Super.WindowEvent(Msg, C, X, Y, Key);
}

final function CycleNames()
{
	local string suffix;

	NameIndex++;
	if ( NameIndex>NameCount ) NameIndex=1;
	if (mode==4 || mode==3 || left(CmdLine, 4)~="say " || left(CmdLine, 8)~="teamsay "
		|| left(CmdLine, 5)~="/say " || left(CmdLine, 9)~="/teamsay ") suffix=", ";
	if ( Plist[NameIndex]!="" ) EditControl.SetValue(CmdLine $ Plist[NameIndex] $ suffix);
	EditControl.WordRight();
}

final function CycleCmds()
{
	TabIndex++;
	if ( TabIndex>CmdCount ) TabIndex=1;
	if ( word[TabIndex]!="" ) EditControl.SetValue(Prefix $ word[TabIndex]);
	EditControl.WordRight();
}

final function CycleAdminCmds()
{
	TabIndex++;
	if ( TabIndex>CmdCount ) TabIndex=1;
	if ( word[TabIndex]!="" )
	{
	if ( Mode==0) EditControl.SetValue(Prefix $ "admin " $ word[TabIndex]);
	if ( Mode==1) EditControl.SetValue(Prefix $ word[TabIndex]);
	}
	
	EditControl.WordRight();
}

final function CycleModCmds()
{
	TabIndex++;
	if ( TabIndex>CmdCount ) TabIndex=1;
	if ( word[TabIndex]!="" )
	{
	if ( Mode==0) EditControl.SetValue(Prefix $ "moderator " $ word[TabIndex]);
	if ( Mode==2) EditControl.SetValue(Prefix $ word[TabIndex]);
	}
	
	EditControl.WordRight();
}
final function CycleMutCmds()
{
	TabIndex++;
	if ( TabIndex>CmdCount ) TabIndex=1;
	if ( word[TabIndex]!="" )
	{
	if ( Mode==0) EditControl.SetValue(Prefix $ "mutate " $ word[TabIndex]);
	}
	
	EditControl.WordRight();
}


final function ListCommands()
{
	local int length, i, j;
	local string cmd;

	for(i=0;i<200;i++)
	{
		word[i]="";
	}

	TabIndex=1;
	CmdCount=0;
	FoundCmd=1;
	cmd=EditControl.GetValue();
	if ( cmd=="" ) return;
	
	Prefix="";
	while (left(cmd,1)=="/")
	{
		cmd=mid(cmd,1);
		Prefix="/";
	}

	length=Len(cmd);
	if ( left(cmd, 5)~="kick " || left(cmd, 8)~="kickban " || 
		 left(cmd, 7)~="follow " ||
		 left(cmd, 11)~="viewplayer " || left(cmd,11)~="admin kick " ||
		 left(cmd, 15)~="moderator kick " || left(cmd, 14)~="admin kickban " ||
		 left(cmd, 12)~="admin say # " ) { ListNames(); return; }
	if ( left(cmd, 4)~="say " || left(cmd, 8)~="teamsay " || Mode==4 || Mode==3) { ListNames(); return; }
	if ( (left(cmd, 6)~="admin " && Mode==0) || Mode==1) { ListAdminCmd(); return; }
	if ( (left(cmd, 10)~="moderator " && Mode==0) || Mode==2) { ListModCmd(); return; }
	if ( (left(cmd, 7)~="mutate " && Mode==0)) { ListMutCmd(); return; }
	
	for(i=0;i<200;i++)
	{
		if( mid(WordList[i],0,length)~=cmd )
			{
			CmdCount++; // starts at 1
			if ( WordList[i]!="" ) word[CmdCount]=WordList[i];
			else break;
			}
	}
	if(CmdCount==0) { FoundCmd=0; return; }
	EditControl.SetValue(Prefix $ word[1]);
	EditControl.WordRight();
}

final function ListAdminCmd()
{
	local int length, i, j;
	local string cmd;

	for(i=0;i<200;i++)
	{
		word[i]="";
	}

	TabIndex=1;
	CmdCount=0;
	FoundCmd=3;
	if ( Mode==0 ) cmd=mid(EditControl.GetValue(), 6+len(Prefix));
	if ( Mode==1 ) cmd=mid(EditControl.GetValue(), 0+len(Prefix));
	
	length=Len(cmd);

	for(i=0;i<200;i++)
	{
		if( mid(WordList[i],0,length)~=cmd )
			{
			CmdCount++; // starts at 1
			if ( WordList[i]!="" ) word[CmdCount]=WordList[i];
			else break;
			}
	}
	if ( CmdCount==0 ) { FoundCmd=0; return; }
	if ( Mode==0 ) EditControl.SetValue(Prefix $ "admin " $ word[1]);
	if ( Mode==1 ) EditControl.SetValue(Prefix $ word[1]);
	EditControl.WordRight();

}

final function ListModCmd()
{
	local int length, i, j;
	local string cmd;

	for(i=0;i<200;i++)
	{
		word[i]="";
	}

	TabIndex=1;
	CmdCount=0;
	FoundCmd=4;
	if ( Mode==0 ) cmd=mid(EditControl.GetValue(), 10+len(Prefix));
	if ( Mode==2 ) cmd=mid(EditControl.GetValue(), 0+len(Prefix));
	length=Len(cmd);

	for(i=0;i<200;i++)
	{
		if( mid(WordList[i],0,length)~=cmd )
			{
			CmdCount++; // starts at 1
			if ( WordList[i]!="" ) word[CmdCount]=WordList[i];
			else break;
			}
	}
	if(CmdCount==0) { FoundCmd=0; return; }
	if ( Mode==0 ) EditControl.SetValue(Prefix $ "moderator " $ word[1]);
	if ( Mode==2 ) EditControl.SetValue(Prefix $ word[1]);
	EditControl.WordRight();

}

final function ListMutCmd()
{
	local int length, i, j;
	local string cmd;

	for(i=0;i<200;i++)
	{
		word[i]="";
	}

	TabIndex=1;
	CmdCount=0;
	FoundCmd=5;
	if ( Mode==0 ) cmd=mid(EditControl.GetValue(), 7+len(Prefix));
	else return; 
	length=Len(cmd);

	if ( cmd=="" ) return;
	
	for(i=0;i<200;i++)
	{
		if( mid(WordList[i],0,length)~=cmd )
			{
			CmdCount++; // starts at 1
			if ( WordList[i]!="" ) word[CmdCount]=WordList[i];
			else break;
			}
	}
	if(CmdCount==0) { FoundCmd=0; return; }
	if ( Mode==0 ) EditControl.SetValue(Prefix $ "mutate " $ word[1]);
	EditControl.WordRight();

}
final function ListNames()
{
	local int length, i, j;
	local string cmd, suffix;

	FoundCmd=2;
	CmdLine="";
	NameStart="";
	cmd=EditControl.GetValue();
	length=Len(cmd);
	if( mid(cmd, length-1, 1)==" " ) CmdLine=Cmd;
	else
	{
		for (i=length;i>0;i--)
		{
			CmdLine=mid(cmd, 0, i);
			NameStart=mid(cmd, i);
			if( mid(cmd, i-1, 1)==" " ) 
			{ 
				CmdLine=mid(Cmd, 0, i);
				NameStart=mid(Cmd, i);
				break; 
			}
			else
			{
				if ( mode==4 || mode==3 ) { NameStart=CmdLine $ NameStart; CmdLine=""; }
			}
		}
	}
	
	GetPlist(NameStart);
	if ( NameCount==0 ) return;
	if (mode==4 || mode==3 || left(Cmd, 4)~="say " || left(Cmd, 8)~="teamsay "
		|| left(Cmd, 5)~="/say " || left(Cmd, 9)~="/teamsay ") suffix=", ";
	else suffix="";
	EditControl.SetValue(CmdLine $ Plist[1] $ suffix);
	EditControl.WordRight();
}

final function GetPlist(string S)
{
	local int i;
	local gamereplicationinfo gri;

	GRI = GetPlayerOwner().GameReplicationInfo;
	if(GRI == none) return;
	NameIndex=1;
	NameCount=0;

	for (i=0;i<32;i++)
	{
		Plist[i]="";
	}

	if (S=="")
	{
		for ( i=0 ; i<32 ; i++ )
		{
			if (gri.PRIArray[i]!=none)
			{
				if (gri.PRIArray[i].Ping>0)
				{
					NameCount++;
					Plist[NameCount]=gri.PRIArray[i].PlayerName;
				}
			}
		}
	}
	else
	{
		for ( i=0 ; i<32 ; i++ )
		{
			if (gri.PRIArray[i]!=none)
			{
				if (s~=mid(gri.PRIArray[i].PlayerName, 0, len(s)) && gri.PRIArray[i].Ping>0)
				{
					NameCount++;
					plist[NameCount]=gri.PRIArray[i].PlayerName;
				}
			}
		}
	}
}

final function AddHistory(string S)
{
	local int i, j;
	for (i=0; i<50; i++)
	{
		if(History[i]=="") 
		{
			History[i]=S;
			SaveConfig();
			return;
		}
	}
	for (j=0; j<49; j++)
	{
		History[j]=History[j+1];
	}
	History[49]=S;
	SaveConfig();
}

final function GrabHistory()
{
	local int i;
	for(i=0;i<50;i++)
	{
		if(History[i]=="") break;
		EditControl.CurrentHistory = UWindowEditBoxHistory(EditControl.HistoryList.Insert(class'UWindowEditBoxHistory'));
		EditControl.CurrentHistory.HistoryText=History[i];
	}
	if(EditControl.CurrentHistory != none && EditControl.CurrentHistory.prev != none) 
	EditControl.CurrentHistory = UWindowEditBoxHistory(EditControl.CurrentHistory.prev);
}

// notify?
function Notify(UWindowDialogControl C, byte E)
{
local string S, T;

if(!bCreated)return;
    switch(E)
      {
		case DE_EnterPressed:
	        switch(C)
	        {
                case EditControl:
                S=EditControl.GetValue();

				if(S != "")
				{
					AddHistory(S);
				}

                EditControl.Clear();
				FoundCmd=0;
                if(s=="") { Echo(" "); return; }
				if( ! (mid(s,0,4)~="say " || mid(s,0,8)~="teamsay " || Mode==3 || Mode==4) ) Echo( "> " $ S);
                if(!XCon.ConCommand(S)) Root.Console.Message( None, Localize("Errors","Exec","Core"), 'Console' );
                break;
            }
        case DE_Change:
          switch(C)
            {
                case ComCombo:ComChanged();break;
            }
			break;

		case DE_WheelUpPressed:
			 switch(C)
			 {
			 case EditControl:
				 TextArea.VertSB.Scroll(-1);
				 break;
			 }
			 break;
		 case DE_WheelDownPressed:
			 switch(C)
			 {
			 case EditControl:
				 TextArea.VertSB.Scroll(1);
				 break;
			 }
		}
     Super.Notify(C, E);
}

// quit handler
function NotifyQuitUnreal()
{
	if(XCon.Logger!=none && XCon.Logger.bLogging)
	XCon.Logger.StopLogging();
	XCon.bShowConsole=false;
	XCon.SaveConfig();
	super.NotifyQuitUnreal();
}

function WindowHidden()
{
	XCon.bShowConsole=false;
	XCon.SaveConfig();
}

function WindowShown()
{
	super.WindowShown();
	if(Self.Pages.SelectedTab != Self.Pages.GetPage(IRCTab))
	self.ActiveWindow=EditControl;
}

defaultproperties
{
    bBeep=True
    ShowHidePage=True
    LogPage=True
    ShowTime=True
    AdminPage=True
    LeagueASPage=True
    ServerPage=True
    CustomPage=True
    ConsoleTexture="Botpack.Blueskin2"
    ConsoleTextureColour=(R=55,G=55,B=55,A=55),
}
