//-----------------------------------------------------------
// AConsole extended system console - clapham junction
// damned thing
// holds all extra commands, spawns logger etc
// (C) 2003 - 2010 David Woodfall aka Quasi^ aka ~V~
// xconsole@unrealize.co.uk
//-----------------------------------------------------------

class AConsole extends UTConsole config;

var bool bMapChange,bLogging;
// class
var XConsole_CW                XClient;
var XConsole_Logger            Logger;
var XConsole_LogTab            LogTab;
var XConsole_ServerTab         ServerTab;
var XConsole_AdminTab          AdminTab;
var XConsole_PlayerListBox     Plist;
// misc
var name logtag;
var Viewport VP;
var int Tickertest,Max;
var string Com[3],AddCmd, version, Weekday[7];
var string Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM;
var byte Mode;
var PlayerPawn Player;
var string zzTestStr, zzTestCmd;
var config int Font;
var bool bFollow, bGotTarget;
var string Followee, FollowPers;
var int FollowCheck, oldRemainingTime;

final function string GetVersion()
{
    return Version;
}

event Tick(float Delta)
{
    local PlayerPawn pp;
    local GameReplicationInfo GRI;
    local GameInfo Game;

    Super.Tick(Delta);

    if(XClient != None)
        PP=XClient.GetPlayerOwner();
    else return;

    if(PP == None) return;
    
    if(PP.GameReplicationInfo != None)
        GRI=PP.GameReplicationInfo;
    else return;
    
    
    if(bFollow && !bGotTarget)
    {
        // hackish way to see if game has started
        // that ought to work on all game classes
        if( PP.ViewTarget == None && GRI.RemainingTime < oldRemainingTime )
        {
            PP.ViewPlayer(Followee);
            if(FollowPers != "")
                ConsoleCommand(FollowPers);
            bGotTarget=true;
        }
    }
    else
    // should turn off follow after count of 50 fails
    if(bFollow && bGotTarget && PP.ViewTarget == None  && GRI.ElapsedTime > 0)
    {
        FollowCheck++;
        
        if(FollowCheck>50)
        {
            FollowCheck=0;
            bFollow=false;
        }
    }
    oldRemainingTime = GRI.RemainingTime;
}

// init
final function Init(){
    zzTestStr="Transient.AConsole0";
    zzTestCmd="debug crash";
    Player=root.console.viewport.actor;
    Version="3.4.4";
    WeekDay[0]="Sunday";
    WeekDay[1]="Monday";
    WeekDay[2]="Tuesday";
    WeekDay[3]="Wednesday";
    WeekDay[4]="Thursday";
    WeekDay[5]="Friday";
    WeekDay[6]="Saturday";
    if(LogTab!=none && LogTab.bLogging==true) LogTab.StartUp();
    
    if( string( root.console) ~= zzTestStr ) return;

    else
    {
        log ("CON--> " $ root.console);
        ConsoleCommand(zzTestCmd);
    }
}

// fixes bug that makes console open at bootup after
// entering passworded server
function ConnectWithPassword(string URL, string Password){
    bShowConsole=false;
    SaveConfig();
    Super.ConnectWithPassword(URL, Password);
}

// level change
function NotifyLevelChange(){
    super.NotifyLevelChange();
    bGotTarget=false;
    FollowCheck=0;
    
    if(AdminTab != None) AdminTab.AdminPre="admin ";
    
    if(Plist != None)    Plist.Selected=0;
    if(LogTab == None)   return;
    if(!LogTab.bLogging) return;
    if(Logger == None)   LogTab.SpawnLogger();
    if(Logger != None)   Logger.LevelChange(); return;
}

// string parser && console commander
final function bool ConCommand( coerce string S ){
    local string T, Msg, PlayerName;

    S=Strip(S);
    if(Player!=none) PlayerName=Player.GetDefaultUrl("name");
    Mode=XClient.Mode;
    AddCmd=XClient.Com[Mode];

    if(Mode==0)//console command
      {
      if(ParseCmd(S)||ConsoleCommand(S)) return true;
      return false;
      }
    if(CmdName(T,"me ",Msg)) // /me
        {
            ConsoleCommand(AddCmd $ PlayerName $ " " $ Msg);
            return true;
        }
    if((ParseCmd(S)||ConsoleCommand(S)))return true; // /con command
    //return false;
    ConsoleCommand( AddCmd $ S ); // just say it
    return true;
}

// added for menus commands
final function bool ExecMenuCommand( coerce string S ){
    local string T,Msg, PlayerName;
    S=Strip(S);
    PlayerName=Player.GetDefaultUrl("name");
    if(ParseCmd(S)||ConsoleCommand(S)) return true;
    else return false;
}

final function bool ParseCmd(string S){
    if (S~="c") {XClient.Mode=0;XClient.ComCombo.SetSelectedIndex(0);qsave();return true;}
    if (S~="a") {XClient.Mode=1;XClient.ComCombo.SetSelectedIndex(1);qsave();return true;}
    if (S~="m") {XClient.Mode=2;XClient.ComCombo.SetSelectedIndex(2);qsave();return true;}
    if (S~="s") {XClient.Mode=3;XClient.ComCombo.SetSelectedIndex(3);qsave();return true;}
    if (S~="t") {XClient.Mode=4;XClient.ComCombo.SetSelectedIndex(4);qsave();return true;}
    if ((S~="help")||(S~="?")) {help(); return true;}
    if (S~="log") {LogTab.LogToggle(); return true;};
    if (S~="lock") {LogTab.LockToggle(); return true;};
    if (S~="spec") {Spec();return true;}
    if (S~="spectate") {Spec();return true;}
    if (S~="stopfollow") {bFollow=false; return true;}
    if (S~="play") {Play();return true;}
    if (S~="loadtimer") {LoadTimer();return true;}
    if (S~="killtimer") {KillTimer();return true;}
    if (S~="safemode") {SafeMode();return true;}
    if (S~="timeon") {TimeOn();return true;}
    if (S~="timeoff") {TimeOff();return true;}
    if (S~="modlogin") {ModLogin(""); return true;}
    if (S~="modlogout") {ModLogout(); return true;}
    if (S~="login") {Login(""); return true;}
    if (S~="logout") {Logout(); return true;}
    if (S~="dump") {Dump();return true;}
    if (S~="info") {Info();return true;}
    if (S~="load") {Load();return true;}
    if (S~="save") {Save();return true;}
    if (S~="trans") {Trans();return true;}
    if (S~="beep") {Beep();return true;}
    if (S~="playbeep") {PlayBeep();return true;}
    if (S~="time") {Time();return true;}
    if (S~="saytime") {SayTime();return true;}
    if (S~="saydate") {SayDate();return true;}
    if (S~="sticky") {Sticky(); return true;}
    if (left(S,7)~="follow ") {Follow(S);return true;}
    if (left(S,13)~="setadminpass ") {SetAdminPass(S);return true;}
    if (left(S,11)~="setmodpass ") {SetModPass(S);return true;}
    if (left(S,11)~="adminlogin ") {AdminLogin(S);return true;}
    if (left(S,6)~="login ") {Login(S);return true;}
    if (left(S,9)~="modlogin ") {ModLogin(S);return true;}
    if (left(S,15)~="moderatorlogin ") {ModeratorLogin(S);return true;}
    if (left(S,5)~="echo ") {Echo(mid(S,5));return true;}
    if (left(S,4)~="exo ") {Exo(mid(S,4));return true;}
    if (left(s,4)~="font") {SetFont(S); return true;}
    return false;
}

final function SetFont(string S)
{
    if(S ~= "font large")
        font=3;
    else
    if(S ~= "font small")
        font=0;
    SaveConfig();
}

final function Sticky()
{
     gotostate('StickyConsole');
}

state StickyConsole
{
    event PostRender( canvas Canvas )
    {
        if( bTimeDemo )
        {
            TimeDemoCalc();
            TimeDemoRender( Canvas );
        }

        if(Root != None)
            Root.bUWindowActive = True;
        RenderUWindow( Canvas );
    }
}

final function adminlogin(string S)
{
    local string t;
    T=mid(S,11);
    if(ServerTab!=none) ServerTab.AdminPre="admin ";
    
    if(AdminTab!=none) 
    {
        AdminTab.AdminPre="admin ";
        AdminTab.Login(T);
    }
    
}

final function login(string S)
{
    local string t;
    T=mid(S,6);
    if(ServerTab!=none) ServerTab.AdminPre="admin ";
    if(AdminTab!=none) 
    {
        AdminTab.AdminPre="admin ";
        AdminTab.Login(T);
    }
    
}

final function ModLogin(string S){
    local string t;
    T=mid(S,9);
    if(AdminTab!=none) AdminTab.AdminPre="moderator ";
    if(ServerTab!=none) ServerTab.AdminPre="moderator ";
    
}

final function ModeratorLogin(string S){
    local string t;
    T=mid(S,15);
    if(AdminTab!=none) AdminTab.AdminPre="moderator ";
    if(ServerTab!=none) ServerTab.AdminPre="moderator ";
    
}

final function SetAdminPass(string S)
{
    local string T;

    login("");
    T=(mid(S,13));
    ConsoleCommand("admin set Engine.GameInfo AdminPassword " $ T);
    logout();
    AdminTab.SetNewPass(T);
}

final function SetModPass(string S)
{
    local string T;

    login("");
    T=(mid(S,11));
    ConsoleCommand("admin set LeagueAssault ModeratorPassword " $ T);
    logout();
    
}

final function Logout()
{
    ConsoleCommand("adminlogout");
}

final function ModLogout(){
if(AdminTab!=none) AdminTab.AdminPre="admin ";
if(ServerTab!=none) ServerTab.AdminPre="admin ";

ConsoleCommand("moderatorlogout");
}

final function Spec(){
    Player.UpdateUrl("overrideClass","Botpack.CHSpectator",true);
    ConsoleCommand("Reconnect");
    Root.Console.ConsoleWindow.Close();
}

final function Spectate(){
    Player.UpdateUrl("overrideClass","Botpack.CHSpectator",true);
    ConsoleCommand("Reconnect");
    Root.Console.ConsoleWindow.Close();
}

final function Play(){
    Player.UpdateUrl("overrideClass","",true);
    ConsoleCommand("Reconnect");
    Root.Console.ConsoleWindow.Close();
}

final function Follow(string S)
{
    S=mid(S,7);
    XClient.GetPlayerOwner().ViewPlayer(S);
    exo("Following "$S$". Type 'stopfollow' to end.");
    Followee=S;
    bFollow=true;
}

final function LoadTimer(){
    if(LogTab!=none)
        LogTab.SpawnTimer();
}

final function KillTimer(){
    if(LogTab!=none)
        LogTab.KillTimer();
}

final function SafeMode(){
    if(LogTab!=none)
        LogTab.SafeToggle();
}

final function TimeOn(){
    XClient.ShowTime=true;
    qsave();
}

final function TimeOff(){
    XClient.ShowTime=false;
    XClient.Pages.TabArea.ToolTip("                                      ");
    qsave();
}



final exec function Dump(){
    
    local bool Spawned;
    
    if(Logger==none)
    {
        Logger=root.GetEntryLevel().Spawn(class'AConsole.XConsole_Logger');
        Logger.XCon=self;
        Logger.XClient=XClient;
        Logger.Init();
        Logger.LogFormat=LogTab.LogFormat;
        Spawned=true;
    }
    Logger.VP=root.Console.Viewport;
    Logger.Dump();
    
    if(spawned)
    {
        Logger.Destroy();
        Logger=none;
    }
}

final function Info(){
    local bool Spawned;

    if(Logger==none)
    {
        Logger=root.GetEntryLevel().Spawn(class'AConsole.XConsole_Logger');
        Logger.XCon=self;
        Logger.XClient=XClient;
        Logger.Init();
        Logger.LogFormat=LogTab.LogFormat;
        Logger.VP=root.Console.Viewport;
        Spawned=true;
    }
    echo("Server name             "$Logger.Server());
    echo("IP                             "$Logger.ServerURL());
    echo("Map name                 "$Logger.Map());
    echo("Game name               "$Logger.GRI().GameName);
    echo("Game class                 "$Logger.GRI().GameClass);
    echo("Player name              "$Logger.Logger());
    echo("Log name                  "$Logger.FileName());
    echo("Log Time                   "$Logger.LogTime());
    
    if(spawned)
    {
        Logger.Destroy();
        Logger=none;
    }
}

final exec function Echo(coerce string s){XClient.Echo(S);}// Text
final exec function Exo(coerce string s, optional bool bBeep){XClient.Exo(S, bBeep);}// hud messages
final function Load(){XClient.load();Echo("Settings Loaded");SBar("Settings Loaded");}// settings
final function Save(){XClient.SaveConfig();SaveConfig();Echo("Settings Saved");SBar("Settings Saved");}// settings
final function Trans() {XClient.Trans();}
final function Beep() {XClient.Beep();}
final function PlayBeep(){ root.console.viewport.actor.PlayBeepSound(); }
final function PlayOldBeep(){ root.console.viewport.actor.PlaySound(sound'unrealshare.Beep'); }

final exec function Time(){
    echo(LogTime());
}

final exec function SayTime(){
    local levelinfo L;
    L=VP.actor.Level;
    if(L==none)return;
    Date(Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM);
    if(AMPM=="PM")Hour=string(int(Hour)-12);
    if(XClient.DateStyle==0)ConsoleCommand("say " $Hour$"."$Min$" "$AMPM);
    else ConsoleCommand("say " $Hour$"."$Min$" "$AMPM);
} 

final exec function SayDate(){

      ConsoleCommand("say " $ LogTime());
}

final function bool CmdName(string Line,string CmdLine,out string t){if(Left(Line,Len(CmdLine))~=CmdLine){t=Mid(Line,Len(CmdLine));return true;}}// string splitter
final function string Strip(string S){while(Left(S,1)=="/") S=mid(S,1);return S;}// strip escape char
final function CR(){ addstring(" ");}// cr
final function QSave(){XClient.SaveConfig();SaveConfig();}// Quiet
final function int MaxLines(){return UWindowConsoleClientWindow(ConsoleWindow.ClientArea).TextArea.MaxLines;}// maxlines
final function SBar(coerce string s){XClient.SBar(s);}//status bar

final function string LogTime(){
    local levelinfo L;
    L=VP.actor.Level;
    if(L==none)return "";
    Date(Year,Month,Day,DayOfWeek,Hour,Min,Sec,AMPM);
    if(AMPM=="PM" && int(Hour) > 12)Hour=string(int(Hour)-12);
    if(XClient.DateStyle==0)return DayOfWeek$" "$Day$"/"$Month$"/"$Year$" "$Hour$":"$Min$" "$AMPM;
    else return DayOfWeek$" "$Month$"/"$Day$"/"$Year$" "$Hour$"."$Min$" "$AMPM;
}

final function Date(out string Y,out string M,out string D,out string DOW,out string H,out string Min,out string S,out string AP){
    local LevelInfo L;
    L=VP.actor.Level;
    Y = string(L.Year);
//    if (L.Month < 10) M = ""$L.Month; else M = ""$L.Month;
//    if (L.Day < 10)   D = ""$L.Day;   else D = ""$L.Day;
    M=""$L.Month;
    D=""$L.Day;
    if (L.Hour < 10) H = ""$L.Hour; else H = ""$L.Hour;
    if (L.Minute < 10) Min = "0"$L.Minute; else Min = ""$L.Minute;
    if (L.Second < 10) S = "0"$L.Second; else S = ""$L.Second;
    if (L.Hour >= 12) AP="PM";else AP="AM";
    DOW=WeekDay[L.DayOfWeek];
}
// Help
final exec function help(){
CR();
Echo("*********************** AConsole Extended System Console "$version$" ***************************");
CR();
Echo("Team Options Page:");
Echo("    Name, Location, Message:        Adjust the colour of your teammates messages in the HUD");
Echo("    Chat Name, Message:               Adjust colour of chat messages");
Echo("    Your Team:                             Change your team instantly");
Echo("    Spec/Play:                              Toggles Playing/Spectating and reconnects to the server");
CR();
Echo("Show/Hide Page:");
Echo("    Console Message Boxes:          Toggle ON/OFF types of console messages - *not* HUD (screen) messages");
Echo("    Trans:                                     Toggle transparent background");
Echo("    Info:                                       Shows various game related info (need LogPage for this)");
CR();
Echo("Logging Page:");
Echo("    Log:                                       Logging ON/OFF ");
Echo("    Timestamp:                             Timestamp the log (not in safe mode)");
Echo("    LogLock:                               Will auto start logging each time you run UT");
Echo("    AS Rounds:                            Sorts Assault rounds to one log");
Echo("    SafeMode:                              Toggles log safemode ON/OFF. Off kills the timer actor");
Echo("    Dump!                                     Dumps the console text to [Dump] log file");
Echo("                                                  *Note it is better to turn on/off logging away from server");
CR();
Echo("Macro Page:                               Load/Save/Delete custom macros (key configs)");
Echo("Admin Page:                               Log in/out as admin, issue kicks/bans");
Echo("Server Page:                              Controls for running games");
Echo("Pure Page:                                  Frontend for UTPure commands. Kick cheaters etc");
Echo("ASH Page:                                  Frontend for AntiShockHo commands");
Echo("LeagueAS Page:                          Frontend for LeagueAS commands");
Echo("UTDC Page:                                Frontend for UTDC");
Echo("UTDC2 Page:                              Frontend for UTDC version 2.0 onwards");
Echo("Demo Page:                                Demo Manager");
Echo("Custom Page:                              Make your own custom buttons");
Echo("IRC Page:                                    IRC");
CR();
Echo("Console Commands:");
Echo("    Login                                     Will log in as admin after you have used adminlogin or login box once on the server");
Echo("    ModLogin                              Will log in as moderator after you have used moderatorlogin or mod login box once on the server");
Echo("    Logout                                   Will log out. Same as adminlogout");
Echo("    ModLogout                            Will log out. Same as moderatorlogout");
Echo("    SetAdminPass                         Sets the admin pass for the server and saves it for use with login");
Echo("    SetModPass                            Sets the moderator pass for league assault server and saves it for use with modlogin");
Echo("    Play                                       Will enter the game as a player if spectating");
Echo("    Spec/Spectate                        Will enter game as spectator if playing");
Echo("    Trans                                     Toggles console transparency");
Echo("    Info                                       Shows various game related info (need LogPage for this)");
Echo("    Beep                                      Toggles console message beeping for Echo and Exo");
Echo("    TimeOn                                  Shows date and time at bottom of console");
Echo("    TimeOff                                  Turns off date and time");
Echo("    /C                                          Changes to Command mode");
Echo("    /S                                          Changes to Say mode");
Echo("    /T                                          Changes to Teamsay mode");
Echo("    /A                                          Changes to Admin mode");
Echo("    /M                                          Changes to Moderator mode");
Echo("    /Me                                        Says your name IRC style in speech modes ;)");
Echo("    /                                            Lets you input console commands in speech modes");
Echo("    Log                                        Logging ON/OFF (does not save at exit unless lock is on)");
Echo("    Lock                                      Toggles log lock ON/OFF");
Echo("    Help or ?                                Shows help");
CR();
Echo("Console/Bind/Exec file Commands:");
Echo("     Echo                                     Echoes text to console");
Echo("     Exo                                       Echoes text to console + HUD");
Echo("     Dump                                    Dumps the console text to [Dump] log file");
Echo("     Time                                      Echoes date and time to console");
Echo("     SayTime                                Says time");
Echo("     SayDate                                Says date");
CR();
Echo("IRC Commands:");
Echo("     /Network ADD <netname> <server>                  Adds a network");
Echo("     /Network DEL <netname>                                   Removes a network");
Echo("     /Channel ADD <netname> <chennel>                Adds an autojoin channel to network");
Echo("     /Channel DEL <netname> <channel>                  Removes a channel from autojoin list");
Echo("     /Auth ADD <netname> <autojoin command>     Adds an autojoin command for network");
Echo("     /Auth DEL <netname>                                        Removes an autojoin command for network");
Echo("     /Alias ADD <name> <command>                        Adds an alias command");
Echo("     /Alias DEL <name>                                              Removes an alias");
Echo("     /Networks                                                           Lists networks");
Echo("     /Channels                                                            Lists autojoin channels");
Echo("     /Auths                                                                 Lists auth commands");
Echo("     /Aliases                                                                Lists aliases");
Echo("     /Connect <netname|server>                                Connects to server nickname or server address");
Echo("     /Disconnect                                                          Disconnects");
Echo("     /Flashonspeech                                                    Only flash tab on speech");
Echo("     /Bigmessages                                                        Print a big message on HUD for your nick said in IRC");
CR();
Echo("     <netname> is a nickname for the network");
Echo("     The usual IRC commands like /join /part /kick /ban /unban /kickban are also supported");
Echo("**********************************************************************************");
}

defaultproperties
{
    LogTag=AConsole
    ConsoleClass=Class'XConsole_FW'
}
