//=============================================================================
// PreCacheReplicationInfo.
//
// The CCPPCRI is used to PreCache classes on the client.  Most likely you will
// want to expand this actor in to a child.  It has no built in functionality 
//
//=============================================================================
class CCPPCRI expands ReplicationInfo;

//var bool bInitialized;

// Replicated Server->Client Variables

replication
{
     // Functions that Server calls on the Client
     reliable if ( Role == ROLE_Authority)
          PreCacheClient;
}

// PostBeginPlay is called on the client if it is simulated, but it is before the variables have been replicated
//   Thus, Owner is not replicated yet
// PostNetBeginPlay is called after the variables have been replicated, and so is appropriate
//   It is not called on the server machine (NM_Standalone or NM_Listen) because no variables are replicated to that machine
//   And so, PostBeginPlay is needed for those types of servers

event PostBeginPlay()
{
//     log("CCProtector40.CCPPCRI - PostBeginPlay");
     Super.PostBeginPlay();
     PreCacheClientIfNecessary();
}

simulated event PostNetBeginPlay ()
{
//     log("CCProtector40.CCPPCRI - PostNetBeginPlay");
     Super.PostBeginPlay();
     PreCacheClientIfNecessary();
}

simulated function PreCacheClientIfNecessary ()
{
//	log("CCProtector40.CCPPCRI - PreCacheClientIfNecessary");

	if( Level.NetMode == NM_DedicatedServer ) // don't run on server
		{
//		log("CCProtector40.CCPPCRI - PreCacheClientIfNecessary - Level.NetMode == NM_DedicatedServer");
		return;
		}

	PreCacheClient();
}

simulated function bool PreCacheClient()
{

     local PlayerPawn P;
     
//	 log("CCProtector40.CCPPCRI - PreCacheClient");
	  
     P = PlayerPawn(Owner);
     if (P==None)
     {
          log("CCPPCRI - Error: Attempted to precache CCProtector on something other than a PlayerPawn");
          return false;
     }

     PreCacheClientStub();

     return true;
}

simulated function bool PreCacheClientStub()
{
     return true;
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
     NetPriority=10.000000
}

