<?

/*
	IpToCountry v1.2 Masterserver script.
	Non-database version by AnthraX
	Updated for Daylight Saving Time fix by Rush
*/

error_reporting(E_WARNING);

$timestamp = mktime(gmdate("H, i, s, m, d, Y")); // UTC time
$this_year=gmdate("Y", $timestamp);

// last sunday in march at 1am UTC
$last_day_of_march=gmmktime(1,0,0,3,31,$this_year);
$last_sunday_of_march=strtotime("-".gmdate("w", $last_day_of_march)." day", $last_day_of_march);
    
// last sunday in october at 1am UTC
$last_day_of_october=gmmktime(1,0,0,10,31,$this_year);
$last_sunday_of_october=strtotime("-".gmdate("w", $last_day_of_october)." day", $last_day_of_october);
		  
if( ($timestamp > $last_sunday_of_march) && ($timestamp < $last_sunday_of_october) )
{
    $timestamp=$timestamp+3600; // foward one hour
}

$gmt = date("H:i", $timestamp);

function getiploc($ip)
{
    $numbers = preg_split( "/\./", $ip);
    include("ip_files/".$numbers[0].".php");
    $code=($numbers[0] * 16777216) + ($numbers[1] * 65536) + ($numbers[2] * 256) + ($numbers[3]);
    foreach($ranges as $key => $value)
    {
    	if($key<=$code)
    	{
    		if($ranges[$key][0]>=$code)
    		{
    			$two_letter_country_code=$ranges[$key][1];break;}
                }
        }
        if ($two_letter_country_code=="")
        {
        	$two_letter_country_code="none";
        }
    return $two_letter_country_code;
    
    
}

$ips = $_GET['ip'];

if($ips == "")
    die();
    
/* This file contains the $countries array ... */
include("ip_files/countries.php");
    
/*
$two_letter_country_code=iptocountry($IPaddress);
$three_letter_country_code=$countries[ $two_letter_country_code][0];
$country_name=$countries[$two_letter_country_code][1];

print "Two letters code: $two_letter_country_code<br>";
print "Three letters code: $three_letter_country_code<br>";
print "Country name: $country_name<br>";
*/

/* if the request is a single ip ... */
if(!strstr($ips, ','))
{
    $iploc   = getiploc($ips);
    $Prefix1 = $iploc;
    $Prefix2 = $countries[ $iploc ][0];
    $Country = $countries[ $iploc ][1];
    $Prefix1 = strtolower($Prefix1);

    if($_GET['playerid'] != "")
	$playerid = $_GET['playerid'].":";

    if(strstr($Country, ','))
    {
	$Country=str_replace(', ', "-", $Country);
    }

    echo $gmt." ".$playerid.$ips.":".gethostbyaddr($ips).":".$Country.":".$Prefix2.":".$Prefix1;
}
else
{
    $ip = explode(',', $ips);

    /* First ip seems to have a different return syntax... */
    $iploc   = getiploc($ip[0]);
    $Prefix1 = $iploc;
    $Prefix2 = $countries[ $iploc ][0];
    $Country = $countries[ $iploc ][1];
    $Prefix1 = strtolower($Prefix1);
    echo $gmt." ".$ip[0].":".gethostbyaddr($ip[0]).":".$Country.":".$Prefix2.":".$Prefix1;
    
    for($i=1;$ip[$i]!="";$i++)
    {
	if($i==51) /* reached the limit */
	    break;
        $iploc   = getiploc($ip[i]);
	$Prefix1 = $iploc;
	$Prefix2 = $countries[ $iploc ][0];
	$Country = $countries[ $iploc ][1];
    	$Prefix1 = strtolower($Prefix1);
	
	if(strstr($Country, ','))
	{
	    $Country=str_replace(', ', "-", $Country);
	}
    
        echo ",".$ip[$i].":".gethostbyaddr($ip[$i]).":".$Country.":".$Prefix2.":".$Prefix1;
    }
}

?>