class UTServerAdminSpectator2 extends UTServerAdminSpectator;

var VoiceSpam S1; // variables are stored in main class (VoiceSpam)

function PostBeginPlay()
{
	Self.PlayerReplicationInfo.Team=1; // Listen for messages from players of the BLUE team
	Self.PlayerReplicationInfo.bIsSpectator=true;
	Self.bIsPlayer=false;
	foreach AllActors(class'VoiceSpam', S1) break; // assign VoiceSpam to S1
}

function ClientVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID)
{
	local pawn p;
	local int i;
	
	if(S1==none) return; // If S1 has not (yet) been found
	
	if(string(messagetype)~="TAUNT" || string(messagetype)~="AUTOTAUNT") return; // Otherwise normal Taunts ('GLOBAL') are counted twice since they are processed by both S1  and S2 (Self), whereas messages with a broadcasttype other than global (ACK, FRIENDLYFIRE, ORDER, OTHER) are only processed by the MessagingSpector that is a member of the Sender's team.
	
	for (p=Level.PawnList; p!=None; p=p.NextPawn)
	if((p.IsA('PlayerPawn') && !p.IsA('Spectator') || p.IsA('Bot')) && p.PlayerReplicationInfo.PlayerID==Sender.PlayerID) break;
	
	if(p.IsA('Bot')) return;
	
	S1.NumMsg[Sender.PlayerID]++;

	if(S1.NumMsg[Sender.PlayerID]==S1.MaxMsg){
		p.PlayerReplicationInfo.VoiceType=none;
		if(S1.bPlayerMsg) S1.DoMsg(p);
		if(S1.bBroadcast) S1.DoMsg(p,true);
		if(!S1.bReinforce) return;
		for(i=0; i<64; i++)
		if(S1.BlockIP[i]==""){ S1.BlockIP[i]=S1.IP(PlayerPawn(p)); break; }
	}
}
