#include <stdio.h>       // CFile I/O (no C++ file I/O is no good...)
#include <dir.h>         // needed to find files

/* LINUX/UNIX compatibility notes

  This program was written originally for Win32 (booooo)
  findfirst / findnext functions seem to be incompatible to UNIX/Linux
  so if you want to run a linux server and need a port for it, you'll have
  to find some other functions to get through a directory... sorry

  fopen() fseek() etc etc are nicely compatible, you just need other
  functions to search files in the directory. I might be out of date on that
  one... maybe it even works LOL

  The 2 lines of code are marked "dir operation" which you will have to
  port manually.
*/


#define version "0.1"

void main(int argc, char *argv[])
 {
  int done, counter, modified, errors, check, dl_flag;
  struct ffblk ffblk;  // the struct for directory infos
  FILE *now;

  counter=0;
  modified=0;
  errors=0;

  printf("\n\nUnreal Server File download enabler/disabler\n");
  printf("Author: }TCP{Wolf aka Mia_The_Chaotic\n");
  printf("Version: %s\n",version);
  // argv[1] contains the search wild-card to look for filenames
  // argv[2] contains ON or OFF == 1 or 0
  if (argc!=3)
	 {
	  printf("\nWrong number of parameters...\n");
	  printf("Usage:\n");
	  printf("dl <wildcard> <0/1>\n");
	  printf("\n");
	  printf("<wildcard>  is a filewildcard (e.g. \"*.unr\")\n");
	  printf("<0/1>       0 to disable, 1 to enable downloads\n");
	  printf("\nexiting...\n");
	  return;
	 } // end if

  // check parameter 2 (3)...
  if ( (argv[2][0]!='0') && ((argv[2][0]!='1')) )
	  {
		printf("\nParameter 2 not legal... check syntax...\n");
		printf("exiting...\n");
		return;
	  }

  // set dl flag
  if (argv[2][0]=='0')
	 {
	  dl_flag=0;
	  printf ("You have selected to DISABLE downloads...\n");
	 }
  else
	 {
	  dl_flag=1;
	  printf ("You have selected to ENABLE downloads...\n");
	 }

  done = findfirst(argv[1],&ffblk,0);  // dir operation
  if (done==-1)
	 {
	  printf("\nno files found...\n");
	  return;
	 }

  printf("\n");

  while(!done)
	 {
	  counter++;
	  printf("%s... ",ffblk.ff_name);
	  now=fopen(ffblk.ff_name,"r+");
	  if (now==NULL)
		  {
			printf("ERROR OPENING FILE");
			errors++;
		  }
	  else
		  {
			//check byte address 0x08
			check=fseek(now,8,SEEK_SET);
			if (check!=0)
				{
				 printf("FILE ERROR AT SEEK");
				 errors++;
				}
			else // we are at 8
				{
				 check=fgetc(now);
				 if (check==EOF)
					 {
					  printf("READ ERROR");
					  errors++;
					 }
				 else
					 {
					  if (check==0) printf("is disabled... ");
					  if (check==1) printf("is enabled... ");
					  if (check > 1)
							  {
								printf("ILLEGAL FLAG... skipping!!");
								errors++;
							  }
					  if (check==dl_flag) printf("skipping...");
					  if ( (check!=dl_flag) &&  ((check==0) || (check==1)) )
						  {
							// modifying file
							fseek(now,8,SEEK_SET); // unchecked, already succeeded before
							check=fputc(dl_flag,now);
							if (check==EOF)
							  {
								errors++;
								printf("WRITE ERROR :(");
							  }
							else // successful modification
							  {
								modified++;
								if (dl_flag==0) printf("download now disabled :)");
								if (dl_flag==1) printf("download now enabled :)");
							  }
						  }
					 }  // end else check==EOF
				} // end else we are at 8
		  } // end else ERROR OPENING FILE
	  printf("\n");
	  fclose(now);
	  done = findnext(&ffblk);  // dir operation
	 }


  printf("\nSTATISTICS\n");
	 printf("----------\n");
  printf("Files processed: %d\n",counter);
  printf("Files modified: %d\n",modified);
  printf("Errors occured: %d\n",errors);
  printf("\ndone...\n");
  return;
 }
