class ServerSpam extends Mutator config(ServerSpam);

var bool bCheckedMsg; // We use this bool, so SpamMsg() only has to be called once per message (in contrast to calling it for every actor per message, which is a waste of resources since we already know the result after one call)
var bool bSpamFound; // True if the current message fits the spam criteria
var config int SecondsOnServer; // Only stops spam from players that have been on the server for less than SecondsOnServer (0 = disabled)
var config bool bHardcore; // If True, a message containing four (or more) numbers is considered spam
var config bool bHideForAll; // If True, the message is swallowed completely. If False, however, the message is still shown to the sender, thus imposing a false sense of success in the sender
var config bool bKick; // If True, the offending player will be kicked from the server (and eventually be shown the BlockMsg);
var config bool bMsg; // If True, the offending player is sent the message BlockMsg
var config string BlockMsg; // If bMsg, this message is sent to the offending player
var config string AllowedList[32]; // Max 32 allowed IP addresses

function PostBeginPlay()
{
	Level.Game.RegisterMessageMutator(self);
	SaveConfig(); // To create the .ini if it doesn't exist
}

function bool MutatorBroadcastMessage( Actor Sender, Pawn Receiver,
out coerce string Msg, optional bool bBeep, out optional name Type ) // Note: this is called for each msg receiving actor
{
	if(Sender.IsA('PlayerPawn')){ // Only check messages sent by humans
		if(!bCheckedMsg) SpamMsg(Msg,Pawn(Sender),true); // Called the first time this message is processed
		if(Receiver != none && Receiver.NextPawn == none) bCheckedMsg=false; // This is the last pawn to receive the message, so get ready for the next message
		if(bSpamFound && Receiver != none && Receiver.NextPawn == none){ bSpamFound=false; if(!bHideForAll && Sender==Receiver) return true; else return false; } // Last message: reset bool and swallow
		else if(bSpamFound){ if(!bHideForAll && Sender==Receiver) return true; else return false; } // Swallow message or if bHideForAll is False, show message to sender only
	}
	
	if ( NextMessageMutator != None )
	return NextMessageMutator.MutatorBroadcastMessage(Sender, Receiver, Msg, bBeep, Type);
	else return true;
}

function bool MutatorTeamMessage( Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep )
{
	if(Sender.IsA('PlayerPawn')){
		if(!bCheckedMsg) SpamMsg(S,Pawn(Sender)); 
		if(Receiver != none && Receiver.NextPawn == none) bCheckedMsg=false; 
		if(bSpamFound && Receiver != none && Receiver.NextPawn == none){ bSpamFound=false; if(!bHideForAll && Sender==Receiver) return true; else return false; }
		else if(bSpamFound){ if(!bHideForAll && Sender==Receiver) return true; else return false; }
	}
	
	if ( NextMessageMutator != None )
	return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, S, Type, bBeep );
	else return true;
}

function SpamMsg(string Msg, pawn p, optional bool bSpec)
{
	local int MsgLen, i, num, isSpam, a;
	local string pt1, pt2;

	bCheckedMsg=true; // Set to True to indicate we have checked the current message
	
	// If SecondsOnServer is specified and the player has been on the server for longer than SecondsOnServer, return (classify Msg as not spam)
	if(SecondsOnServer>0 && int(Level.TimeSeconds) - p.PlayerReplicationInfo.StartTime > SecondsOnServer) return;

	if(bSpec) Msg = mid(Msg,len(p.PlayerReplicationInfo.Playername)+1); // Spectator messages contain the Playername + colon. Strip to get just the message.
	
	// It is important we still process the string even if an AllowedList entry is found, or it would be easily exploited: enter an AllowedList IP followed by your spam IP.
	for(i=0; i<32 && AllowedList[i]!=""; i++) // Cycle through the AllowedList and filter the current Msg from any entries found
	if(InStr(Msg,AllowedList[i]) != -1){ // Found an AllowedList entry in the message. Reconstruct the message without this in it, so we can verify it doesn't contain any spam
		pt1 = left(Msg,InStr(Msg,AllowedList[i])); // Get the part left of the AllowedList string
		pt2 = mid(Msg,InStr(Msg,AllowedList[i])+len(AllowedList[i])); // ...And get the part right of the string
		Msg = pt1$pt2; // Msg now consists of the string without our AllowedList entry
	}

	MsgLen = len(Msg); // We need to know how long the loop must run for
	
	if(!bHardcore){
		isSpam++; // Since we check for numbers AFTER the dot and the first octet doesn't have a dot INFRONT of it, we need to increase isSpam by 1 to remain compatible with bHardcore
		for(i=0; i<MsgLen && isSpam!=4; i++) // Break the loop once we've found three instances (isSpam==4)
		// Read the character at i (,i,1). The 1 indicates only one char. Omit for full string or use a number to specify how many chars to read.
		if(mid(Msg,i,1)=="." && i!=MsgLen-1){ // There is a dot ( .) at this location. Do not check if this is the end of the string though.
			num = Asc(mid(Msg,i+1,1)); // Let's check to see if it's followed by a number
			if(num >= 48 && num <= 57) isSpam++; // It's a number; not good!
		}
	}else{ // Hardcore lockdown: if the message contains four numbers (not including parts consisting of >=4 conjoined numbers), it's considered spam (since this could constitute the smallest IP address possible: x.x.x.x)
		for(i=0; i<MsgLen && isSpam<5; i++){ // using isSpam<5 since isSpam can increase beyond 4 in bHardcore
			num = Asc(mid(Msg,i,1));
			if(num >= 48 && num <= 57){ // Found a number. Now check whether it has at least 3 numbers following that (if so, it can't be part of an IP address and shouldn't be counted)
				while(num >= 48 && num <= 57 && i<MsgLen){ // This wil keep going until no more numbers are found (or end of string is encountered).
					a++; // amount of numbers found 
					i++; // increase to check next character and keep FOR loop in sync (since any numbers found now, at this position in the string, shouldn't be checked again)
					num = Asc(mid(Msg,i,1));
				}
				if(a<4) isSpam+=a; // If less than 4 characters (could be part of an IP address), add the amount encountered to isSpam
				a=0;
			}			
		}
	}

	if(isSpam>=4){ 
		bSpamFound=true; //Found the pattern of an IP address
		if(bMsg) p.ClientMessage(BlockMsg);
		if(bKick) p.Destroy(); 
	}
}

defaultproperties
{
	SecondsOnServer=0
	bHardcore=False
	bHideForAll=True
	bKick=False
	bMsg=True
	BlockMsg="The advertising of IP addresses is not allowed on this server." 
}