//=============================================================================
// AdvancedTeamBalancer.
//
// Made by CacoFFF aka Higor
// Contact me at caco_fff@hotmail.com 
//
// This version is entirely serverside and native
//=============================================================================
class AdvancedTeamBalancer expands Mutator
	config (AdvancedTeamBalancer)
	native;

var() config enum EIdentificationMethod
{
	EID_Name,
	EID_IP,
	EID_NexGen,
	EID_SiegeFP,
	EID_HWID
} AuthMethod;

//Default score/minute ratio for calculating strength
var() config float DefSStr; //420 over 30 minutes
var() config float DefKStr; //125 over 30 minutes
var() config float NewcomerStrength; //Assign this strenght to newcomers

var() config float WaitBeforeBalance; //Wait x seconds before initial balance
var() config int PunishSpecLamerMins; //Minutes to disallow spectators to rejoin as players
var() config int MinBalanceSeconds; //Minimum amount of seconds to rebalance
var() config int TeamSettleTime; //If a player sits in a team for more that X seconds, don't move him if bDisableGlobalBalance
var() config bool bQueueSwitch;
var() config bool bNoDeathOnSwitch;
var() config bool bNewcomerPolicy;
var() config bool bDisableGlobalBalance;
var() config bool DebugMode; //DebugMessages
var() config bool bAutoGlobalBalance;
var() config string OperatorKey; //Key needed to perfor admin commands

var float SecondCount;
var bool bIsMessageMut; //Already registered as message mutator
var bool bInitialTimer;
var bool bForceSave;
var int TickChecks;
var int NextBalance;
var int GeneralCheck; //Check this player id here
var int HighestID; //Highest ID caught and included

var int MaxTeams;

//Current score/minute ratio for calculating strength
var float CurSStr;
var float CurKStr;
var int BalanceTolerance; //Extra tolerance to initial balance
var bool bMatchStarted;
var bool bDontPassP;

//Compatibility reasons leads me to keep older struct formats
struct StoredProfile_V1
{
	var() string PCode;
	var() float SStr[16]; //Score strength
	var() float KStr[16]; //Kill strength
	var() int LastHere; //Matches since player was last seen here
};

struct StoredProfile_V2
{
	var() string PCode;
	var() byte Count;
	var() float SStr[16]; //Score strength
	var() float KStr[16]; //Kill strength
	var() int LastHere; //Matches since player was last seen here
};


var int ProfileCount;
var StoredProfile_V1 Prof[1024];
//var array<StoredProfile_V2> ProfArray;
var() config string StatsFile;

var() config string ClientInterfaceClass;
var CTB_ServerInterfaceComp InterfaceHandler;

//TeamGamePlus creates 4 default teaminfos
//Team array location is done thru index and not color
var ATB_TeamObject Teams[8], Deathmatch, Factions[24];
var int iTeams;

var array<ATB_PlayerProfile> ActiveProfiles;
var array<ATB_PlayerProfile> InActiveProfiles;
var ATB_PlayerProfile BestKRatio, BestSRatio;

var TeamInfo TInfos[32];
var int iTI;
var string LastMSG;

//Siege support
var bool bIsSiege;

//native final function ArrayAdd( out array<Object> TArray);
native final function ArrayRemove( out array<Object> TArray, int Idx);
native final function int ArrayNum( out array<Object> TArray);
native final function Object ArrayGet( out array<Object> TArray, int Idx);

native final function ATB_PlayerProfile FindByPlayer( out array<ATB_PlayerProfile> TArray, Pawn aPawn);
native final function AddProfileTo( out array<ATB_PlayerProfile> TArray, ATB_PlayerProfile AddThis);
native final function PushStrengths( int ProfIdx); //Pushes K and S old strengths 1 level in this offline profile

native final function bool LoadProfiles();
native final function bool SaveProfiles();
native final function bool FindOffline( ATB_PlayerProfile aP);
/* SET OLDSTRENGHT VALUES, THEN THE OFFLINEINDEX IN THE ONLINE PROFILE
	aP.OldKStrength = Prof[i].KStr;
	aP.OldSStrength = Prof[i].SStr;
	aP.OfflineIndex = i;
*/


//Move Timer here!!!
auto state Operation
{
Begin:
	Sleep(0.0);
	if ( bIsSiege )
		SetupSiege();
}

function AddMutator(Mutator M)
{
	//Don't add copy of self
	if ( (M != none) && M.IsA('AdvancedTeamBalancer') )
		return;

	if ( NextMutator == None )
		NextMutator = M;
	else
		NextMutator.AddMutator(M);
}

//Setup the mutator's initial parameters!
event PostBeginPlay()
{
	local int i;
	local class<ATB_BasePlugin> PluginClass;

	Super.PostBeginPlay();

	if ( StatsFile == "" )
		StatsFile = "CacusStats.bin";
	if ( !LoadProfiles() )
		Log("Balancer failed to load file "$StatsFile);
	SecondCount = Level.TimeSeconds;
	SetTimer( 0.25, true);
	bInitialTimer = true;
	Disable('Tick');
	GeneralCheck = 0;

	//How many teams are playing
	//We could use a faction type game
	if ( !Level.Game.IsA('TeamGamePlus') )
		Destroy();
	else if ( Level.Game.IsA('CTFGame') )
		MaxTeams = 2;
	else if ( Level.Game.IsA('Assault') )
		MaxTeams = 2;
	else if ( Level.Game.IsA('SiegeGI') )
	{
		bIsSiege = True;
		Goto FINISH_SETUP;
	}
	else
		MaxTeams = TeamGamePlus( Level.Game).MaxTeams;


	For ( i=0; i<MaxTeams ; i++ )
	{
		SetupTeam(i);
		Debug("Added team number "$i);
	}

	FINISH_SETUP:
}

//Find siege cores
function SetupSiege()
{
	local StationaryPawn aP;
	local int sTeams[8], i;

	bIsSiege = True;
	ForEach AllActors ( class'StationaryPawn', aP)
	{
		if ( aP.IsA('sgBaseCore') )
		{
			i = int(aP.GetPropertyText("Team"));
			if ( sTeams[i]++ == 0 )
			{
				Debug("Adding Siege Team: "$i);
				SetupTeam(i);
				MaxTeams++;
			}
		}
	}
}

//HARDCODED PARAMETERS:
// 255 = DEATHMATCH
//
// 100-123 = Factions
//
function SetupTeam( int TIndex)
{
	local ATB_TeamObject NewTeam;
	local int i;

	//Standard team
	if ( TIndex < 100 )
	{
		NewTeam = new class'ATB_TeamObject';
		NewTeam.TeamColor = TIndex;
		While ( (Teams[i] != none) )
			i++;
		if ( i<ArrayCount(Teams) )
			Teams[i] = NewTeam;
		else
			Debug("ADVANCEDTEAMBALANCER: TEAM LIST OVERFLOW!");

	}
	//Faction
	else if ( TIndex < 124 )
	{
	}

}

//SIEGE STATUS, THIS IS AN UGLY HACK TO MAKE SURE SIEGE WORKS!
function SiegeStatus()
{
	local StationaryPawn sP;
	local int i, k, j[8];
	local pawn P;

//CORES EXIST FIRST, WE TAKE ADVANTAGE OF THAT TO MAKE ITERATIONS FASTER
	ForEach AllActors ( class'StationaryPawn', sP)
	{
		if ( sP.IsA('sgBaseCore') )
		{
			k = int( sP.GetPropertyText("Team") );
			if ( j[k]++ == 0 ) //j[] array counts the amount of cores per team
			{
				if ( ++i == MaxTeams ) //All relevant cores have been counted, all teams playing
					return;
			}
		}
	}

	//One or more teams have just been defeated, send all players to zero-team array
	i=0;
	While ( i<MaxTeams )
	{
		//This team has no cores, therefore, defeated
		if ( j[Teams[i].TeamColor] == 0 )
		{
			Debug("Siege TEAM "$Teams[i].TeamColor$" has been defeated");

			//Clear defeated team, remove members from team array
			For ( k=0 ; k<Teams[i].Size ; k++ )
			{
				Teams[i].Elem[k] = none;
				Teams[i].Elem[k].LastTeam = Teams[i];
				Teams[i].Elem[k].OnTeam = none;
			}
			Teams[i].TInfo = none;
			Teams[i] = Teams[--MaxTeams];
			Teams[MaxTeams] = none;
			continue;
		}
		i++;
	}
}

event Tick( float Delta)
{
	local int i, j, k, h;
	local float fSwitch, fTemp, tmpKS[2], tmpSS[2];
	local float TotalK[4], TotalS[4];
	local bool bDiscardK; //Discard kill strength in the biggest team, over anything
	local ATB_TeamObject BiggestT, SmallestT;
	local ATB_PlayerProfile aP;

	if ( TickChecks <= 0 )
	{
		Disable('Tick');
		return;
	}

	//With every check, be less picky about balance
	BalanceTolerance += 2;
	TickChecks--;

	//Team size check, if biggest-smallest is > 1, balance size first
	SIZE_CHECK:
	j = 32;
	k = -1;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( j > Teams[i].Size )
		{
			j = Teams[i].Size;
			SmallestT = Teams[i];
		}
		if ( k < Teams[i].Size )
		{
			k = Teams[i].Size;
			BiggestT = Teams[i];
		}
	}
	if ( (BiggestT.Size - 1) > SmallestT.Size ) //Bigger team has 2 or more member difference
	{
		//Register last on biggest to last on smallest

		Debug("Team "$BiggestT.TeamColor$" is too big with "$BiggestT.Size$" players");

		aP = BiggestT.Last();
		BiggestT.RemoveLast();
		SmallestT.AddPlayer( aP, true);
		//Don't directly handle team changes here if TeamLock is enabled
//		if ( !bTeamLock)
//			ChangeTeam, how do i do this?
		Goto SIZE_CHECK;
	}


	//Team strength check
	//Measure strength on all teams (sum of both strengths)
	//Only take into account the old stats
	For ( i=0 ; i<MaxTeams ; i++ )
		For ( j=0; j<Teams[i].Size ; j++ )
			TotalS[i] += Teams[i].Elem[j].OldKStrength + Teams[i].Elem[j].OldSStrength;

	//Get weakest and strongest team (sum strength), swap one from weakest to strongest
	TotalK[0] = 0;
	TotalK[1] = 99999;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( TotalS[i] > TotalK[0] )
		{
			BiggestT = Teams[i];
			TotalK[0] = TotalS[i];
		}
		if ( TotalS[i] < TotalK[1] )
		{
			SmallestT = Teams[i];
			TotalK[1] = TotalS[i];
		}
	}

	//Both teams have the exact same stats?? (maybe a botmatch, or a newcomer match)
	//Don't do more balance
	if ( SmallestT == BiggestT )
	{
		TickChecks = 0;
		Debug( "Found team equivalence!, check what's happening on team "$SmallestT.TeamColor);
		return;
	}

	Debug( "Smallest team is "$SmallestT.TeamColor$", biggest team is "$BiggestT.TeamColor);

	//Get individual ratings on both teams in question Biggest is 0, Smallest is 1
	TotalK[1] = 0;
	TotalS[1] = 0;
	TotalK[0] = 0;
	TotalS[0] = 0;
	For ( i=0; i<SmallestT.Size ; i++ )
	{
		TotalS[1] += SmallestT.Elem[i].OldSStrength;
		TotalK[1] += SmallestT.Elem[i].OldKStrength;
	}
	For ( i=0; i<BiggestT.Size ; i++ )
	{
		TotalS[0] += BiggestT.Elem[i].OldSStrength;
		TotalK[0] += BiggestT.Elem[i].OldKStrength;
	}

	Debug( "Smallest K="$int(TotalK[1])$" S="$int(TotalS[1])$" ; Biggest K="$int(TotalK[0])$" S="$int(TotalS[0]) );


	if ( (TotalK[0] - TotalK[1]) > (ArrayNum(ActiveProfiles) + BalanceTolerance) )
		bDiscardK = true; //Priority is to balance kill ratio

	//Teams are relatively balanced
	if ( (TotalS[0] + TotalK[0]) - (TotalS[1] + TotalK[1]) < BalanceTolerance ) //Difference of less than (30 + PlayerCount) means balanced
	{
		//Measure K rating difference
		if ( abs(TotalK[0] - TotalK[1]) < BalanceTolerance ) //If sum AND one of the sumands is within tolerance, the other sumand is also withing tolerance
		{
			TickChecks = 0;
			Debug( "Found team balance!");
			return;
		}
		else if ( (TotalK[0] - TotalK[1]) < -BalanceTolerance ) //Kill ratio too high on weaker team?
			Goto KILL_RATIO_FIX;

		//Grab first strong member in list, swap with first weaker member in other list
		//Give priority to the ones first in the list, also, see how the score strength affects this
		//Compare stats individually between every player
		fSwitch = 20 + (int(!bDiscardK))*10 ; //Minimum difference required to switch both players
		For ( i=0 ; i<BiggestT.Size ; i++ )
		{
			aP = BiggestT.Elem[i];
			tmpKS[0] = aP.OldKStrength;

			For ( j=0 ; j<SmallestT.Size ; j++ )
			{
				tmpKS[1] = SmallestT.Elem[j].OldKStrength;

				//Immediately discard players with similar or worse kill strength, smaller team needs those with high ratios
				if ( bDiscardK )
					if ( (tmpKS[0] * 1.3) <	tmpKS[1] )
						continue;
				else if ( (tmpKS[0] * 0.9) < tmpKS[1] ) //Discard players with less ratio
					continue;


				tmpSS[0] = aP.OldSStrength;
				tmpSS[1] = SmallestT.Elem[j].OldSStrength;
				//Increase priority for score strength if we don't need to discard kill strength
				fTemp = ((tmpKS[0] - tmpKS[1]) + (tmpSS[0] - tmpSS[1]) * (1+int(!bDiscardK)) ) * (32.0 - i) * 0.03125; 

				//Found two good candidates, mark for switch
				if ( fTemp > fSwitch )
				{
					//Safe, works with full arrays
					BiggestT.RemoveAtIndex(i);
					BiggestT.AddPlayer( SmallestT.Elem[j], true);
					SmallestT.RemoveAtIndex(j);
					SmallestT.AddPlayer( aP, true);

					Debug( "Sent "$aP.PlayerName$" to team "$SmallestT.TeamColor$"; "$BiggestT.Last().PlayerName$" to "$BiggestT.TeamColor);
					return;
				}
			}
		}

		Debug( "Error, formulate now");

		//Extra case for biggest team having less kill ratios
		if ( false )
		{
			KILL_RATIO_FIX:

			fTemp = 999;
			//Swap player with less kill ratio and more score ratio on stronger team, with a random from weaker (weird shit incoming here)
			For ( i=0 ; i<BiggestT.Size ; i++ )
			{
				aP = BiggestT.Elem[i];
				if ( (aP.OldKStrength - aP.OldSStrength * 0.5) < fTemp )
				{
					fTemp = (aP.OldKStrength - aP.OldSStrength * 0.5);
					k = i;
				}
			}

			h = Rand(SmallestT.Size);

			BiggestT.RemoveAtIndex(k);
			BiggestT.AddPlayer( SmallestT.Elem[h], true);
			SmallestT.RemoveAtIndex(h);
			SmallestT.AddPlayer( aP, true);

			Debug("Fixing kill ratio, "$aP.PlayerName$" had only K="$int(aP.OldKStrength)$", S="$int(aP.OldSStrength) );
			Debug("In his place, "$BiggestT.Last().PlayerName$" was switched");
			return;
		}


	}
	//Aggressive yet simple team balancing, grab the best player, exchange him with someone with less power (depending on actual team difference)
	else
	{
		//Get an actual balance tolerance
		k = -1;
		j = -1;
		fSwitch = ((TotalS[0] + TotalK[0]) - (TotalS[1] + TotalK[1])) * 0.5;
		tmpSS[0] = 999;

		//Find best player on best team
		For ( i=0 ; i<BiggestT.Size ; i++ )
			if ( (BiggestT.Elem[i].OldKStrength + BiggestT.Elem[i].OldSStrength) > fTemp )
			{
					fTemp = BiggestT.Elem[i].OldKStrength + BiggestT.Elem[i].OldSStrength;
					k = i;
			}

		tmpKS[0] = fTemp; //Store highest strength rating here
		fTemp = 0;
		h = -1;

		//Find player that best matches equality criteria
		//The idea is to get fTemp as close as possible to fSwitch
		For ( i=0 ; i<SmallestT.Size ; i++ )
		{
			tmpKS[1] = SmallestT.Elem[i].OldKStrength + SmallestT.Elem[i].OldSStrength;
			if ( tmpKS[1] >= tmpKS[0] ) //Player on smaller team better than best on bigger team?
				continue;
			fTemp = abs(fSwitch - (tmpKS[0] - tmpKS[1]));
			if ( fTemp < tmpSS[0] )
			{
				tmpSS[0] = fTemp;
				tmpSS[1] = tmpKS[1]; //For logging purposes
				h = i;
			}
		}

		Debug("fSwitch is "$fSwitch$" closest is "$tmpSS[0] );

		if ( (k >= 0) && (h >= 0) )
		{
			aP = BiggestT.Elem[k];
			Debug("Exchanged "$aP.PlayerName$" with "$int(tmpKS[0])$"  and  "$SmallestT.Elem[h].PlayerName$" with "$int(tmpSS[1]));
			BiggestT.RemoveAtIndex(k);
			BiggestT.AddPlayer( SmallestT.Elem[h], true);
			SmallestT.RemoveAtIndex(h);
			SmallestT.AddPlayer( aP, true);
			return;
		}

		//No exchange: all players have same rating

	}

}

event Timer()
{
	local int i, j, k;
	local pawn P, NoInits[16]; //Only handle 32 uninitialized players
	local ATB_PlayerProfile aP;

	TeamGamePlus(Level.Game).bNoTeamChanges = false;
	TeamGamePlus(Level.Game).bBalanceTeams = false;
	TeamGamePlus(Level.Game).bPlayersBalanceTeams = false;
	LastMsg = "";
	if ( bForceSave )
	{
		SaveConfig();
		bForceSave = false;
	}

	//Update siege teams //HACK, FIX LATER
	if ( bIsSiege )
		SiegeStatus();

	//Process once, add all players who have joined and immediately start the balance
	if ( bInitialTimer )
	{
		if ( !bMatchStarted && (Min(DeathMatchPlus(Level.Game).countdown,DeathMatchPlus(Level.Game).NetWait-DeathMatchPlus(Level.Game).ElapsedTime) > 2) )
			return;
		KillOthers(); //Kill other team balancers
		SecondCount = Level.TimeSeconds + Level.TimeDilation * 0.25;
		RegisterMessageMutator();
		SetupGameProfiles();
		bInitialTimer = false;
		TickChecks = 10 + MaxTeams;
		BalanceTolerance = ArrayNum(ActiveProfiles);
		Enable('Tick');
		Debug("Initial balance triggered");
		return;
		//Wait 2 seconds, then start checking every second
	}


	if (Level.TimeSeconds - SecondCount >= Level.TimeDilation) //Checks happen in game time, not engine time (done to match the HUD timer)
		SecondCount += Level.TimeDilation;
	else
		return; //A second didn't pass, don't check yet

	//Methodology:
	// Go through the level's actor list, should be in the same order as our list
	// If this pawn is a player, we check the active players
	// If there is a match, proceed
	// If there isn't, check if somebody left
	// If there are more players in the actor list than our list, add a player to our list
	j = 0;

	if ( (MaxTeams == 2) && abs(Teams[0].Size - Teams[1].Size) > 1 )
		NextBalance--;

	if ( NextBalance > 0 )
		NextBalance--;

	//Initialize players here
	//Clean initialized profiles from the uninit list
	i = 0;

	//Janitorial tasks
	if ( FRand() < 0.2 )
	{
		For ( i=0 ; i<MaxTeams ; i++ )
			Teams[i].JanitorTask();
	}

	//Mid balancer
	if ( bAutoGlobalBalance && !bDisableGlobalBalance && (FRand() < 0.1) )
	{
		j = -1;
		k = 1000;
		For ( i=0 ; i<MaxTeams ; i++ )
		{
			if ( Teams[i].Size < k )
				k = Teams[i].Size;
			if ( Teams[i].Size > j )
				j = Teams[i].Size;
		}
		//j is the biggest team, now if the biggest team is winning, add 1 to enforce balance
		if ( j-1 > k )
		{
			BroadcastGlobal("Performing automatic global balancing");
			GlobalBalance(true);
		}
	}

}


//Simple policy, assign new players without being too intrusive
function SimplePolicy( ATB_PlayerProfile aP)
{
	local ATB_TeamObject SmallestT, BiggestT;
	local int i, j, k;

	//Size check
	j = 32;
	k = -1;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( j > Teams[i].Size )
		{
			j = Teams[i].Size;
			SmallestT = Teams[i];
		}
		if ( k < Teams[i].Size )
		{
			k = Teams[i].Size;
			BiggestT = Teams[i];
		}
	}

	//Return to old team if not big enough
	if ( aP.OnTeam != none )
	{
		if ( (aP.OnTeam.Size - SmallestT.Size) < 2 )
		{
			aP.OnTeam.AddPlayer( aP); //No need to correct profile
			return;
		}
	}

	//Random team if all teams have same size
	if ( SmallestT == BiggestT )
	{
		Teams[ Rand(MaxTeams) ].AddPlayer( aP, true);
		return;
	}

	//Enter smallest team otherwise
	SmallestT.AddPlayer( aP, true);
}

//Newcomer policy, this handles the way newcomers are assigned
function NewcomerPolicy( ATB_PlayerProfile aP, optional bool bIgnoreSize)
{
	local int i, j, k;
	local float TotalK[2], TotalS[4];
	local ATB_TeamObject SmallestT, BiggestT;

		//FIX, let teamlock handle team changes!

	if ( bIgnoreSize )
		Goto POST_SIZE;

	//Size check between the 2 involved teams if done if bIgnoreSize = false
	j = 33;
	k = -1;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( j > Teams[i].Size )
		{
			j = Teams[i].Size;
			SmallestT = Teams[i];
		}
		if ( k < Teams[i].Size )
		{
			k = Teams[i].Size;
			BiggestT = Teams[i];
		}
	}
	if ( (BiggestT.Size - 1) > SmallestT.Size ) //Bigger team has 2 or more member difference
	{
		//Register newcomer on smallest team
		SmallestT.AddPlayer( aP, True);
		return;
	}


	//Add to smallest team if biggest isn't losing
	if ( BiggestT.TInfo.Score > SmallestT.TInfo.Score )
	{
		SmallestT.AddPlayer( aP, True);
		return;
	}

	POST_SIZE:

	//Team strength check
	//Measure strength on all teams (sum of both strengths)
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		For ( j=0; j<Teams[i].Size ; j++ )
			TotalS[i] += Teams[i].Elem[j].KStrength + Teams[i].Elem[j].SStrength;
		if ( bIgnoreSize )
			TotalS[i] += Teams[i].Size * 80;
		Debug("Newcomer strength for"@Teams[i]@"is:"@TotalS[i]);
	}

	//Get weakest and strongest team (sum strength)
	TotalK[0] = 0;
	TotalK[1] = 99999;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( TotalS[i] > TotalK[0] )
		{
			BiggestT = Teams[i];
			TotalK[0] = TotalS[i];
		}
		if ( TotalS[i] < TotalK[1] )
		{
			SmallestT = Teams[i];
			TotalK[1] = TotalS[i];
		}
	}

	Debug("Weakest is "$SmallestT.TeamColor$"; Strongest is"@BiggestT.TeamColor);

	//Newcomer policy on a very simple version
	if ( bIgnoreSize )
	{
		SmallestT.AddPlayer( aP, true);
		return;
	}

	//Both teams have the exact same stats?? (maybe a botmatch, or a newcomer match)
	//Assign to random team
	if ( SmallestT == BiggestT )
	{
		Teams[ Rand(MaxTeams) ].AddPlayer( aP, true);
		return;
	}

	//Less than 6 players on both stronger and weaker?, Stronger has more players? assign on weaker
	if ( (SmallestT.Size + BiggestT.Size < 6) || (SmallestT.Size <= BiggestT.Size) )
	{
		SmallestT.AddPlayer( aP, true);
		return;
	}

	//Find worst player on weaker team
	TotalK[0] = 350;
	k = -1;
	For ( i=0 ; i<SmallestT.Size ; i++ )
		if ( SmallestT.Elem[i].KStrength + SmallestT.Elem[i].SStrength < TotalK[0] )
		{
			TotalK[0] = SmallestT.Elem[i].KStrength + SmallestT.Elem[i].SStrength;
			k = i;
		}

	if ( k<0 )
		Debug("CRITICAL ERROR IN NEWCOMER POLICY");

	BiggestT.AddPlayer( SmallestT.Elem[k] , true);
	SmallestT.RemoveAtIndex(k);
	SmallestT.AddPlayer( aP, true);
	Debug("Newcomer policy success, switched "$BiggestT.Last().PlayerName$" to "$BiggestT.TeamColor$", added newcomer in "$SmallestT.TeamColor);
}

function bool GlobalBalance( optional bool bPickLatest)
{
	local int i, j, k, h;
	local ATB_PlayerProfile aP;
	local ATB_TeamObject SmallestT, BiggestT;
	local float TotalK[2], TotalS[4], fSwitchK, fSwitchS;
	local bool bReturnHere;

	//First, find team with 2 or greater size difference
	SIZE_CHECK:
	j = 32;
	k = -1;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( j > Teams[i].Size )
		{
			j = Teams[i].Size;
			SmallestT = Teams[i];
		}
		if ( k < Teams[i].Size )
		{
			k = Teams[i].Size;
			BiggestT = Teams[i];
		}
	}
	i = 3;
	if ( bPickLatest )
		i = 1;
	if ( (BiggestT.Size - i) > SmallestT.Size ) //Bigger team has 4 or more member difference (or 2 if bPickLatest)
	{
		//Select latest player
		aP = BiggestT.Last();

		//Move to smallest team
		BiggestT.RemoveLast();
		SmallestT.AddPlayer( aP, true);
		bReturnHere = true;
		Goto SIZE_CHECK;
	}
	else if ( bReturnHere )
		return true;


	//Bigger team has 2 or more member difference
	if ( (BiggestT.Size - 1) > SmallestT.Size )
	{
		//Measure smallest and biggest strength
		For ( i=0; i<BiggestT.Size ; i++ )
		{
			aP = BiggestT.Elem[i];
			TotalK[0] += aP.KStrength;
			TotalS[0] += aP.SStrength;
		}
		For ( i=0; i<SmallestT.Size ; i++ )
		{
			aP = SmallestT.Elem[i];
			TotalK[1] += aP.KStrength;
			TotalS[1] += aP.SStrength;
		}

		//If smallest is stronger
		if ( (TotalK[1] + TotalS[1]) > (TotalK[0] + TotalS[0]) )
		{
			//If smallest is losing, get worst player from biggest
			if ( BiggestT.TInfo.Score > SmallestT.TInfo.Score )
			{
				//Find worst player on bigger team
				TotalK[0] = 350;
				k = -1;

				For ( i=0 ; i<BiggestT.Size ; i++ )
				{
					aP = BiggestT.Elem[i];
					if ( aP.KStrength + aP.SStrength < TotalK[0] )
					{
						TotalK[0] = aP.KStrength + aP.SStrength;
						k = i;
					}
				}
				SmallestT.AddPlayer( BiggestT.Elem[k], true ); //First add to new team, 
				BiggestT.RemoveAtIndex( k); //Then remove from old, avoids extra operations
//FIX, use instant ChangeTeam!
				return true;
			}
			//Else, do nothing
			return false;
		}

		MOVE_TO_WEAKEST:
		//Find team difference tolerance, sum is positive 100%
		//Goal is to approach these values
		fSwitchK = (TotalK[0] - TotalK[1]) * 0.5; //Kill difference
		fSwitchS = (TotalS[0] - TotalS[1]) * 0.5; //Score difference

		//Cycle through biggest team players, get best match
		TotalS[3] = 999;
		For ( i=0 ; i<BiggestT.Size ; i++ )
		{
			TotalS[2] = abs( (fSwitchK - BiggestT.Elem[i].KStrength) + (fSwitchS - BiggestT.Elem[i].SStrength) );
			if ( TotalS[2] < TotalS[3] )
			{
				TotalS[3] = TotalS[2];
				k = i;
			}
		}

		//Move this player to smallest
		SmallestT.AddPlayer( BiggestT.Elem[k], true);
		BiggestT.RemoveAtIndex(k);

		BroadcastGlobal("Sent"@SmallestT.Last().PlayerName@"to weakest team");
		return true;
	}

	//Team strength check
	//Measure strength on all teams (sum of both strengths)
	For ( i=0 ; i<MaxTeams ; i++ )
		For ( j=0; j<Teams[i].Size ; j++ )
			TotalS[i] += Teams[i].Elem[j].KStrength + Teams[i].Elem[j].SStrength;

	//Get weakest and strongest team (sum strength)
	TotalK[0] = -1;
	TotalK[1] = 99999;
	For ( i=0 ; i<MaxTeams ; i++ )
	{
		if ( TotalS[i] > TotalK[0] )
		{
			BiggestT = Teams[i];
			TotalK[0] = TotalS[i];
		}
		if ( TotalS[i] < TotalK[1] )
		{
			SmallestT = Teams[i];
			TotalK[1] = TotalS[i];
		}
	}

	if ( SmallestT == BiggestT ) //Sanity check... same strength?
		return false;

	//Teams seem balanced, return or kill sender
	if ( abs(TotalK[0] - TotalK[1]) < 40 )
	{
		BroadcastGlobal("Teams seem to be reasonably balanced");
		return false;
	}

	//Teams have same size
	if ( BiggestT.Size == SmallestT.Size )
	{
		MID_TIER_SWITCH:
		//Get mid tier player
		h = -1;
		aP = BiggestT.GetMidTier();
		fSwitchS = (TotalK[0] - TotalK[1]) * 0.5; //Kill+Score difference, always positive

		//Find player that best matches equality criteria
		//The idea is to get the difference as close as possible to 0
		TotalS[0] = 9999;
		For ( i=0 ; i<SmallestT.Size ; i++ )
		{
			TotalS[1] = SmallestT.Elem[i].KStrength + SmallestT.Elem[i].SStrength;
			if ( TotalS[1] >= (aP.KStrength + aP.SStrength) ) //Player on smaller team better than mid tier on bigger team?
				continue;
			if ( abs(fSwitchS - (aP.KStrength + aP.SStrength - TotalS[1])) < TotalS[0] )
			{
				TotalS[0] = abs(fSwitchS - (aP.KStrength + aP.SStrength - TotalS[1]));
				h = i;
			}
		}

		if ( h<0 )
		{
			Debug("CRITICAL: NO VALID EXCHANGE FOR MID TIER");
			return false;
		}
		//This specific swapping order is safe at full arrays
		BiggestT.RemovePlayer( aP);
		BiggestT.AddPlayer( SmallestT.Elem[h], true);
		SmallestT.RemoveAtIndex( h);
		SmallestT.AddPlayer( aP, true);
		BroadcastGlobal( aP.PlayerName @ "and" @ BiggestT.Last().PlayerName @ "have been team-switched");
		return true;
	}

	//Teams are not tied
	if ( BiggestT.TInfo.Score != SmallestT.TInfo.Score )
	{
		//Weakest is losing and has less players
		if ( (SmallestT.Size < BiggestT.Size) && (BiggestT.TInfo.Score > SmallestT.TInfo.Score) )
		{
			//Find player that best matches equality criteria (no switch, simply move to weakest)
			//First, measure weakest and strongest ratings
			TotalK[0] = 0; TotalS[0] = 0; TotalK[1] = 0 ; TotalS[1] = 0;
			For ( i=0; i<BiggestT.Size ; i++ )
			{
				TotalK[0] += BiggestT.Elem[i].KStrength;
				TotalS[0] += BiggestT.Elem[i].SStrength;
			}
			For ( i=0; i<SmallestT.Size ; i++ )
			{
				TotalK[1] += SmallestT.Elem[i].KStrength;
				TotalS[1] += SmallestT.Elem[i].SStrength;
			}
			Debug("Step 5, moving mid tier from strongest to weakest");
			Goto MOVE_TO_WEAKEST;
		}
	}

	Debug("Step 6, doing a mid tier switch");
	Goto MID_TIER_SWITCH;
}

//Strength is calculated here, as well as the strength factors are measured
function CalcStrengthFor( ATB_PlayerProfile aP)
{
	local float fTmp;
	local float fOld;

	if ( aP.PlaySeconds <= 0 )
	{
		aP.KStrength = aP.OldKStrength;
		aP.SStrength = aP.OldSStrength;
		aP.PlaySeconds++;
		return;
	}

	//CACUS: PLACE THESE IN A BETTER LOCATION
	if ( BestKRatio == none )
		BestKRatio = aP;
	if ( BestSRatio == none )
		BestSRatio = aP;

	//Inrterpolation between strength from last match and strength from current one
	fOld = fMax( 0.0, 360.0 - aP.PlaySeconds) / 360;

	//Kill strength first
	//Get Kill/Seconds ratio to determine if we're over the limit
	RECALC_STR:
	fTmp = (float(aP.KillCount) / float(aP.PlaySeconds)) * 60.0;
	if ( BestKRatio == aP )
	{
		CurKStr = fMax(fTmp, DefKStr);
		if ( FRand() < 0.1 )
			Debug("CurKStr is "$CurKStr$" given by "$BestKRatio.PlayerCode);
	}
	aP.KStrength = 100.0f * (fTmp / CurKStr) * (1.0 - fOld) + aP.OldKStrength * fOld;
	if ( aP.KStrength > BestKRatio.KStrength ) //Strongest killer, change top and recalc
	{
		BestKRatio = aP;
		Goto RECALC_STR;
	}


	//Score strength then
	//Get Score/Seconds ratio to determine if we're over the limit
	RECALC_SCOR:
	fTmp = (aP.PScore / float(aP.PlaySeconds)) * 60.0;
	if ( BestSRatio == aP )
	{
		CurSStr = fMax(fTmp, DefSStr);
		if ( FRand() < 0.1 )
			Debug("CurSStr is "$CurSStr$" given by "$BestSRatio.PlayerCode);
	}
	aP.SStrength = 100.0f * (fTmp / CurSStr) * (1.0 - fOld) + aP.OldSStrength * fOld;
	if ( aP.SStrength > BestSRatio.SStrength ) //Strongest scorer, change top and recalc
	{
		BestSRatio = aP;
		Goto RECALC_SCOR;
	}
}


function ChangeTeam( pawn aPlayer, int newTeam)
{
	local int oldTeam;
	local translocator tmpTrans;
	local navigationpoint newStart;

	OldTeam = aPlayer.PlayerReplicationInfo.Team;
	Level.Game.ChangeTeam( aPlayer, newTeam);
	if ( Level.Game.bTeamGame && (aPlayer.PlayerReplicationInfo.Team != OldTeam) )
	{
		if ( !bNoDeathOnSwitch )
			aPlayer.Died( None, '', aPlayer.Location );
		else
		{
			tmpTrans = Translocator(aPlayer.FindInventoryType(class'Translocator'));
			if ( tmpTrans != none && tmpTrans.TTarget != None ) //Remove translocator target
			{
				tmpTrans.bTTargetOut = false;
				tmpTrans.TTarget.Destroy();
				tmpTrans.TTarget = None;
			}
			if ( CTFFlag(aPlayer.PlayerReplicationInfo.HasFlag) != none ) //Drop the flag, upwards...
				CTFFlag(aPlayer.PlayerReplicationInfo.HasFlag).Drop( vect(0,0,500));
			newStart = Level.Game.FindPlayerStart( aPlayer, newTeam);

			if ( newStart != none )
			{
				aPlayer.SetLocation( newStart.Location);
				aPlayer.SetRotation( newStart.Rotation);
				aPlayer.ViewRotation = aPlayer.Rotation;
				aPlayer.Acceleration = vect(0,0,0);
				aPlayer.Velocity = vect(0,0,0);
				aPlayer.Health = aPlayer.Default.Health;
				aPlayer.ClientSetLocation( newStart.Location, newStart.Rotation );
			}
		}
	}
}


function SetupGameProfiles()
{
	local int i, j;
	local pawn P;
	local ATB_PlayerProfile aP;
	local bool bFixTeam;
	local TeamInfo TI;

	ForEach AllActors ( class'TeamInfo', TI )
		TInfos[iTI++] = TI;

	For ( j=0 ; j<MaxTeams ; j++ )
		For ( i=0 ; i<iTI ; i++ )
			if ( TInfos[i].TeamIndex == Teams[j].TeamColor )
			{
				Teams[j].TInfo = TInfos[i];
				Debug("Attached "$TInfos[i]$" to "$Teams[j]);
				break;
			}

	//Add to teams before running the initial balance
	For ( i=ArrayNum(ActiveProfiles)-1 ; i>=0 ; i-- )
	{
		aP = ATB_PlayerProfile(ArrayGet(ActiveProfiles,i));
		if ( aP == none )
			Debug("No ActiveProfile in slot"@i);
		else
		{
			For ( j=0 ; j<MaxTeams ; j++ )
			{
				if ( aP.PlayerPawn.PlayerReplicationInfo.Team == Teams[j].TeamColor )
				{
					Teams[j].AddPlayer(aP,true);
					break;
				}
			}
		}
	}
}

//Player is now allowed to play
function PlayerAuthed( ATB_PlayerProfile eP)
{
	local ATB_PlayerProfile aP;
	local int i;

	NextBalance = Max( NextBalance-10, 10); //Wait at least 10 seconds to rebalance
	For ( i=ArrayNum(InactiveProfiles)-1 ; i>=0 ; i-- )
	{
		aP = ATB_PlayerProfile(ArrayGet(InactiveProfiles,i));
		if ( aP == none )
			Debug("InactiveProfiles slot "$i$" is empty");
		else if ( aP.PlayerCode == eP.PlayerCode )
		{
			aP.BecomeNoDelete();
			aP.SetOwner( eP.PlayerPawn);
			aP.PlayerPawn = eP.PlayerPawn;
			//CACUS: Add this player to a team here!
			aP.bIsPlaying = true;
			aP.bIsInitialized = true;
			aP.TimeStamp = Level.TimeSeconds - float(aP.PlaySeconds) * Level.TimeDilation; //Recalculate time stamp
			aP.bIsSpectator = aP.PlayerPawn.IsA('Spectator');
			if ( aP.bIsSpectator )
				SpecStamp( aP);
			NextBalance = Max( NextBalance-10, 0); //This player was already here, reduce timer
			ArrayRemove( InactiveProfiles, i);
			AddProfileTo( ActiveProfiles, aP);
			InitialTeam( aP, true);
			Debug("Player returned: " $ aP.PlayerCode);
			eP.Destroy();
			return;
		}
	}

	eP.bIsPlaying = true;
	if ( !FindOffline( eP) )
	{
		eP.OldKStrength = NewcomerStrength;
		eP.OldSStrength = NewcomerStrength;
		eP.OfflineIndex = -1;
	}
	eP.PlayerName = eP.PlayerPawn.PlayerReplicationInfo.PlayerName;
	eP.TimeStamp = Level.TimeSeconds;
	AddProfileTo( ActiveProfiles, eP);
	InitialTeam( eP);
	Debug("New player"@ eP.PlayerName @"arrived, ID:"@eP.PlayerCode );
}

//CACUS: IMPLEMENT PLAYER REJOIN AND RECOVER
function InitialTeam( ATB_PlayerProfile aP, optional bool bTryRecoverLast)
{
	//Don't do team processing before game starts
	if ( bInitialTimer )
		return;

	if ( bNewcomerPolicy )
	{
		if ( bDisableGlobalBalance )
			NewcomerPolicy( aP, true);
		else
			NewcomerPolicy( aP);
	}
	else
		SimplePolicy( aP);
}

//Genuine active player left the game, remove from array
function PlayerLeft( ATB_PlayerProfile eP)
{
	local int i;
	local ATB_PlayerProfile aP;

	For ( i=ArrayNum(ActiveProfiles)-1 ; i>=0 ; i-- )
	{
		aP = ATB_PlayerProfile(ArrayGet(ActiveProfiles,i));
		if ( aP == eP )
		{
			ArrayRemove( ActiveProfiles, i);
			if ( InterfaceHandler != none )
				InterfaceHandler.I_DelPlayer( i);
			break;
		}
	}
	NextBalance = Max( NextBalance-10, 5);
}


function SpecStamp( ATB_PlayerProfile eP)
{
	//A lamer spectator, should i prevent him from playing as punishment?
	if ( !eP.bIsSpectator && (PunishSpecLamerMins > 0) )
	{
		eP.SpectatorStamp = eP.LastCheckup + float(PunishSpecLamerMins) * 60.0 * Level.TimeDilation; //Minutes of punishment = Time you can rejoin as player
		if ( eP.SpectatorStamp > Level.TimeSeconds )
			BroadcastGlobal( eP.PlayerName$" is back as spectator, now you wait "$ 
								Left( string(abs(Level.TimeSeconds-eP.SpectatorStamp) / Level.TimeDilation), 4)
								$	" seconds to rejoin as player");
	}
}

function BroadcastGlobal( string Message)
{
   local PlayerPawn P;

   ForEach AllActors( class'PlayerPawn', P)
      P.ClientMessage( Message);
}

function String FixAddress( string address)
{
	if ( InStr( address, ":") > 0 )
			return Left( address, InStr( address, ":") );
}



//======================
//Mutator hook functions
//======================
function bool HandleEndGame()
{
	local int i, j, MaxTimes;
	local ATB_PlayerProfile aP;

//Compute strength, save all profiles, stop timer
	SetTimer(0.0, false);

	For ( i=ArrayNum(ActiveProfiles)-1 ; i>=0 ; i-- )
	{
		aP = ATB_PlayerProfile(ArrayGet(ActiveProfiles,i));
		aP.BecomeStatic();
		//Spectator, zapping players and special offline indexes don't save
		if ( (aP.PlaySeconds < 20) || (aP.OfflineIndex == -2) )
			continue;
		CalcStrengthFor( aP);
		j = aP.OfflineIndex;
		if ( j < 0 )
		{
			AddProfileFor(aP);
			continue;
		}
		Prof[j].PCode = aP.PlayerCode; //Update code
		PushStrengths( j);
		Prof[j].SStr[0] = aP.SStrength;
		Prof[j].KStr[0] = aP.KStrength;
		Prof[j].LastHere = 0;
	}
	For ( i=ArrayNum(InactiveProfiles)-1 ; i>=0 ; i-- )
	{
		aP = ATB_PlayerProfile(ArrayGet(InactiveProfiles,i));
		aP.BecomeStatic();
		if ( (aP.PlaySeconds < 20) || (aP.OfflineIndex == -2) )
			continue;
		CalcStrengthFor( aP);
		j = InactiveProfiles[i].OfflineIndex;
		if ( j < 0 )
		{
			AddProfileFor(aP);
			continue;
		}
		Prof[j].PCode = aP.PlayerCode; //Update code
		PushStrengths( j);
		Prof[j].SStr[0] = aP.SStrength;
		Prof[j].KStr[0] = aP.KStrength;
		Prof[j].LastHere = 0;
	}

	For ( i=0 ; i<ProfileCount ; i++ )
	{
		if ( Prof[i].LastHere++ >= MaxTimes )
			MaxTimes = Prof[i].LastHere;
	}
	For ( i=0 ; i<ArrayCount(Teams) ; i++ )
		if ( Teams[i] != none )
			Teams[i].TInfo = none;

	//Cleanup
	While ( ProfileCount > 900 )
	{
		if ( MaxTimes > 20 )
			MaxTimes -= 10;
		if ( MaxTimes > 25 )
			MaxTimes -= 15;
		For ( i=0 ; i<ProfileCount ; i++ )
		{
			if ( Prof[i].LastHere >= MaxTimes )
			{
				Prof[i--] = Prof[--ProfileCount];
				Prof[ProfileCount].PCode = "";
				For ( j=0 ; j<16 ; i++ )
				{
					Prof[ProfileCount].KStr[0] = 0;
					Prof[ProfileCount].SStr[0] = 0;
				}
				Prof[ProfileCount].LastHere = 0;
			}
		}
		MaxTimes--;
	}

	SaveConfig(); //CACUS: REPLACE WITH BINARY FILE GENERATOR
	if ( !SaveProfiles() )
		Log("Balancer failed to save file "$StatsFile);

	if ( NextMutator != None )
		return NextMutator.HandleEndGame();
	return false;
}


//Register first in the list, so we can catch balance messages before other mutators
function RegisterMessageMutator()
{
	local mutator aMut;

	if ( bIsMessageMut )
	{
		//FUTURE: Move me from mid or end of the list to first
		//This may happen if other mutators register late as we do
		return;
	}

	aMut = Level.Game.MessageMutator;
	Level.Game.MessageMutator = self;
	NextMessageMutator = aMut;
	bIsMessageMut = true;
}


function ModifyPlayer(Pawn Other)
{
	local ATB_PlayerProfile aP;

	aP = GetProfFor( Other);
//	Debug("PROFILE FOR "$Other$" IS "$aP);

	bMatchStarted = true;

	if ( (TournamentPlayer(Other) != none) && (aP != none) && SpectatorSwitch( aP) )
	{
		Debug("VALID SPEC SWITCH");
		return;
	}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

//Increase kill count for this player
function ScoreKill(Pawn Killer, Pawn Other)
{
	local ATB_PlayerProfile aP;

	if ( (Killer != none) && (Other != none) && (Killer != Other) )
	{
		aP = FindByPlayer( ActiveProfiles, Killer);
		if ( aP != none )
			aP.KillCount++;
	}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

function bool MutatorTeamMessage( Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep )
{
	local int i;
	local playerpawn P;

	if ( S == LastMsg )
		Goto END;
	LastMsg = S;
	CommonCommands( Sender, S);

	END:

	if ( DontPass( S) )
		return true;

	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, S, Type, bBeep );
	return true;
}

function bool MutatorBroadcastMessage( Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, out optional name Type )
{
	local int i;
	local playerpawn P;
	local string orgMsg;

	if ( Msg == LastMsg )
		Goto END;
	LastMsg = Msg;
	orgMsg = Msg;
	While ( inStr( orgMsg, ":") > -1 )
		orgMsg = Mid( orgMsg, inStr( orgMsg, ":")+1 );

	CommonCommands( Sender, orgMsg);

	END:
	if ( DontPass( orgMsg ) )
		return true;

	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );
	return true;
}

function CommonCommands( Actor Sender, String S)
{
	local int i, j;
	local playerpawn P;
	local ATB_PlayerProfile aP;
	local float aS, K;

	if ( bMatchStarted && ((S ~= "!t") || (S ~= "!teams") || (S ~= "!team")) )
	{
		if ( CanBalance( Sender) )
		{
			NextBalance = Max( NextBalance, MinBalanceSeconds);
			GlobalBalance();
		}
		else
		{
			if ( bDisableGlobalBalance )
				BroadcastGlobal("Global balancing is disabled");
			else
				BroadcastGlobal("Team balancing is currently locked");
		}
	}

	if ( S ~= "!playerlist" )
	{
		For ( i=ArrayNum(ActiveProfiles)-1 ; i>=0 ; i-- )
		{
			aP = ATB_PlayerProfile(ArrayGet(ActiveProfiles,i));
			Pawn(Sender).ClientMessage("Player num #"$i$" is "$aP.PlayerName@" ; K="$Left( string(aP.KStrength),5)$" S="$Left( string(aP.SStrength),5) );
		}
		aP = none;
	}
	else if ( S ~= "!playermemory" )
	{
		ForEach AllActors (class'Playerpawn', P)
		{
			Pawn(Sender).ClientMessage("Player in memory: "$P.PlayerReplicationInfo.PlayerName$" with ID: "$P.PlayerReplicationInfo.PlayerID);
		}
	}
	else if ( S ~= "!enter" )
	{
		ENTER_SELECTED:
		aP = GetProfFor( PlayerPawn(Sender) );

		if ( !SpectatorSwitch(aP) && aP.bIsInitialized) //CACUS CORRECT!, IT WAS ELSE IF BEFORE
		{
			//CORRECT LATER
			if ( (Pawn(Sender).Physics == PHYS_Flying) || (Pawn(Sender).PlayerRestartState == 'PlayerSpectating') )
			{
				Pawn(Sender).PlayerRestartState = 'PlayerWalking';
				Sender.GotoState('Dying');
				Pawn(Sender).Health = 1;
				aP.OnTeam = none;
				aP.bIsSpectator = false;
				if ( bNewcomerPolicy )
					NewcomerPolicy( aP, bDisableGlobalBalance);
				else
					SimplePolicy( aP);
			}
		}
	}
	else if ( S ~= "!report" )
	{
		aP = GetProfFor( PlayerPawn(Sender) );
		Pawn(Sender).ClientMessage("Team is: "$string(aP.OnTeam.TeamColor)$"; Playing for "$aP.PlaySeconds);
	}
	else if ( S ~= "!stats" )
	{
		For ( i=0 ; i<MaxTeams ; i++ )
		{
			K=0; aS=0;
			For ( j=0 ; j<Teams[i].Size ; j++ )
			{
				K += Teams[i].Elem[j].KStrength;
				aS += Teams[i].Elem[j].SStrength;
			}
			Pawn(Sender).ClientMessage("Team number "$string(Teams[i].TeamColor)$" > K="$K@", S="$aS);
		}
	}
	else if ( (S ~= "!p") || (S ~= "!play") )
	{
		aP = GetProfFor( PlayerPawn(Sender) );
		if ( aP.OnTeam == none ) //Teamless? enter a team
		{
			bDontPassP = true;
			Goto ENTER_SELECTED;
		}
	}


}

function bool DontPass( string Msg)
{
	if ( (Msg ~= "!r") || (Msg ~= "!b") || (Msg ~= "!red") || (Msg ~= "!blue") || (Msg ~= "!t") || (Msg ~= "!teams") || (Msg ~= "!team") || (Msg ~= "!enter") )
		return true;
	if ( bDontPassP && ( (Msg ~= "!p") || (Msg ~= "!play") ) )
	{
		bDontPassP = false;
		return true;
	}
	return false;
}

function bool CanBalance( Actor Sender)
{
	if ( Pawn(Sender) == none )
		return false;
	if ( NextBalance > 0 )
		return false;
	if ( (Spectator(Sender) != none) && (!Spectator(Sender).PlayerReplicationInfo.bAdmin) )
		return false;
	return !bDisableGlobalBalance;
}

function ATB_PlayerProfile GetProfFor( Pawn Other)
{
	return FindByPlayer( ActiveProfiles, Other);
}

function bool SpectatorSwitch( ATB_PlayerProfile aP)
{
	if ( !bMatchStarted || aP.bIsABot )
		return false;

//	if ( aP.PScore > 1 )
//		return false;
//	Debug(Level.TimeSeconds@aP.SpectatorStamp);

	return Level.TimeSeconds < aP.SpectatorStamp;
}

function KillOthers()
{
	local Mutator M, aut, nx, bc;
	local ReplicationInfo gInf;

	For ( M=Level.Game.BaseMutator ; M!=none ; M=M.nextMutator )
	{
		if ( InStr( Caps(string(M.Class)),"AUTOTEAMBALANCE") != -1 )
			aut = M;
		else if ( M.IsA('NexgenController') )
			nx = M;
		else if ( M.IsA('BalanceController') )
			bc = M;
	}

	//Remove AutoTeamBalancer
	if ( aut != none )
	{
		if ( Level.Game.BaseMutator == aut )
			Level.Game.BaseMutator = aut.NextMutator;
		else
			For ( M=Level.Game.BaseMutator ; M!=none ; M=M.nextMutator )
				if ( M.NextMutator == aut )
				{
					M.NextMutator = aut.NextMutator;
					break;
				}
		aut.NextMutator = none;
	}

	//Remove my BalanceController
	if ( bc != none )
	{
		if ( Level.Game.BaseMutator == bc )
			Level.Game.BaseMutator = bc.NextMutator;
		else
			For ( M=Level.Game.BaseMutator ; M!=none ; M=M.nextMutator )
				if ( M.NextMutator == bc )
				{
					M.NextMutator = bc.NextMutator;
					break;
				}
		bc.NextMutator = none;
		bc.Destroy();
	}

	//Disable nexgen balancer, unlock team placement
	if ( nx != none )
	{
		nx.SetPropertyText("teamBalancer","none");
		ForEach AllActors (class'ReplicationInfo', gInf )
			if ( gInf.IsA('NexgenGameInfo') )
			{
				gInf.SetPropertyText("bTeamsLocked","False");
				gInf.SetPropertyText("bNoTeamSwitch","False");
				gInf.SetPropertyText("bNoTeamBalance","False");
				break;
			}
	}
}

//========================
//Offline profile handling
//========================

//Instantly processes a new offline profile for an online profile
function int AddProfileFor( ATB_PlayerProfile aP)
{
	Prof[ProfileCount].PCode = aP.PlayerCode;
	Prof[ProfileCount].SStr[0] = aP.SStrength;
	Prof[ProfileCount].KStr[0] = aP.KStrength;
	Prof[ProfileCount].LastHere = 0;
	ProfileCount++;
}

final function Debug( coerce string MSG)
{
	if ( DebugMode )
		Log("ATB DEBUG: "$MSG,'Log');
}

defaultproperties
{
     DefSStr=8.000000
     DefKStr=4.000000
     bNoDeathOnSwitch=True
     WaitBeforeBalance=25.000000
     bNewcomerPolicy=True
     bDisableGlobalBalance=True
     PunishSpecLamerMins=1
     MinBalanceSeconds=40
     TeamSettleTime=120
     HighestID=-1
}
