//=============================================================================
// ATB_TeamObject.
//
// Made by CacoFFF aka Higor
// Contact me at caco_fff@hotmail.com 
//
// Team object, made for elimination type games.
// Players are ordered in arrival
//=============================================================================
class ATB_TeamObject expands Object;


var byte TeamColor;
var string TeamName;
var ATB_PlayerProfile Elem[32];
var byte Size;

//DEINIT THIS VARIABLE UPON GAME END!!!
var TeamInfo TInfo;


//Utilitary functions, we follow the very foundation of C and C++ at making structures here
function JanitorTask() 
{
	local int i;

	While ( i<Size )
	{
		if ( (Elem[i] == none) || !Elem[i].bIsPlaying )
		{
			Log("INVALID ELEMENT FOUND IN TEAM JANITORIAL TASK");
			Elem[i] = Elem[--Size];
			Elem[Size] = none;
			continue;
		}
		if (Elem[i].OnTeam != self)
		{
			Elem[i].ToTeam(self);
			LOG("INVALID TEAM FOUND ON TEAM JANITORIAL TASK");
		}
		i++;
	}
	TInfo.Size = Size; //Should i fix this?
}

function AddPlayer( ATB_PlayerProfile aPlayer, optional bool bCorrectProfile)
{
	Elem[Size++] = aPlayer;
	if ( bCorrectProfile )
		aPlayer.ToTeam( self);
}

function RemovePlayer( ATB_PlayerProfile aPlayer)
{
	local int i;

	While ( i<Size )
	{
		if ( Elem[i] == aPlayer )
		{
			RemoveAtIndex(i);
			return;
		}
		i++;
	}
}

function RemoveAtIndex( int j)
{
	--Size;
	LOOP:
	if ( j>=Size )
	{
		Elem[j] = none;
		return;
	}
	Elem[j] = Elem[j+1];
	j++;
	Goto LOOP;

	if ( TInfo != none )
		TInfo.Size = Size;
}

function ATB_PlayerProfile Last()
{
	return Elem[ Size-1 ];
}

function RemoveLast()
{
	Elem[--Size] = none;

	if ( TInfo != none )
		TInfo.Size = Size;
}

//Sort players in team by strength, choose accordingly
function ATB_PlayerProfile GetMidTier()
{
	local int i;
	local ATB_PlayerProfile Samples[3], nEb;

	//Pick weakest
	if ( Size == 2 )
	{
		if ( (Elem[0].KStrength + Elem[0].SStrength) < (Elem[1].KStrength + Elem[1].SStrength) )
			return Elem[0];
		return Elem[1];
	}
	else if ( Size == 3 )
	{
		Samples[0] = Elem[0];
		Samples[1] = Elem[1];
		Samples[2] = Elem[2];
	}
	else
	{
		Samples[0] = Elem[Rand(Size)];
		Samples[1] = Elem[Rand(Size)];
		Samples[2] = Elem[Rand(Size)];
	}

	//Sort them by strength
	While ( i<2 )
	{
		if ( (Samples[i].KStrength + Samples[i].SStrength) > (Samples[i+1].KStrength + Samples[i+1].SStrength) )
		{	//Swap
			nEb = Samples[i];
			Samples[i] = Samples[i+1];
			Samples[i+1] = nEb;
			if ( i==0 )
				++i;
			else
				--i;
		}
		else
			++i;
	}
	return Samples[1];
}

defaultproperties
{
}
