//=============================================================================
// ATB_PlayerProfile.
//
// Made by CacoFFF aka Higor
// Contact me at caco_fff@hotmail.com 
//
// This is a player profile
//=============================================================================
class ATB_PlayerProfile expands Info
	native;

var const AdvancedTeamBalancer ATB;

var string PlayerName;
var int PlayerId; //Player's id during this session
var int KillCount;
var float PScore;
var float KStrength, OldKStrength;
var float SStrength, OldSStrength;
var int SecondsInTeam;
var int TPosition;
var int PlaySeconds; //Seconds played
var float TimeStamp;
var float SpectatorStamp; //Only set if player changed to spectator after having played
var float LockTime;
var bool bIsSpectator;
var bool bIsPlaying; //If this var is False, then player can't interact with world
var bool bIsABot;
var int OfflineIndex; //Quick link to offline profile; Don't save if ( == -2)

var actor PlayerActor; //We're using this to initialize a player
var pawn PlayerPawn;
var string PlayerCode; //Unique ID code, security of our checks:
//Hardware ID
//Siege Fingerprint
//NexGen ID
//IP Address
//Player name

var bool bIsInitialized;
var ATB_TeamObject OnTeam, LastTeam, WantsTeam;
var float LastCheckup; //Last time i was here

var float UpdateTimer; //I'll move this to native code later

//Utilitary functions, we follow the very foundation of C and C++ at making structures here
native final function BecomeStatic();
native final function BecomeNoDelete();
native final function BecomeNormal();

event PostBeginPlay()
{
	PlayerPawn = Pawn(Owner);
	bIsSpectator = PlayerPawn.IsA('Spectator');

	if ( PlayerPawn.IsA('PlayerPawn') && PlayerPawn(PlayerPawn).Player == none )
		Destroy();
	if ( PlayerPawn.PlayerReplicationInfo.PlayerName == "" || PlayerPawn.PlayerReplicationInfo.PlayerName == "Player" )
		Destroy();
}

function ToTeam( ATB_TeamObject NewTeam)
{
	if ( (NewTeam == none) || (NewTeam == OnTeam) )
		return;

	LastTeam = OnTeam;
	OnTeam = NewTeam;
	if ( WantsTeam == OnTeam )
		WantsTeam = none;
}


function bool IsAuthenticated()
{
	if ( PlayerPawn == none )
		return false;
	//Auth a bot
	if ( !PlayerPawn.IsA('PlayerPawn') )
		return BotAuth();
	if ( ATB.AuthMethod == EID_HWID )
		return ACEAuth();
	if ( ATB.AuthMethod == EID_Name )
	{
		PlayerCode = PlayerPawn.PlayerReplicationInfo.PlayerName;
		return true;
	}
	return true;
}

function bool ACEAuth()
{
	local actor A;
	local string str;

	if ( PlayerActor == none )
		ForEach PlayerPawn.ChildActors(class'Actor',A)
		{
			if ( A.IsA('IACECheck') )
			{
				PlayerActor = A;
				break;
			}
		}

	if ( PlayerActor != none )
	{
		str = PlayerActor.GetPropertyText("HWHash");
		if ( str != "" )
		{
			PlayerCode = xxGetToken( str, ":", 1);
			if ( Len(PlayerCode) < 8 ) //This client couldn't report HWID, get siege fingerprint instead
				PlayerCode = "UNIX>"$ PlayerPawn.PlayerReplicationInfo.GetPropertyText("PlayerFingerPrint");
			if ( PlayerCode == "UNIX>" )
				return false;
			return true;
		}
	}
	return false;
}

function bool BotAuth()
{
	if ( PlayerPawn.IsA('BotZ') )
		PlayerCode = "BOTZ>"$PlayerPawn.PlayerReplicationInfo.PlayerName;
	else
		PlayerCode = "BOT>"$PlayerPawn.PlayerReplicationInfo.PlayerName;
	OfflineIndex = -2; //Do not save
	bIsABot = true;
	return true;
}

//If this actor becomes static, Tick isn't called
event Tick( float Delta)
{
	//This pawn is leaving
	if ( PlayerPawn == none || PlayerPawn.bDeleteMe )
	{
		ATB.PlayerLeft( self);
		PlayerPawn = none;
		bIsPlaying = false;
		bIsInitialized = false;
		LastCheckup = Level.TimeSeconds;
		RemoveFromTeam();
		BecomeStatic(); //Static actor doesn't Tick
		return;
	}

	//Initialize this pawn
	if ( !bIsInitialized )
	{
		if ( (FRand() < 0.3) && IsAuthenticated() ) //Don't check every frame, may be expensive
		{
			bIsInitialized = true;
			//Lookup player strength database
			ATB.PlayerAuthed( self);
			if ( !bDeleteMe )
				BecomeNoDelete(); //If i'm about to be deleted, it's because there's an old profile with this player's data
		}
		return;
	}

	if ( !bIsPlaying || !ATB.bMatchStarted || bIsSpectator )
		return;

	if ( LockTime > 0 )
		LockTime -= Delta/Level.TimeDilation;

	if ( (UpdateTimer += (Delta/Level.TimeDilation)) > 1 )
		UpdateStats();
}

function UpdateStats()
{
	PlaySeconds++;
	UpdateTimer -= 1;

	//Update player name if changed
	if ( PlayerPawn.PlayerReplicationInfo.PlayerName != PlayerName )
	{
		ATB.BroadcastGlobal( PlayerName$" is now aliasing as "$PlayerPawn.PlayerReplicationInfo.PlayerName);
		PlayerName = PlayerPawn.PlayerReplicationInfo.PlayerName;
	}

	if ( OnTeam != none )
	{
		SecondsInTeam++;
		if ( (OnTeam.TeamColor != PlayerPawn.PlayerReplicationInfo.Team) && (OnTeam.TeamColor < 100) )
		{
			ATB.Debug("FORCE TEAM CHANGE ON"$PlayerPawn@ self @"to"@OnTeam.TeamColor);
			ATB.ChangeTeam( PlayerPawn, OnTeam.TeamColor);
		}
	}
	PScore = PlayerPawn.PlayerReplicationInfo.Score;
	ATB.CalcStrengthFor( self);
}

/* THIS SNIPPET CALLS THE ACTOR'S TICK!!!!!!!!!!!!!!
 * Function: Tick
UBOOL AATB_PlayerProfile::Tick(FLOAT T, ELevelTick TickType)
{
	UpdateTimers(T);

	if (TickType != LEVELTICK_ViewportsOnly)
	{
		if (bDeleteMe)
			return 1;
	}

	return Super::Tick(T, TickType);
}
*/

function RemoveFromTeam()
{
	if ( OnTeam != none )
	{
		LastTeam = OnTeam;
		OnTeam.RemovePlayer( self);
		OnTeam = none;
	}
}

//Removing code dependancy for ACE modules
static function string xxGetToken(string zzString, string zzDelimiter, int zzToken)
{
    local int zzI;

    zzString = zzString$zzDelimiter;

    for (zzI = 0; zzI < zzToken; ++zzI)
    {
        if (InStr(zzString, zzDelimiter) != -1)
            zzString = Mid(zzString,InStr(zzString,zzDelimiter)+Len(zzDelimiter));
    }

    if (InStr(zzString,zzDelimiter) != -1)
        return Left(zzString,InStr(zzString,zzDelimiter));
    else
        return zzString;
}

defaultproperties
{
	bGameRelevant=True
	bHidden=True
}
