// Includes.
#include "CacusTeamBalancer.h"

#define NAMES_ONLY
#define AUTOGENERATE_NAME(name) CACUSTEAMBALANCER_API FName CACUSTEAMBALANCER_##name;
#define AUTOGENERATE_FUNCTION(cls,idx,name) IMPLEMENT_FUNCTION(cls,idx,name)
#include "CacusTeamBalancerClasses.h"
#undef AUTOGENERATE_FUNCTION
#undef AUTOGENERATE_NAME
#undef NAMES_ONLY
void RegisterNames()
{
	static INT Registered=0;
	if(!Registered++)
	{
		#define NAMES_ONLY
		#define AUTOGENERATE_NAME(name) extern CACUSTEAMBALANCER_API FName CACUSTEAMBALANCER_##name; CACUSTEAMBALANCER_##name=FName(TEXT(#name),FNAME_Intrinsic);
		#define AUTOGENERATE_FUNCTION(cls,idx,name)
		#include "CacusTeamBalancerClasses.h"
		#undef DECLARE_NAME
		#undef NAMES_ONLY
	}
}

// Package implementation.
IMPLEMENT_PACKAGE(CacusTeamBalancer);

void AAdvancedTeamBalancer::execLoadProfiles(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execLoadProfiles);
	P_FINISH;

	FArchive* Src = GFileManager->CreateFileReader( *StatsFile );
	if ( Src )
	{
		int iVersion = 0;
		*Src << iVersion;
		if ( iVersion == 1 ) //Different versions
		{
			for ( int i=0 ; i<1024 ; i++ )
				*Src << Prof[i];
		}
		Src->Close();
		delete Src;
		*(UBOOL*)Result = true;
	}
	else
		*(UBOOL*)Result = false;

	unguard;
}

void AAdvancedTeamBalancer::execSaveProfiles(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execSaveProfiles);
	P_FINISH;

	FArchive* Src = GFileManager->CreateFileWriter( *StatsFile, (true?0:FILEWRITE_NoReplaceExisting) | (true?FILEWRITE_EvenIfReadOnly:0) );
	if ( Src )
	{
		int iVersion = 1;
		*Src << iVersion;
		//Version 1 binary
		for ( int i=0 ; i<1024 ; i++ )
			*Src << Prof[i];
		Src->Close();
		delete Src;
		*(UBOOL*)Result = true;
	}
	else
		*(UBOOL*)Result = false;
	unguard;
}

void AAdvancedTeamBalancer::execFindByPlayer(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execFindByPlayer);
	P_GET_STRUCT_REF(TArray<class AATB_PlayerProfile*>,Arr);
	P_GET_OBJECT( APawn, P);
	P_FINISH;

	if ( Arr && P )
	{
		int i = 0;
		while ( i < Arr->Num() )
		{
			if ( (*Arr)(i)->PlayerPawn == P )
			{
				*(AATB_PlayerProfile**)Result = (*Arr)(i);
				break;
			}
			i++;
		}
	}
	unguard;
}

void AAdvancedTeamBalancer::execFindOffline(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execFindOffline);
	P_GET_OBJECT(AATB_PlayerProfile, aP);
	P_FINISH;

	*(UBOOL*)Result = false;
	if ( aP )
	{
		int i=0;
		while ( i<ProfileCount )
		{
			if ( Prof[i].PCode == aP->PlayerCode )
			{
				aP->OfflineIndex = i;
				Prof[i].CalcStrength( &(aP->OldSStrength), &(aP->OldKStrength));
				*(UBOOL*)Result = true;
				break;
			}
			i++;
		}
	}
	unguard;
}

//native final function AddProfileTo( out array<ATB_PlayerProfile> TArray, ATB_PlayerProfile AddThis);
void AAdvancedTeamBalancer::execAddProfileTo(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execAddProfileTo);
	P_GET_STRUCT_REF(TArray<class AATB_PlayerProfile*>,Arr);
	P_GET_OBJECT( AATB_PlayerProfile, AddThis);
	P_FINISH;
	Arr->AddUniqueItem(AddThis);
	unguard;
}

void AAdvancedTeamBalancer::execArrayGet(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execArrayGet);
	P_GET_STRUCT_REF(TArray<class UObject*>, Arr);
	P_GET_INT(Idx);
	P_FINISH;
	if ( Arr && Idx >= 0 && Idx < Arr->Num() )
		*(UObject**)Result = (*Arr)(Idx);
	unguard;
}
void AAdvancedTeamBalancer::execArrayNum(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execArrayNum);
	P_GET_STRUCT_REF(TArray<class UObject*>, Arr);
	P_FINISH;
	int i = 0;
	if ( Arr )
		i = Arr->Num();
	*(INT*)Result = i;
	unguard;
}
void AAdvancedTeamBalancer::execArrayRemove(FFrame &Stack, RESULT_DECL)
{
	guard(AAdvancedTeamBalancer::execArrayRemove);
	P_GET_STRUCT_REF(TArray<UObject*>, Arr);
	P_GET_INT(Idx);
	P_FINISH;
	if ( Idx >= 0 && Idx < Arr->Num() )
		Arr->Remove(Idx,1);
	unguard;
}

void AAdvancedTeamBalancer::execPushStrengths(FFrame &Stack, RESULT_DECL)
{
//	guard(AAdvancedTeamBalancer::execPushStrengths); //Guards removed, this function must be called super fast
	P_GET_INT(Idx);
	P_FINISH;
	Prof[Idx].PushUp();
//	unguard;
}

//AActor* SpawnActor( UClass* Class, FName InName=NAME_None, AActor* Owner=NULL, class APawn* Instigator=NULL, FVector Location=FVector(0,0,0), FRotator Rotation=FRotator(0,0,0), AActor* Template=NULL, UBOOL bNoCollisionFail=0, UBOOL bRemoteOwned=0 );
//Deprecating unrealscript code
void AAdvancedTeamBalancer::DetectNewPlayers()
{
	guard(AAdvancedTeamBalancer::execDetectNewPlayers);
	if ( Level->Game->CurrentID > HighestID )
	{
		APawn *P = Level->PawnList;
		while ( P )
		{
			if ( P->PlayerReplicationInfo  )
			{
				if ( P->PlayerReplicationInfo->PlayerID >= HighestID )
				{
					AATB_PlayerProfile *PP = (AATB_PlayerProfile*) XLevel->SpawnActor( AATB_PlayerProfile::StaticClass(), NAME_None, P, P);
					if ( PP ) //Fix to prevent potential crash
						PP->ATB = this;
				}
				else
					P = NULL;
			}
			if ( P )
				P = P->nextPawn;
		}
		HighestID = Level->Game->CurrentID;
	}
	unguard;
}

UBOOL AAdvancedTeamBalancer::Tick(FLOAT T, ELevelTick TickType)
{
	if ( !bDeleteMe )
	{
		DetectNewPlayers();
	}

	return Super::Tick(T, TickType);
}


//=====================
// Simple natives on the profiles

void AATB_PlayerProfile::execBecomeNormal(FFrame &Stack, RESULT_DECL)
{
	P_FINISH;
	bStatic = false;
	bNoDelete = false;
}
void AATB_PlayerProfile::execBecomeNoDelete(FFrame &Stack, RESULT_DECL)
{
	P_FINISH;
	bStatic = false;
	bNoDelete = true;
}
void AATB_PlayerProfile::execBecomeStatic(FFrame &Stack, RESULT_DECL)
{
	P_FINISH;
	bStatic = true;
	bNoDelete = false;
}


//=====================
// Interface handler

void UCTB_ServerInterfaceComp::execI_DelPlayer(FFrame &Stack, RESULT_DECL)
{
	P_GET_INT(Idx);
	P_FINISH;
	
	UFunction* Func = Interface->FindFunction( Native_DelPlayer);
	if (Func)
		ProcessEvent(Func,&Idx);
}

void UCTB_ServerInterfaceComp::execI_Str(FFrame &Stack, RESULT_DECL)
{
	FLOAT Str[2];
	Stack.Step( Stack.Object, &Str[0] );
	Stack.Step( Stack.Object, &Str[1] );
//	P_GET_FLOAT(Str[2]);
	P_FINISH;
	
	UFunction* Func = Interface->FindFunction( Native_Str);
	if (Func)
		ProcessEvent(Func,&Str);
}

void UCTB_ServerInterfaceComp::execI_Player(FFrame &Stack, RESULT_DECL)
{
	P_GET_STRUCT( ExtPlayerParam, Parms);
	P_FINISH;

	UFunction* Func = Interface->FindFunction( Native_Player);
	if (Func)
		ProcessEvent(Func,&Parms);
}

/*
	if (Func)
	{
		void *funcParms = appAlloca(Func->ParmsSize);
		appMemzero(funcParms, Func->ParmsSize);
		ProcessEvent(Func,funcParms);
	}

*/


IMPLEMENT_CLASS(AAdvancedTeamBalancer);
IMPLEMENT_CLASS(AATB_PlayerProfile);
IMPLEMENT_CLASS(UCTB_ServerInterfaceComp);
