struct ExtPlayerParam
{
	int idx;
	FString PName;
	float KS, SS;
	BYTE Team;
	float aLock;
	float aTTime;
};

class CACUSTEAMBALANCER_API FStoredProfile_V1
{
	public:

	FString PCode;
	float SStr[16]; //Score strength
	float KStr[16]; //Kill strength
	int LastHere; //Matches since player was last seen here

	FStoredProfile_V1() {}

	void PushUp()
	{
		for ( int i=14 ; i>=0 ; i-- )
		{
			SStr[i+1] = SStr[i];
			KStr[i+1] = KStr[i];
		}
		SStr[0] = 0;
		KStr[0] = 0;
	}

	void CalcStrength( float *S, float *K)
	{
		if ( SStr[0] <= 0 || KStr[0] <= 0) //Safety
		{
			S = 0;
			K = 0;
		}
		else
		{
			float SumS = 0;
			float SumK = 0;
			for ( int i=0 ; i<16 ; i++ )
			{
				if ( SStr[0] <= 0 && KStr[0] <= 0)
				{
					*S = SumS / (float)i;
					*K = SumK / (float)i;
					return;
				}
				SumS += SStr[i];
				SumK += KStr[i];
			}
		}
	}

	// Serializer.
	friend FArchive& operator<<( FArchive& Ar, FStoredProfile_V1& R )
	{
		Ar << R.PCode;
		for ( int i=0 ; i<16 ; i++ )
			Ar << R.SStr[i] << R.KStr[i];
		return Ar << R.LastHere;
	}
};

class CACUSTEAMBALANCER_API FStoredProfile_V2
{
	public:

	FString PCode;
	BYTE Count; //Optimize!
	float SStr[16]; //Score strength
	float KStr[16]; //Kill strength
	int LastHere; //Matches since player was last seen here

	FStoredProfile_V2() {}

	void PushUp()
	{
		for ( int i=14 ; i>=0 ; i-- )
		{
			SStr[i+1] = SStr[i];
			KStr[i+1] = KStr[i];
		}
		SStr[0] = 0;
		KStr[0] = 0;
		if ( Count < 16 )
			Count++;
	}

	void CalcStrength( float *S, float *K)
	{
		if ( SStr[0] <= 0 || KStr[0] <= 0) //Safety
		{
			*S = 0;
			*K = 0;
		}
		else
		{
			float SumS = 0;
			float SumK = 0;
			int i = 0;
			for ( i=0 ; i<Count ; i++ )
			{
				SumS += SStr[i];
				SumK += KStr[i];
			}
			*S = SumS / (float)i;
			*K = SumK / (float)i;
		}
	}

	// Serializer.
	friend FArchive& operator<<( FArchive& Ar, FStoredProfile_V2& R )
	{
		Ar << R.PCode;
		Ar << R.Count;
		for ( int i=0 ; i<R.Count ; i++ )
			Ar << R.SStr[i] << R.KStr[i];
		return Ar << R.LastHere;
	}
};