class UdpServerUplinkX extends UdpLink
	config(Uplink);

struct settingst{
	var string MasterServerAddress;
	var int MasterServerPort;
	var IpAddr MasterServerIpAddr;
	var bool special;
	var bool dontresolve;
	var string IpAddress;
};

var config settingst MasterServers[10];


var config int UpdateMinutes;
var name TargetQueryName;
var config int Region;
var config bool DoUplink;
var string HeartbeatMessage;
var UdpServerQuery QueryAct;
var int	CurrentQueryNum;

var config int QueryPort;
var string GameName;
var config int debuglevel;

// Initialize.
function PreBeginPlay()
{
	local UplinkResolver Resolver;
	local int i;
	local int UplinkPort;
	if( !DoUplink ) { Log(self$" DoUplink is not set.  Not connecting to Master Server."); return; }
	if( Level.NetMode == NM_ListenServer ) { Log(self$" This is a Listen server.  Not connecting to Master Server."); return; }
	//Find a the server query handler.
	foreach AllActors(class'UdpServerQuery', QueryAct, TargetQueryName) { break; }
	if (QueryAct == None)
	{
		Log(self$" UdpServerUplink: Could not find a UdpServerQuery object, using override QueryPort setting");
		if (QueryPort == 0) { QueryPort = 7778; saveconfig(); }
	}
	else { QueryPort = QueryAct.Port; /*QueryAct = None;*/ }

	GameName = "ut";
	HeartbeatMessage = "\\heartbeat\\"$QueryPort$"\\gamename\\"$GameName;

	//set up the settings

	for (i=0;i < 10;i++)
	{
		if ((MasterServers[i].MasterServerAddress == "") && (MasterServers[i].dontresolve == False)) { break; }
		if (MasterServers[i].dontresolve == True)
		{
			StringToIpAddr(MasterServers[i].IpAddress,MasterServers[i].MasterServerIpAddr);
			MasterServers[i].MasterServerIpAddr.Port = MasterServers[i].MasterServerPort; 
		}
		else
		{ 
			Resolver = spawn(class'UplinkResolver',self);
			Resolver.N = i;
			Resolver.Resolve(MasterServers[i].MasterServerAddress);
			MasterServers[i].MasterServerIpAddr.Port = MasterServers[i].MasterServerPort;
		}
	}
	// Bind the local port. we require this?
	UplinkPort = (QueryPort+1);
	if( BindPort(UplinkPort, true) == 0 )
	{
		Log( "UdpServerUplink: Error binding port, aborting." );
		return;
	}
	Log("UdpServerUplink: Port "$UplinkPort$" successfully bound.");

	super.PreBeginPlay();
}
function string getvar(string type,int number)
{
	switch (caps(type))
	{
		case ("NAME"): return MasterServers[number].MasterServerAddress; break;
		case ("PORT"): return string(MasterServers[number].MasterServerPort);
	}
}
function string setvar(string type,int number,string type2, IpAddr address)
{
	switch (caps(type))
	{
		case ("MasterServerIpAddr"): 
		switch (caps(type2))
		{
			case ("ADDR"): MasterServers[number].MasterServerIpAddr.addr = address.Addr;
		}
	}
}

/* states:
1, 10 seconds to resolve addresses (linux limit 3 threads)
2, SetTimer(UpdateMinutes * 60, true); */

auto state state1
{
	function Timer()
	{
		GotoState( 'state2' );
	}
	// The "Begin" label.
	Begin:
	Log(self$" Beginning State1");
	settimer(10,false);
}

state state2
{
	// Notify the MasterServer we exist.
	function Timer()
	{
		local int i;
		local bool Result;
		for (i=0;i < 10;i++)
		{
			if ((MasterServers[i].MasterServerAddress == "") && (MasterServers[i].dontresolve == False)) { break; }
			else if (MasterServers[i].special == True) { Result = SendText(MasterServers[i].MasterServerIpAddr,HeartbeatMessage$"\\gamever\\"$Level.EngineVersion); }
			else { Result = SendText(MasterServers[i].MasterServerIpAddr,HeartbeatMessage); }
			if ( !Result ) { log(self$" Failed to send heartbeat to master server "$MasterServers[i].MasterServerAddress); }
			//else { log(self$" Sent uplink to "$MasterServers[i].MasterServerAddress); }
		}

	}
	Begin:
	Timer();
	SetTimer(UpdateMinutes * 60, true);
	Log(self$" Beginning State2");
}

/* Stop the uplink. where is this called from?
function Halt()
{
	SetTimer(0.0, false);
}
*/

event ReceivedText( IpAddr Addr, string Text )
{
	local string Query;
	local bool QueryRemaining;
	local int  QueryNum, PacketNum;

	// Assign this packet a unique value from 1 to 100
	CurrentQueryNum++;
	if (CurrentQueryNum > 100)
		CurrentQueryNum = 1;
	QueryNum = CurrentQueryNum;
	//log("recieved "$Text);
	Query = Text;
	if (Query == "")		// If the string is empty, don't parse it
		QueryRemaining = false;
	else
		QueryRemaining = true;
	
	while (QueryRemaining) {
		Query = ParseQuery(Addr, Query, QueryNum, PacketNum);
		if (Query == "")
			QueryRemaining = false;
		else
			QueryRemaining = true;
	}
}

function bool ParseNextQuery( string Query, out string QueryType, out string QueryValue, out string QueryRest, out string FinalPacket )
{
	local string TempQuery;
	local int ClosingSlash;

	if (Query == "")
		return false;

	// Query should be:
	//   \[type]\<value>
	if (Left(Query, 1) == "\\")
	{
		// Check to see if closed.
		ClosingSlash = InStr(Right(Query, Len(Query)-1), "\\");
		if (ClosingSlash == 0)
			return false;

		TempQuery = Query;

		// Query looks like:
		//  \[type]\
		QueryType = Right(Query, Len(Query)-1);
		QueryType = Left(QueryType, ClosingSlash);

		QueryRest = Right(Query, Len(Query) - (Len(QueryType) + 2));

		if ((QueryRest == "") || (Len(QueryRest) == 1))
		{
			FinalPacket = "final";
			return true;
		} else if (Left(QueryRest, 1) == "\\")
			return true;	// \type\\

		// Query looks like:
		//  \type\value
		ClosingSlash = InStr(QueryRest, "\\");
		if (ClosingSlash >= 0)
			QueryValue = Left(QueryRest, ClosingSlash);
		else
			QueryValue = QueryRest;

		QueryRest = Right(Query, Len(Query) - (Len(QueryType) + Len(QueryValue) + 3));
		if (QueryRest == "")
		{
			FinalPacket = "final";
			return true;
		} else
			return true;
	} 
	else 
	{
		return false;
	}
}

function string ParseQuery( IpAddr Addr, coerce string QueryStr, int QueryNum, out int PacketNum )
{
	local string QueryType, QueryValue, QueryRest, ValidationString;
	local bool Result;
	local string FinalPacket;
	//log("parsing "$querytype);
	//log("two "$querystr);
	Result = ParseNextQuery(QueryStr, QueryType, QueryValue, QueryRest, FinalPacket);
	if( !Result )
		return "";

	if( QueryType=="basic" )
	{
		// Ignore.
		Result = true;
	}
	else if( QueryType=="secure" )
	{
		//log("validate");
		QueryValue = left(QueryValue,6);
		ValidationString = "\\validate\\"$Validate(QueryValue, QueryAct.GameName);
		Result = SendQueryPacket(Addr, ValidationString, QueryNum, ++PacketNum, FinalPacket);
	}
	return QueryRest;
}

// SendQueryPacket is a wrapper for SendText that allows for packet numbering.
function bool SendQueryPacket(IpAddr Addr, coerce string SendString, int QueryNum, int PacketNum, string FinalPacket)
{
	local bool Result;
	//log("sending to "$string(addr.addr)$" string: "$sendstring);
	if (FinalPacket == "final") {
		SendString = SendString$"\\final\\";
	}
	SendString = SendString$"\\queryid\\"$QueryNum$"."$PacketNum;

	Result = SendText(Addr, SendString);

	return Result;
}

defaultproperties
{
	//requires extra info from server
	MasterServers(0)=(MasterServerAddress="unreal.epicgames.com",MasterServerPort=27900,special=True)
	MasterServers(1)=(MasterServerAddress="master.telefragged.com",MasterServerPort=27500)
	MasterServers(2)=(MasterServerAddress="master.333networks.com",MasterServerPort=27900,dontresolve=True,IpAddr="84.83.176.234")
	MasterServers(3)=(MasterServerAddress="utmaster.epicgames.com",MasterServerPort=27900)
	//bindport override?
	//UplinkPort=7779
	DoUplink=True
	UpdateMinutes=1
	TargetQueryName=MasterUplink
	RemoteRole=ROLE_None
	debuglevel=2
}
