class VAServer extends Mutator;

var string nextoptions;
var string MenuName;
var string RevertVoice;

//$ADD B5
var bool bLogJoinRequest;

final simulated function nlog (optional coerce string S)
{
  if (  !Class'VASettings'.Default.bShowNoticeLog )
  {
    return;
  }
  Log(S,Class.Name);
}

final simulated function wlog (optional coerce string S)
{
  Log(S,Class.Name);
}

function PreBeginPlay ()
{
  Spawn(Class'NN_DemoRecSN');
  Spawn(Class'DummyRI');    
}

function ModifyPlayer (Pawn Other)
{
  Super.ModifyPlayer(Other);   
}

function PostBeginPlay ()
{
  local string Pound; 

  Class'VASettings'.static.staticsaveconfig();
    
  Pound = "_______________________________";
  nlog(Pound);
  nlog("    # Build  #    ##");
  nlog("     #      #    #  #");
  nlog("      #    #    ######");
  nlog("       #  #    #      #");
  nlog("        ##    #   1.1  #");
  nlog(Pound);
  nlog("#     VALHALLA AVATAR 1.1     #");
  if ( Level.NetMode != 1 )
  {
    wlog("#    ERROR: Only for use      #");
    wlog("#   on DEDICATED SERVERS!     #");
    Destroy();
  } else {
    nlog("#    Success: Initialized!    #");
  }
  if ( bDeleteMe )
  {
    return;
  }
  nlog("Client can force Skins:" @ string(Class'VASettings'.Default.AllowClientForceDefault));
  nlog("Default player:" @ Class'VASettings'.Default.DefaultPlayer);
  nlog("Gesture interval:" @ string(Class'VASettings'.Default.gesturetime));
  if ( Class'VASettings'.Default.MeshSkinAllowChange == 0 )
  {
    nlog("Mesh and skin in-game changing disabled!");
  } else {
    if ( Class'VASettings'.Default.MeshSkinAllowChange == 1 )
    {
      nlog("skin in-game changing enabled, but mesh changing is disabled!");
    } else {
      nlog("Mesh and skin in-game changing enabled!");
    }
  }
  nlog(Pound);
  NextMutator = Level.Game.BaseMutator.NextMutator;
  Level.Game.BaseMutator.NextMutator = self;
  Spawn(Class'ShieldNotify');
  
  bLogJoinRequest = FoundDevNet() && Class'VASettings'.Default.bLogJoinRequest;
}

function bool FoundDevNet()
{
  local String strSuppress;
  strSuppress = Caps(ConsoleCommand("GET Core.System Suppress"));
  
  if( instr(strSuppress,"DEVNET,") >= 0 || instr(strSuppress,"DEVNET)") >= 0 )
    return true;
    
  return false;
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
  
  if(bLogJoinRequest)
    log("Join request -> "@Options);
    
  //$ADDED B5; Security check for Skins, faces and voice packs.
  CheckLogin(Options);
  
  nextoptions = Options;  
  
  if ( Class'VASettings'.Default.bDoNotLoadSMVServerSide )
  {
    FixOptions(Options,"Class","Botpack.TMale2");
    FixOptions(Options,"skin","SoldierSkins.blkt");
    FixOptions(Options,"Face","SoldierSkins.Othello");
    FixOptions(Options,"Voice","BotPack.VoiceMaleTwo");
  }
    
  if ( NextMutator != None )
  {
    NextMutator.ModifyLogin(SpawnClass,Portal,Options);
  }
  RevertVoice = SpawnClass.Default.VoiceType;
  if (  !ClassIsChildOf(SpawnClass,Class'Spectator') )
  {
    SpawnClass = Class'ALplayer';
  }
}

function CheckLogin(out String Options)
{
  local String Skin,Face,Voice;
  local int i;
  
  Skin  = Level.Game.ParseOption(Options,"Skin");
  Face  = Level.Game.ParseOption(Options,"Face");
  Voice = Level.Game.ParseOption(Options,"Voice");
  
  if(Skin != "")
  {
    for(i = 0; i < ArrayCount(Class'VASettings'.default.BadSkins); i++)
    {
        if(Caps(Skin) == Caps(Class'VASettings'.default.BadSkins[i]))
        {
            if(Class'VASettings'.default.bLogBadLogins)
            {
              log("-----------------------------------------------------------");
              log("[VA] Illegal skin found during initial check.");
              log("[VA] Player:"@ Level.Game.ParseOption(Options,"Name"));
              log("[VA] *Skin :"@ Skin);
              log("[VA] Face  :"@ Face);
              log("-----------------------------------------------------------");
            }
            FixOptions(Options,"Skin","");
            FixOptions(Options,"Face","");
            break;
        }
    }
  }
  
  if(Face != "")
  {
    for(i = 0; i < ArrayCount(Class'VASettings'.default.BadFaces); i++)
    {
        if(Caps(Face) == Caps(Class'VASettings'.default.BadFaces[i]))
        {
            if(Class'VASettings'.default.bLogBadLogins)
            {
              log("-----------------------------------------------------------");
              log("[VA] Illegal face texture found during initial check.");
              log("[VA] Player:"@ Level.Game.ParseOption(Options,"Name"));
              log("[VA] Skin  :"@ Skin);
              log("[VA] *Face :"@ Face);
              log("-----------------------------------------------------------");
            }
            FixOptions(Options,"Face","");            
            break;
        }
    }
  }  
  
  if(Voice != "")
  {
    for(i = 0; i < ArrayCount(Class'VASettings'.default.BadVoices); i++)
    {
        if(Caps(Voice) == Caps(Class'VASettings'.default.BadVoices[i]))
        {
            if(Class'VASettings'.default.bLogBadLogins)
            {
              log("-----------------------------------------------------------");
              log("[VA] Illegal voice pack found during initial check.");
              log("[VA] Player:"@ Level.Game.ParseOption(Options,"Name"));
              log("[VA] *Voice:"@ Voice);
              log("-----------------------------------------------------------");
            }
            FixOptions(Options,"Voice","");
            break;
        }
    }
  }    
}

final function FixOptions (out string Options, string Key, string Value)
{
  local string L;
  local string R;
  local string PName;
  local int pos;

  pos = InStr(Caps(Options),"?" $ Caps(Key) $ "=");
  if ( pos == -1 )
  {
    return;
  }
  L = Options;
  L = Left(L,pos);
  R = Options;
  R = Mid(R,pos + 2 + Len(Key));
  pos = InStr(R,"?");
  PName = Left(R,pos);
  R = Mid(R,pos);
  Options = L $ "?" $ Key $ "=" $ Value $ R;
}

function bool CheckReplacement (Actor thing, out byte i)
{
  local Class<VoicePack> vpclass;
  local PlayerReplicationInfo PRI;
  local ALPRI APRI;
  local int x;

  if ( ALplayer(thing) != None )
  {
    Spawn(Class'ALPRI',thing);
    /*Server -> Client; Sending Data
    */
    ALplayer(thing).bServerForcedSkin       = Class'VASettings'.Default.bForceServerDefaultPlayer;
    ALplayer(thing).ServerDefaultSkin       = Class'VASettings'.Default.DefaultPlayer;
    ALplayer(thing).AllowClientForceDefault = Class'VASettings'.Default.AllowClientForceDefault;
    
    for(x = 0; x < ArrayCount(ALplayer(thing).AllowedClientDefaultSkins); x++)
    {
      if(class'VASettings'.Default.AllowedClientForcedSkins[x] != "")
        ALplayer(thing).AllowedClientDefaultSkins[x] = class'VASettings'.Default.AllowedClientForcedSkins[x];
    }
  }
  if ( (PlayerReplicationInfo(thing) != None) && (ALplayer(thing.Owner) != None) && (Class'ALPRI'.static.GetALPRI(thing) != None) )
  {
    PRI = PlayerReplicationInfo(thing);
    Class'ALPRI'.static.GetALPRI(thing).PRI = PRI;
    Class'ALPRI'.static.GetALPRI(thing).zzVoicestring = Level.Game.ParseOption(nextoptions,"Voice");    
    Class'ALPRI'.static.GetALPRI(thing).zzClassString = xxclasscheck(Level.Game.ParseOption(nextoptions,"Class"));
    Class'ALPRI'.static.GetALPRI(thing).zzskinstring = Level.Game.ParseOption(nextoptions,"Skin");
    Class'ALPRI'.static.GetALPRI(thing).zzfacestring = Level.Game.ParseOption(nextoptions,"Face");
    /*
    log("nextoptions="@nextoptions);
    log("Level.Parse:Voice="@Level.Game.ParseOption(nextoptions,"Voice"));
    log("Level.Parse:Class="@Level.Game.ParseOption(nextoptions,"Class"));
    log("Level.Parse:Skin="@Level.Game.ParseOption(nextoptions,"Skin"));
    log("Level.Parse:Face="@Level.Game.ParseOption(nextoptions,"Face"));
    */
    if ( Class'ALPRI'.static.GetALPRI(thing).zzskinstring == "" )
    {
      Class'ALPRI'.static.GetALPRI(thing).zzskinstring = "None";
    }
    if ( Class'ALPRI'.static.GetALPRI(thing).zzfacestring == "" )
    {
      Class'ALPRI'.static.GetALPRI(thing).zzfacestring = "None";
    }
    
    nlog(PRI.PlayerName @ 
      "Options: Class:" @ Class'ALPRI'.static.GetALPRI(thing).zzClassString 
      @ "SkinClass:" @ Class'ALPRI'.static.GetALPRI(thing).zzskinstring @ "Face:" 
      @ Class'ALPRI'.static.GetALPRI(thing).zzfacestring @ "Voice:" 
      @ Class'ALPRI'.static.GetALPRI(thing).zzVoicestring);
     
     /*   
    if(ValidSkin(Class'ALPRI'.static.GetALPRI(thing).zzClassString))
    {
      if ( ALplayer(thing) != None)
      {
        ALplayer(thing).ValidSkin = true;
      }
    }
      */
    PlayerPawn(thing.Owner).MenuName = MenuName;
    vpclass = Class<VoicePack>(DynamicLoadObject(RevertVoice,Class'Class',True));
    if ( vpclass != None )
    {
      PRI.VoiceType = vpclass;
    }
  }
  return True;
}

function string xxclasscheck (string inclass)
{
  local int i;
  local Class<PlayerPawn> LocalCheck;

  MenuName = "";
  switch (Caps(inclass))
  {
	case "OLDSKOOL.MALEONE":
	case "OLDMODELS.OLDMODELSMALEONE":
	case "UNREAL1MODELS.TMALEONE":
	case "UNREALI.MALEONE":
	inclass="unreali.maleone";
	MenuName="Male 1";
	break;
	case "OLDSKOOL.MALETWO":
	case "OLDMODELS.OLDMODELSMALETWO":
	case "UNREAL1MODELS.TMALETWO":
	case "UNREALI.MALETWO":
	inclass="unreali.maletwo";
	MenuName="Male 2";
	break;
	case "OLDSKOOL.MALETHREE":
	case "OLDMODELS.OLDMODELSMALETHEEE":
	case "UNREAL1MODELS.TMALETHREE":
	case "UNREALI.MALETHREE":
	inclass="unreali.malethree";
	MenuName="Male 3";
	break;
	case "OLDSKOOL.FEMALEONE":
	case "OLDMODELS.OLDMODELSFEMALEONE":
	case "UNREAL1MODELS.TFEMALEONE":
	case "UNREALI.FEMALEONE":
	inclass="unreali.femaleone";
	MenuName="Female 1";
	break;
	case "OLDSKOOL.FEMALETWO":
	case "UNREAL1MODELS.TFEMALETWO":
	case "OLDMODELS.OLDMODELSFEMALETWO":
	case "UNREALI.FEMALETWO":
	inclass="unreali.femaletwo";
	MenuName="Female 2";
	break;
	case "UNREALI.NALIPLAYER":
	case "NALIFIX.TNALI2":
	case "UNREAL1MODELS.TOURNAMENTNALI":
	case "MULTIMESH.TNALI":
	inclass="multimesh.tnali";
	MenuName="Nali";
	break;
	case "OLDSKOOL.SKTROOPER":
	case "OLDMODELS.OLDMODELSSKTROOPER":
	case "UNREAL1MODELS.TOURNAMENTSKTROOPER":
	case "UNREALI.SKAARJPLAYER":
	inclass="unreali.skaarjplayer";
	MenuName="Skaarj Trooper";
	break;
	case "MULTIMESH.TSKAARJ":
	MenuName="Skaarj Hybrid";
	break;
	case "COWFIX.TCOWFIXED":
	case "MULTIMESH.TCOW":
	inclass="multimesh.tcow";
	MenuName="Nali Cow";
	break;
	case "SKELETALCHARSFIX313.WARBOSSFIX313":
	case "SKELETALCHARSFIX313.WARBOSSMFIX313":
	case "SKELETALCHARS.WARBOSS":
	inclass="skeletalchars.warboss";
	MenuName="War Boss";
	break;
	case "SKELETALCHARSFIX313.XANMK2FIX313":
	case "SKELETALCHARSFIX313.XANMK2MFIX313":
	case "SKELETALCHARS.XANMK2":
	inclass="skeletalchars.xanmk2";
	MenuName="Xan Mark ][";
	break;
	case "BOSSFACE.TBOSSFACE":
	inclass="botpack.tboss";
	MenuName="Boss";
	break;
	case "VABETA.ALPLAYER":
	case "":
	inclass=Class'VASettings'.Default.DefaultPlayer;
	break;
	default:
  }
  for(i = 0; i < 64; i++)
  {
    if ( Class'VASettings'.Default.BadClasses[i] ~= inclass )
    {
      MenuName = "";
      inclass = Class'VASettings'.Default.DefaultPlayer;
      break;
    } 
  }
  
  if ( MenuName == "" )
  {
    LocalCheck = Class<PlayerPawn>(DynamicLoadObject(inclass,Class'Class',True));
    if ( LocalCheck != None )
    {
      MenuName = LocalCheck.Default.MenuName;
    } else {
      MenuName = GetItemName(inclass);
    }
  }
  return inclass;
}

function Destroyed ()
{
  local Mutator zzm;

  if ( Level.Game == None )
  {
    return;
  }
  for(zzm = Level.Game.BaseMutator; zzm != None; zzm = zzm.NextMutator)
  {
    if ( zzm.NextMutator == self )
      break;
  }
  zzm.NextMutator = NextMutator;
  NextMutator = None;
}


static function bool ValidSkin(string SkinClass, ALPlayer Player)
{
  local int x;
  local String SkinName, SkinItem, SkinPackage;
  SkinName = SkinClass;
  SkinItem = Mid(SkinName,InStr(SkinName,".") + 1);
  SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem) - 1);

  if(SkinPackage ~= "SoldierSkins" || 
    SkinPackage ~= "SkeletalChars" ||
    SkinPackage ~= "FCommandoSkins" ||
    SkinPackage ~= "MultiMesh" ||
    SkinPackage ~= "CommandoSkins" ||
    SkinPackage ~= "BotPack" ||
    SkinPackage ~= "Unreali")
    return true;
    
    if(Player != None)
    {
      for(x = 0; x < ArrayCount(Player.AllowedClientDefaultSkins); x++)
      {
        if(SkinClass ~= Player.AllowedClientDefaultSkins[x])  
          return true; 
      }
    }
    
    return false;
}

defaultproperties
{
}
