class NN_DemoRecStats extends Info;

var bool bServerSideDemo;
var bool bInitialized;

simulated function Tick (float F)
{
  local NN_DemoOwnerInfo i;

  if ( Owner == None )
  {
    Destroy();
    Default.bServerSideDemo = False;
    return;
  }
  if (  !bInitialized )
  {
    bInitialized = True;
    Disable('Tick');
    if ( Level.NetMode == 3 )
    {
      Default.bServerSideDemo = True;
      foreach Level.ChildActors(Class'NN_DemoOwnerInfo',i)
      {
        i.Destroy();
      }
    }
  }
}

static final simulated function bool SetNNProjectileHidden (Actor A)
{
  local PlayerPawn P;

  if ( (A == None) || Default.bServerSideDemo )
  {
    return False;
  }
  P = PlayerPawn(A.Owner);
  if ( P == None )
  {
    P = PlayerPawn(A.Instigator);
  }
  if ( (P != None) && (Class'NN_ClientSideDemoStats'.static.GetDemoOwner(A) != None) && (P == Class'NN_ClientSideDemoStats'.static.GetDemoOwner(A)) )
  {
    return True;
  }
  if ( (P == None) || (P.Player == None) )
  {
    return False;
  }
  return True;
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
}
