class NN_ClientSideDemoStats extends Info;

var bool bInitialized;

simulated function Tick (float F)
{
  local NN_DemoOwnerInfo i;

  if ( Owner == None )
  {
    Destroy();
    return;
  }
  if ( (Level.NetMode != 3) || bInitialized || Class'NN_DemoRecStats'.Default.bServerSideDemo )
  {
    return;
  }
  if ( Class'NN_ClientSideDemoStats'.static.GetDemoOwner(self) != None )
  {
    return;
  }
  if ( IsDemo(Owner) )
  {
    i = Spawn(Class'NN_DemoOwnerInfo',Level);
    i.DemoOwner = PlayerPawn(Owner);
  }
}

static final simulated function PlayerPawn GetDemoOwner (Actor A)
{
  local NN_DemoOwnerInfo i;

  if ( (A == None) || (A.Level == None) )
  {
    return None;
  }
  foreach A.Level.ChildActors(Class'NN_DemoOwnerInfo',i)
  {
    break;
  }
  if ( i == None )
  {
    return None;
  }
  return i.DemoOwner;
}

final simulated function bool IsDemo (Actor A)
{
  local PlayerPawn P;
  local NN_ClientSideDemoStats OtherStats;

  if ( PlayerPawn(A) == None )
  {
    return False;
  }
  bInitialized = True;
  Disable('Tick');
  if ( A.Level.NetMode == 3 )
  {
    foreach A.AllActors(Class'PlayerPawn',P)
    {
      if ( (P.Player == None) || (P.Player.Actor == None) )
      {
        continue;
      } else {
        if ( Spectator(P) != None )
        {
          foreach P.ChildActors(Class'NN_ClientSideDemoStats',OtherStats)
          {
            return False;
          }
        }
        if ( P != A )
        {
          return True;
        }
      }
    }
  }
  return False;
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
}
