class DPMSPlayerSetupClient extends UTPlayerSetupClient;

function Close (optional bool bByParent)
{
  local int NewTeam;

  NewTeam = int(TeamCombo.GetValue2());
  if ( (NewPlayerClass != None) && (NewPlayerClass.Default.Mesh != GetPlayerOwner().Mesh) )
  {
    ALplayer(GetPlayerOwner()).xxSetMeshClass(string(NewPlayerClass),SkinCombo.GetValue2(),FaceCombo.GetValue2());
  } else {
    if ( NewPlayerClass != None )
    {
      GetPlayerOwner().ServerChangeSkin(SkinCombo.GetValue2(),FaceCombo.GetValue2(),NewTeam);
    }
  }
  if ( GetPlayerOwner().PlayerReplicationInfo.Team != NewTeam )
  {
    GetPlayerOwner().ChangeTeam(NewTeam);
  }
  Super.Close(bByParent);
}

function Created ()
{
  Super.Created();
  if ( Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo) != None )
  {
    NewPlayerClass = Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass;
  }
}

function LoadCurrent ()
{
  local string Voice;
  local string OverrideClassName;
  local Class<PlayerPawn> OverrideClass;
  local string SN;
  local string FN;

  Voice = "";
  NameEdit.SetValue(GetPlayerOwner().PlayerReplicationInfo.PlayerName);
  TeamCombo.SetSelectedIndex(Max(TeamCombo.FindItemIndex2(string(GetPlayerOwner().PlayerReplicationInfo.Team)),0));
  if ( (GetLevel().Game != None) && GetLevel().Game.IsA('UTIntro') || GetPlayerOwner().IsA('Commander') || GetPlayerOwner().IsA('Spectator') )
  {
    SN = GetPlayerOwner().GetDefaultURL("Skin");
    FN = GetPlayerOwner().GetDefaultURL("Face");
    ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex2(GetPlayerOwner().GetDefaultURL("Class"),True),0));
    Voice = GetPlayerOwner().GetDefaultURL("Voice");
  } else {
    if ( ALplayer(GetPlayerOwner()) != None )
    {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex2(string(Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass),True),0));
    } else {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex2(string(GetPlayerOwner().Class),True),0));
    }
    GetPlayerOwner().GetMultiSkin(GetPlayerOwner(),SN,FN);
    if ( (ClassCombo.GetSelectedIndex() == 0) && (ALplayer(GetPlayerOwner()) != None) && (string(Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass) ~= "Unreali.SkaarjPlayer") )
    {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex("Unreal Skaarj Trooper",True),0));
      if ( ClassCombo.GetSelectedIndex() == 0 )
      {
        ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex("Skaarj Trooper",True),0));
      }
    }
    if ( (ClassCombo.GetSelectedIndex() == 0) && (ALplayer(GetPlayerOwner()) != None) )
    {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex(Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass.Default.MenuName,True),0));
    }
    if ( (ClassCombo.GetSelectedIndex() == 0) && (ALplayer(GetPlayerOwner()) != None) )
    {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex("oldmodels.oldmodels" $ GetPlayerOwner().GetItemName(Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass.Default.MenuName),True),0));
    }
    if ( (ClassCombo.GetSelectedIndex() == 0) && (ALplayer(GetPlayerOwner()) != None) )
    {
      ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex("oldskool." $ GetPlayerOwner().GetItemName(Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzMyClass.Default.MenuName),True),0));
    }
  }
  SkinCombo.SetSelectedIndex(Max(SkinCombo.FindItemIndex2(SN,True),0));
  FaceCombo.SetSelectedIndex(Max(FaceCombo.FindItemIndex2(FN,True),0));
  if ( Voice == "" )
  {
    Voice = Class'ALPRI'.static.GetALPRI(GetPlayerOwner().PlayerReplicationInfo).zzVoicestring;
  }
  IterateVoices();
  VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(Voice,True),0));
  OverrideClassName = GetPlayerOwner().GetDefaultURL("OverrideClass");
  if ( OverrideClassName != "" )
  {
    OverrideClass = Class<PlayerPawn>(DynamicLoadObject(OverrideClassName,Class'Class'));
  }
  SpectatorCheck.bChecked = (OverrideClass != None) && ClassIsChildOf(OverrideClass,Class'CHSpectator');
}

function UseSelected ()
{
  if ( Initialized )
  {
    GetPlayerOwner().UpdateURL("Class",ClassCombo.GetValue2(),True);
    GetPlayerOwner().UpdateURL("Skin",SkinCombo.GetValue2(),True);
    GetPlayerOwner().UpdateURL("Face",FaceCombo.GetValue2(),True);
    GetPlayerOwner().UpdateURL("Team",TeamCombo.GetValue2(),True);
  }
  if ( NewPlayerClass.Default.SelectionMesh != "" )
  {
    MeshWindow.SetMeshString(NewPlayerClass.Default.SelectionMesh);
  } else {
    MeshWindow.SetMesh(NewPlayerClass.Default.Mesh);
  }
  MeshWindow.ClearSkins();
  if ( ClassIsChildOf(NewPlayerClass,Class'UnrealIPlayer') )
  {
    Class'ALPRI'.static.SetUnrealISkin(MeshWindow.MeshActor,SkinCombo.GetValue2(),int(TeamCombo.GetValue2()));
  } else {
    NewPlayerClass.static.SetMultiSkin(MeshWindow.MeshActor,SkinCombo.GetValue2(),FaceCombo.GetValue2(),int(TeamCombo.GetValue2()));
  }
}

function LoadClasses ()
{
  local int NumPlayerClasses;
  local string NextPlayer;
  local string NextDesc;
  local bool bHasOSA;

  GetPlayerOwner().GetNextIntDesc("TournamentPlayer",0,NextPlayer,NextDesc);
  while ( NextPlayer != "" )
  {
    ClassCombo.AddItem(NextDesc,NextPlayer,0);
    if ( InStr(NextPlayer,"SkTrooper") != -1 )
      bHasOSA = True;
            
    NumPlayerClasses++;
    GetPlayerOwner().GetNextIntDesc("TournamentPlayer",NumPlayerClasses,NextPlayer,NextDesc);
  }
  
  NumPlayerClasses = 0;
  if (  !bHasOSA )
  {
    GetPlayerOwner().GetNextIntDesc("UnrealIPlayer",0,NextPlayer,NextDesc);
    while ( NextPlayer != "" )
    {
      if(NextDesc != "Spectator")
        ClassCombo.AddItem(NextDesc,NextPlayer,0);
      NumPlayerClasses++;
      GetPlayerOwner().GetNextIntDesc("UnrealIPlayer",NumPlayerClasses,NextPlayer,NextDesc);
    }
  }
  ClassCombo.Sort();
}

function IterateVoices ()
{
  local int NumVoices;
  local string NextVoice;
  local string NextDesc;
  local string VoicePackMetaClass;
  local bool OldInitialized;

  OldInitialized = Initialized;
  Initialized = False;
  VoicePackCombo.Clear();
  Initialized = OldInitialized;
  if ( ClassIsChildOf(NewPlayerClass,Class'TournamentPlayer') )
  {
    VoicePackMetaClass = Class<TournamentPlayer>(NewPlayerClass).Default.VoicePackMetaClass;
  } else {
    if ( NewPlayerClass.Default.bIsFemale )
    {
      VoicePackMetaClass = "BotPack.VoiceFemale";
    } else {
      VoicePackMetaClass = "BotPack.VoiceMale";
    }
  }
  DynamicLoadObject(VoicePackMetaClass,Class'Class');
  GetPlayerOwner().GetNextIntDesc(VoicePackMetaClass,0,NextVoice,NextDesc);
  while ( NextVoice != "" )
  {
    VoicePackCombo.AddItem(NextDesc,NextVoice,0);
    NumVoices++;
    GetPlayerOwner().GetNextIntDesc(VoicePackMetaClass,NumVoices,NextVoice,NextDesc);
  }
  VoicePackCombo.Sort();
}

function IterateSkins ()
{
  local string SkinName;
  local string SkinDesc;
  local string TestName;
  local string temp;
  local string FaceName;
  local int i;
  local bool bNewFormat;

  SkinCombo.Clear();
  if ( ClassIsChildOf(NewPlayerClass,Class'Spectator') )
  {
    SkinCombo.HideWindow();
    return;
  } else {
    SkinCombo.ShowWindow();
  }
  bNewFormat = NewPlayerClass.Default.bIsMultiSkinned;
  SkinName = "None";
  TestName = "";
  while ( True )
  {
    GetPlayerOwner().GetNextSkin(MeshName,SkinName,1,SkinName,SkinDesc);
    if ( SkinName == TestName )
      break; //End Main While Loop
      
    if ( TestName == "" )
      TestName = SkinName;
      
    if (  !bNewFormat )
    {
      temp = GetPlayerOwner().GetItemName(SkinName);
      if ( Left(temp,2) != "T_" )
      {
        if ( SkinDesc == "" )
          SkinCombo.AddItem(temp,SkinName);
        else
          SkinCombo.AddItem(SkinDesc,SkinName);
      }
    } else {
      if ( SkinDesc != "" )
      {
        temp = GetPlayerOwner().GetItemName(SkinName);
        if ( Mid(temp,5,64) == "" )
          SkinCombo.AddItem(SkinDesc,Left(SkinName,Len(SkinName) - Len(temp)) $ Left(temp,4));
      }
    }
  }
  if ( SkinCombo.List.Items.Count() == 0 )
  {
    AddUISkins(MeshName);
  }
  SkinCombo.Sort();
}

function AddUISkins (string Model)
{
  Model = Model $ "Skins";
  switch (Caps(Model))
  {
    case "MALE1SKINS":
    SkinCombo.AddItem("Carter",Model $ ".Carter");
    SkinCombo.AddItem("Gibbed",Model $ ".Male1Gib");
    SkinCombo.AddItem("Kurgan",Model $ ".Kurgan");
    SkinCombo.AddItem("Davies (hidden)",Model $ "UTHiddenUnrealI.Davies");
    SkinCombo.AddItem("Dargan (hidden)",Model $ "UTHiddenUnrealI.Dargan");
    SkinCombo.AddItem("Avatar (hidden)",Model $ "UTHiddenUnrealI.Avatar");
    SkinCombo.AddItem("Boris (hidden)",Model $ "UTHiddenUnrealI.Boris");
    SkinCombo.AddItem("Smith (hidden)",Model $ "UTHiddenUnrealI.Smith");
    SkinCombo.AddItem("Karl (hidden)",Model $ "UTHiddenUnrealI.Karl");
    SkinCombo.AddItem("Curtis (hidden)",Model $ "UTHiddenUnrealI.Curtis");
    break;
    case "MALE2SKINS":
    SkinCombo.AddItem("Ash",Model $ ".Ash");
    SkinCombo.AddItem("Gibbed",Model $ ".Male2Gib");
    SkinCombo.AddItem("Ivan",Model $ ".Ivan");
    SkinCombo.AddItem("Kristoph",Model $ ".Kristoph");
    break;
    case "MALE3SKINS":
    SkinCombo.AddItem("Bane",Model $ ".Bane");
    SkinCombo.AddItem("Dante",Model $ ".Dante");
    SkinCombo.AddItem("Dregor",Model $ ".Dregor");
    SkinCombo.AddItem("Gibbed",Model $ ".Male3Gib");
    SkinCombo.AddItem("Krige",Model $ ".Krige");
    break;
    case "FEMALE1SKINS":
    SkinCombo.AddItem("Drace",Model $ ".Drace");
    SkinCombo.AddItem("Gibbed",Model $ ".FemGib1");
    SkinCombo.AddItem("Gina",Model $ ".Gina");
    SkinCombo.AddItem("Nikita",Model $ ".Nikita");
    SkinCombo.AddItem("Raquel",Model $ ".Raquel");
    SkinCombo.AddItem("Tamika",Model $ ".Tamika");
    break;
    case "FEMALE2SKINS":
    SkinCombo.AddItem("Dimitra",Model $ ".Dimitra");
    SkinCombo.AddItem("Gibbed",Model $ ".Fem2Gib");
    SkinCombo.AddItem("Katryn",Model $ ".Katryn");
    SkinCombo.AddItem("Sonya",Model $ ".Sonya");
    SkinCombo.AddItem("Shiva (hidden)",Model $ "UTHiddenUnrealI.Shiva");
    SkinCombo.AddItem("Cholerae (hidden)",Model $ "UTHiddenUnrealI.Cholerae");
    break;
    case "SKTROOPERSKINS":
    SkinCombo.AddItem("Infantry",Model $ ".T_Skaarj1");
    SkinCombo.AddItem("Officer",Model $ ".T_Skaarj3");
    SkinCombo.AddItem("Sniper",Model $ ".T_Skaarj2");
    break;
    default:
  }
}

function ClassChanged()
{
  Super.ClassChanged();

    if(Initialized)
    {
      ClassChanging = True;
      IterateVoices();
      if(ClassIsChildOf(NewPlayerClass, class'TournamentPlayer'))
      VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class<TournamentPlayer>(NewPlayerClass).default.VoiceType, True), 0));
      else if(ClassIsChildOf(NewPlayerClass, class'MaleTwo'))
      VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class'TMale2'.default.VoiceType, True), 0));
      else if(ClassIsChildOf(NewPlayerClass, class'MaleThree'))
      VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class'TMale2'.default.VoiceType, True), 0));
      else if(ClassIsChildOf(NewPlayerClass, class'FemaleTwo'))
      VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class'TFemale2'.default.VoiceType, True), 0));
      else if(ClassIsChildOf(NewPlayerClass, class'SkaarjPlayer'))
      VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class'ALPlayer'.default.VoiceType, True), 0));
      else
      VoicePackCombo.SetSelectedIndex(0);
      ClassChanging = False;
    }
    VoicePackCombo.ShowWindow();
}

simulated function VoiceChanged ()
{
  local Class<ChallengeVoicePack> VoicePackClass;
  local ChallengeVoicePack V;

  if ( Initialized )
  {
    VoicePackClass = Class<ChallengeVoicePack>(DynamicLoadObject(VoicePackCombo.GetValue2(),Class'Class'));
    if (  !ClassChanging )
    {
      V = GetPlayerOwner().Spawn(VoicePackClass,GetPlayerOwner(),,GetPlayerOwner().Location);
      V.ClientInitialize(GetPlayerOwner().PlayerReplicationInfo,GetPlayerOwner().PlayerReplicationInfo,'ACK',Rand(VoicePackClass.Default.numAcks));
    }
    GetPlayerOwner().UpdateURL("Voice",VoicePackCombo.GetValue2(),True);
    if ( GetPlayerOwner().IsA('TournamentPlayer') )
    {
      TournamentPlayer(GetPlayerOwner()).SetVoice(VoicePackClass);
    }
  }
}

defaultproperties
{
}
