class AMSMeshInfo extends TournamentMaleMeshInfo;

static function PlayDecap (ALplayer Other)
{
  local Carcass carc;
  local Class<UTHeads> carcclass;

  Other.PlayAnim('Dead4',,0.1);
  if (  !Other.HasAnim('HeadIsRemoved') )
  {
    return;
  }
  if ( Other.bIsFemale )
  {
    carcclass = Class'UT_HeadFemale';
  } else {
    carcclass = Class'UT_HeadMale';
  }
  carc = Other.Spawn(carcclass,,,Other.Location + Other.CollisionHeight * vect(0.00,0.00,0.80),Other.Rotation + rot(3000,0,16384));
  if ( carc != None )
  {
    if ( Class'ALPRI'.static.GetALPRI(Other.PlayerReplicationInfo).zzMyClass.Default.CarcassType == Class'TBossCarcass' )
    {
      carc.Mesh = LodMesh'bossheadm';
      carc.DrawScale = 0.16;
    }
    carc.RemoteRole = ROLE_None;
    carc.Initfor(Other);
    carc.Velocity = Other.Velocity + VSize(Other.Velocity) * VRand();
    carc.Velocity.Z = FMax(carc.Velocity.Z,Other.Velocity.Z);
  }
}

defaultproperties
{
}
