class ALPRI extends ReplicationInfo;

var PlayerPawn zzlocalplayer;
var string zzVoicestring;
var string zzskinstring;
var string zzfacestring;
var string zzClassString;
var string zzlastskin;
var string zzlastface;
var string zzlastclass;
var Class<PlayerPawn> zzMyClass;
var byte zzlastteam;
var bool bxxInit;
var bool bxxsetclass;
var string TalkTextureStrBackup;
var bool bAlreadySetSkin;
var PlayerReplicationInfo PRI;
var bool bClientDemoInit;
var VAClientConfig ClientConf;
var bool bLocalPlayer;


replication
{
  unreliable if ( ROLE == ROLE_Authority )
    zzVoicestring,zzskinstring,zzfacestring,zzClassString,PRI;
}

static simulated function ALPRI GetALPRI (Actor A)
{
  local ALPRI APRI;
  local PlayerReplicationInfo P;
  local ALplayer AP;
  local ALPRIArray ALPArray;

  if ( A == None )
    return None;
    
  if ( ALPRI(A) != None )
    return ALPRI(A);
  
  if ( PlayerReplicationInfo(A) != None )
    P = PlayerReplicationInfo(A);
  else 
    if ( ALplayer(A) != None )
      P = ALplayer(A).PlayerReplicationInfo;
      
  foreach A.Level.ChildActors(Class'ALPRIArray',ALPArray)
  {
    break;
  }
  if ( ALPArray == None )
    ALPArray = A.Spawn(Class'ALPRIArray',A.Level);
    
  if ( ALPArray == None || P == None)
    return None;
    
  if ( (ALPArray.PRIArray[P.PlayerID] == P) && (ALPArray.ALPRIArray[P.PlayerID] != None) )
    return ALPArray.ALPRIArray[P.PlayerID];
    
  AP = ALplayer(P.Owner);
  if ( AP == None )
  {
    foreach A.AllActors(Class'ALPRI',APRI)
    {
      if ( APRI.PRI == P )
        break;
    }
  } 
  else 
  {
    foreach AP.ChildActors(Class'ALPRI',APRI)
    {
      break;
    }
  }
  
  if ( APRI == None )
    return None;
    
  ALPArray.ALPRIArray[P.PlayerID] = APRI;
  ALPArray.PRIArray[P.PlayerID] = P;
  return APRI;
}

simulated function Tick (float F)
{
  local PlayerPawn P;
  local int i;

  if ( ROLE == ROLE_Authority )
  {
    if ( Owner == None )
    {
      Destroy();
      return;
    }
  }
  if ( (ROLE == ROLE_Authority) && (Level.NetMode != 0) )
    return;
        
  if ( (zzskinstring != "") && (zzfacestring != "") && (zzClassString != "") )
  {
    if ( xxInit() )
    {
      if ( zzskinstring ~= "None" )
      {
        zzskinstring = "";
      }
      if ( zzfacestring ~= "None" )
      {
        zzfacestring = "";
      }
      if ( Class'NN_ClientSideDemoStats'.static.GetDemoOwner(self) == None )
      {
        Disable('Tick');
      }
      bxxInit = True;
    }
  }
  if (  !bAlreadySetSkin )
  {
    SetSkinTimer();
  }
  if (  !bClientDemoInit && (Class'NN_ClientSideDemoStats'.static.GetDemoOwner(self) != None) )
  {
    if ( zzskinstring == "" )
    {
      zzskinstring = "None";
    }
    if ( zzfacestring == "" )
    {
      zzfacestring = "None";
    }
    if ( (zzskinstring != "") && (zzfacestring != "") && (zzClassString != "") )
    {
      zzlastskin = "";
      zzlastface = "";
      zzlastclass = "";
      if ( xxInit() )
      {
        if ( zzskinstring ~= "None" )
        {
          zzskinstring = "";
        }
        if ( zzfacestring ~= "None" )
        {
          zzfacestring = "";
        }
        if ( bxxsetclass && (zzMyClass != None) && (ALplayer(Owner) != None) && (ALplayer(Owner).PlayerReplicationInfo != None) )
        {
          ALplayer(Owner).Init();
          bClientDemoInit = True;
          bAlreadySetSkin = False;
          Log("bClientDemoInit Done!");
        }
        bxxInit = True;
        Disable('Tick');
      }
    }
    if (  !bAlreadySetSkin )
    {
      SetSkinTimer();
    }
  }
}

simulated function PostBeginPlay ()
{
  xxInit();  
}

simulated event bool xxInit ()
{
  local PlayerPawn zzP;

  if ( (PlayerPawn(Owner) != None) && (Viewport(PlayerPawn(Owner).Player) != None) )
  {
    zzlocalplayer = PlayerPawn(Owner);
  } else {
    foreach AllActors(Class'PlayerPawn',zzP)
    {
      if ( Viewport(zzP.Player) != None )
        zzlocalplayer = zzP;
    }
  }
  if ( Pawn(Owner) != None )
  {
    PRI = Pawn(Owner).PlayerReplicationInfo;
  }
  if ( (PRI == None) || (zzlocalplayer == None) || (zzlocalplayer.PlayerReplicationInfo == None) )
  {
    return False;
  }
  xxsetclass();
  SetSkinTimer();
  return True;
}

simulated function xxsetclass ()
{    
  //$ADDED Ability to force skins, clientside and Serverside.
  if(ClientConf == None)
  {
    ClientConf = new (Class'VAClientConfig','VAClientConfig') Class'VAClientConfig';
    ClientConf.SaveConfig();
  }  
  
  if(PRI != None && zzlocalplayer != None && zzlocalplayer.PlayerReplicationInfo != None)
    bLocalPlayer = (PRI.PlayerName == zzlocalplayer.PlayerReplicationInfo.PlayerName);
  
  if(ALplayer(zzlocalplayer) != None && ALplayer(zzlocalplayer).bServerForcedSkin)
  {
    zzClassString = ALplayer(zzlocalplayer).ServerDefaultSkin;
    zzskinstring = "";
    zzfacestring = "";
    log("Server has forced default skin to:" @ ALplayer(zzlocalplayer).ServerDefaultSkin);        
  }
  else
  {
    if(ClientConf.bForceDefaultSkin && ALplayer(zzlocalplayer).AllowClientForceDefault && !bLocalPlayer)
    {
      //if(ALplayer(zzlocalplayer).ValidSkin)
      if( class'VAServer'.static.ValidSkin(ClientConf.DefaultClientClass,ALplayer(zzlocalplayer)) )
      {
        zzClassString = ClientConf.DefaultClientClass;
        zzskinstring = ClientConf.DefaultClientSkin;
        zzfacestring = ClientConf.DefaultClientFace;
        log("You are forcing default skin to:" @ ClientConf.DefaultClientClass @ 
          "with skin:" @ zzskinstring @ "and face to: "@ zzfacestring);
      }
      else
      {
        log("You are using a default skin (Skinclass=" $ ClientConf.DefaultClientClass $ ") that is not allowed. Ask admins if they can add it.");
        ClientConf.bForceDefaultSkin = False;
        ClientConf.SaveConfig();
      }                      
    }
  }    
  
  if ( zzClassString == "" )
    zzMyClass = None;
  else
    zzMyClass = Class<PlayerPawn>(DynamicLoadObject(zzClassString,Class'Class',true));
    
  if ( zzMyClass == None || zzMyClass.Default.Mesh == None )
  {
    if ( ALplayer(zzlocalplayer) == None)
      zzMyClass = Class<PlayerPawn>(DynamicLoadObject(ALplayer(zzlocalplayer).ServerDefaultSkin,Class'Class',true));
      
    if ( zzMyClass == None || zzMyClass.Default.Mesh == None )
      zzMyClass = Class'TMale1';
      
    zzskinstring = "";
    zzfacestring = "";
  }
     
  Mesh = zzMyClass.Default.Mesh;
  if(PRI != None)
     PRI.Mesh = zzMyClass.Default.Mesh;
  if ( string(zzMyClass) ~= "unreali.skaarjplayer" )
  {
    DrawScale = 0.75;
    PrePivot.Z = -5.0;
  } else {
    DrawScale = Default.DrawScale;
    PrePivot = Default.PrePivot;
  }
  if ( Owner != None )
  {
    Owner.SkelAnim = None;
    if ( ALplayer(Owner).myState != 'PlayerWaiting' && 
         ALplayer(Owner).myState != 'PlayerSpectating' && 
         ALplayer(Owner).myState != 'PlayerShip' )
      Owner.Mesh = Mesh;
      
    Owner.DrawScale = DrawScale;
    Owner.PrePivot = PrePivot;
    ALplayer(Owner).MeshInfo = Class'DPMSMeshInfo';
    ALplayer(Owner).SoundInfo = None;
    Owner.Tick(0.0);
    Owner.AnimEnd();
  }
  
  if(PRI != None)
    PRI.bIsFemale = zzMyClass.Default.bIsFemale;
    
  zzlastclass = zzClassString;
  zzlastskin = "q";
  bxxsetclass = True;
}

simulated event Timer ()
{
  SetSkinTimer();
}

simulated event SetSkinTimer ()
{
  local Class<ChallengeVoicePack> myvp;
  local string zzskinpackage;  

  if ( (ROLE == ROLE_Authority && Level.NetMode != 0) || !bxxInit)
    return;
        
  if ( (TalkTextureStrBackup != "") && (Owner != None) && (Pawn(Owner).PlayerReplicationInfo != None) )
  {
    if ( TalkTextureStrBackup ~= "None" )
      PRI.TalkTexture = None; 
    else
      PRI.TalkTexture = DLO(TalkTextureStrBackup);
    
    TalkTextureStrBackup = "";
  }
  
  if ( zzClassString != zzlastclass )
    xxsetclass();
    
  if ( zzMyClass != None && 
       Owner != None && 
       Owner.Mesh != zzMyClass.Default.Mesh &&  
       !Owner.IsInState('PlayerWaiting') && 
       !Owner.IsInState('PlayerSpectating') &&  
       !Owner.IsInState('PlayerShip') )
    Owner.Mesh = zzMyClass.Default.Mesh;
    
  if ( Owner != None && 
       Owner.Mesh == None &&  
       !Owner.IsInState('PlayerWaiting') &&  
       !Owner.IsInState('PlayerShip') &&  
       !Owner.IsInState('PlayerSpectating') || 
       zzlastskin != zzskinstring || 
       zzlastface != zzfacestring || 
       zzlastteam != PRI.Team )
  {
    Log("Setting skin to" @ zzskinstring @ 
        "and face to" @ zzfacestring @ 
        "with team" @ string(PRI.Team) @ 
        "for" @ PRI.PlayerName);
        
    zzskinpackage = Left(zzskinstring,Len(GetItemName(zzskinstring)));
    if ( (Owner == None || Owner.ROLE == ROLE_SimulatedProxy) && !(Left(string(zzMyClass.Default.Mesh),14) ~= "skeletalchars.") )
    {
      if ( Left(zzskinpackage,Len(GetItemName(string(zzMyClass.Default.Mesh)))) != GetItemName(string(zzMyClass.Default.Mesh)) 
          || Right(zzskinstring,2) == "t_" )
      {
        zzskinstring = "";
        zzfacestring = "";
      }
    }
    zzlastteam = PRI.Team;
    zzlastskin = zzskinstring;
    zzlastface = zzfacestring;
    xxsetupskin();
  }
  
  if(!ClientConf.bUseCustomVoicePacks && !CheckVoice(zzVoicestring))
  {
      if(string(PRI.VoiceType) != "BotPack.VoiceFemaleTwo" && string(PRI.VoiceType) != "BotPack.VoiceMaleTwo")
      {      
        if(PRI.bIsFemale)
          myvp = Class<ChallengeVoicePack>(DynamicLoadObject("BotPack.VoiceFemaleTwo",Class'Class',True));
        else
          myvp = Class<ChallengeVoicePack>(DynamicLoadObject("BotPack.VoiceMaleTwo",Class'Class',True));
         
        if(bLocalPlayer)
        {
          if(ALplayer(zzlocalplayer) != None)
            ALplayer(zzlocalplayer).SetVoice(myvp);
        }
          
        PRI.VoiceType = myvp;              
      }
      return;
  }
  
  
  if ( zzVoicestring != "" && string(PRI.VoiceType) != zzVoicestring)
  {
    myvp = Class<ChallengeVoicePack>(DynamicLoadObject(zzVoicestring,Class'Class',True));
    if ( myvp == None )
      zzVoicestring = "";
    else
      PRI.VoiceType = myvp;
  }
}

function bool CheckVoice(String strVoice)
{
   if(instr(strVoice,"Botpack.") >= 0 || instr(strVoice,"MultiMesh.") >= 0)
    return true;
   
   return false;
}

simulated function xxsetupskin (optional int Tries)
{
  local Texture zzmultiback[8];
  local Texture zzskinback;
  local Texture zztalkback;
  local int zzi;
  local bool bValidSkin;

  TalkTextureStrBackup = "";
  if ( Owner != None )
  {
    Owner.SkelAnim = None;
    Owner.Mesh = zzMyClass.Default.Mesh;
  }
  PRI.Mesh = zzMyClass.Default.Mesh;
  Mesh = zzMyClass.Default.Mesh;
  for(zzi = 0; zzi < 8; zzi++)
  {
    PRI.MultiSkins[zzi] = None;
    MultiSkins[zzi] = None;
    if ( Owner != None )
      Owner.MultiSkins[zzi] = None;
  }
  PRI.Skin = None;
  Skin = None;
  
  if ( Owner != None )
    Owner.Skin = None;
    
  if ( ClassIsChildOf(zzMyClass,Class'UnrealIPlayer') )
  {
    self.SetUnrealISkin(self,zzskinstring,PRI.Team);
  } else
  if ( string(zzMyClass) ~= "multimesh.tnali" )
  {
    setnaliskin();
  } else
  if ( string(zzMyClass) ~= "multimesh.tcow" )
  {
    setcowskin();
  } else
  if ( (string(zzMyClass) ~= "skeletalchars.WarBoss") || (string(zzMyClass) ~= "skeletalchars.XanMK2") )
  {
    setskelskins();
  } else
  if ( string(zzMyClass) ~= "botpack.tboss" )
  {
    SetBossSkins();
  } else 
  {
      if ( Owner != None )
      {
        Owner.Mesh = zzMyClass.Default.Mesh;
        SetMultiSkinFix(Owner,zzskinstring,zzfacestring,PRI.Team,Class<TournamentPlayer>(zzMyClass));
        //log("zzFaceString="@zzfacestring);              
        //Class<TournamentPlayer>(zzMyClass).static.SetMultiSkin(Owner,zzskinstring,zzfacestring,PRI.Team);
        for(zzi = 0; zzi < 8; zzi++)
        {
          PRI.MultiSkins[zzi] = Owner.MultiSkins[zzi];
          MultiSkins[zzi] = Owner.MultiSkins[zzi];
        }
        PRI.Skin = Owner.Skin;
        Skin = Owner.Skin;
        if ( zzskinstring == "" )
          zzMyClass.static.GetMultiSkin(Owner,zzskinstring,zzfacestring);                
      } else 
      {
        for(zzi = 0; zzi < 8; zzi++)
          zzmultiback[zzi] = zzlocalplayer.MultiSkins[zzi];
        
        PRI.Mesh = zzlocalplayer.Mesh;
        Mesh = zzlocalplayer.Mesh;
        zzlocalplayer.Mesh = zzMyClass.Default.Mesh;
        zzskinback = zzlocalplayer.Skin;
        zztalkback = zzlocalplayer.PlayerReplicationInfo.TalkTexture;
        zzMyClass.static.SetMultiSkin(zzlocalplayer,zzskinstring,zzfacestring,PRI.Team);
        
        if ( zzskinstring == "" )
          zzMyClass.static.GetMultiSkin(zzlocalplayer,zzskinstring,zzfacestring);
        
        for(zzi = 0; zzi < 8; zzi++)
        {
          PRI.MultiSkins[zzi] = zzlocalplayer.MultiSkins[zzi];
          MultiSkins[zzi] = zzlocalplayer.MultiSkins[zzi];
          zzlocalplayer.MultiSkins[zzi] = zzmultiback[zzi];
        }
        
        PRI.Skin = zzlocalplayer.Skin;
        Skin = zzlocalplayer.Skin;
        zzlocalplayer.Skin = zzskinback;
        zzlocalplayer.Mesh = Mesh;
        PRI.Mesh = zzMyClass.Default.Mesh;
        Mesh = zzMyClass.Default.Mesh;
        PRI.TalkTexture = zzlocalplayer.PlayerReplicationInfo.TalkTexture;
        PRI.TalkTexture.LODSet = LODSET_None;
        zzlocalplayer.PlayerReplicationInfo.TalkTexture = zztalkback;
      }
  }
  
  if ( Owner != None )
  {
    Owner.SkelAnim = None;
    Owner.Mesh = PRI.Mesh;
    for(zzi = 0; zzi < 8; zzi++)
    {
      Owner.MultiSkins[zzi] = PRI.MultiSkins[zzi];
      if ( PRI.MultiSkins[zzi] != None )
      {
        if(!bValidSkin)
          bValidSkin = True;
                    
        Owner.MultiSkins[zzi].LODSet = LODSET_Skin;
      }
    }
    
    //If it fails load temporary the default one. (Can be changed via VASettings ini)
    if(!bValidSkin)
    {
       if(Tries == 1)
       {
         //If it fails 2 times then load TMale 1
         zzMyClass = Class'TMale1';
       }
       else
       {
         //If it fails the first time load the DefaultPlayer
         zzMyClass = Class<PlayerPawn>(DynamicLoadObject(ALplayer(zzlocalplayer).ServerDefaultSkin,Class'Class',true));
       }
       Mesh = zzMyClass.Default.Mesh;
       PRI.Mesh = zzMyClass.Default.Mesh;
       zzskinstring="";
       zzfacestring="";
       //If nothing can be done well continue as a bad skin.
       if(Tries < 2)
       {
        xxsetupskin(Tries + 1);
        return;
       }
       log("[VA2] Error -> Failed to load a skin for:"@PRI.PlayerName);
    }
    
    Owner.Skin = PRI.Skin;
    if ( ClassIsChildOf(zzMyClass,Class'TournamentPlayer') )
    {
      TournamentPlayer(Owner).StatusDoll = Class<TournamentPlayer>(zzMyClass).Default.StatusDoll;
      TournamentPlayer(Owner).StatusBelt = Class<TournamentPlayer>(zzMyClass).Default.StatusBelt;
    } else 
    {
      if ( PRI.bIsFemale )
      {
        TournamentPlayer(Owner).StatusDoll = Texture'Woman';
        TournamentPlayer(Owner).StatusBelt = Texture'WomanBelt';
      } else {
        TournamentPlayer(Owner).StatusDoll = TournamentPlayer(Owner).Default.StatusDoll;
        TournamentPlayer(Owner).StatusBelt = TournamentPlayer(Owner).Default.StatusBelt;
      }
    }
    Owner.DrawScale = PRI.DrawScale;
    Owner.PrePivot = PRI.PrePivot;
    TournamentPlayer(Owner).bIsFemale = PRI.bIsFemale;
  }
  bAlreadySetSkin = True;
  SetTimer(1.0,True);
}

simulated function SetMultiSkinFix (Actor SkinActor, string SkinName, string FaceName, byte TeamNum, Class<TournamentPlayer> SC)
{
  local string FacePackage;
  local string SkinItem;
  local string FaceItem;
  local string SkinPackage;
  local string TexString;
  local bool bSuccess;

  //Log("Simulated->SetMultiSkinFix");
  SkinName = zzskinstring;
  FaceName = zzfacestring;
  FaceItem = Mid(FaceName,InStr(FaceName,".") + 1);
  FacePackage = Left(FaceName,Len(FaceName) - Len(FaceItem));
  SkinItem = Mid(SkinName,InStr(SkinName,".") + 1);
  SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem));
  /*
  log("SkinName="@SkinName);
  log("SkinItem="@SkinItem);
  log("SkinPackage="@SkinPackage);  
  log("FaceName="@FaceName);
  log("FaceItem="@FaceItem);
  log("FacePackage="@FacePackage);
  log("----");
  log("SC.Default.FixedSkin="@SC.Default.FixedSkin);
  log("SC.Default.DefaultSkinName="@SC.Default.DefaultSkinName);
  */
  
  if ( SkinPackage == "" )
  {
    SkinPackage = SC.Default.DefaultPackage;
    SkinName = SkinPackage $ SkinName;
  }
  if ( FacePackage == "" )
  {
    FacePackage = SC.Default.DefaultPackage;
    FaceName = FacePackage $ FaceName;
  }
  
  if(SC.Default.DefaultSkinName != "")
  {
    if (  !SC.static.SetSkinElement(SkinActor,SC.Default.FixedSkin,SkinName $ string(SC.Default.FixedSkin + 1),SC.Default.DefaultSkinName $ string(SC.Default.FixedSkin + 1)) )
    {
      SkinName = SC.Default.DefaultSkinName;
      FaceName = "";
    }
    SC.static.SetSkinElement(SkinActor,SC.Default.FaceSkin,FacePackage $ SkinItem $ string(SC.Default.FaceSkin + 1) $ FaceItem,SkinName $ string(SC.Default.FaceSkin + 1));
    if ( TeamNum != 255 )
    {
      bSuccess = SC.static.SetSkinElement(SkinActor,SC.Default.TeamSkin1,SkinName $ string(SC.Default.TeamSkin1 + 1) $ "T_" $ string(TeamNum),SkinName $ string(SC.Default.TeamSkin1 + 1));
      bSuccess = bSuccess && SC.static.SetSkinElement(SkinActor,SC.Default.TeamSkin2,SkinName $ string(SC.Default.TeamSkin2 + 1) $ "T_" $ string(TeamNum),SkinName $ string(SC.Default.TeamSkin2 + 1));
    } else {
      bSuccess = SC.static.SetSkinElement(SkinActor,SC.Default.TeamSkin1,SkinName $ string(SC.Default.TeamSkin1 + 1),"");
      bSuccess = bSuccess && SC.static.SetSkinElement(SkinActor,SC.Default.TeamSkin2,SkinName $ string(SC.Default.TeamSkin2 + 1),"");
    }
    
    if ( Pawn(SkinActor) != None )
    {
      if ( FaceName != "" )
      {
        TexString = FacePackage $ SkinItem $ "5" $ FaceItem;
      } else {
        TexString = "None";
      }
      if ( Pawn(SkinActor).PlayerReplicationInfo != None )
      {
        if(TexString != "" && TexString != "None")
          Pawn(SkinActor).PlayerReplicationInfo.TalkTexture = DLO(TexString);          
      } else {
        TalkTextureStrBackup = TexString;
      }
    }
  }
  
  if(!bSuccess)
  {
    log("Trying the old way->SetMultiSkin");
    SC.static.SetMultiSkin(SkinActor,zzskinstring,zzfacestring,TeamNum);    
  }
  //Log("Simulated->SetMultiSkinFix->END");
}

simulated function setnaliskin ()
{
  local string SkinItem;
  local string SkinPackage;
  local string SkinName;

  SkinName = zzskinstring;
  Log("Setting nali");
  if ( SkinName == "" )
  {
    SkinName = "TNaliMeshSkins.Ouboudah";
    SkinPackage = "TNaliMeshSkins.";
  } else {
    SkinItem = Mid(zzskinstring,InStr(zzskinstring,".") + 1);
    SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem));
    if ( SkinPackage == "" )
    {
      SkinPackage = "TNaliMeshSkins.";
      SkinName = SkinPackage $ SkinName;
    }
  }
  if (  !SetSkinElement(0,SkinName,"TNaliMeshSkins.Ouboudah") )
    SkinName = "TNaliMeshSkins.Ouboudah";
    
  if ( PRI.Team < 4 )
    SetSkinElement(0,SkinPackage $ "T_nali_" $ string(PRI.Team),"TNaliMeshSkins.T_nali_" $ string(PRI.Team));
    
  PRI.TalkTexture = DLO(SkinName $ "-Face");
  if ( PRI.TalkTexture == None )
    PRI.TalkTexture = DLO("TNaliMeshSkins.nali-Face");
    
}

simulated function setcowskin ()
{
  local string SkinItem;
  local string SkinPackage;
  local string SkinName;

  SkinName = zzskinstring;
  Log("setting cow");
  if ( SkinName == "" )
  {
    SkinName = "TCowMeshSkins.WarCow";
    SkinPackage = "TCowMeshSkins.";
  } else {
    SkinItem = Mid(zzskinstring,InStr(zzskinstring,".") + 1);
    SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem));
    if ( SkinPackage == "" )
    {
      SkinPackage = "TCowMeshSkins.";
      SkinName = SkinPackage $ SkinName;
    }
  }
  SetSkinElement(0,SkinName,"TCowMeshSkins.WarCow");
  if (  !SetSkinElement(1,SkinName,"TCowMeshSkins.WarCow") )
  {
    SkinName = "TCowMeshSkins.WarCow";
  }
  if ( PRI.Team < 4 )
  {
    if ( SkinName ~= "TCowMeshSkins.AtomicCow" )
    {
      SetSkinElement(1,SkinPackage $ "AtomicCow",SkinName);
    } else {
      SetSkinElement(1,SkinName $ "T_" $ string(PRI.Team),SkinName);
    }
    SetSkinElement(2,SkinPackage $ "T_cow_" $ string(PRI.Team),"TCowMeshSkins.T_Cow_" $ string(PRI.Team));
  } else {
    SetSkinElement(2,SkinPackage $ "cowpack","EpicCustomModels.TCowMeshSkins.cowpack");
  }
  PRI.TalkTexture = DLO(SkinName $ "Face");
  if ( PRI.TalkTexture == None )
    PRI.TalkTexture = DLO("EpicCustomModels.TCowMeshSkins.WarCowFace");
    
}

static function Texture GetUISkin(string SkinName)
{
  local string fem, male, UI, sk;   //consts
  fem="FEMALE2SKINSUTHIDDENUNREALI.";
  male="MALE1SKINSUTHIDDENUNREALI.";
  UI="UnrealI.Skins.";
  sk="SKTROOPERSKINSUT.";
  //catch hidden skins. hidden skins r fun :)
  switch (CAPS(skinname)){
    Case fem$"SHIVA":
      return DLO(UI$"F2Female2");
    Case fem$"CHOLERAE":
    //Case fem$"CHOL1T_2": //team skin I guess.
      return DLO(UI$"F2Female4");
    Case male$"DAVIES":
      return DLO(UI$"JMale2");
    Case male$"DARGAN":
      return DLO(UI$"JMale3");
    Case male$"AVATAR":
      return DLO(UI$"JMale4");
    Case male$"BORIS":
      return DLO(UI$"JMale5");
    Case male$"SMITH":
      return DLO(UI$"JMale6");
    Case male$"KARL":
      return DLO(UI$"JMale7");
    Case male$"CURTIS":
    //Case male$"CURT1T_2":
      return DLO(UI$"JMale8");
    Case "MALE1SKINS.CARY1T_3":
      return DLO("Male1Skins.Carter");
    Case sk$"SKAARJ":
    Case sk$"FALLBACK":
    //hacked colours
    case sk$"FALL1T_0":
     return DLO("UPTexture.Skaarj_0");
    case sk$"FALL1T_1":
     return DLO("UPTexture.Skaarj_1");
    case sk$"FALL1T_2":
     return DLO("UPTexture.Skaarj_2");
    case sk$"FALL1T_3":
     return DLO("UPTexture.Skaarj_3");
   }
  //nothin' special
  return DLO (SkinName);
}

static function Texture DLO (string zzTexture)
{
  if(zzTexture != "")
    return Texture(DynamicLoadObject(zzTexture,Class'Texture',True));
  
  return None;
}

static function SetUnrealISkin (Actor SkinActor, string SkinName, byte TeamNum)
{
  local string SkinItem;
  local string SkinPackage;
  local string TeamSkinName;
  local string MeshName;
  local Texture MySkin;
  local int i;
  local string TeamColor[4];
  local ALPRI SAPRI;

  TeamColor[0] = "Red";
  TeamColor[1] = "Blue";
  TeamColor[2] = "Green";
  TeamColor[3] = "Yellow";    
  
  SkinItem = Mid(SkinName,InStr(SkinName,".") + 1);
  SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem) - 1);
  if ( TeamNum == 255 )
  {
    MySkin = GetUISkin(SkinName);
    if ( (MySkin == None) && (InStr(SkinPackage,"SkinsUT") < 0) )
      MySkin = GetUISkin(SkinPackage $ "UT." $ SkinItem);      
    if ( MySkin == None )
      MySkin = GetUISkin(GetUIDefault(Mid(string(SkinActor.Mesh),InStr(string(SkinActor.Mesh),".") + 1)));
      
  } else {
    if (  !(string(SkinActor.Mesh) ~= "unreali.sktrooper") && (SkinName ~= GetUIDefault(Mid(string(SkinActor.Mesh),InStr(string(SkinActor.Mesh),".") + 1))) )
      TeamSkinName = SkinPackage $ ".T_" $ TeamColor[TeamNum];
    else
      TeamSkinName = SkinPackage $ "." $ Left(SkinItem $ "1111",4) $ "1T_" $ string(TeamNum);
      
    MySkin = GetUISkin(TeamSkinName);
    if ( (MySkin == None) && (InStr(SkinPackage,"SkinsUT") < 0) )
      MySkin = GetUISkin(SkinPackage $ "UT." $ Left(SkinItem $ "1111",4) $ "1T_" $ string(TeamNum));
      
    if ( MySkin == None )
    {
      if ( string(SkinActor.Mesh) ~= "unreali.sktrooper" )
        MySkin = GetUISkin("sktrooperskinsut.fall1T_" $ string(TeamNum));
      else
        MySkin = GetUISkin(Mid(string(SkinActor.Mesh),InStr(string(SkinActor.Mesh),".") + 1) $ "skins.T_" $ TeamColor[TeamNum]);
    }
  }
  if ( MySkin == None )
    MySkin = GetUISkin(GetUIDefault(Mid(string(SkinActor.Mesh),InStr(string(SkinActor.Mesh),".") + 1)));
  
  if ( string(SkinActor.Mesh) ~= "unreali.sktrooper" )
    SkinActor.MultiSkins[1] = DLO("UnrealI.STEffect.stshield");
    
  SkinActor.Skin = MySkin;
  SkinActor.MultiSkins[0] = MySkin;
  
  SAPRI = ALPRI(SkinActor);
  if(SAPRI == None)
    return;
  
  SAPRI.PRI.Skin = MySkin;
  SAPRI.PRI.MultiSkins[0] = MySkin;
  
  if ( SkinActor.Class == Default.Class )
  {
    MySkin = GetUISkin(SkinPackage $ "." $ Left(SkinItem $ "1111",4) $ "5");
    if ( (MySkin == None) && (InStr(SkinPackage,"SkinsUT") < 0) )
    {
      MySkin = GetUISkin(SkinPackage $ "UT." $ Left(SkinItem $ "1111",4) $ "5");
    }
    if ( MySkin == None )
    {
      MySkin = GetUISkin(GetUITalk(Mid(string(SkinActor.Mesh),InStr(string(SkinActor.Mesh),".") + 1)));
    }
    if ( MySkin == None )
    {
      if ( Class'ALPRI'.static.GetALPRI(SkinActor).zzMyClass.Default.bIsFemale )
      {
        MySkin = DLO("fcommandoskins.cMDo5Ivana");
      } else {
        MySkin = DLO("UTtech2.Deco.xmetex2x1");
      }
    }
  }
  //PlayerReplicationInfo(SkinActor).TalkTexture = MySkin;
  //PRI.TalkTexture = MySkin;
  SAPRI.PRI.TalkTexture = MySkin;
}

static function string GetUIDefault (string MeshName)
{
  switch (Caps(MeshName))
  {
    case "SKTROOPER":
    return MeshName $ "skinsut.fallback";
    case "MALE1":
    return MeshName $ "skins.kurgan";
    case "MALE2":
    return MeshName $ "skins.ash";
    case "MALE3":
    return MeshName $ "skins.dante";
    case "FEMALE1":
    return MeshName $ "skins.gina";
    case "FEMALE2":
    return MeshName $ "skins.sonya";
    default:
  }
}

static function string GetUITalk(string meshname){
switch (caps(meshname)){
    case "SKTROOPER":
      return "UPTexture.skaa5";
    case "MALE1":
      return "UPTexture.kurg5";
    case "MALE2":
      return "UPTexture.ash15";
    case "MALE3":
      return "UPTexture.dant5";
    case "FEMALE1":
      return "UPTexture.gina5";
    case "FEMALE2":
      return "UPTexture.sony5";
  }
}

simulated function setskelskins ()
{
  local string SkinItem;
  local string SkinPackage;
  local string FaceItem;
  local string FacePack;
  local string MeshName;
  local string SkinName;
  local string fallbackskin[5];
  local string fallbackface[5];
  local bool bAllowed;
  local bool bFake;
  local Texture Face;
  local Texture Body;

  if ( string(zzMyClass) ~= "Skeletalchars.WarBoss" )
  {
    fallbackskin[0] = "WarRed";
    fallbackskin[1] = "WarBlue";
    fallbackskin[2] = "WarGreen";
    fallbackskin[3] = "WarGold";
    fallbackskin[4] = "WarBlue";
    fallbackface[0] = "WarRedface";
    fallbackface[1] = "WarBlueface";
    fallbackface[2] = "WarGreenface";
    fallbackface[3] = "WarGoldface";
    fallbackface[4] = "WarBlueface";
  } else {
    fallbackskin[0] = "XanBlue";
    fallbackskin[1] = "XanRed";
    fallbackskin[2] = "XanGreen";
    fallbackskin[3] = "XanBronze";
    fallbackskin[4] = "XanTitanium";
    fallbackface[0] = "XanBlueface";
    fallbackface[1] = "XanRedface";
    fallbackface[2] = "Xanface";
    fallbackface[3] = "bronzeface";
    fallbackface[4] = "TitanFace";
  }
  SkinName = zzskinstring;
  MeshName = Mid(string(zzMyClass.Default.Mesh),InStr(string(zzMyClass.Default.Mesh),".") + 1);
  if ( SkinName == "" )
  {
    SkinName = "skeletalchars." $ fallbackskin[PRI.Team];
  }
  SkinItem = Mid(zzskinstring,InStr(zzskinstring,".") + 1);
  SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem) - 1);
  bAllowed = Left(SkinName,Len(MeshName)) ~= MeshName;
  if (  !bAllowed && ((Owner == None) || (Owner.ROLE == ROLE_SimulatedProxy)) )
  {
    bFake = True;
  } else {
    bFake = SkinItem ~= "fake";
  }
  if ( PRI.Team < 4 )
  {
    if (  !bFake )
    {
      Body = DLO(SkinPackage $ "." $ SkinItem $ "1T_" $ string(PRI.Team));
      if ( Body != None )
      {
        Face = DLO(SkinPackage $ "." $ SkinItem $ "5T_" $ string(PRI.Team));
      }
    }
    if ( bFake || (Body == None) )
    {
      Body = DLO("skeletalchars." $ fallbackskin[PRI.Team]);
      Face = DLO("skeletalchars." $ fallbackface[PRI.Team]);
    } else {
      if ( Face == None )
        Face = DLO(SkinPackage $ "." $ SkinItem $ "5");
    }
  } else {
    if (  !bFake )
    {
      Body = DLO(SkinPackage $ "." $ SkinItem $ "1");
      if ( Body != None )
        Face = DLO(SkinPackage $ "." $ SkinItem $ "5");
    }
    if ( bFake || (Body == None) )
    {
      Body = DLO("skeletalchars." $ fallbackskin[4]);
      Face = DLO("skeletalchars." $ fallbackface[4]);
    }
  }
  PRI.Skin = Body;
  PRI.MultiSkins[0] = Body;
  PRI.MultiSkins[1] = Body;
  Skin = Body;
  MultiSkins[0] = Body;
  MultiSkins[1] = Body;
  PRI.TalkTexture = Face;
}

simulated function SetBossSkins ()
{
  local string SkinItem;
  local string SkinPackage;
  local string FaceItem;
  local string FacePackage;
  local string SkinName;
  local string FaceName;

  SkinName = zzskinstring;
  FaceName = zzfacestring;
  FaceItem = GetItemName(FaceName);
  FacePackage = Left(FaceName,Len(FaceName) - Len(FaceItem));
  SkinItem = GetItemName(SkinName);
  SkinPackage = Left(SkinName,Len(SkinName) - Len(SkinItem));
  if ( SkinPackage == "" )
  {
    SkinPackage = "BossSkins.";
    SkinName = SkinPackage $ SkinName;
  }
  if ( FacePackage == "" )
  {
    FacePackage = "BossSkins.";
    FaceName = "Bossskins." $ FaceName;
  }
  if ( PRI.Team != 255 )
  {
    if (  !SetSkinElement(0,SkinName $ "1T_" $ string(PRI.Team),"") )
    {
      if (  !SetSkinElement(0,SkinName $ "1","") )
      {
        SetSkinElement(0,"BossSkins.boss1T_" $ string(PRI.Team),"BossSkins.boss1");
        SkinName = "BossSkins.boss";
      }
    }
    SetSkinElement(1,SkinName $ "2T_" $ string(PRI.Team),SkinName $ "2");
    SetSkinElement(2,SkinName $ "3T_" $ string(PRI.Team),SkinName $ "3");
    if (  !SetSkinElement(3,SkinName $ "4" $ FaceItem $ "T_" $ string(PRI.Team),"") )
    {
      SetSkinElement(3,SkinName $ "4T_" $ string(PRI.Team),SkinName $ "4");
    }
  } else {
    if (  !SetSkinElement(0,SkinName $ "1","BossSkins.boss1") )
    {
      SkinName = "BossSkins.boss";
    }
    SetSkinElement(1,SkinName $ "2","BossSkins.boss2");
    SetSkinElement(2,SkinName $ "3","BossSkins.boss3");
    SetSkinElement(3,SkinName $ "4" $ FaceItem,SkinName $ "4");
  }
  PRI.TalkTexture = DLO(SkinName $ "5" $ FaceItem);
  if ( PRI.TalkTexture == None )
    PRI.TalkTexture = DLO(SkinName $ "5Xan");
    
  if ( PRI.TalkTexture == None )
    PRI.TalkTexture = DLO(SkinName $ "5" $ FaceItem);
    
  if ( PRI.TalkTexture == None )
    PRI.TalkTexture = DLO("bossskins.boss5Xan");
    
}

simulated function bool SetSkinElement (int SkinNo, string SkinName, string DefaultSkinName)
{
  local Texture NewSkin;
  local int i;
  NewSkin = DLO(SkinName);
  if ( NewSkin != None )
  {
    PRI.MultiSkins[SkinNo] = NewSkin;
    MultiSkins[SkinNo] = NewSkin;
    return True;
  } else {
    Log("Failed to load " $ SkinName $ " so load " $ DefaultSkinName);    
    if ( DefaultSkinName != "" )
    {
        NewSkin = DLO(DefaultSkinName);
        PRI.MultiSkins[SkinNo] = NewSkin;
        MultiSkins[SkinNo] = NewSkin;
    }
    return False;
  }
}

function string GetItemName (string FullName)
{
  return Mid(FullName,InStr(FullName,".") + 1);
}

simulated function string getmesh (out byte zzinfo)
{
  if (  !(zzClassString ~= string(zzMyClass)) )
  {
    return zzClassString;
  }
  zzinfo = 1;
  if ( zzMyClass.Default.MenuName != "" )
  {
    return zzMyClass.Default.MenuName @ "(" $ zzClassString $ ")";
  }
  return zzClassString;
}

simulated function string getskinpackage (out byte zzinfo)
{
  if ( (zzskinstring == "") || ClassIsChildOf(zzMyClass,Class'UnrealIPlayer') )
  {
    zzinfo = 1;
    return Left(string(PRI.MultiSkins[0]),InStr(string(PRI.MultiSkins[0]),"."));
  }
  if ( Left(zzskinstring,InStr(zzskinstring,".")) ~= Left(string(PRI.MultiSkins[0]),InStr(string(PRI.MultiSkins[0]),".")) )
  {
    zzinfo = 1;
  }
  return Left(zzskinstring,InStr(zzskinstring,"."));
}

simulated function string GetSkinItem ()
{
  return Mid(zzskinstring,InStr(zzskinstring,".") + 1);
}

simulated function string GetFaceItem ()
{
  if ( zzfacestring != "" )
  {
    return Mid(zzfacestring,InStr(zzfacestring,".") + 1);
  }
  return "N/A";
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
     NetUpdateFrequency=2.000000
}
