class ST_ShockRifleGib extends ST_ShockRifle;

function Fire ( float Value )
{
	local bbPlayer bbP;
	
	if (Owner.IsA('Bot'))
	{
		Super.Fire(Value);
		return;
	}
	
	bbP = bbPlayer(Owner);
	if (bbP != None && bNewNet && Value < 1)
		return;
	
	if ( (AmmoType == None) && (AmmoName != None) )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	//if ( AmmoType.UseAmmo(1) )
	//{
		bbPlayer(Owner).xxAddFired(7);
		GotoState('NormalFire');
		bPointing=True;
		bCanClientFire = true;
		ClientFire(Value);
		if ( bRapidFire || (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if ( bInstantHit )
			TraceFire(0.0);
		else
			ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
	//}
}

function AltFire( float Value )
{
	local actor HitActor;
	local vector HitLocation, HitNormal, Start;
	local bbPlayer bbP;
	local NN_ShockProjRedOwnerHidden RNNSP;
	local NN_ShockProjBlueOwnerHidden BNNSP;
	local NN_ShockProjGreenOwnerHidden GNNSP;
	local NN_ShockProjGoldOwnerHidden GoNNSP;
	
	if (Owner.IsA('Bot'))
	{
		Super.AltFire(Value);
		return;
	}
	
	bbP = bbPlayer(Owner);
	if (bbP != None && bNewNet && Value < 1)
		return;

	if ( Owner == None )
		return;

	if ( Owner.IsA('Bot') ) //make sure won't blow self up
	{
		Start = Owner.Location + CalcDrawOffset() + FireOffset.Z * vect(0,0,1); 
		if ( Pawn(Owner).Enemy != None )
			HitActor = Trace(HitLocation, HitNormal, Start + 250 * Normal(Pawn(Owner).Enemy.Location - Start), Start, false, vect(12,12,12));
		else
			HitActor = self;
		if ( HitActor != None )
		{
			Global.Fire(Value);
			return;
		}
	}	
	if ( AmmoType != None )
	{
		GotoState('AltFiring');
		bCanClientFire = true;
		if ( Owner.IsA('Bot') )
		{
			if ( Owner.IsInState('TacticalMove') && (Owner.Target == Pawn(Owner).Enemy)
			 && (Owner.Physics == PHYS_Walking) && !Bot(Owner).bNovice
			 && (FRand() * 6 < Pawn(Owner).Skill) )
				Pawn(Owner).SpecialFire();
		}
		bPointing=True;
		ClientAltFire(value);
		if (bNewNet)
		{
			if(Pawn(Owner) != None && (Pawn(Owner).PlayerReplicationInfo != None))
			{
					Switch(Pawn(Owner).PlayerReplicationInfo.Team)
					{
						case 0:
							RNNSP = NN_ShockProjRedOwnerHidden(ProjectileFire(Class'NN_ShockProjRedOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (RNNSP != None)
							{
								RNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									RNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(RNNSP);
							}
							break;
						case 1:
							BNNSP = NN_ShockProjBlueOwnerHidden(ProjectileFire(Class'NN_ShockProjBlueOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (BNNSP != None)
							{
								BNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									BNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(BNNSP);
							}
							break;
						case 2:
							GNNSP = NN_ShockProjGreenOwnerHidden(ProjectileFire(Class'NN_ShockProjGreenOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (GNNSP != None)
							{
								GNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									GNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(GNNSP);
							}
							break;
						case 3:
							GoNNSP = NN_ShockProjGoldOwnerHidden(ProjectileFire(Class'NN_ShockProjGoldOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (GoNNSP != None)
							{
								GoNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									GoNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(GoNNSP);
							}
							break;
						default:
							BNNSP = NN_ShockProjBlueOwnerHidden(ProjectileFire(Class'NN_ShockProjBlueOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (BNNSP != None)
							{
								BNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									BNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(BNNSP);
							}
							break;
					}
				}
				else
				{
							BNNSP = NN_ShockProjBlueOwnerHidden(ProjectileFire(Class'NN_ShockProjBlueOwnerHidden', AltProjectileSpeed, bAltWarnTarget));
							if (BNNSP != None)
							{
								BNNSP.NN_OwnerPing = float(Owner.ConsoleCommand("GETPING"));
								if (bbP != None)
									BNNSP.zzNN_ProjIndex = bbP.xxNN_AddProj(BNNSP);
							}
				}
			//}
		}
		else
		{
			if(Pawn(Owner) != None && (Pawn(Owner).PlayerReplicationInfo != None))
			{
					Switch(Pawn(Owner).PlayerReplicationInfo.Team)
					{
						Case 0:
							Pawn(Owner).PlayRecoil(FiringSpeed);
							ProjectileFire(Class'ST_ShockProjRed', AltProjectileSpeed, bAltWarnTarget);
							break;
						Case 1:
							Pawn(Owner).PlayRecoil(FiringSpeed);
							ProjectileFire(Class'ST_ShockProjBlue', AltProjectileSpeed, bAltWarnTarget);
							break;
						Case 2:
							Pawn(Owner).PlayRecoil(FiringSpeed);
							ProjectileFire(Class'ST_ShockProjGreen', AltProjectileSpeed, bAltWarnTarget);
							break;
						Case 3:
							Pawn(Owner).PlayRecoil(FiringSpeed);
							ProjectileFire(Class'ST_ShockProjGold', AltProjectileSpeed, bAltWarnTarget);
							break;
						default:
							Pawn(Owner).PlayRecoil(FiringSpeed);
							ProjectileFire(Class'ST_ShockProjBlue', AltProjectileSpeed, bAltWarnTarget);
							break;
					}
				}
				else
				{
					Pawn(Owner).PlayRecoil(FiringSpeed);
					ProjectileFire(Class'ST_ShockProjBlue', AltProjectileSpeed, bAltWarnTarget);
				}
			}
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local PlayerPawn PlayerOwner;
	local Pawn PawnOwner;
	
	if (Owner.IsA('Bot'))
	{
		Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
		return;
	}
	
	if (bbPlayer(Owner) != None && !bbPlayer(Owner).xxConfirmFired(7))
		return;
	
	PawnOwner = Pawn(Owner);
	if (STM != None)
		STM.PlayerFire(PawnOwner, 5);		// 5 = Shock Beam.

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
		PlayerOwner.ClientInstantFlash( -0.4, vect(450, 190, 650));
	SpawnEffect(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);

	if ( NN_ShockProjRedOwnerHidden(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		NN_ShockProjRedOwnerHidden(Other).SuperExplosion();
		return;
	}
	if ( NN_ShockProjBlueOwnerHidden(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);		// 5 = Shock Beam
		Other.SetOwner(Owner);
		NN_ShockProjBlueOwnerHidden(Other).SuperExplosion();
		return;
	}
	else if ( NN_ShockProjGreenOwnerHidden(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		NN_ShockProjGreenOwnerHidden(Other).SuperExplosion();
		return;
	}
	else if ( NN_ShockProjGoldOwnerHidden(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		NN_ShockProjGoldOwnerHidden(Other).SuperExplosion();
		return;
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////
	
	else if ( ST_ShockProjRed(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		ST_ShockProjRed(Other).SuperExplosion();
		return;
	}
	else if ( ST_ShockProjBlue(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);		// 5 = Shock Beam
		ST_ShockProjBlue(Other).SuperExplosion();
		return;
	}
	else if ( ST_ShockProjGreen(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		ST_ShockProjGreen(Other).SuperExplosion();
		return;
	}
	else if ( ST_ShockProjGold(Other)!=None )
	{
		//AmmoType.UseAmmo(1);
		if (bbPlayer(Owner) != None)
			bbPlayer(Owner).xxAddFired(11);
		if (STM != None)
			STM.PlayerUnfire(PawnOwner, 5);
		Other.SetOwner(Owner);
		ST_ShockProjGold(Other).SuperExplosion();
		return;
	}
	else if (bNewNet)
	{
		if(Pawn(Owner) != None && (Pawn(Owner).PlayerReplicationInfo != None))
		{
				Switch(Pawn(owner).PlayerReplicationInfo.Team)
				{
					case 0:
						DoRingExplosion_RED(PlayerPawn(Owner), HitLocation, HitNormal);	
						break;
					case 1:
						DoRingExplosion_BLUE(PlayerPawn(Owner), HitLocation, HitNormal);	
						break;
					case 2:
						DoRingExplosion_GREEN(PlayerPawn(Owner), HitLocation, HitNormal);
						break;
					case 3:
						DoRingExplosion_GOLD(PlayerPawn(Owner), HitLocation, HitNormal);
						break;
					case 4:
						DoRingExplosion_BLUE(PlayerPawn(Owner), HitLocation, HitNormal);
						break;
					default:
						DoRingExplosion_BLUE(PlayerPawn(Owner), HitLocation, HitNormal);
						break;
				}
			}
			else
				DoRingExplosion_BLUE(PlayerPawn(Owner), HitLocation, HitNormal);
		//}	
	}
	else
	{
		if(Pawn(Owner) != None && (Pawn(Owner).PlayerReplicationInfo != None))
		{
				Switch(Pawn(Owner).PlayerReplicationInfo.Team)
				{
					case 0:
						Spawn(class'Red_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
					case 1:
						Spawn(class'Blue_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
					case 2:
						Spawn(class'Green_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
					case 3:
						Spawn(class'Gold_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
					case 4:
						Spawn(class'Blue_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
					default:
						Spawn(class'Blue_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
						break;
				}
			}
			else
				Spawn(class'Blue_RingExplosion',,, HitLocation+HitNormal*8,rotator(HitNormal));
	}

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if (STM != None)
			STM.PlayerHit(PawnOwner, 5, False);			// 5 = Shock Beam
		Other.TakeDamage(HitDamage, PawnOwner, HitLocation, vect(0,0,0), MyDamageType);
		if (STM != None)
			STM.PlayerClear();
	}

	if (Pawn(Other) != None && Other != Owner && Pawn(Other).Health > 0)
	{	// We hit a pawn that wasn't the owner or dead. (How can you hit yourself? :P)
		HitCounter++;						// +1 hit
		if (HitCounter == 3)
		{	// Wowsers!
			HitCounter = 0;
			if (STM != None)
				STM.PlayerSpecial(PawnOwner, 5);		// 5 = Shock Beam
		}
	}
	else
		HitCounter = 0;
}

defaultproperties
{
     hitdamage=1000
     InstFog=(X=800.000000,Z=0.000000)
     AmmoName=Class'Botpack.SuperShockCore'
     PickupAmmoCount=100
     AltProjectileClass=Class'ST_ShockProjGib'
     aimerror=650.000000
     DeathMessage="%k gibbed %o with the %w."
     PickupMessage="You got the ComboGib Rifle."
     ItemName="ComboGib Rifle"
}
