class NoSpamShock2 extends NoSpamShock config(ComboShock);

function bool canAltFire() {
	local int count;
	local ShockProj proj, first;

	if (!EnableNoSpam || MaxShockBalls <= 0)
		return true;
	
	ForEach AllActors(Class'ShockProj', proj)
		if (proj.Instigator == Pawn(Owner) && proj.bOwnerNoSee) {
			count++;
			if (first == None)
				first = proj;
		}

	if (count >= MaxShockBalls)
		first.Destroy();
	
	return true;
}

simulated function bool canClientAltFire() {
	local int count;
	local ShockProj proj, first;

	if (!EnableNoSpam || MaxShockBalls <= 0)
		return true;
	
	ForEach AllActors(Class'ShockProj', proj)
		if (proj.Instigator == Pawn(Owner) && !proj.bOwnerNoSee) {
			count++;
			if (first == None)
				first = proj;
		}

	if (count >= MaxShockBalls)
		first.Destroy();
	
	return true;
}

defaultproperties
{
    MaxShockBalls=1
    AntiSpamMeasure="Remove Oldest Ball"
}
