class NoSpamShock1 extends NoSpamShock config(ComboShock);

function bool canAltFire() {
	local int shockBalls;
	local ShockProj proj;

	if (!EnableNoSpam || MaxShockBalls <= 0)
		return true;
	
	ForEach AllActors(Class'ShockProj', proj) {
		if (proj.Instigator == Pawn(Owner) && proj.bOwnerNoSee)
			shockBalls++;
	}
	return shockBalls < MaxShockBalls;
}

simulated function bool canClientAltFire() {
	local int shockBalls;
	local ShockProj proj;

	if (!EnableNoSpam || MaxShockBalls <= 0)
		return true;
	
	ForEach AllActors(Class'ShockProj', proj) {
		if (proj.Instigator == Pawn(Owner) && !proj.bOwnerNoSee)
			shockBalls++;
	}
	return shockBalls < MaxShockBalls;
}

defaultproperties
{
    MaxShockBalls=3
    AntiSpamMeasure="Limit Number of Balls"
}
