class NNSettingsMenuPage extends UMenuPageWindow;

var UWindowCheckbox bFastWeapon, bDI, bTSB, bSniperTrace, bLowAmWarn, bTeamLocation, bFlagLocation;
var UWindowComboControl NNSniperStyle, ChatPos, BeepSound, HUDSy;

var UWindowSmallButton Close;

function Created()
{
	Super.Created();

	bFastWeapon = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 20, WinWidth - 30, 1));
	bFastWeapon.bAcceptsFocus=False;
	bFastWeapon.SetText("Fast Weapon Switching");
	bFastWeapon.SetFont(F_Normal);
	bFastWeapon.Align=TA_Left;
	bFastWeapon.bChecked=Class'NNSettings'.default.bFWS;

	bDI = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 40, WinWidth - 30, 1));
	bDI.bAcceptsFocus=False;
	bDI.SetText("Show Damage Indicator");
	bDI.SetFont(F_Normal);
	bDI.Align=TA_Left;
	bDI.bChecked=Class'NNSettings'.default.bDamageIndicator;

	bTSB = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 60, WinWidth - 30, 1));
	bTSB.bAcceptsFocus=False;
	bTSB.SetText("Team-Based Shock Effects");
	bTSB.SetFont(F_Normal);
	bTSB.Align=TA_Left;
	bTSB.bChecked=Class'NNSettings'.default.bTeamShockBeams;
	
	bSniperTrace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 80, WinWidth - 30, 1));
	bSniperTrace.bAcceptsFocus=False;
	bSniperTrace.SetText("Sniper Trace Effects");
	bSniperTrace.SetFont(F_Normal);
	bSniperTrace.Align=TA_Left;
	bSniperTrace.bChecked=Class'NNSettings'.default.bSniperTraceEffects;
	
	bLowAmWarn = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 100, WinWidth - 30, 1));
	bLowAmWarn.bAcceptsFocus=False;
	bLowAmWarn.SetText("Show Low Ammo Warning");
	bLowAmWarn.SetFont(F_Normal);
	bLowAmWarn.Align=TA_Left;
	bLowAmWarn.bChecked=Class'NNSettings'.default.bShowLowAmmoWarning;

	BeepSound = UWindowComboControl(CreateControl(class'UWindowComboControl', 10, 120, WinWidth - 30, 1));
   	BeepSound.SetFont(F_Normal);
   	BeepSound.EditBoxWidth = 80;
   	BeepSound.AddItem("Default", "0");
   	BeepSound.AddItem("Q3", "1");
   	BeepSound.SetSelectedIndex(class'NNSettings'.default.BeepSoundType);
   	BeepSound.SetEditable(False);
   	BeepSound.Text = "Beep Sound Type ";

	NNSniperStyle = UWindowComboControl(CreateControl(class'UWindowComboControl', 10, 140, WinWidth - 30, 1));
   	NNSniperStyle.SetFont(F_Normal);
   	NNSniperStyle.EditBoxWidth = 80;
   	NNSniperStyle.AddItem("Default", "0");
   	NNSniperStyle.AddItem("Tactical", "1");
   	NNSniperStyle.AddItem("Sci-Fi", "2");
   	NNSniperStyle.AddItem("None", "3");
   	NNSniperStyle.SetSelectedIndex(class'NNSettings'.default.SniperScopeStyle);
   	NNSniperStyle.SetEditable(False);
   	NNSniperStyle.Text = "Sniper Scope Style";
	
	ChatPos = UWindowComboControl(CreateControl(class'UWindowComboControl', 10, 160, WinWidth - 30, 1));
   	ChatPos.SetFont(F_Normal);
   	ChatPos.EditBoxWidth = 100;
   	ChatPos.AddItem("Top-Corner", "0");
   	ChatPos.AddItem("Bottom-Corner", "1");
   	ChatPos.SetSelectedIndex(class'NNSettings'.default.ChatAreaPosition);
   	ChatPos.SetEditable(False);
   	ChatPos.Text = "Chat and Messages Area Position";

   	bTeamLocation = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 180, WinWidth - 30, 1));
	bTeamLocation.bAcceptsFocus=False;
	bTeamLocation.SetText("Show Team Mates location");
	bTeamLocation.SetFont(F_Normal);
	bTeamLocation.Align=TA_Left;
	bTeamLocation.bChecked=Class'NNSettings'.default.bShowTeamMatesLocation;

	bFlagLocation = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 200, WinWidth - 30, 1));
	bFlagLocation.bAcceptsFocus=False;
	bFlagLocation.SetText("Show CTF Flags location");
	bFlagLocation.SetFont(F_Normal);
	bFlagLocation.Align=TA_Left;
	bFlagLocation.bChecked=Class'NNSettings'.default.bShowFlagsLocation;

	Close = UWindowSmallButton(CreateControl(class'UWindowSmallButton', WinWidth - 100,WinHeight - 30,80.0,35.0));
	Close.SetText("Close");
	Close.DownSound = Sound'WindowClose';
	Close.NotifyWindow = Self;
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C,E);

	switch(E) {
		case DE_Change: 
			switch(C) {
				case bFastWeapon:
					if(bFastWeapon != None)
					{
						class'NNSettings'.default.bFWS = bFastWeapon.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case bDI:
					if(bDI != None)
					{
						class'NNSettings'.default.bDamageIndicator = bDI.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case bTSB:
					if(bTSB != None)
					{
						class'NNSettings'.default.bTeamShockBeams = bTSB.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case BeepSound:
					if(BeepSound != None)
					{
						class'NNSettings'.default.BeepSoundType = byte(BeepSound.GetValue2());
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case bSniperTrace:
					if(bSniperTrace != None)
					{
						class'NNSettings'.default.bSniperTraceEffects = bSniperTrace.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case bLowAmWarn:
					if(bLowAmWarn != None)
					{
						class'NNSettings'.default.bShowLowAmmoWarning = bLowAmWarn.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case NNSniperStyle:
					if(NNSniperStyle != None)
					{
               			class'NNSettings'.default.SniperScopeStyle = byte(NNSniperStyle.GetValue2());
               			class'NNSettings'.static.StaticSaveConfig();
               		}
               		break;
				case ChatPos:
					if(ChatPos != None)
					{
               			class'NNSettings'.default.ChatAreaPosition = byte(ChatPos.GetValue2());
               			class'NNSettings'.static.StaticSaveConfig();
               		}
               		break;
               	case bTeamLocation:
					if(bTeamLocation != None)
					{
						class'NNSettings'.default.bShowTeamMatesLocation = bTeamLocation.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
				case bFlagLocation:
					if(bFlagLocation != None)
					{
						class'NNSettings'.default.bShowFlagsLocation = bFlagLocation.bChecked;
						class'NNSettings'.static.StaticSaveConfig();
					}
					break;
               	}
               	break;

               	case DE_Click:
				switch(C)
		        {
				 	case Close:
				 		if(Close != None)
				 		{
				 			Class'NNSettings'.static.StaticSaveConfig();
							SaveConfig();
		               		ParentWindow.ParentWindow.Close();
		               	}
		               	break;
		        }
		    break;
        }
}

defaultproperties
{
}