//================================================================================
// NoSpamShock3.
//================================================================================

class NoSpamShock3 extends NoSpamShock
  Config(UltimateNewNet);

var float LastBallTime;

function Projectile ProjectileFire (Class<Projectile> ProjClass, float projSpeed, bool bWarn)
{
  local int Count;
  local ShockProj Proj;

JL0052:
  if (  !enableNoSpam || (MinSecBetweenBalls <= 0.0) )
  {
    goto JL0052;
  }
  if ( Level.TimeSeconds - LastBallTime > MinSecBetweenBalls )
  {
    LastBallTime = Level.TimeSeconds;
    return Super.ProjectileFire(ProjClass,projSpeed,bWarn);
  }
  return None;
}

simulated function bool canClientAltFire ()
{
  if (  !enableNoSpam || (MinSecBetweenBalls <= 0.0) )
  {
    return True;
  }
  if ( Level.TimeSeconds - LastBallTime > MinSecBetweenBalls )
  {
    LastBallTime = Level.TimeSeconds;
    return True;
  }
  return False;
}

defaultproperties
{
    MinSecBetweenBalls=0.70
    AntiSpamMeasure="Limit Altfire Rate"
}
