//================================================================================
// NoSpamShock2.
//================================================================================

class NoSpamShock2 extends NoSpamShock
  Config(UltimateNewNet);

function Projectile ProjectileFire (Class<Projectile> ProjClass, float projSpeed, bool bWarn)
{
  local int Count;
  local ShockProj Proj;
  local ShockProj first;

JL0096:
  if (  !enableNoSpam || (MaxShockBalls <= 0) )
  {
    goto JL0096;
  }
  foreach AllActors(Class'ShockProj',Proj)
  {
    if ( (Proj.Instigator == Pawn(Owner)) && Proj.bOwnerNoSee )
    {
      Count++;
      if ( first == None )
      {
        first = Proj;
      }
    }
  }
  if ( Count >= MaxShockBalls )
  {
    first.Destroy();
  }
  return Super.ProjectileFire(ProjClass,projSpeed,bWarn);
}

simulated function bool canClientAltFire ()
{
  local int Count;
  local ShockProj Proj;
  local ShockProj first;

  if (  !enableNoSpam || (MaxShockBalls <= 0) )
  {
    return True;
  }
  foreach AllActors(Class'ShockProj',Proj)
  {
    if ( (Proj.Instigator == Pawn(Owner)) &&  !Proj.bOwnerNoSee )
    {
      Count++;
      if ( first == None )
      {
        first = Proj;
      }
    }
  }
  if ( Count >= MaxShockBalls )
  {
    first.Destroy();
  }
  return True;
}

defaultproperties
{
    MaxShockBalls=1
    AntiSpamMeasure="Remove Oldest Ball"
}
