//================================================================================
// NoSpamShock1.
//================================================================================

class NoSpamShock1 extends NoSpamShock
  Config(UltimateNewNet);

function Projectile ProjectileFire (Class<Projectile> ProjClass, float projSpeed, bool bWarn)
{
  local int Count;
  local ShockProj Proj;

JL0076:
  if (  !enableNoSpam || (MaxShockBalls <= 0) )
  {
    goto JL0076;
  }
  foreach AllActors(Class'ShockProj',Proj)
  {
    if ( (Proj.Instigator == Pawn(Owner)) && Proj.bOwnerNoSee )
    {
      Count++;
    }
  }
  if ( Count >= MaxShockBalls )
  {
    return None;
  }
  return Super.ProjectileFire(ProjClass,projSpeed,bWarn);
}

simulated function bool canClientAltFire ()
{
  local int Count;
  local ShockProj Proj;

  if (  !enableNoSpam || (MaxShockBalls <= 0) )
  {
    return True;
  }
  foreach AllActors(Class'ShockProj',Proj)
  {
    if ( (Proj.Instigator == Pawn(Owner)) &&  !Proj.bOwnerNoSee )
    {
      Count++;
    }
  }
  return Count < MaxShockBalls;
}

defaultproperties
{
    MaxShockBalls=3
    AntiSpamMeasure="Limit Number of Balls"
}
