//================================================================================
// NoSpamShock.
//================================================================================

class NoSpamShock extends ST_ShockRifleGib
  Config(UltimateNewNet);

var bool enableNoSpam;
var config int MaxShockBalls;
var config float MinSecBetweenBalls;
var string AntiSpamMeasure;

replication
{
	reliable if( Role==ROLE_Authority )
    enableNoSpam,MaxShockBalls,MinSecBetweenBalls;
}

function PostBeginPlay ()
{
  Super.PostBeginPlay();
  enableNoSpam = Class'ComboShock'.Default.enableNoSpam;
}

simulated function bool ClientAltFire (float Value)
{
  if ( (Role < 4) &&  !canClientAltFire() )
  {
    LoopAnim('Fire2',0.41 + 0.41 * FireAdjust,0.05);
    return False;
  }
  return Super.ClientAltFire(Value);
}

simulated function bool canClientAltFire ()
{
  return True;
}

defaultproperties
{
    AntiSpamMeasure="fight fire with fire"
}
