//================================================================================
// Damage.
//================================================================================

class Damage extends Mutator
  Config(UltimateNewNet);

var config float DamageScaling;
var config float KnockbackScaling;
var config float SelfDamageScaling;
var config float SelfKnockbackScaling;
var config float FallDamageScaling;
var config float ZoneDamageScaling;
var config name WepName[16];
var config float WeaponDamageScaling[16];
var config float WeaponKnockbackScaling[16];

function PostBeginPlay ()
{
  Super.PostBeginPlay();
  Level.Game.RegisterDamageMutator(self);
  ApplyZoneDamageScale();
  Log("#===================================#");
  Log("#  Damage/Boost Scaling in General  #");
  Log("#===================================#");
  Log("#  Hostile Damage:     " $ string(DamageScaling) $ "     #");
  Log("#  Knockback:          " $ string(KnockbackScaling) $ "     #");
  Log("#  Self Damage:        " $ string(SelfDamageScaling) $ "     #");
  Log("#  Self Knockback:     " $ string(SelfKnockbackScaling) $ "     #");
  Log("#  Fall Damage:        " $ string(FallDamageScaling) $ "     #");
  Log("#  Zone Damage:        " $ string(ZoneDamageScaling) $ "     #");
  Log("#===================================#");
}

function ApplyZoneDamageScale ()
{
  local ZoneInfo Zone;

  foreach AllActors(Class'ZoneInfo',Zone)
  {
    Zone.DamagePerSec *= ZoneDamageScaling;
  }
}

function MutatorTakeDamage (out int actualDamage, Pawn Victim, Pawn instigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
  local Weapon W;
  local int i;

  if ( Victim == instigatedBy )
  {
    if ( actualDamage >= 10000 )
    {
      return;
    }
    actualDamage *= SelfDamageScaling;
    Momentum *= SelfKnockbackScaling;
  } else {
    actualDamage *= DamageScaling;
    Momentum *= KnockbackScaling;
  }
JL008F:
  if ( (instigatedBy != None) && (instigatedBy.Weapon != None) )
  {
    W = instigatedBy.Weapon;
    i = 0;
    if ( i < 16 )
    {
      if ( W.IsA(WepName[i]) )
      {
        actualDamage *= WeaponDamageScaling[i];
        Momentum *= WeaponKnockbackScaling[i];
      } else {
        ++i;
        goto JL008F;
      }
    }
  }
  if ( DamageType == 'Fall' )
  {
    actualDamage *= FallDamageScaling;
  }
  Super.MutatorTakeDamage(actualDamage,Victim,instigatedBy,HitLocation,Momentum,DamageType);
}

defaultproperties
{
    DamageScaling=1.00
    KnockbackScaling=1.00
    SelfDamageScaling=1.00
    SelfKnockbackScaling=1.00
    FallDamageScaling=1.00
    ZoneDamageScaling=1.00
    WeaponDamageScaling(0)=1.00
    WeaponDamageScaling(1)=1.00
    WeaponDamageScaling(2)=1.00
    WeaponDamageScaling(3)=1.00
    WeaponDamageScaling(4)=1.00
    WeaponDamageScaling(5)=1.00
    WeaponDamageScaling(6)=1.00
    WeaponDamageScaling(7)=1.00
    WeaponDamageScaling(8)=1.00
    WeaponDamageScaling(9)=1.00
    WeaponDamageScaling(10)=1.00
    WeaponDamageScaling(11)=1.00
    WeaponDamageScaling(12)=1.00
    WeaponDamageScaling(13)=1.00
    WeaponDamageScaling(14)=1.00
    WeaponDamageScaling(15)=1.00
    WeaponKnockbackScaling(0)=1.00
    WeaponKnockbackScaling(1)=1.00
    WeaponKnockbackScaling(2)=1.00
    WeaponKnockbackScaling(3)=1.00
    WeaponKnockbackScaling(4)=1.00
    WeaponKnockbackScaling(5)=1.00
    WeaponKnockbackScaling(6)=1.00
    WeaponKnockbackScaling(7)=1.00
    WeaponKnockbackScaling(8)=1.00
    WeaponKnockbackScaling(9)=1.00
    WeaponKnockbackScaling(10)=1.00
    WeaponKnockbackScaling(11)=1.00
    WeaponKnockbackScaling(12)=1.00
    WeaponKnockbackScaling(13)=1.00
    WeaponKnockbackScaling(14)=1.00
    WeaponKnockbackScaling(15)=1.00
}
