//================================================================================
// ComboShock.
//================================================================================

class ComboShock extends Damage
  Config(UltimateNewNet);

var string PackageName;
var string AntiSpamMeasure;
var string WeaponString;
var string AmmoString;
var name WeaponName;
var name AmmoName;
var Class<NoSpamShock> ShockRifleClass;
var config bool bGiveShockRifle;
var config bool enableNoSpam;
var config float AmmoAmount;
var config bool bUseCustomInitialAmmo;
var config bool bKeepInventoryDM;
var config bool bKeepInventoryCTF;
var config bool bKeepInventoryAS;
var config bool bKeepInventoryDOM;
var config bool bKeepInventoryTDM;
var config bool bKeepInventoryLMS;
var config bool bKeepInventoryOther;
var bool bKeepInv;
var config byte AntiSpamMethodDM;
var config byte AntiSpamMethodCTF;
var config byte AntiSpamMethodAS;
var config byte AntiSpamMethodDOM;
var config byte AntiSpamMethodTDM;
var config byte AntiSpamMethodLMS;
var config byte AntiSpamMethodOther;
var byte AntiSpamMethod;

event Tick(float DeltaTime)
{
	local Ammo AUX;
	
	ForEach Level.AllActors(Class'Ammo',AUX)
	{
	  AUX.AmmoAmount = AmmoAmount;
	}
}

function RemovePickup ()
{
  local Inventory Inv;

  foreach AllActors(Class'Inventory',Inv)
  {
    if ( Inv.IsA('Pickup') &&  !Inv.IsA('UT_Jumpboots') || Inv.IsA('Weapon') )
    {
      if ( Inv.myMarker != None )
      {
        Inv.Destroy();
      }
    }
  }
}

function PostBeginPlay ()
{
  Super.PostBeginPlay();
  RemovePickup();
  Log("#=======================#");
  Log("# ComboShock for NewNet #");
  Log("#=======================#");
  if ( Level.Game.IsA('Assault') )
  {
    bKeepInv = bKeepInventoryAS;
    AntiSpamMethod = AntiSpamMethodAS;
  } else {
    if ( Level.Game.IsA('CTFGame') )
    {
      bKeepInv = bKeepInventoryCTF;
      AntiSpamMethod = AntiSpamMethodCTF;
    } else {
      if ( Level.Game.IsA('Domination') )
      {
        bKeepInv = bKeepInventoryDOM;
        AntiSpamMethod = AntiSpamMethodDOM;
      } else {
        if ( Level.Game.IsA('LastManStanding') )
        {
          bKeepInv = bKeepInventoryLMS;
          AntiSpamMethod = AntiSpamMethodLMS;
        } else {
          if ( Level.Game.IsA('TeamGamePlus') )
          {
            bKeepInv = bKeepInventoryTDM;
            AntiSpamMethod = AntiSpamMethodTDM;
          } else {
            if ( Level.Game.IsA('DeathMatchPlus') )
            {
              bKeepInv = bKeepInventoryDM;
              AntiSpamMethod = AntiSpamMethodDM;
            } else {
              bKeepInv = bKeepInventoryOther;
              AntiSpamMethod = AntiSpamMethodOther;
            }
          }
        }
      }
    }
  }
  Log("# AntiSpamMethod = " $ string(AntiSpamMethod));
  Log("# bKeepInv = " $ string(bKeepInv));
  Log("#=======================#");
  if ( bKeepInv )
  {
    Log("# Melee Weapons are kept for " $ string(Level.Game.Class));
  }
  PackageName = Left(string(self.Class),InStr(string(self.Class),"."));
  WeaponString = PackageName $ "." $ string(WeaponName) $ string(AntiSpamMethod);
  ShockRifleClass = Class<NoSpamShock>(DynamicLoadObject(WeaponString,Class'Class'));
  AntiSpamMeasure = ShockRifleClass.Default.AntiSpamMeasure;
}

function ModifyPlayer(Pawn P) {
	if (bGiveShockRifle)
		GiveWeaponClass(P, ShockRifleClass);
	
	if ( P.IsA('PlayerPawn') && !P.IsA('Spectator') )
		MutatorMessage(PlayerPawn(P));

	super.ModifyPlayer(P);
	if (NextMutator != None)
		NextMutator.ModifyPlayer(P);
}

function MutatorMessage(PlayerPawn PP) {
	if (PP != None && PP.PlayerReplicationInfo != None && PP.PlayerReplicationInfo.Deaths == 0) {
		PP.ClientMessage("ComboShock for NewNet");
		if (enableNoSpam)
			PP.ClientMessage("AntiSpam Method: "$AntiSpamMeasure);
	}
}

function bool CheckReplacement (Actor Other, out byte bSuperRelevant)
{
  if ( Other.IsA('Weapon') )
  {
    if ( (WeaponString != "") &&  !Other.IsA(WeaponName) )
    {
      if (  !bKeepInv || (Weapon(Other).AmmoName != None) )
      {
        return False;
      }
    }
  }
  if ( Other.IsA('Ammo') )
  {
    if ( (AmmoString != "") &&  !Other.IsA(AmmoName) )
    {
      return False;
    }
  }
  bSuperRelevant = 0;
  return True;
}

function GiveWeapon (Pawn P, string WeaponName)
{
  GiveWeaponClass(P,Class<Weapon>(DynamicLoadObject(WeaponName,Class'Class')));
}

function GiveWeaponClass(Pawn P, class<Weapon> WeaponClass) {
	local Weapon W;

	if (WeaponClass == None || P.FindInventoryType(WeaponClass) != None)
		return;

	W = P.Spawn(WeaponClass, self);
	if (W != None) {
		W.RespawnTime = 0.0;
		W.GiveTo(P);
		W.bHeldItem = true;
		W.bCanThrow = false;
		/*
		if (W.AmmoName != None) {
			if (bUseCustomInitialAmmo) {
				W.PickupAmmoCount = W.AmmoName.default.MaxAmmo * InitialAmmo;
				if (W.PickupAmmoCount <= 0)
					W.PickupAmmoCount = 1;
			}
			W.GiveAmmo(P);
		}
		*/
		W.GiveAmmo(P);
		W.SetSwitchPriority(P);
		W.WeaponSet(P);
		W.AmbientGlow = 0;
		if (P.IsA('PlayerPawn'))
			W.SetHand(PlayerPawn(P).Handedness);
		else
			W.GotoState('Idle');
	}
}

defaultproperties
{
    AmmoString="Botpack.ShockCore"
    WeaponName=NoSpamShock
    AmmoName=ShockCore
    bGiveShockRifle=True
    enableNoSpam=True
    AmmoAmount=50
    bKeepInventoryCTF=True
    bKeepInventoryAS=True
    bKeepInventoryDOM=True
    AntiSpamMethodDM=2
    AntiSpamMethodCTF=2
    AntiSpamMethodAS=2
    AntiSpamMethodDOM=2
    AntiSpamMethodTDM=2
    AntiSpamMethodLMS=2
    AntiSpamMethodOther=2
    WepName=ComboGib Rifle
    WeaponDamageScaling=100.00
}
