class BlueSniperTrace2 extends BlueSniperTrace;

simulated function Timer()
{
	local BlueSniperTrace r;
	local int i;
	local float scaler, lastscaler;
	local vector CurLoc;

	MoveAmount /= 10000;

	CurLoc = Location;
	lastscaler = 1.0;
	
	for (i = 1; i <= NumPuffs; i++)
	{
		scaler = 1.0 - (float(i)/(float(NumPuffs)*3.0));
		CurLoc = CurLoc + (MoveAmount * ((180 * DrawScale) * lastscaler));
		r = Spawn(class'BlueSniperTrace',,, CurLoc);
		r.RemoteRole = ROLE_None;
		r.DrawScale = scaler * DrawScale;
		lastscaler = scaler;
	}
}

simulated function PostBeginPlay()
{
	if ( Level.NetMode != NM_DedicatedServer )
	{
		SetTimer(0.01, false);
		//PlayAnim('getbig', 1/Default.LifeSpan, 0);
	}
}

defaultproperties
{
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.500000
     DrawType=DT_Mesh
     DrawScale=1.00
     Style=STY_Translucent
     LODBias=200.00
     Mesh=LodMesh'railtrail'
     MultiSkins(0)=Texture'BlueSw'
     MultiSkins(1)=Texture'BlueSw'
     bUnlit=True
}