class IGPlus_ModelImport extends Object;

var Mesh DefaultMesh[18];
var Mesh RateCorrectedMesh[18];

//
// Boss
//

#exec MESH IMPORT MESH=Boss ANIVFILE=MODELS\Boss_a.3D DATAFILE=MODELS\Boss_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=Boss X=-150 Y=40 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Boss SEQ=All       STARTFRAME=0   NUMFRAMES=700
#exec MESH SEQUENCE MESH=Boss SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=20 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Boss SEQ=Breath1   STARTFRAME=25  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Breath2   STARTFRAME=32  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=CockGun   STARTFRAME=52  NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=DuckWlkL  STARTFRAME=60  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Boss SEQ=DuckWlkS  STARTFRAME=75  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Boss SEQ=HeadHit   STARTFRAME=90  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=JumpLgFr  STARTFRAME=91  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=JumpSmFr  STARTFRAME=92  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=LandLgFr  STARTFRAME=93  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Boss SEQ=LandSmFr  STARTFRAME=94  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Boss SEQ=LeftHit   STARTFRAME=95  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=Look      STARTFRAME=96  NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=RightHit  STARTFRAME=136 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=RunLg     STARTFRAME=137 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Boss SEQ=RunLgFr   STARTFRAME=147 NUMFRAMES=10 RATE=17    Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=RunSm     STARTFRAME=157 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Boss SEQ=RunSmFr   STARTFRAME=167 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=StillFrRp STARTFRAME=177 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=StillLgFr STARTFRAME=187 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=StillSmFr STARTFRAME=197 NUMFRAMES=8  RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=SwimLg    STARTFRAME=205 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Boss SEQ=SwimSm    STARTFRAME=220 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Boss SEQ=TreadLg   STARTFRAME=235 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=TreadSm   STARTFRAME=250 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Victory1  STARTFRAME=265 NUMFRAMES=18 RATE=6  	Group=Gesture
#exec MESH SEQUENCE MESH=Boss SEQ=WalkLg    STARTFRAME=283 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Boss SEQ=WalkLgFr  STARTFRAME=298 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=WalkSm    STARTFRAME=313 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Boss SEQ=WalkSmFr  STARTFRAME=328 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=Wave      STARTFRAME=343 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Boss SEQ=Walk      STARTFRAME=358 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Boss SEQ=TurnLg    STARTFRAME=298 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=Boss SEQ=TurnSm    STARTFRAME=328 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=Boss SEQ=Breath1L  STARTFRAME=373 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Breath2L  STARTFRAME=380 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=CockGunL  STARTFRAME=400 NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=LookL     STARTFRAME=408 NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=WaveL     STARTFRAME=448 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Boss SEQ=Chat1     STARTFRAME=463 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Chat2     STARTFRAME=476 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Boss SEQ=Thrust    STARTFRAME=486 NUMFRAMES=15 RATE=20		Group=Gesture
#exec MESH SEQUENCE MESH=Boss SEQ=DodgeB    STARTFRAME=501 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=DodgeF    STARTFRAME=502 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=DodgeR    STARTFRAME=503 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=DodgeL    STARTFRAME=504 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=Fighter   STARTFRAME=187 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=Boss SEQ=Flip      STARTFRAME=505 NUMFRAMES=20	RATE=21		Group=Jumping
#exec MESH SEQUENCE MESH=Boss SEQ=Dead1     STARTFRAME=525 NUMFRAMES=13 RATE=12		Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=Dead2     STARTFRAME=538 NUMFRAMES=16 RATE=12
#exec MESH SEQUENCE MESH=Boss SEQ=Dead3     STARTFRAME=554 NUMFRAMES=13 RATE=12
#exec MESH SEQUENCE MESH=Boss SEQ=Dead4     STARTFRAME=567 NUMFRAMES=16 RATE=12
#exec MESH SEQUENCE MESH=Boss SEQ=Dead7     STARTFRAME=583 NUMFRAMES=21 RATE=15		Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=Dead8     STARTFRAME=604 NUMFRAMES=18 RATE=15		Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=Dead9     STARTFRAME=622 NUMFRAMES=20 RATE=30		Group=TakeHit
#exec MESH SEQUENCE MESH=Boss SEQ=Dead9B    STARTFRAME=642 NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=Boss SEQ=Dead11    STARTFRAME=652 NUMFRAMES=18 RATE=15
#exec MESH SEQUENCE MESH=Boss SEQ=BackRun   STARTFRAME=670 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=StrafeL   STARTFRAME=680 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Boss SEQ=StrafeR   STARTFRAME=690 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH NOTIFY MESH=Boss SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep


#exec MESH SEQUENCE MESH=Boss SEQ=DeathEnd  STARTFRAME=537 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Boss SEQ=DeathEnd2 STARTFRAME=553 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Boss SEQ=DeathEnd3 STARTFRAME=566 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=Boss X=0.0585 Y=0.0585 Z=0.117

#exec MESH NOTIFY MESH=Boss SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Boss SEQ=Dead1 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead2 TIME=0.9 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead4 TIME=0.6 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead7 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead8 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead9B TIME=0.8 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Boss SEQ=Dead11 TIME=0.57 FUNCTION=LandThump

//
// Commando
//

#exec MESH IMPORT MESH=Commando ANIVFILE=MODELS\Commando_a.3D DATAFILE=MODELS\Commando_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=Commando X=-150 Y=40 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Commando SEQ=All       STARTFRAME=0   NUMFRAMES=700
#exec MESH SEQUENCE MESH=Commando SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=20 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Breath1   STARTFRAME=25  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Breath2   STARTFRAME=32  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=CockGun   STARTFRAME=52  NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=DuckWlkL  STARTFRAME=60  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Commando SEQ=DuckWlkS  STARTFRAME=75  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Commando SEQ=HeadHit   STARTFRAME=90  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=JumpLgFr  STARTFRAME=91  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=JumpSmFr  STARTFRAME=92  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=LandLgFr  STARTFRAME=93  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Commando SEQ=LandSmFr  STARTFRAME=94  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Commando SEQ=LeftHit   STARTFRAME=95  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Look      STARTFRAME=96  NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=RightHit  STARTFRAME=136 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=RunLg     STARTFRAME=137 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Commando SEQ=RunLgFr   STARTFRAME=147 NUMFRAMES=10 RATE=17     Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=RunSm     STARTFRAME=157 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Commando SEQ=RunSmFr   STARTFRAME=167 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StillFrRp STARTFRAME=177 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=StillLgFr STARTFRAME=187 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=StillSmFr STARTFRAME=197 NUMFRAMES=8  RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=SwimLg    STARTFRAME=205 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Commando SEQ=SwimSm    STARTFRAME=220 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Commando SEQ=TreadLg   STARTFRAME=235 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=TreadSm   STARTFRAME=250 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Victory1  STARTFRAME=265 NUMFRAMES=18 RATE=11 	Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=WalkLg    STARTFRAME=283 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=WalkLgFr  STARTFRAME=298 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=WalkSm    STARTFRAME=313 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=WalkSmFr  STARTFRAME=328 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=Wave      STARTFRAME=343 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Walk      STARTFRAME=358 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=TurnLg    STARTFRAME=298 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=Commando SEQ=TurnSm    STARTFRAME=328 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=Commando SEQ=Breath1L  STARTFRAME=373 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Breath2L  STARTFRAME=380 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=CockGunL  STARTFRAME=400 NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=LookL     STARTFRAME=408 NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=WaveL     STARTFRAME=448 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Chat1     STARTFRAME=463 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Chat2     STARTFRAME=476 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Thrust    STARTFRAME=486 NUMFRAMES=15 RATE=20		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeB    STARTFRAME=501 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeF    STARTFRAME=502 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeR    STARTFRAME=503 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeL    STARTFRAME=504 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=Fighter   STARTFRAME=187 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=Commando SEQ=Flip      STARTFRAME=505 NUMFRAMES=20	RATE=21		Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=Dead1     STARTFRAME=525 NUMFRAMES=13 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead2     STARTFRAME=538 NUMFRAMES=16 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=Dead3     STARTFRAME=554 NUMFRAMES=13 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=Dead4     STARTFRAME=567 NUMFRAMES=16 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=Dead7     STARTFRAME=583 NUMFRAMES=21 RATE=12		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead8     STARTFRAME=604 NUMFRAMES=18 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead9     STARTFRAME=622 NUMFRAMES=20 RATE=30		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead9B    STARTFRAME=642 NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=Commando SEQ=Dead11    STARTFRAME=652 NUMFRAMES=18 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=BackRun   STARTFRAME=670 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StrafeL   STARTFRAME=680 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StrafeR   STARTFRAME=690 NUMFRAMES=10 RATE=17		Group=MovingFire

#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd  STARTFRAME=537 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd2 STARTFRAME=553 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd3 STARTFRAME=566 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=Commando X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=Commando SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=Dead1 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead2 TIME=0.9 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead4 TIME=0.6 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead7 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead8 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead9B TIME=0.8 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead11 TIME=0.57 FUNCTION=LandThump


//
// FCommando
//

#exec MESH IMPORT MESH=FCommando ANIVFILE=MODELS\FCommando_a.3D DATAFILE=MODELS\FCommando_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=FCommando X=-30 Y=-115 Z=20 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=FCommando SEQ=All       STARTFRAME=0   NUMFRAMES=681
#exec MESH SEQUENCE MESH=FCommando SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=15 RATE=20	Group=Gesture
#exec MESH SEQUENCE MESH=FCommando SEQ=Breath1   STARTFRAME=20  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Breath2   STARTFRAME=27  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=CockGun   STARTFRAME=47  NUMFRAMES=6  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=DuckWlkL  STARTFRAME=53  NUMFRAMES=15 RATE=15	Group=Ducking
#exec MESH SEQUENCE MESH=FCommando SEQ=DuckWlkS  STARTFRAME=68  NUMFRAMES=15 RATE=15	Group=Ducking
#exec MESH SEQUENCE MESH=FCommando SEQ=HeadHit   STARTFRAME=83  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=JumpLgFr  STARTFRAME=84  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=JumpSmFr  STARTFRAME=85  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=LandLgFr  STARTFRAME=86  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=FCommando SEQ=LandSmFr  STARTFRAME=87  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=FCommando SEQ=LeftHit   STARTFRAME=88  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=Look      STARTFRAME=89  NUMFRAMES=35 RATE=15    Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=RightHit  STARTFRAME=124 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=RunLg     STARTFRAME=125 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=FCommando SEQ=RunLgFr   STARTFRAME=135 NUMFRAMES=10 RATE=17    Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=RunSm     STARTFRAME=145 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=FCommando SEQ=RunSmFr   STARTFRAME=155 NUMFRAMES=10 RATE=17	Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=StillFrRp STARTFRAME=165 NUMFRAMES=10 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=StillLgFr STARTFRAME=175 NUMFRAMES=10 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=StillSmFr STARTFRAME=185 NUMFRAMES=8  RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=SwimLg    STARTFRAME=193 NUMFRAMES=18 RATE=15
#exec MESH SEQUENCE MESH=FCommando SEQ=SwimSm    STARTFRAME=211 NUMFRAMES=18 RATE=15
#exec MESH SEQUENCE MESH=FCommando SEQ=TreadLg   STARTFRAME=229 NUMFRAMES=15 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=TreadSm   STARTFRAME=244 NUMFRAMES=15 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Victory1  STARTFRAME=259 NUMFRAMES=10 RATE=6  	Group=Gesture
#exec MESH SEQUENCE MESH=FCommando SEQ=WalkLg    STARTFRAME=269 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=FCommando SEQ=WalkLgFr  STARTFRAME=284 NUMFRAMES=15 RATE=18	Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=WalkSm    STARTFRAME=299 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=FCommando SEQ=WalkSmFr  STARTFRAME=314 NUMFRAMES=15 RATE=18	Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=Wave      STARTFRAME=329 NUMFRAMES=15 RATE=15	Group=Gesture
#exec MESH SEQUENCE MESH=FCommando SEQ=Walk      STARTFRAME=344 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=FCommando SEQ=TurnLg    STARTFRAME=284 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=FCommando SEQ=TurnSm    STARTFRAME=314 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=FCommando SEQ=Breath1L  STARTFRAME=359 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Breath2L  STARTFRAME=366 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=CockGunL  STARTFRAME=386 NUMFRAMES=6  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=LookL     STARTFRAME=392 NUMFRAMES=35 RATE=15    Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=WaveL     STARTFRAME=427 NUMFRAMES=15 RATE=15	Group=Gesture
#exec MESH SEQUENCE MESH=FCommando SEQ=Chat1     STARTFRAME=442 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Chat2     STARTFRAME=455 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=FCommando SEQ=Thrust    STARTFRAME=465 NUMFRAMES=15 RATE=20	Group=Gesture
#exec MESH SEQUENCE MESH=FCommando SEQ=DodgeB    STARTFRAME=480 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=DodgeF    STARTFRAME=481 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=DodgeR    STARTFRAME=482 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=DodgeL    STARTFRAME=483 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=Fighter   STARTFRAME=175 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=FCommando SEQ=Flip      STARTFRAME=484 NUMFRAMES=31 RATE=46	Group=Jumping
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead2     STARTFRAME=515 NUMFRAMES=18 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead3     STARTFRAME=533 NUMFRAMES=16 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead4     STARTFRAME=549 NUMFRAMES=13 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead6     STARTFRAME=562 NUMFRAMES=11 RATE=10

#exec MESH SEQUENCE MESH=FCommando SEQ=DeathEnd  STARTFRAME=532 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FCommando SEQ=DeathEnd2 STARTFRAME=561 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FCommando SEQ=DeathEnd3 STARTFRAME=572 NUMFRAMES=1

#exec MESH SEQUENCE MESH=FCommando SEQ=Dead1     STARTFRAME=573 NUMFRAMES=23 RATE=12
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead5     STARTFRAME=596 NUMFRAMES=13 RATE=12
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead9     STARTFRAME=609 NUMFRAMES=20 RATE=12
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead9B    STARTFRAME=629 NUMFRAMES=11 RATE=12
#exec MESH SEQUENCE MESH=FCommando SEQ=Dead7     STARTFRAME=640 NUMFRAMES=11 RATE=12
#exec MESH SEQUENCE MESH=FCommando SEQ=BackRun   STARTFRAME=651 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=StrafeL   STARTFRAME=661 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=FCommando SEQ=StrafeR   STARTFRAME=671 NUMFRAMES=10 RATE=17		Group=MovingFire

#exec MESHMAP SCALE MESHMAP=FCommando X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=FCommando SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=FCommando SEQ=Dead2  TIME=0.66 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead3  TIME=0.38 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead4  TIME=0.46 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead6  TIME=0.54 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead1  TIME=0.69 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead5  TIME=0.61 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead9b TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=FCommando SEQ=Dead7  TIME=0.54 FUNCTION=LandThump

//
// SGirl
//

#exec MESH IMPORT MESH=SGirl ANIVFILE=Models\SGirl_a.3D DATAFILE=Models\SGirl_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=SGirl X=-30 Y=-115 Z=20 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=SGirl SEQ=All       STARTFRAME=0   NUMFRAMES=681
#exec MESH SEQUENCE MESH=SGirl SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=15 RATE=20	Group=Gesture
#exec MESH SEQUENCE MESH=SGirl SEQ=Breath1   STARTFRAME=20  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Breath2   STARTFRAME=27  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=CockGun   STARTFRAME=47  NUMFRAMES=6  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=DuckWlkL  STARTFRAME=53  NUMFRAMES=15 RATE=15	Group=Ducking
#exec MESH SEQUENCE MESH=SGirl SEQ=DuckWlkS  STARTFRAME=68  NUMFRAMES=15 RATE=15	Group=Ducking
#exec MESH SEQUENCE MESH=SGirl SEQ=HeadHit   STARTFRAME=83  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=JumpLgFr  STARTFRAME=84  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=JumpSmFr  STARTFRAME=85  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=LandLgFr  STARTFRAME=86  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=SGirl SEQ=LandSmFr  STARTFRAME=87  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=SGirl SEQ=LeftHit   STARTFRAME=88  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=Look      STARTFRAME=89  NUMFRAMES=35 RATE=15    Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=RightHit  STARTFRAME=124 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=RunLg     STARTFRAME=125 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=SGirl SEQ=RunLgFr   STARTFRAME=135 NUMFRAMES=10 RATE=17    Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=RunSm     STARTFRAME=145 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=SGirl SEQ=RunSmFr   STARTFRAME=155 NUMFRAMES=10 RATE=17	Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=StillFrRp STARTFRAME=165 NUMFRAMES=10 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=StillLgFr STARTFRAME=175 NUMFRAMES=10 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=StillSmFr STARTFRAME=185 NUMFRAMES=8  RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=SwimLg    STARTFRAME=193 NUMFRAMES=18 RATE=15
#exec MESH SEQUENCE MESH=SGirl SEQ=SwimSm    STARTFRAME=211 NUMFRAMES=18 RATE=15
#exec MESH SEQUENCE MESH=SGirl SEQ=TreadLg   STARTFRAME=229 NUMFRAMES=15 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=TreadSm   STARTFRAME=244 NUMFRAMES=15 RATE=15	Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Victory1  STARTFRAME=259 NUMFRAMES=10 RATE=6  	Group=Gesture
#exec MESH SEQUENCE MESH=SGirl SEQ=WalkLg    STARTFRAME=269 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=SGirl SEQ=WalkLgFr  STARTFRAME=284 NUMFRAMES=15 RATE=18	Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=WalkSm    STARTFRAME=299 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=SGirl SEQ=WalkSmFr  STARTFRAME=314 NUMFRAMES=15 RATE=18	Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=Wave      STARTFRAME=329 NUMFRAMES=15 RATE=15	Group=Gesture
#exec MESH SEQUENCE MESH=SGirl SEQ=Walk      STARTFRAME=344 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=SGirl SEQ=TurnLg    STARTFRAME=284 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=SGirl SEQ=TurnSm    STARTFRAME=314 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=SGirl SEQ=Breath1L  STARTFRAME=359 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Breath2L  STARTFRAME=366 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=CockGunL  STARTFRAME=386 NUMFRAMES=6  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=LookL     STARTFRAME=392 NUMFRAMES=35 RATE=15    Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=WaveL     STARTFRAME=427 NUMFRAMES=15 RATE=15	Group=Gesture
#exec MESH SEQUENCE MESH=SGirl SEQ=Chat1     STARTFRAME=442 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Chat2     STARTFRAME=455 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=SGirl SEQ=Thrust    STARTFRAME=465 NUMFRAMES=15 RATE=20	Group=Gesture
#exec MESH SEQUENCE MESH=SGirl SEQ=DodgeB    STARTFRAME=480 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=DodgeF    STARTFRAME=481 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=DodgeR    STARTFRAME=482 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=DodgeL    STARTFRAME=483 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=Fighter   STARTFRAME=175 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=SGirl SEQ=Flip      STARTFRAME=484 NUMFRAMES=31 RATE=46	Group=Jumping
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead2     STARTFRAME=515 NUMFRAMES=18 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead3     STARTFRAME=533 NUMFRAMES=16 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead4     STARTFRAME=549 NUMFRAMES=13 RATE=10	Group=TakeHit
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead6     STARTFRAME=562 NUMFRAMES=11 RATE=10

#exec MESH SEQUENCE MESH=SGirl SEQ=DeathEnd  STARTFRAME=532 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SGirl SEQ=DeathEnd2 STARTFRAME=561 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SGirl SEQ=DeathEnd3 STARTFRAME=572 NUMFRAMES=1

#exec MESH SEQUENCE MESH=SGirl SEQ=Dead1     STARTFRAME=573 NUMFRAMES=23 RATE=12
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead5     STARTFRAME=596 NUMFRAMES=13 RATE=12
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead9     STARTFRAME=609 NUMFRAMES=20 RATE=12
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead9B    STARTFRAME=629 NUMFRAMES=11 RATE=12
#exec MESH SEQUENCE MESH=SGirl SEQ=Dead7     STARTFRAME=640 NUMFRAMES=11 RATE=12
#exec MESH SEQUENCE MESH=SGirl SEQ=BackRun   STARTFRAME=651 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=StrafeL   STARTFRAME=661 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=SGirl SEQ=StrafeR   STARTFRAME=671 NUMFRAMES=10 RATE=17		Group=MovingFire

#exec MESHMAP SCALE MESHMAP=SGirl X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=SGirl SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=SGirl SEQ=Dead2  TIME=0.66 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead3  TIME=0.38 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead4  TIME=0.46 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead6  TIME=0.54 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead1  TIME=0.69 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead5  TIME=0.61 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead9b TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=SGirl SEQ=Dead7  TIME=0.54 FUNCTION=LandThump

//
// Soldier
//

#exec MESH IMPORT MESH=Soldier ANIVFILE=MODELS\Soldier_a.3D DATAFILE=MODELS\Soldier_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=Soldier X=-150 Y=40 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Soldier SEQ=All       STARTFRAME=0   NUMFRAMES=700
#exec MESH SEQUENCE MESH=Soldier SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=20 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Soldier SEQ=Breath1   STARTFRAME=25  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Breath2   STARTFRAME=32  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=CockGun   STARTFRAME=52  NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=DuckWlkL  STARTFRAME=60  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Soldier SEQ=DuckWlkS  STARTFRAME=75  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Soldier SEQ=HeadHit   STARTFRAME=90  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=JumpLgFr  STARTFRAME=91  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=JumpSmFr  STARTFRAME=92  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=LandLgFr  STARTFRAME=93  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Soldier SEQ=LandSmFr  STARTFRAME=94  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Soldier SEQ=LeftHit   STARTFRAME=95  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=Look      STARTFRAME=96  NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=RightHit  STARTFRAME=136 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=RunLg     STARTFRAME=137 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Soldier SEQ=RunLgFr   STARTFRAME=147 NUMFRAMES=10 RATE=17    Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=RunSm     STARTFRAME=157 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Soldier SEQ=RunSmFr   STARTFRAME=167 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=StillFrRp STARTFRAME=177 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=StillLgFr STARTFRAME=187 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=StillSmFr STARTFRAME=197 NUMFRAMES=8  RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=SwimLg    STARTFRAME=205 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Soldier SEQ=SwimSm    STARTFRAME=220 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Soldier SEQ=TreadLg   STARTFRAME=235 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=TreadSm   STARTFRAME=250 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Victory1  STARTFRAME=265 NUMFRAMES=18 RATE=11 		Group=Gesture
#exec MESH SEQUENCE MESH=Soldier SEQ=WalkLg    STARTFRAME=283 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Soldier SEQ=WalkLgFr  STARTFRAME=298 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=WalkSm    STARTFRAME=313 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Soldier SEQ=WalkSmFr  STARTFRAME=328 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=Wave      STARTFRAME=343 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Soldier SEQ=Walk      STARTFRAME=358 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Soldier SEQ=TurnLg    STARTFRAME=298 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=Soldier SEQ=TurnSm    STARTFRAME=328 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=Soldier SEQ=Breath1L  STARTFRAME=373 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Breath2L  STARTFRAME=380 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=CockGunL  STARTFRAME=400 NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=LookL     STARTFRAME=408 NUMFRAMES=40 RATE=15     Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=WaveL     STARTFRAME=448 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Soldier SEQ=Chat1     STARTFRAME=463 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Chat2     STARTFRAME=476 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Soldier SEQ=Thrust    STARTFRAME=486 NUMFRAMES=15 RATE=20		Group=Gesture
#exec MESH SEQUENCE MESH=Soldier SEQ=DodgeB    STARTFRAME=501 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=DodgeF    STARTFRAME=502 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=DodgeR    STARTFRAME=503 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=DodgeL    STARTFRAME=504 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=Fighter   STARTFRAME=187 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=Soldier SEQ=Flip      STARTFRAME=505 NUMFRAMES=20 RATE=21		Group=Jumping
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead1     STARTFRAME=525 NUMFRAMES=13 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead2     STARTFRAME=538 NUMFRAMES=16 RATE=10
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead3     STARTFRAME=554 NUMFRAMES=13 RATE=10
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead4     STARTFRAME=567 NUMFRAMES=16 RATE=10
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead7     STARTFRAME=583 NUMFRAMES=21 RATE=12		Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead8     STARTFRAME=604 NUMFRAMES=18 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead9     STARTFRAME=622 NUMFRAMES=20 RATE=30		Group=TakeHit
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead9B    STARTFRAME=642 NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=Soldier SEQ=Dead11    STARTFRAME=652 NUMFRAMES=18 RATE=10
#exec MESH SEQUENCE MESH=Soldier SEQ=BackRun   STARTFRAME=670 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=StrafeL   STARTFRAME=680 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Soldier SEQ=StrafeR   STARTFRAME=690 NUMFRAMES=10 RATE=17		Group=MovingFire

#exec MESH SEQUENCE MESH=Soldier SEQ=DeathEnd  STARTFRAME=537 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Soldier SEQ=DeathEnd2 STARTFRAME=553 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Soldier SEQ=DeathEnd3 STARTFRAME=566 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=Soldier X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=Soldier SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Soldier SEQ=Dead1 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead2 TIME=0.9 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead4 TIME=0.6 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead7 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead8 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead9B TIME=0.8 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Soldier SEQ=Dead11 TIME=0.57 FUNCTION=LandThump


DefaultProperties
{
	DefaultMesh(0)=LodMesh'Botpack.FCommando'
	DefaultMesh(1)=LodMesh'Botpack.FCommando'
	DefaultMesh(2)=LodMesh'Botpack.FCommando'
	DefaultMesh(3)=LodMesh'Botpack.FCommando'
	DefaultMesh(4)=LodMesh'Botpack.SGirl'
	DefaultMesh(5)=LodMesh'Botpack.SGirl'
	DefaultMesh(6)=LodMesh'Botpack.SGirl'
	DefaultMesh(7)=LodMesh'Botpack.SGirl'
	DefaultMesh(8)=LodMesh'Botpack.SGirl'
	DefaultMesh(9)=LodMesh'Botpack.Commando'
	DefaultMesh(10)=LodMesh'Botpack.Commando'
	DefaultMesh(11)=LodMesh'Botpack.Commando'
	DefaultMesh(12)=LodMesh'Botpack.Soldier'
	DefaultMesh(13)=LodMesh'Botpack.Soldier'
	DefaultMesh(14)=LodMesh'Botpack.Soldier'
	DefaultMesh(15)=LodMesh'Botpack.Soldier'
	DefaultMesh(16)=LodMesh'Botpack.Soldier'
	DefaultMesh(17)=LodMesh'Botpack.Boss'
	RateCorrectedMesh(0)=LodMesh'FCommando'
	RateCorrectedMesh(1)=LodMesh'FCommando'
	RateCorrectedMesh(2)=LodMesh'FCommando'
	RateCorrectedMesh(3)=LodMesh'FCommando'
	RateCorrectedMesh(4)=LodMesh'SGirl'
	RateCorrectedMesh(5)=LodMesh'SGirl'
	RateCorrectedMesh(6)=LodMesh'SGirl'
	RateCorrectedMesh(7)=LodMesh'SGirl'
	RateCorrectedMesh(8)=LodMesh'SGirl'
	RateCorrectedMesh(9)=LodMesh'Commando'
	RateCorrectedMesh(10)=LodMesh'Commando'
	RateCorrectedMesh(11)=LodMesh'Commando'
	RateCorrectedMesh(12)=LodMesh'Soldier'
	RateCorrectedMesh(13)=LodMesh'Soldier'
	RateCorrectedMesh(14)=LodMesh'Soldier'
	RateCorrectedMesh(15)=LodMesh'Soldier'
	RateCorrectedMesh(16)=LodMesh'Soldier'
	RateCorrectedMesh(17)=LodMesh'Boss'
}