class NewNetH4X extends Arena config (FragNewNet);

var config bool bAllowJumpBoots;
var config bool bAllowHealthPickups;
var config bool bAllowArmorItems;
var config bool bAllowInvisibility;
var config bool bAllowAmplifier;
var config bool bAllowRedeemer;

function PreBeginPlay()
{
	Super.PreBeginPlay();
	SetTimer(Level.TimeDilation, true);
}

function PostBeginPlay()
{
	local Inventory AUX;

	ForEach Level.AllActors(Class'Inventory',AUX)
	{
		if (bAllowRedeemer && AUX.IsA('WarheadLauncher'))
		    continue;
		else if (AUX.isA('Ammo') && !AUX.bHeldItem || AUX.isA('Weapon') && !AUX.bHeldItem)
		{
		    AUX.Destroy();
			continue;
		}
	}

	Super.PostBeginPlay();
	SaveConfig();
}

function Timer()
{
	local Ammo A;

	ForEach AllActors(class'Ammo', A)
	{
		if (A != none && !A.IsA('WarHeadAmmo'))
			A.AmmoAmount = A.MaxAmmo;
	}
}

function bool AlwaysKeep (Actor Other)
{
    if (InStr(Caps(Other.Class.Name), "ST_")>=0)
        return true;

	if (bAllowRedeemer && InStr(Caps(Other.Class.Name),"REDEEMER")>=0)
		return true;

    if (bAllowRedeemer && InStr(Caps(Other.Class.Name), "WARHEADAMMO")>=0)
        return true;

	if (NextMutator != None )
		return (NextMutator.AlwaysKeep(Other));

  return false;
}

function bool CheckReplacement (Actor Other, out byte bSuperRelevant)
{
	if (Other.IsA('Pickup'))
	{
		if (bAllowHealthPickups)
		{
			if (Other.IsA('MedBox') || Other.IsA('HealthPack') || Other.IsA('HealthVial'))
				return true;
		}

		if (bAllowArmorItems )
		{
			if (Other.IsA('ThighPads') || Other.IsA('Armor2') || Other.IsA('UT_ShieldBelt'))
				return true;
		}

		if (bAllowJumpBoots && Other.IsA('UT_Jumpboots'))
			return true;

		if (bAllowInvisibility && Other.IsA('UT_invisibility'))
			return true;

		if (bAllowAmplifier && Other.IsA('UDamage'))
			return true;

		return false;
	}

	if (Other.IsA('Weapon'))
	{
		if (Other.IsA('Translocator'))
			return true;

	    if (bAllowRedeemer && Other.IsA('WarheadLauncher'))
            return true;
	    else
	    	return Super.CheckReplacement (Other, bSuperRelevant);
    }

	return true;
}

defaultproperties
{
    WeaponName=ST_h4x_Rifle
    AmmoName=h4x_Bullets
    WeaponString="ST_h4x_Rifle"
    AmmoString="h4x_Bullets"
    DefaultWeapon=Class'ST_h4x_Rifle'
	bAllowJumpBoots=True
	bAllowHealthPickups=True
	bAllowArmorItems=True
}
