class SmartUTSpawnNotify expands SpawnNotify;

var Actor IpToCountry;
var bool bChecked;

simulated event Actor SpawnNotification( Actor A )
{
  local Actor Search;
  local SmartDOMPRI DOMRI;
  local SmartTDMPRI TDMRI;
  local SmartTLMSPRI TLMSRI;
  local SmartCTFPRI CTFRI;
   //local SmartDMPRI DMRI;
  
	if (A.Owner==None || (!A.Owner.IsA('PlayerPawn') && !A.Owner.IsA('Bot')) || (!Pawn( A.Owner).bIsPlayer))
		return A;

	// IpToCountry
	if(!bChecked)
	{
		foreach Level.Game.AllActors(class'Actor', Search, 'IpToCountry')
		{
			IpToCountry=Search;
			break;
		}
		bChecked=True;
	}
 
	if (string(Level.Game.Class)~= "TLastManStanding.TLastManStanding") {
		TLMSRI=Spawn( class'SmartTLMSPRI', A);
		if (IpToCountry != None && TLMSRI!=None)
		{
			TLMSRI.IpToCountry=IpToCountry;
			TLMSRI.bIpToCountry=True;
		}
	} else if (string(Level.Game.Class)~= "Botpack.Domination") {
		DOMRI=Spawn( class'SmartDOMPRI', A);
		if (IpToCountry != None && DOMRI!=None)
		{
			DOMRI.IpToCountry=IpToCountry;
			DOMRI.bIpToCountry=True;
		}	
	} else if (string(Level.Game.Class)~= "Botpack.TeamGamePlus") {
		TDMRI=Spawn( class'SmartTDMPRI', A);
		if (IpToCountry != None && TDMRI!=None)
		{
			TDMRI.IpToCountry=IpToCountry;
			TDMRI.bIpToCountry=True;
		}		
	} else if (string(Level.Game.Class)~= "Botpack.CTFGame") {
		CTFRI=Spawn( class'SmartCTFPRI', A);
		if (IpToCountry != None && CTFRI!=None)
		{
			CTFRI.IpToCountry=IpToCountry;
			CTFRI.bIpToCountry=True;
		}
	} else {
		log("Unsupported game:"@string(Level.Game.Class), 'SmartUT');
	}
	
	return A;
}

defaultproperties
{
    ActorClass=Class'Engine.PlayerReplicationInfo'
}
