class SmartUTPRI expands ReplicationInfo;

// Replicated
var int Score, Kills, Suicides, HeadShots; // Frags
var int ShieldBelts, Amplifiers; // Pickups
var string CountryPrefix; // CountryFlags

// Server side
var int MultiLevel, FragSpree, SpawnKillSpree;
var float LastKillTime, LastDeathTime, SpawnTime;
var bool bHadFirstSpawn;
var float TimeJoined;
var float TimePlayed;

// Client side
var bool bViewingStats;
var float IndicatorStartShow;
var byte IndicatorVisibility;

// CountryFlags
var Actor IpToCountry;
var bool bIpToCountry;

replication
{
	// Stats
	reliable if( Role == ROLE_Authority )
		Score, Kills, Suicides, HeadShots,
		ShieldBelts, Amplifiers,
		CountryPrefix;

	reliable if( Role == ROLE_Authority )
		ToggleStats, ShowStats;
}

function PostBeginPlay()
{
	super.PostBeginPlay();
	SetTimer( 0.5, True );
}

function Timer()
{
	local float PlayerTime;
	local PlayerPawn p;
	local string temp, Address;

	if( Owner == None )
	{
		SetTimer( 0.0, False );
		Destroy();
	}

	if (Level.Game!=None && !Level.Game.bGameEnded)
	{
		if (Level.Game.GameReplicationInfo.RemainingTime>0)
			TimePlayed = (TournamentGameReplicationInfo(Level.Game.GameReplicationInfo).TimeLimit*60)-Level.Game.GameReplicationInfo.RemainingTime-TimeJoined;
		else
			TimePlayed = Level.Game.GameReplicationInfo.ElapsedTime-TimeJoined;
	}
	
	// CountryFlags
	if(bIpToCountry)
	{	
		if(CountryPrefix=="")
		{	
			if (Owner.Owner.IsA('PlayerPawn'))
			{
				P=PlayerPawn(Owner.Owner);
				if (NetConnection(P.Player)!=None)
				{
					temp=P.GetPlayerNetworkAddress();
					Address=Left(temp, InStr(temp, ":"));
					temp=IpToCountry.GetItemName(Address);
					if (temp=="!Disabled")
						bIpToCountry=False;
					else if (Left(temp, 1) != "!")
					{
						CountryPrefix=SelElem(temp, 5);
						if (CountryPrefix=="")
							bIpToCountry = False;
					}
				}
				else
				{
					CountryPrefix="tg";
					bIpToCountry = False;
				}
			}
			else
				bIpToCountry = False;
		}
		else
			bIpToCountry = false;
	}
}

// Called on the server, executed on the client
simulated function ToggleStats()
{
  local PlayerPawn P;

  if( Owner == None ) return;
  P = PlayerPawn( Owner.Owner );
  if( P == None ) return;

  if( P.Scoring != None && !P.Scoring.IsA( 'SmartUTScoreBoard' ) )
  {
    P.ClientMessage( "Problem loading the SmartUT ScoreBoard..." );
  }
  else
  {
    bViewingStats = !bViewingStats;
    IndicatorStartShow = Level.TimeSeconds;
    IndicatorVisibility = 255;
    P.bShowScores = True;
  }
}

// Called on the client
simulated function ShowStats()
{
	local PlayerPawn P;

	if (Owner==None)
		return;
	
	P = PlayerPawn(Owner.Owner);
	if (P==None)
		return;

	if (P.Scoring!=None && !P.Scoring.IsA('SmartUTScoreBoard'))
	{
		P.ClientMessage( "Problem loading a SmartUT ScoreBoard..." );
	}
	else
	{
		bViewingStats = True;
	}
}

function ClearStats()
{
	Score = 0;
	Kills = 0;
	Suicides = 0;
	HeadShots = 0;  
	ShieldBelts = 0;
	Amplifiers = 0;
	SpawnTime = 0;
	TimePlayed = 0;
}

// CountryFlags
static final function string SelElem(string Str, int Elem)
{
	local int pos;
	while(Elem-->1)
		Str=Mid(Str, InStr(Str,":")+1);
	pos=InStr(Str, ":");
	if(pos != -1)
    	Str=Left(Str, pos);
    return Str;
}

defaultproperties
{
}
