// Above all other messages.
class SmartUTMessage extends LocalMessagePlus;

var string SpawnKillMsg;

static function float GetOffset( int Switch, float YL, float ClipY )
{
  return ( default.YPos / 768.0 ) * ClipY - 3 * YL;
}

static function string GetString( optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject )
{
  if (RelatedPRI_1 == None) return "";

  switch( Switch )
  {
    case 10: // Spawnkilling
      return RelatedPRI_1.PlayerName @ default.SpawnKillMsg;
  }
  return "";
}

static simulated function ClientReceive( PlayerPawn P, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject )
{
  super.ClientReceive( P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
}

defaultproperties
{
    SpawnKillMsg="is a spawnkilling lamer!"
    FontSize=1
    bIsSpecial=True
    bIsUnique=True
    bFadeMessage=True
    DrawColor=(R=24,G=192,B=24,A=0),
    YPos=196.00
    bCenter=True
}
