class SmartUTGameReplicationInfo expands ReplicationInfo;

var int TickRate;
var bool bStatsDrawFaces, bPlay30SecSound;
var class<ScoreBoard> NormalScoreBoardClass;
var SmartUTEndStats EndStats;
var SmartUTPRI PRIArray[64];
var bool bInitialized, bServerInfoSetServerSide;
var bool bShowExtraInfo;
var class<HUD> DefaultHUDType;
var string CountryFlagsPackage; // CountryFlags

replication
{
	// Settings
	reliable if( Role == ROLE_Authority )
		bPlay30SecSound, bStatsDrawFaces, CountryFlagsPackage, bShowExtraInfo;

	reliable if( Role == ROLE_Authority )
		bInitialized, TickRate, NormalScoreBoardClass, EndStats, bServerInfoSetServerSide, DefaultHUDType;
}

simulated function PostBeginPlay()
{
	SetTimer( 0.5, True );
}

simulated function Timer()
{
	RefreshPRI();
}

simulated function SmartUTPRI GetStats( Actor P )
{
	local int i;
	local PlayerReplicationInfo PRI;

	if( !P.IsA( 'Pawn' ) ) return None;
	PRI = Pawn( P ).PlayerReplicationInfo;
	if( PRI == None ) return None;

	for( i = 0; i < 64; i++ )
	{
		if( PRIArray[i] == None ) break;
		if( PRIArray[i].Owner == PRI ) return PRIArray[i];
	}
	
	return None;
}

simulated function SmartUTPRI GetStatsByPRI( PlayerReplicationInfo PRI )
{
	local int i;

	if( PRI == None ) return None;

	for( i = 0; i < 64; i++ )
	{
		if( PRIArray[i] == None ) break;
		if( PRIArray[i].Owner == PRI ) return PRIArray[i];
	}
	
	return None;
}

simulated function SmartUTPRI GetStatNr( byte i )
{
	return PRIArray[i];
}

simulated function ClearStats()
{
	local int i;
	
	for( i = 0; i < 64; i++ )
	{
		if( PRIArray[i] == None ) break;
		PRIArray[i].ClearStats();
	}
}

simulated function RefreshPRI()
{
	local SmartUTPRI PRI;
	local int i;

	for(i=0; i<64; i++)
		PRIArray[i] = None;

	i = 0;
	ForEach AllActors(class'SmartUTPRI', PRI)
	{
		if (i<64)
		{
			if (PRI.Owner!=None)
				PRIArray[i++] = PRI;
		}
		else break;
	}
}

defaultproperties
{
    RemoteRole=2
}
