class SmartTLMS expands SmartUT config( SmartUT );

/* Server Vars */

/* Server Vars Configurable */
var() config bool bPlayOutSound;
var() config int SuicidePenalty, TeamKillPenalty, LowHealthBonus;

function bool PreventDeath( Pawn Victim, Pawn Killer, name DamageType, vector HitLocation )
{
	local PlayerReplicationInfo VictimPRI, KillerPRI;
	local bool bPrevent;
	local Pawn p;
	local SmartTLMSPRI KillerStats, VictimStats;

	bPrevent = super.PreventDeath( Victim, Killer, DamageType, HitLocation );
	if (bWarmup || bPrevent || Victim==None || Killer==None)
		return bPrevent; 

	VictimPRI = Victim.PlayerReplicationInfo;	
	if( VictimPRI==None || !Victim.bIsPlayer || ( VictimPRI.bIsSpectator && !VictimPRI.bWaitingPlayer ) )
		return bPrevent;

	VictimStats = SmartTLMSPRI(SmartUTGame.GetStats( Victim ));
	if (VictimStats!=None && (Killer==None || Killer==Victim))
	{		
		// Handle suicide
		if (SuicidePenalty!=0)
		{
			VictimStats.Score -= SuicidePenalty;		
			if (bShowBonusConsoleMsg && SuicidePenalty!=0)
				Victim.ClientMessage("Penalty of"@SuicidePenalty@"point(s) for suiciding!") ;
		}
		
		return bPrevent;
	}

	KillerPRI = Killer.PlayerReplicationInfo;
	if ( KillerPRI==None || !Killer.bIsPlayer || ( KillerPRI.bIsSpectator && !KillerPRI.bWaitingPlayer ) )
		return bPrevent;
	
	KillerStats = SmartTLMSPRI(SmartUTGame.GetStats(Killer));
	if (KillerStats!=None)
	{
		// Handle teamkill
		if (VictimPRI.Team==KillerPRI.Team)
		{	
			KillerStats.Teamkills++;
			KillerStats.Score -= TeamKillPenalty;
			if (bShowBonusConsoleMsg && TeamKillPenalty!=0)
				Killer.ClientMessage("Penalty of"@TeamKillPenalty@"point(s) for teamkilling!") ;				
			
			// Log
			if( Level.Game.LocalLog != None )
				Level.Game.LocalLog.LogSpecialEvent( "teamkill", KillerPRI.PlayerID, VictimPRI.PlayerID);

			return bPrevent;
		}

		// Low health bonus
		if (LowHealthBonus!=0 && Killer.Health<50)
		{
			KillerStats.Score += LowHealthBonus;
			if (bShowBonusConsoleMsg && LowHealthBonus!=0)
				Killer.ClientMessage("Bonus of"@LowHealthBonus@"point(s) for killing a player with low health!") ;
		}
		
	}

	return bPrevent;
}

function ScoreKill(Pawn Killer, Pawn Victim)
{
	super.ScoreKill(Killer, Victim);
	PlayLeadSound();
}

function bool MutatorBroadcastLocalizedMessage( Actor Sender, Pawn Receiver, out class<LocalMessage> Message, out optional int Switch, out optional PlayerReplicationInfo RelatedPRI_1, out optional PlayerReplicationInfo RelatedPRI_2, out optional Object OptionalObject )
{
	if (Message==class'LMSOutMessage')
	{
		if (RelatedPRI_1!=None)
		{
			if (bPlayOutSound && Receiver!=None && Receiver.PlayerReplicationInfo!=None && Receiver.PlayerReplicationInfo.Team!=RelatedPRI_1.Team && PlayerPawn(Receiver)!=None)
				PlayerPawn(Receiver).ReceiveLocalizedMessage(class'SmartUTAudioMsg', 5);
		}
	}

	return super.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
}

function SendSmartUTRules(PlayerPawn Sender)
{
	Sender.ClientMessage( "- Suicide:" @ SuicidePenalty @ "pts, Teamkill:"@TeamKillPenalty );
	Sender.ClientMessage( "- Low Health:" @ LowHealthBonus @ "pts." );
	Sender.ClientMessage( "- Spree:" @ SpreeLevelBonus @ "pts per level, Multikill:"@ MultiKillLevelBonus @ "pts per level." );
}

function SendSmartUTInfo(PlayerPawn Sender) {}

function GetSmartUTInfo(out string SoundsString, out string MsgsString, out string CMsgsString)
{
	if( bPlayOutSound ) SoundsString = SoundsString @ "Out";
}

function CalcSmartUTEndStats()
{
	local SmartTLMSPRI TopScore, TopHeadShots, PawnStats;
	local string BestRecordDate;
	local int ID;
	local float PerHour;
	local PlayerReplicationInfo PRI;
	local SmartTLMSEndStats EndStats;
	local byte i;
	
	Super.CalcSmartUTEndStats();

	EndStats = SmartTLMSEndStats(SmartUTGame.EndStats);
	SmartUTGame.RefreshPRI();
	for( i = 0; i < 64; i++ )
	{
		PawnStats = SmartTLMSPRI(SmartUTGame.GetStatNr(i));
		if( PawnStats==None) break;
		if (TopScore == None || PlayerReplicationInfo(PawnStats.Owner).Score>PlayerReplicationInfo(TopScore.Owner).Score)
			TopScore = PawnStats;
		if (TopHeadShots == None || PawnStats.HeadShots>TopHeadShots.HeadShots)
			TopHeadShots = PawnStats;
	}
			
	PRI = PlayerReplicationInfo( TopScore.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( PRI.Score / PerHour > EndStats.MostPoints.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostPoints.Count = PRI.Score / PerHour;
		EndStats.MostPoints.PlayerName = PRI.PlayerName;
		EndStats.MostPoints.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostPoints.RecordDate = BestRecordDate;
	}

	PRI = PlayerReplicationInfo( TopHeadShots.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( TopHeadShots.HeadShots / PerHour > EndStats.MostHeadShots.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostHeadShots.Count = TopHeadShots.HeadShots / PerHour;
		EndStats.MostHeadShots.PlayerName = PRI.PlayerName;
		EndStats.MostHeadShots.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostHeadShots.RecordDate = BestRecordDate;
	}
	
	EndStats.SaveConfig();

}

simulated event PostRender( Canvas C )
{
  local int i, Y, X;
  local float DummyY, Size;
  local string TempStr;
  local int Eff;
  local SmartUTPRI PlayerStats;

  super.PostRender(C);
    
  // Draw Extra Info
  if (SmartUTGame.bShowExtraInfo)
  {
	PlayerStats = SmartUTGame.GetStatsByPRI(pPRI);
  	if (PlayerStats!=None)
	{
		C.Style = ERenderStyle.STY_Normal;
		C.Font = MyFonts.GetSmallestFont( C.ClipX );
	
		if (PlayerStats.Kills+pPRI.Deaths!=0)
		{
			Eff = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100);
			if (Eff>=75)
				C.DrawColor = GreenTeamColor;
			else if (Eff<=25)
				C.DrawColor = RedTeamColor;
			else
				C.DrawColor = GoldTeamColor;
			TempStr = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100)$"%";
		}
		else
		{
			C.DrawColor = White;
			TempStr = "N/A";
		}
				
		C.StrLen( TempStr, Size, DummyY );
		if( MyHUD.bHideAllWeapons ) Y = C.ClipY;
		else if( MyHUD.HudScale * MyHUD.WeaponScale * C.ClipX <= C.ClipX - 256 * MyHUD.Scale) Y = C.ClipY - 64 * MyHUD.Scale;
		else Y = C.ClipY - 128 * MyHUD.Scale;
		X = C.ClipX - Size - 6;
		Y = Y - 4 - 32 + ( 32 - DummyY ) / 2;
		C.SetPos( X, Y);
		C.DrawText( TempStr );

		TempStr = "D:"$int(pPRI.Deaths)@"E:";
		C.StrLen( TempStr, Size, DummyY );
		C.SetPos( X - Size, Y );
		C.DrawColor = White;
		C.DrawText( TempStr );
	}
  }
}

defaultproperties
{
    bPlayOutSound=True
    SmartUTEndStatsClass=Class'SmartTLMSEndStats'
    SmartUTScoreBoardClass=Class'SmartTLMSScoreBoard'
    SmartUTServerInfoClass=Class'SmartTLMSServerInfo'
    GreenTeamColor=(R=0,G=255,B=0,A=0),
    GoldTeamColor=(R=255,G=255,B=0,A=0),
    SpreeLevelBonus=1
}
