class SmartTDMGameReplicationInfo expands SmartUTGameReplicationInfo;

var bool bCamperEnhanced;


replication
{
  // Settings
  reliable if( Role == ROLE_Authority )
    bCamperEnhanced;
}

simulated function SmartUTPRI GetStats( Actor P )
{
  local int i;
  local PlayerReplicationInfo PRI;

  if( !P.IsA( 'Pawn' ) ) return None;
  PRI = Pawn( P ).PlayerReplicationInfo;
  if( PRI == None ) return None;

  for( i = 0; i < 64; i++ )
  {
    if( PRIArray[i] == None ) break;
    if( PRIArray[i].Owner == PRI ) return PRIArray[i];
  }
  return None;
}

simulated function SmartUTPRI GetStatsByPRI( PlayerReplicationInfo PRI )
{
  local int i;

  if( PRI == None ) return None;
  for( i = 0; i < 64; i++ )
  {
    if( PRIArray[i] == None ) break;
    if( PRIArray[i].Owner == PRI ) return PRIArray[i];
  }
  return None;
}

simulated function SmartUTPRI GetStatNr( byte i )
{
  return PRIArray[i];
}

simulated function ClearStats()
{
  local int i;
  for( i = 0; i < 64; i++ )
  {
    if( PRIArray[i] == None ) break;
    PRIArray[i].ClearStats();
  }
}

simulated function RefreshPRI()
{
	local SmartUTPRI PRI;
	local int i;

	for(i=0; i<64; i++)
		PRIArray[i] = None;

	i = 0;
	ForEach AllActors(class'SmartUTPRI', PRI)
	{
		if (i<64)
		{
			if (PRI.Owner!=None)
				PRIArray[i++] = PRI;
		}
		else break;
	}
}

defaultproperties
{
}
