class SmartTDM expands SmartUT config( SmartUT );

/* Server Vars */

/* Server Vars Configurable */
var() config bool bCamperEnhanced;
var() config int AmplifierKilledBonus, TeamKillPenalty, LowHealthBonus; // Frags
var() config int AmplifierPickupBonus, BigHealthPickupBonus, ShieldBeltPickupBonus, InvisibilityPickupBonus; // Pickups

function PostBeginPlay()
{
	super.PostBeginPlay();
	
	SmartTDMGameReplicationInfo(SmartUTGame).bCamperEnhanced = bCamperEnhanced;
	if (bCamperEnhanced)
		Log( "Info: Camper Enhanced" , 'SmartTDM' );
}

function bool PreventDeath( Pawn Victim, Pawn Killer, name DamageType, vector HitLocation )
{
	local PlayerReplicationInfo VictimPRI, KillerPRI;
	local bool bPrevent;
	local Pawn p;
	local SmartTDMPRI KillerStats, VictimStats;
	local Inventory aAmp;
	local float TimeAwake;

	bPrevent = super.PreventDeath( Victim, Killer, DamageType, HitLocation );
	if (bWarmup || bPrevent || Victim==None || Killer==None)
		return bPrevent; 

	VictimPRI = Victim.PlayerReplicationInfo;	
	if( VictimPRI==None || !Victim.bIsPlayer || ( VictimPRI.bIsSpectator && !VictimPRI.bWaitingPlayer ) )
		return bPrevent;

	VictimStats = SmartTDMPRI(SmartUTGame.GetStats( Victim ));
	if (VictimStats!=None && (Killer==None || Killer==Victim))
	{	
		// Suicide
		if (SuicidePenalty!=0)
		{
			VictimStats.Score -= SuicidePenalty;		
			if (bShowBonusConsoleMsg && SuicidePenalty!=0)
				Victim.ClientMessage("Penalty of"@SuicidePenalty@"point(s) for suiciding!") ;
		}
		
		return bPrevent;
	}
	
	KillerPRI = Killer.PlayerReplicationInfo;
	if ( KillerPRI==None || !Killer.bIsPlayer || ( KillerPRI.bIsSpectator && !KillerPRI.bWaitingPlayer ) )
		return bPrevent;

	KillerStats = SmartTDMPRI(SmartUTGame.GetStats( Killer ));
	if (KillerStats!=None)
	{		
		// Handle teamkills
		if (VictimPRI.Team==KillerPRI.Team)
		{	
			KillerStats.Teamkills++;

			if (TeamKillPenalty!=0)
			{
				KillerStats.Score -= TeamKillPenalty;
				if (bShowBonusConsoleMsg && TeamKillPenalty!=0)
					Killer.ClientMessage("Penalty of"@TeamKillPenalty@"point(s) for Teamkilling!") ;				
			}

			// Log
			if( Level.Game.LocalLog != None )
				Level.Game.LocalLog.LogSpecialEvent( "teamkill", KillerPRI.PlayerID, VictimPRI.PlayerID);

			return bPrevent;
		}
	
		// Register UDamage kills
		if (Killer.FindInventoryType(class'UDamage')!=None)
			KillerStats.AmpKills++;
		if (Victim.FindInventoryType(class'UDamage')!=None)
		{	
			KillerStats.Score += AmplifierKilledBonus;
			if (bShowBonusConsoleMsg && AmplifierKilledBonus!=0)
				Killer.ClientMessage("Bonus of"@AmplifierKilledBonus@"point(s) for killing a player with Damage Amplifier!") ;
		}
		
		// Low health bonus
		if (Killer.Health<50)
		{
			KillerStats.Score += LowHealthBonus;
			if (bShowBonusConsoleMsg && LowHealthBonus!=0)
				Killer.ClientMessage("Bonus of"@LowHealthBonus@"point(s) for killing a player with Low Health!") ;
		}
	}
	
	return bPrevent;
}

function ScoreKill(Pawn Killer, Pawn Victim)
{
	local Pawn p;

	super.ScoreKill(Killer, Victim);
	
	// Camper Enhanced
	if (bCamperEnhanced && (Victim.IsA('Bot') || (Victim.IsA('PlayerPawn') && !PlayerPawn(Victim).bIsCrouching)))
	{
		Victim.PlayerReplicationInfo.Score -= 1.0;
		TeamGamePlus(Level.Game).Teams[Victim.PlayerReplicationInfo.Team].Score -= 1.0; 
	}
	
	PlayLeadSound();

}

function bool HandlePickupQuery( Pawn Other, Inventory Item, out byte bAllowPickup )
{
	local SmartTDMPRI OtherStats;
	local bool bPickup;
	
	bPickup = super.HandlePickupQuery(Other, Item, bAllowPickup);
	
	if (!bWarmup && Other!=None)
	{
		OtherStats = SmartTDMPRI(SmartUTGame.GetStats( Other ));
		if (OtherStats!=None)
		{
		
			// Pickups
			if (Item.IsA('UT_ShieldBelt'))
			{
				OtherStats.Score += ShieldBeltPickupBonus;
				if (bShowBonusConsoleMsg && ShieldBeltPickupBonus!=0)
					Other.ClientMessage("Bonus of"@ ShieldBeltPickupBonus@"point(s) for a Shieldbelt pickup!") ;
			}
			else if (Item.IsA('UDamage'))
			{
				OtherStats.Score += AmplifierPickupBonus;
				if (bShowBonusConsoleMsg && AmplifierPickupBonus!=0)
					Other.ClientMessage("Bonus of"@AmplifierPickupBonus@"point(s) for a Damage Amplifier pickup!") ;
			}
			else if (Item.IsA('HealthPack'))
			{
				//OtherStats.BigHealths++;
				OtherStats.Score += BigHealthPickupBonus;
				if (bShowBonusConsoleMsg && BigHealthPickupBonus!=0)
					Other.ClientMessage("Bonus of"@BigHealthPickupBonus@"point(s) for a Big Health pickup!") ;
			}
			else if (Item.IsA('UT_invisibility'))
			{
				OtherStats.Invisibilities++;
				OtherStats.Score += InvisibilityPickupBonus;
				if (bShowBonusConsoleMsg && InvisibilityPickupBonus!=0)
					Other.ClientMessage("Bonus of"@InvisibilityPickupBonus@"point(s) for an Invisibility pickup!") ;
			}

		}
	}
	
	return bPickup;
}

function bool HandleEndGame()
{
	local SmartTDMPRI OtherStats;
	local bool bTied;
	
	if (TeamGamePlus(Level.Game).Teams[0].Score==TeamGamePlus(Level.Game).Teams[1].Score)
		bTied = True;

	if (bForcedEndGame || (bEnableOvertimeControl && !bOvertime && DeathMatchPlus(Level.Game).bTournament))
	{
		bForcedEndGame = False;
		if (bTied)
		{		
			SetEndCamsTiedGame();	
			return True;
		}
	}
	
	if(!bTied)
	{
		foreach AllActors(class'SmartTDMPRI', OtherStats)
		{
			ProcessMultiStats(OtherStats);
			ProcessSpreeStats(OtherStats);
		}	
		CalcSmartUTEndStats();
	}

	if (NextMutator!=None)
		return NextMutator.HandleEndGame();
	return False;
}

function SendSmartUTRules(PlayerPawn Sender)
{
	Sender.ClientMessage( "- Suicide:" @ SuicidePenalty @ "pts, Teamkill:"@TeamKillPenalty );
	Sender.ClientMessage( "- Amplifier:" @ AmplifierPickupBonus @ "pts, Big Health:"@BigHealthPickupBonus@"pts, Shieldbelt:"@ShieldBeltPickupBonus@"pts, Invisibility:"@ InvisibilityPickupBonus@"pts.");
	Sender.ClientMessage( "- Low Health:" @ LowHealthBonus @ "pts, Amp killed:"@AmplifierKilledBonus@"pts." );
	Sender.ClientMessage( "- Spree:" @ SpreeLevelBonus @ "pts per level, Multikill:"@ MultiKillLevelBonus @ "pts per level." );
}

function SendSmartUTInfo(PlayerPawn Sender)
{
	Sender.ClientMessage( "- bCamperEnhanced:" @ bCamperEnhanced );
}

function GetSmartUTInfo(out string SoundsString, out string MsgsString, out string CMsgsString) {}

function CalcSmartUTEndStats()
{
	local SmartTDMPRI TopScore, TopFrags, TopHeadshots, PawnStats;
	local string BestRecordDate;
	local int ID;
	local float PerHour;
	local PlayerReplicationInfo PRI;
	local byte i;
	local SmartTDMEndStats EndStats;

	Super.CalcSmartUTEndStats();
	
	EndStats = SmartTDMEndStats(SmartUTGame.EndStats);
	SmartUTGame.RefreshPRI();

	for( i = 0; i < 64; i++ )
	{
		PawnStats = SmartTDMPRI(SmartUTGame.GetStatNr( i ));
	    if( PawnStats == None ) break;
		if( TopFrags == None || PlayerReplicationInfo( PawnStats.Owner ).Score > PlayerReplicationInfo( TopFrags.Owner ).Score ) TopFrags = PawnStats;
		if (TopScore==None || PawnStats.Score>TopScore.Score)
			TopScore = PawnStats;
	    if (TopHeadshots==None || PawnStats.HeadShots>TopHeadshots.HeadShots)
			TopHeadshots = PawnStats;
	}

	PRI = PlayerReplicationInfo( TopScore.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( PRI.Score / PerHour > EndStats.MostPoints.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
		EndStats.MostPoints.Count = TopScore.Score / PerHour;
		EndStats.MostPoints.PlayerName = PRI.PlayerName;
		EndStats.MostPoints.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostPoints.RecordDate = BestRecordDate;
	}

	PRI = PlayerReplicationInfo( TopHeadshots.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( TopHeadshots.HeadShots / PerHour > EndStats.MostHeadShots.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
	    EndStats.MostHeadShots.Count = TopHeadshots.HeadShots / PerHour;
	    EndStats.MostHeadShots.PlayerName = PRI.PlayerName;
	    EndStats.MostHeadShots.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostHeadShots.RecordDate = BestRecordDate;
	}

	PRI = PlayerReplicationInfo( TopFrags.Owner );
	PerHour = ( Level.TimeSeconds - PRI.StartTime ) / 3600;
	if( PRI.Score / PerHour > EndStats.MostFrags.Count && Level.TimeSeconds - PRI.StartTime > 300 )
	{
	    EndStats.MostFrags.Count =  PRI.Score / PerHour;
	    EndStats.MostFrags.PlayerName = PRI.PlayerName;
	    EndStats.MostFrags.MapName = Level.Title;
		TeamGamePlus(Level.Game).GetTimeStamp( BestRecordDate );
		EndStats.MostFrags.RecordDate = BestRecordDate;
	}
	
	EndStats.SaveConfig();

}

function SetEndCamsTiedGame()
{
	local Pawn pn, Best;
	local PlayerPawn Player;
	local SmartTDMPRI OtherStats;

	foreach AllActors(class'SmartTDMPRI', OtherStats)
	{
		ProcessMultiStats(OtherStats);
		ProcessSpreeStats(OtherStats);
	}	

	// Find Individual Winner
	for( pn = Level.PawnList ; pn != None ; pn = pn.NextPawn )
	{
		if (pn.bIsPlayer && ((Best==None)||(pn.PlayerReplicationInfo.Score>Best.PlayerReplicationInfo.Score)))
			Best = pn;
	}

	DeathMatchPlus(Level.Game).GameReplicationInfo.GameEndedComments = GameTieMessage;
	DeathMatchPlus(Level.Game).EndTime = Level.TimeSeconds + 3.0;

  for( pn = Level.PawnList ; pn != None ; pn = pn.NextPawn )
  {
    Player = PlayerPawn( pn );
    if( Player != None )
    {
      Player.bBehindView = True;
      if( Player == Best ) Player.ViewTarget = None;
      else Player.ViewTarget = Best;

      Player.ClientPlaySound( sound'CaptureSound', , true );
      Player.ClientGameEnded();
    }
    pn.GotoState( 'GameEnded' );
  }

  DeathMatchPlus(Level.Game).CalcEndStats();
  CalcSmartUTEndStats();
}

//----------------------------------------------------------------------------------------------------------------
//------------------------------------------------ CLIENT FUNCTIONS ----------------------------------------------
//----------------------------------------------------------------------------------------------------------------

/*
 * Render the HUD that is startup logo and FC location.
 * ONLY gets executed on clients.
 */
simulated event PostRender( Canvas C )
{
  local int i, Y, X;
  local float DummyY, Size;
  local string TempStr;
  local int Eff;
  local SmartUTPRI PlayerStats;

  super.PostRender(C);
    
  // Draw Extra Info
  if (SmartUTGame.bShowExtraInfo)
  {
	PlayerStats = SmartUTGame.GetStatsByPRI(pPRI);
  	if (PlayerStats!=None)
	{
		C.Style = ERenderStyle.STY_Normal;
		C.Font = MyFonts.GetSmallestFont( C.ClipX );
	
		if (PlayerStats.Kills+pPRI.Deaths!=0)
		{
			Eff = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100);
			if (Eff>=75)
				C.DrawColor = GreenTeamColor;
			else if (Eff<=25)
				C.DrawColor = RedTeamColor;
			else
				C.DrawColor = GoldTeamColor;
			TempStr = int((PlayerStats.Kills/(pPRI.Deaths+PlayerStats.Kills)) * 100)$"%";
		}
		else
		{
			C.DrawColor = White;
			TempStr = "N/A";
		}
				
		C.StrLen( TempStr, Size, DummyY );
		if( MyHUD.bHideAllWeapons ) Y = C.ClipY;
		else if( MyHUD.HudScale * MyHUD.WeaponScale * C.ClipX <= C.ClipX - 256 * MyHUD.Scale) Y = C.ClipY - 64 * MyHUD.Scale;
		else Y = C.ClipY - 128 * MyHUD.Scale;
		X = C.ClipX - Size - 6;
		Y = Y - 4 - 32 + ( 32 - DummyY ) / 2;
		C.SetPos( X, Y);
		C.DrawText( TempStr );

		TempStr = "D:"$int(pPRI.Deaths)@"E:";
		C.StrLen( TempStr, Size, DummyY );
		C.SetPos( X - Size, Y );
		C.DrawColor = White;
		C.DrawText( TempStr );
	}
  }
}

defaultproperties
{
    AmplifierKilledBonus=2
    TeamKillPenalty=5
    AmplifierPickupBonus=2
    BigHealthPickupBonus=1
    ShieldBeltPickupBonus=2
    InvisibilityPickupBonus=1
    SmartUTEndStatsClass=Class'SmartTDMEndStats'
    SmartUTGameReplicationInfoClass=Class'SmartTDMGameReplicationInfo'
    SmartUTScoreBoardClass=Class'SmartTDMScoreBoard'
    SmartUTServerInfoClass=Class'SmartTDMServerInfo'
    GreenTeamColor=(R=0,G=255,B=0,A=0),
    GoldTeamColor=(R=255,G=255,B=0,A=0),
    bShowExtraInfo=False
    SpawnKillTime=2.00
    SpreeLevelBonus=1
    KillBonus=1
    SuicidePenalty=2
}
